;;; -*- Mode: LISP; Syntax: Common-lisp; Package: YY; Base: 10 -*-
;;;  Active-region 
;;;  active-region.lisp
;;;
;;;  Copyright (C) 1989,1990,1991 Aoyama Gakuin University
;;;
;;;		All Rights Reserved
;;;
;;; This software is developed for the YY project of Aoyama Gakuin University.
;;; Permission to use, copy, modify, and distribute this software
;;; and its documentation for any purpose and without fee is hereby granted,
;;; provided that the above copyright notices appear in all copies and that
;;; both that copyright notice and this permission notice appear in 
;;; supporting documentation, and that the name of Aoyama Gakuin
;;; not be used in advertising or publicity pertaining to distribution of
;;; the software without specific, written prior permission.
;;;
;;; This software is made available AS IS, and Aoyama Gakuin makes no
;;; warranty about the software, its performance or its conformity to
;;; any specification. 
;;;
;;; To make a contact: Send E-mail to ida@csrl.aoyama.ac.jp for overall
;;; issues. To ask specific questions, send to the individual authors at
;;; csrl.aoyama.ac.jp. To request a mailing list, send E-mail to 
;;; yyonx-request@csrl.aoyama.ac.jp.
;;;
;;; Authors:
;;;   version 1.0 90/06/01 by t.kosaka (kosaka@csrl.aoyama.ac.jp)
;;;   version 1.1 90/07/31 by t.kosaka
;;;   update 1.11 90/09/14 by t.kosaka
;;;   version 1.2 90/11/05 by t.kosaka
;;;   updata 1.21 90/11/06 by T.kosaka

;;; $B%"%/%F%#%V%j!<%8%g%s%s%/%i%9(B
;;; 6/14 1990 $B8E:d(B
;;; Version 1.0   Coded by t.kosaka 1990-6-14

(in-package :yy)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; $B%"%/%F%#%V%j!<%8%g%s%s%/%i%9(B ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defclass active-region (event-method-mixin region)
  ((active-region-territory-no :initarg :active-region-territory-no
			     :initform 0 :type integer
			     :accessor active-region-territory-no
			     :accessor territory)

   (active-region-symbol :initform (gentemp)
			 :accessor active-region-symbol)
   
   ;;; $B%"%/%F%#%V%j!<%8%g%s$N$,F~$k(B
   (active-region-list :initform nil
                       :accessor active-region-list)

   (active-region-parent :initarg :active-region-parent
			 :accessor active-region-parent)))

;;; active-region$B$r>C5n$9$k(B
;;; flush-active-region active-region &optioanal (territory T)
;;; ARG.
;;;          active-region = $B%"%/%F%#%V%j!<%8%g%s(B
;;;          territory     = $B$b$7(BT$B$J$i$P!"%F%j%H%j!<$N>C5n(B
(defmethod flush-active-region ((a-region active-region)
				&optional (territory T))
  (dolist (item (active-region-list a-region))
	  (flush-active-region item NIL))
  
  ;;; $B4XO"IU$1$r2r=|(B
  (delete-lisp-object (active-region-territory-no a-region))

  ;;;  $B?F$N$+$i<+J,$r<h$j=|$/(B
  (setf (active-region-list (active-region-parent a-region))
	(delete a-region 
		(active-region-list (active-region-parent a-region))))

  ;;; $B%F%j%H%j!<$NGK2u(B
  (if territory
      (yy-protocol-5 (active-region-territory-no a-region)))

  (setf (active-region-territory-no a-region) nil))


;;; print-object
(defmethod  print-object ((object active-region) stream)
  (format stream "\#<Active Region :L ~a :B ~a :W ~a :H ~a>"
	  (region-left object)
	  (region-bottom object)
	  (region-width object)
	  (region-height object)))

;;; parent-stream
(defmethod parent-stream ((object active-region))
  (parent-stream (active-region-parent object)))

;;; $B%"%/%F%#%V%j!<%8%g%s$N$?$a$N?F$+$i$N(Bleft$B$rJV$9(B
(defgeneric real-left (parent x)
  (:method ((parent active-region) x)
	   x)
  (:method ((parent window-stream) x)
	   (+ (world-x-start parent) x)))

;;; $B%"%/%F%#%V%j!<%8%g%s$N$?$a$N?F$+$i$N(Bbottom$B$rJV$9(B
(defgeneric real-bottom (parent y)
  (:method ((parent active-region) y)
	   y)
  (:method ((parent window-stream) y)
	   (+ (with-translate-coordinate-stream y parent)
			    (world-y-start parent))
	   ))

;;; $B%"%/%F%#%V%j!<%8%g%s$N$?$a$N?F$N%F%j%H%j!<HV9f$rJV$9(B
(defgeneric parent-territory-no (parent)
  (:method ((parent window-stream))
	   (world-territory-no parent))
  (:method ((parent active-region))
	   (active-region-territory-no parent)))

;;; $B%"%/%F%#%V%j!<%8%g%s@8@.(B
(defun make-active-region (&rest rest 
			   &key (region  nil)
				(left 0) (right 0)
				(top 0) (bottom 0)
				(width nil) (height nil)
				(parent *ROOT-WINDOW*)
				(button1-method nil)
				(left-button-down-1-method nil)
				(middle-button-down-1-method nil)
				(right-button-down-1-method nil)
				(button-up-method nil)
				(left-button-up-method nil)
				(middle-button-up-method nil)
				(right-button-up-method nil)
				(button2-method nil)
				(left-button-down-2-method nil)
				(middle-button-down-2-method nil)
				(right-button-down-2-method nil)
				(move-mouse-cursor-method nil)
				(mouse-cursor-in-method nil)
				(mouse-cursor-out-method nil)
				(mouse-cursor-wait-method nil)
				(class 'active-region)
				&allow-other-keys
				)
  (declare (inline +))
  (let* ((lleft (if region
		   (region-left region)
		 left))
	 (bbottom (if region 
		     (region-bottom region)
		   bottom))
	 (rright (if region
		    (region-right region)
		   (if width
		       (+ left width)
		     right)))
	 (ttop (if region
		  (region-top region)
		 (if height
		     (+ bottom height)
		   top))))
	 
  (apply #'make-instance 
	 class
	 :left lleft
	 :right rright
	 :bottom bbottom
	 :top ttop
	 :active-region-parent parent
	 :button-1 button1-method
	 :left-button-down-1 left-button-down-1-method
	 :middle-button-down-1 middle-button-down-1-method
	 :right-button-down-1 right-button-down-1-method
	 :button-up button-up-method
	 :left-button-up left-button-up-method
	 :middle-button-up middle-button-up-method
	 :right-button-up right-button-up-method
	 :button-2 button2-method
	 :left-button-down-2 left-button-down-2-method
	 :middle-button-down-2 middle-button-down-2-method
	 :right-button-down-2 right-button-down-2-method
	 :move-mouse-cursor move-mouse-cursor-method
	 :mouse-cursor-in mouse-cursor-in-method
	 :mouse-cursor-out mouse-cursor-out-method
	 :mouse-cursor-wait mouse-cursor-wait-method rest))
)

(defmethod initialize-instance :after ((instance active-region) &rest arg &key &allow-other-keys)

  (let ((t-no 0)
	(left (region-left instance))
	(bottom (region-bottom instance))
	(parent (active-region-parent instance))
	(mask (get-avialble-mask arg)))
	      
    ;;; $B%F%j%H%j!<$H$N4XO"$E$1(B
    (setf t-no (with-object-make-territory instance
		      :x (real-left parent left)
		      :y (real-bottom parent bottom)
		      :width (region-width instance)
		      :height (region-height instance)
		      :parent (parent-territory-no parent)
		      :visible T :drawable nil :fence T))

    ;;; $B?F$KEPO?(B
    (push instance (active-region-list parent))

    ;;; $B%F%j%H%j!<HV9f$N@_Dj(B
    (setf (active-region-territory-no instance)
	  t-no)
    
    ;;; $B%$%Y%s%H%^%9%/$N@_Dj(B
    (setf (slot-value instance 'event-mask) mask)
    
    ;;; YY$B%5!<%P$KDLCN(B
    (yy-protocol-72 t-no mask)
    (values)))


;;; $B%"%/%F%#%V%j!<%8%g%sMQ$N%a%=%C%I$N@_Dj(B

;;; $B%$%Y%s%H%a%=%C%I%_%-%7%s$N%"%/%;%C%5(B SETF
(defmethod (setf event-mask) :after ((new-mask integer)
                              (event-method active-region))
  (setf (slot-value event-method 'event-mask)
        (logior new-mask (slot-value event-method 'event-mask)))
  (yy-protocol-72 (active-region-territory-no event-method)
		  (slot-value event-method 'event-mask)))

;;; $B%\%?%s$,2!2<$5$l$?$3$H$K$h$j5/F0$9$k%a%=%C%I(B setf
(defmethod (setf button1-method) :after (new-value
                                       (event-method active-region))
  (when new-value
      (yy-protocol-72 (active-region-territory-no event-method)
                  (slot-value event-method 'event-mask))))

;;; $B:8%\%?%s$,2!2<$5$l$?$3$H$K$h$j5/F0$9$k%a%=%C%I(B SETF
(defmethod (setf left-button-down-1-method) :after (new-value
                                       (event-method active-region))
  (when new-value
      (yy-protocol-72 (active-region-territory-no event-method)
                  (slot-value event-method 'event-mask))))

;;; $BCf%\%?%s$,2!2<$5$l$?$3$H$K$h$j5/F0$9$k%a%=%C%I(B SETF
(defmethod (setf middle-button-down-1-method) :after (new-value
                           (event-method active-region))
  (when new-value
      (yy-protocol-72 (active-region-territory-no event-method)
                  (slot-value event-method 'event-mask))))

;;; $B1&%\%?%s$,2!2<$5$l$?$3$H$K$h$j5/F0$9$k%a%=%C%I(B
(defmethod (setf right-button-down-1-method) :after (new-value
                            (event-method active-region))
  (when new-value
      (yy-protocol-72 (active-region-territory-no event-method)
                  (slot-value event-method 'event-mask))))

;;; $B%\%?%s$,N%$5$l$?;~5/F0$9$k%a%=%C%I(B
(defmethod (setf button-up-method) :after (new-value
                                     (event-method active-region))
  (when new-value
      (yy-protocol-72 (active-region-territory-no event-method)
                  (slot-value event-method 'event-mask))))

;;; $B:8%\%?%s$,N%$5$l$?;~5/F0$9$k%a%=%C%I(B
(defmethod (setf left-button-up-method) :after (new-value
                            (event-method active-region))
  (when new-value
      (yy-protocol-72 (active-region-territory-no event-method)
                  (slot-value event-method 'event-mask))))

;;; $BCf%\%?%s$,N%$5$l$?;~5/F0$9$k%a%=%C%I(B
(defmethod (setf middle-button-up-method) :after (new-value
                           (event-method active-region))
  (when new-value
      (yy-protocol-72 (active-region-territory-no event-method)
                  (slot-value event-method 'event-mask))))

;;; $B1&%\%?%s$,N%$5$l$?;~5/F0$9$k%a%=%C%I(B
(defmethod (setf right-button-up-method) :after (new-value
                           (event-method active-region))
  (when new-value
      (yy-protocol-72 (active-region-territory-no event-method)
                  (slot-value event-method 'event-mask))))

;;; $B%\%?%s$,%@%V%k%/%j%C%/$5$l$?$3$H$K$h$j5/F0$9$k%a%=%C%I(B
(defmethod (setf button2-method) :after (new-value
                           (event-method active-region))
  (when new-value
      (yy-protocol-72 (active-region-territory-no event-method)
                  (slot-value event-method 'event-mask))))

;;; $B:8%\%?%s$,%@%V%k%/%j%C%/$5$l$?$3$H$K$h$j5/F0$9$k%a%=%C%I(B
(defmethod (setf left-button-down-2-method) :after (new-value
                           (event-method active-region))
  (when new-value
      (yy-protocol-72 (active-region-territory-no event-method)
                  (slot-value event-method 'event-mask))))


;;; $BCf%\%?%s$,%@%V%k%/%j%C%/$5$l$?$3$H$K$h$j5/F0$9$k%a%=%C%I(B
(defmethod (setf middle-button-down-2-method) :after (new-value
                           (event-method active-region))
  (when new-value
      (yy-protocol-72 (active-region-territory-no event-method)
                  (slot-value event-method 'event-mask))))


;;; $B1&%\%?%s$,%@%V%k%/%j%C%/$5$l$?$3$H$K$h$j5/F0$9$k%a%=%C%I(B
(defmethod (setf right-button-down-2-method) :after (new-value
                           (event-method active-region))
  (if new-value
    (yy-protocol-72 (active-region-territory-no event-method)
                  (slot-value event-method 'event-mask))))

;;; $B%^%&%9%+!<%=%k$,F0$/$3$H$K$h$j5/F0$9$k%a%=%C%I(B
(defmethod (setf move-mouse-cursor-method) :after (new-value
                           (event-method active-region ))
  (if new-value
    (yy-protocol-72 (active-region-territory-no event-method)
                  (slot-value event-method 'event-mask))))
	    

;;; $B%^%&%9%+!<%=%k$,F~$C$?;~$K5/F0$9$k%a%=%C%I(B
(defmethod (setf mouse-cursor-in-method) :after (new-value
                           (event-method active-region))
  (when new-value
      (yy-protocol-72 (active-region-territory-no event-method)
                  (slot-value event-method 'event-mask))))


;;; $B%^%&%9%+!<%=%k$,=P$?;~$K5/F0$9$k%a%=%C%I(B
(defmethod (setf mouse-cursor-out-method) :after (new-value
                           (event-method  active-region))
  (if new-value
    (yy-protocol-72 (active-region-territory-no event-method)
                  (slot-value event-method 'event-mask))))


;;; $B%^%&%9%+!<%=%k$,$"$kNN0h$G(BN$B%_%jICDd;_$7$?;~$K5/F0$9$k%a%=%C%I(B
(defmethod (setf mouse-cursor-wait-method) :after (new-value
                           (event-method active-region))
  (if new-value
      (yy-protocol-72 (active-region-territory-no event-method)
                  (slot-value event-method 'event-mask))))

;;; $B%"%/%F%#%V%j!<%8%g%s$NJQ99$K$h$k%F%j%H%j!<$NJQ99(B
(defmethod change-active-region ((region active-region))
  (let ((bottom (min (real-bottom (active-region-parent region)
				  (region-bottom region))
		     (real-bottom (active-region-parent region)
				  (region-top region))))
	(parent (active-region-parent region)))

    (yy-protocol-4 (active-region-territory-no region)
		   (real-left parent (region-left region))
		    bottom
		   (region-width region)
		   (region-height region))))

;;; left-bottom setf $B%"%/%;%5(B
(defmethod (setf left-bottom) :after 
  ((new-position position) (region active-region))
  (change-active-region region))

;;; right-top setf $B%"%/%;%5(B
(defmethod (setf right-top ) :after 
  ((new-position position) (region active-region))
  (change-active-region region))

;;; Region$B$N%3%T!<%a%=%C%I(B
(defmethod region-copy :after ((region active-region))
  (make-active-region :left (region-left region)
		      :bottom (region-bottom region)
		      :width (region-width region)
		      :height (region-height region)
		      :parent (active-region-parent region)
		      :button1-method (button1-method region) 
		      :left-button-down-1-method 
		      (left-button-down-1-method region)
		      :middle-button-down-1-method
		      (middle-button-down-1-method region) 
		      :right-button-down-1-method 
		      (right-button-down-1-method region) 
		      :button-up-method 
		      (button-up-method region) 
		      :left-button-up-method
		      (left-button-up-method region) 
		      :middle-button-up-method
		      (middle-button-up-method region)
		      :right-button-up-method
		      (right-button-up-method region) 
		      :button2-method (button2-method region) 
		      :left-button-down-2-method
		      (left-button-down-2-method region) 
		      :middle-button-down-2-method
		      (middle-button-down-2-method region) 
		      :right-button-down-2-method
		      (right-button-down-2-method region) 
		      :move-mouse-cursor-method
		      (move-mouse-cursor-method region) 
		      :mouse-cursor-in-method
		      (mouse-cursor-in-method region) 
		      :mouse-cursor-out-method
		      (mouse-cursor-out-method region) 
		      :mouse-cursor-wait-method
		      (mouse-cursor-wait-method region)))

;;; region-left$B$N(BSETF$B%"%/%;%5(B
(defmethod (setf region-left) :after ((left integer) (region active-region))
  (change-active-region region))

;;; region-top$B$N(BSETF$B%"%/%;%5(B
(defmethod (setf region-top) :after ((top integer) (region active-region))
  (change-active-region region))

;;; region-right$B$N(BSETF$B%"%/%;%5(B
(defmethod (setf region-right) :after ((right integer) (region active-region))
  (change-active-region region))

;;; region-bottom$B$N(BSETF$B%"%/%;%5(B
(defmethod (setf region-bottom) :after ((bottom integer) (region active-region))
  (change-active-region region))

;;; region-width $B$N(BSETF$B%"%/%;%5(B
(defmethod (setf region-width) :after ((width integer) (region active-region))
  (change-active-region region))

;;; region-height$B$N(BSETF$B%"%/%;%5(B
(defmethod (setf region-height) :after ((height integer) (region active-region))
  (change-active-region region))

;;; $B%*%V%8%'%/%H$,(Bregion$B$G$"$k$+(B?
(defun active-region-p (region)
  (typep region 'active-region))

;;; $B%j!<%8%g%s$N%]%8%7%g%s$N(Bsetf
(defmethod (setf region-position) :after ((new-position position)
                                   (region active-region))
  (change-active-region region))

;;;$B%j!<%8%g%s$N%]%8%7%g%s$rM?$($i$l$?(BX Y$B$K@_Dj$9$k!#(B
(defmethod set-region-position-xy :after ((region active-region)
				   (x number)
				   (y number))
  (change-active-region region))

;;;$B%j!<%8%g%s$N%]%8%7%g%s$rM?$($i$l$?(Bposition$B$K@_Dj$9$k!#(B
(defmethod set-region-position :after ((region active-region) 
				       (new-position position))
  (change-active-region region))


;;; $B%"%/%F%#%V%j!<%8%g%s$N?F$NJQ99(B
(defmethod (setf active-region-parent) :after
  ((new-window window-stream) (aregion active-region))
  (let ((r-bottom (real-bottom (active-region-parent aregion)
			       (region-bottom  aregion))))

	;;; $B%F%j%H%j$N?F$NJQ99(B
    (delete aregion (active-region-list 
		      (active-region-parent aregion)))

    (yy-protocol-6 (active-region-territory-no aregion)
		   (parent-territory-no (active-region-parent aregion))
		   (region-left aregion)  r-bottom)
    (call-next-method)))


;;; $B%"%/%F%#%V%j!<%8%g%s$J$$$N0LCV$r?F$N%&%#%s%I%&%9%H%j!<%`$+$i$N(B
;;; $B0LCV$KJQ99$9$k(B XY
(defmethod translate-root-xy ((a-region active-region) x y)
  (translate-root-xy (active-region-parent a-region)
		     (+ x (region-left a-region))
		     (+ y (region-bottom a-region)))
  )
	
;;; $B%$%Y%s%H$N0l;~Dd;_(B $B%"%/%F%#%V%j!<%8%g%s(B
(defmethod disnable-event ((a-region active-region) mask)
  (let* ((old-mask (event-mask a-region))
         (new-mask (logand (lognot mask) old-mask)))
    (yy-protocol-72 (active-region-territory-no a-region) new-mask)))

;;;$B%$%Y%s%H$N2sI|(B  $B%"%/%F%#%V%j!<%8%g%sMQ(B
(defmethod enable-event ((a-region active-region))
  (yy-protocol-72 (active-region-territory-no a-region)
                  (event-mask a-region)))

