;;; -*- Mode: LISP; Syntax: COMMON-LISP; Base: 10.; Package: XIT -*-
;;;________________________________________________________________________
;;;
;;;                       System: XACT
;;;                       Module: top window
;;;                       Version: 1.0
;;;
;;; Copyright (c): Forschungsgruppe DRUID, Juergen Herczeg
;;;                Universitaet Stuttgart
;;;
;;; File: /usr/local/lisp/xit/xact/top-window.lisp
;;; File Creation Date: 02/11/92 16:20:47
;;; Last Modification Time: 07/16/93 08:08:48
;;; Last Modification By: Juergen Herczeg
;;;
;;;
;;; Changes (worth to be mentioned):
;;; ================================
;;;
;;;_________________________________________________________________________
		    
;___________________________________________________________________________
;
;                           window classes
;___________________________________________________________________________

(in-package :xit)

#||
;; to be removed
(defcontact window-button (bitmap-dispel)
  ((mouse-feedback :initform :border)))

(defmethod initialize-instance :after ((self window-button) &rest initargs
				       &key action-docu)
  (unless (reactivity-entry self :select)
    (let ((actions `((call :part-of ,(view-of self)))))
      (apply #'change-reactivity self :select
	     (if action-docu
		 (cons action-docu actions)
		 actions)))))
||#

(defcontact work-area-window (focus-mixin intel)
  ((reactivity :initform
	       '((:metasystem "Select metasystem"
		     (call :self select-meta-system-for-part-with-event))))))

(defmethod select-meta-system-for-selected-part ((self composite))
  (let ((selected-part
	 (identify-window (toplevel-window self)
			  :test #'(lambda (window)
				    (ancestor-p window self))
			  :mouse-documentation "Select object for metasystem")))
    (when selected-part 
      (select-meta-system selected-part))))

(defmethod select-meta-system-for-part-with-event ((self work-area-window))
  "to be used as action for user event, e.g. a button click"
  (with-event (child x y)
    (if child
      (select-meta-system child)
      (select-meta-system-for-selected-part self))))

(defmethod default-initargs-for (class (parent work-area-window))
  (declare (ignore class))
  (list* :background "white"
	 (call-next-method)))

#||
;; to be removed
(defmethod do-create-part :around (type (parent work-area-window) &optional init-list)
  (call-next-method type parent
		    (append init-list '(:background "white"))))
||#

(defmethod meta-toplevel-window ((self work-area-window))
  self)

(defmethod meta-toplevel-window-p ((self work-area-window))
  t)

(defmethod remove-all-objects ((self work-area-window))
  (broadcast self #'destroy))

(defmethod generate-code ((self work-area-window))
  (generate-and-write-code (parts self)))

;___________________________________________________________________________
;
;                           top window
;___________________________________________________________________________

(defcontact ui-construction-window (window-icon-mixin paned-window)
  ((name :initform :user-interface-construction-window)
   (inside-border :initform 3)
   (adjust-size? :initform nil)
   (reactivity :initform '((:select "Totop window")
			   (:move)))))

(defmethod get-default-icon ((self ui-construction-window) &rest init-list)
  (apply #'make-window 'text-icon
	 :border-width 0
	 :inside-border 0
	 :layouter '(aligning-distance-layouter
		     :alignment :center
		     :distance -1)
	 :text-part `(:border-width 1
		      :background "white"
		      :text ,(text (part self :title))
		      :font (:size :small))
	 :bitmap-part '(:bitmap "xact"
			:background "white"
			:border-width 1)
	 :reactivity '((:move))
         init-list))

(defmethod work-area ((self ui-construction-window))
  (client-window (part self :work-area)))

(defmethod default-parts-options ((class (eql 'ui-construction-window)))
  '(;; header
    (:class text-dispel
     :name :title
     :adjust-size? nil
     :text "User Interface Construction Kit"
     :font (:face :bolditalic :size 14)
     :background "black"
     :foreground "white"
     :inside-border 4
     :display-position :center)

    ;; global operations
    (:class text-menu
     :name :global-operations-menu
     :layouter (distance-layouter :distance 20 :orientation :right)
     :part-font (:size 14 :face :bold)
     :parts
     ((:text "Palette"
       :action (call :eval (select-gio-palette))
       :action-docu "Open palette")
      (:text "Catalog"
       :action (call :eval (select-gio-catalog))
       :action-docu "Open catalog")
      (:text "Metasystem"
       :action (call :eval (select-meta-system-for-selected-part
			    (work-area (part-of *self* 2))))
       :action-docu "Select metasystem for object in work area")))

    ;; load/save operations
    (:class text-menu
     :name :load-save-operations-menu
     :layouter (distance-layouter :distance 20 :orientation :right)
     :part-font (:size 14 :face :bold)
     :parts
     ((:text "Load"
       :action (call :eval (load-code
		      (work-area (part-of *self* 2))))
       :action-docu "Load code for interaction objects")
      (:text "Save"
       :action (call :eval (generate-code
			    (work-area (part-of *self* 2))))
       :action-docu "Generate and save code for interaction objects")))
    
    (:class text-menu
     :name :clear-menu
     :layouter (distance-layouter :distance 20 :orientation :right)
     :part-font (:size 14 :face :bold)
     :parts
     ((:text "Clear"
       :action (call :eval (remove-all-objects
			    (work-area (part-of *self* 2))))
       :action-docu "Remove all interaction objects in work area")))

    ;; window operation menu
    (:class bitmap-menu
     :name :window-operations-menu
     :inside-border 0
     :layouter (distance-layouter :distance 3 :orientation :right)
     :action (call :eval (funcall *part-value* (top-window *self*)))
     :parts
     ((:view-of refresh-window
       :bitmap "button-refresh"
       :action-docu "Refresh Window")
      (:view-of move-window
       :bitmap "button-move"
       :action-docu "Move Window")
      (:view-of resize-window
       :bitmap "button-resize"
       :action-docu "Resize Window")
      (:view-of totop-window
       :bitmap "button-totop"
       :action-docu "Put Window on Top")
      (:view-of tobottom-window
       :bitmap "button-tobottom"
       :action-docu "Put Window to Bottom")
      (:view-of shrink
       :bitmap "button-shrink"
       :action-docu "Shrink Window to Icon")
      (:view-of destroy
       :bitmap "button-kill"
       :cursor "pirate"
       :action-docu "Remove Window")))
 
      ;; work-area
      (:class margined-window
       :name :work-area
       :adjust-size? nil
       :border-width 0
       :margins
       ((standard-margins-with-scroll-bars 
	  :label-options (:text "Work Area" :display-position :left-center) 
	  :scroll-bar-options (:locations (:right :bottom))))
       :client-window
       (work-area-window
	:width 1000
	:height 1000
	:inside-border 0
	:adjust-size? nil
	))
      ))


(defmethod default-layouter-options ((class (eql 'ui-construction-window)))
  '(pane-layouter
       :configuration configuration-1
       :configurations
       ((configuration-1
	  ((:title :ask)
	   (empty 3)
	   (menu-strip (:ask :window-operations-menu) :h
		       (empty 3)
		       (:global-operations-menu :ask)
		       (empty :even)
		       (:load-save-operations-menu :ask)
		       (empty :even)
		       (:clear-menu :ask)
		       (empty :even)
		       (:window-operations-menu :ask)
		       (empty 3))
	   (empty 3)
	   (:work-area :rest))
	   ))))
