;;; -*- Mode: LISP; Syntax: COMMON-LISP; Base: 10.; Package: XIT -*-
;;;________________________________________________________________________
;;;
;;;                       System: XACT 
;;;                       Module: Palettes
;;;                       Version: 1.0
;;;
;;; Copyright (c): Forschungsgruppe DRUID, Juergen Herczeg
;;;                Universitaet Stuttgart
;;;
;;; File: /usr/local/lisp/xit/xact/palette-descriptions.lisp
;;; File Creation Date: 02/06/92 14:18:01
;;; Last Modification Time: 07/15/93 16:06:12
;;; Last Modification By: Juergen Herczeg
;;;
;;;
;;; Changes (worth to be mentioned):
;;; ================================
;;;
;;;________________________________________________________________________

(in-package :xit)
  
;___________________________________________________________________________
;
;                       predefined palettes
;___________________________________________________________________________

(defvar *default-gio-palette* 'intels)

#||
(define-gio-palette 'basics
    :text "Basics"
    :documentation "Basic interaction objects"
    :class 'bitmap-menu
    :parts
    '((:view-of (:class text-dispel
		 :initargs (:text "Text"))
       :bitmap "a-text-dispel"
       :action-docu "Make text dispel")
      (:view-of (:class bitmap-dispel
		 :initargs (:bitmap "a-bitmap-dispel"))
       :bitmap "a-bitmap-dispel"
       :action-docu "Make bitmap dispel")
      (:view-of (:class text-icon
		 :initargs (:text-part (:x 30 :y 20  :text "text")
			    :bitmap-part (:bitmap "icon-bitmap")))
       :bitmap "an-icon"
       :action-docu "Make icon")
      (:view-of (:class soft-button
		 :initargs (:text-part (:text "Button")
			    :bitmap-part (:bitmap "button-ml")))
       :bitmap "a-button"
       :action-docu "Make button")
      (:view-of (:class shadow-borders-popup-container
		 :initargs (:width 100 :height 100 :border-width 1
			    :state :mapped
			    :adjust-size? nil
			    :client-window
			    (intel
			     :adjust-size? nil
			     :reactivity-entries
			     ((:meta-drag-and-drop) (:metasystem)))))
       :bitmap "a-popup-window"
       :action-docu "Make popup window")
      (:view-of (:class text-menu
		 :initargs (:border-width 1))
       :bitmap "a-text-menu"
       :action-docu "Make text menu")
      (:view-of (:class single-choice-box-menu
		 :initargs (:border-width 1))
       :bitmap "a-single-choice-menu"
       :action-docu "Make single choice menu")
      (:view-of (:class multiple-choice-box-menu
		 :initargs (:border-width 1))
       :bitmap "a-multiple-choice-menu"
       :action-docu "Make multiple choice menu")
      (:view-of (:class text-switch
		 :initargs (:border-width 1))
       :bitmap "a-switch"
       :action-docu "Make text switch")
      ;;(:class dispel
       ;;:width 1 :height 1
       ;;:state :managed)
      (:view-of (:class text-property-sheet
		 :initargs (:border-width 1))
       :bitmap "a-property-sheet"
       :action-docu "Make property sheet")
      (:view-of (:class intel
		 :initargs (:width 100 :height 100
			    :border-width 1 :adjust-size? nil))
       :bitmap "an-intel"
       :action-docu "Make intel")
      (:view-of (:class paned-window
		 :initargs (:width 100 :height 100 :adjust-size? nil))
       :bitmap "a-paned-window"
       :action-docu "Make paned window")
      (:view-of (:class margined-window
		 :initargs
		 (:width 100 :height 100 :adjust-size? nil
		  :margins 
		  ((standard-margins-with-scroll-bars 
		    :label-options (:text "Title"
				    :reactivity-entries ((:metasystem)))
		    :scroll-bar-options (:locations (:right :bottom)
					 :reactivity-entries ((:metasystem)))
		    :quad-space-options (:thickness 1
				         :reactivity-entries ((:metasystem)))))
		  ;;:client-window :none ;; doesn't work
		  :client-window (intel
				  :reactivity-entries
				  ((:meta-drag-and-drop) (:metasystem)))))
       :bitmap "a-margined-window"
       :action-docu "Make margined window")
      ))
||#

(define-gio-palette 'intels
    :text "Intels"
    :documentation "Basic composite objects"
    :class 'bitmap-menu
    :parts
    '((:view-of (:class intel
		 :initargs (:width 100 :height 100
			    :border-width 1 :adjust-size? nil))
       :bitmap "an-intel"
       :action-docu "Make intel")
      (:view-of (:class uniform-part-intel
		 :initargs (:width 100 :height 100
			    :border-width 1 :adjust-size? nil
			    :part-class text-dispel))
       :bitmap "a-uni-part-intel"
       :action-docu "Make uniform-part-intel")
      (:view-of (:class paned-window
		 :initargs (:width 100 :height 100 :adjust-size? nil))
       :bitmap "a-paned-window"
       :action-docu "Make paned window")
      (:view-of (:class margined-window
		 :initargs
		 (:width 100 :height 100 :adjust-size? nil
		  :margins 
		  ((standard-margins
		    :label-options (:text "Title"
				    :editable? t
				    :reactivity-entries ((:metasystem)))
		    :quad-space-options (:thickness 1
				         :reactivity-entries ((:metasystem)))))
		  ;;:client-window :none ;; doesn't work
		  :client-window (intel
				  :reactivity-entries ((:metasystem)))))
       :bitmap "a-label-marg-win"
       :action-docu "Make margined window with title")
      (:view-of (:class margined-window
		 :initargs
		 (:width 100 :height 100 :adjust-size? nil
		  :margins 
		  ((standard-margins-with-scroll-bars-without-label 
		    :scroll-bar-options (:locations (:right :bottom)
					 :reactivity-entries ((:metasystem)))
		    :quad-space-options (:thickness 1
				         :reactivity-entries ((:metasystem)))))
		  ;;:client-window :none ;; doesn't work
		  :client-window (intel
				  :reactivity-entries ((:metasystem)))))
       :bitmap "a-scroll-marg-win"
       :action-docu "Make margined window with scrollbars")
      (:view-of (:class margined-window
		 :initargs
		 (:width 100 :height 100 :adjust-size? nil
		  :margins 
		  ((standard-margins-with-scroll-bars 
		    :label-options (:text "Title"
				    :editable? t
				    :reactivity-entries ((:metasystem)))
		    :scroll-bar-options (:locations (:right :bottom)
					 :reactivity-entries ((:metasystem)))
		    :quad-space-options (:thickness 1
				         :reactivity-entries ((:metasystem)))))
		  ;;:client-window :none ;; doesn't work
		  :client-window (intel
				  :reactivity-entries ((:metasystem)))))
       :bitmap "a-margined-window"
       :action-docu "Make margined window with title and scrollbars")
      ))


(define-gio-palette 'dispels
    :text "Dispels"
    :documentation "Basic display objects"
    :parts
    `((:class dispel
       :view-of (:class dispel
		 :initargs (:adjust-size? nil
			    :width 50 :height 30
			    :border-width 1))
       :adjust-size? nil
       :width 50 :height 30
       :border-width 1
       :action-docu "Make dispel")
      (:class text-dispel
       :view-of (:class text-dispel
		 :initargs (:text "text"
			    :editable? t))
       :border-width 1
       :inside-border 5
       :text "text"
       :font (:face :bold)
       :action-docu "Make text dispel")
      (:class multi-line-text-dispel
       :view-of (:class multi-line-text-dispel
		 :initargs (:text ,(format nil "multi-line~%text")
			    :editable? t))
       :border-width 1
       :inside-border 5
       :text ,(format nil "multi-line~%text")
       :font (:face :bold)
       :action-docu "Make multi-line text dispel")
      (:class bitmap-dispel
       :view-of (:class bitmap-dispel
		 :initargs (:bitmap "a-bitmap-dispel"))
       :bitmap "a-bitmap-dispel"
       :action-docu "Make bitmap dispel")
      ))

(define-gio-palette 'graphics
    :text "Graphics"
    :documentation "Graphical objects")

(define-gio-palette 'menus
    :text "Menus"
    :documentation "Menu interaction objects"
    :class 'bitmap-menu
    :parts
    '((:view-of (:class text-menu
		 :initargs (:border-width 1))
       :bitmap "a-text-menu"
       :action-docu "Make text menu")
      (:view-of (:class single-choice-text-menu
		 :initargs (:border-width 1))
       :bitmap "a-single-choice-text-menu"
       :action-docu "Make single choice text menu")
      (:view-of (:class multiple-choice-text-menu
		 :initargs (:border-width 1))
       :bitmap "a-multiple-choice-text-menu"
       :action-docu "Make multiple choice text menu")
      (:view-of (:class single-choice-box-menu
		 :initargs (:border-width 1))
       :bitmap "a-single-choice-menu"
       :action-docu "Make single choice menu")
      (:view-of (:class multiple-choice-box-menu
		 :initargs (:border-width 1))
       :bitmap "a-multiple-choice-menu"
       :action-docu "Make multiple choice menu")
      (:view-of (:class text-switch
		 :initargs (:border-width 1))
       :bitmap "a-switch"
       :action-docu "Make text switch")
      ))

(define-gio-palette 'other
    :text "Other"
    :documentation "Icons, buttons, property sheets"
    :class 'bitmap-menu
    :parts
    '((:view-of (:class text-icon
		 :initargs (:text-part (:x 30 :y 20
					:text "text" :editable? t)
			    :bitmap-part (:bitmap "icon-bitmap")))
       :bitmap "an-icon"
       :action-docu "Make icon")
      (:view-of (:class soft-button
		 :initargs (:text-part (:text "Button" :editable? t)
			    :bitmap-part (:bitmap "button-ml")))
       :bitmap "a-button"
       :action-docu "Make button")
      (:class soft-button
       :view-of (:class soft-button
		 :initargs (:text-part (:text "Button" :editable? t)
			    :bitmap-part :none))
       :inside-border 5
       :text-part (:text "Button")
       :bitmap-part :none
       :action-docu "Make button")
      (:view-of (:class text-property-sheet
		 :initargs (:border-width 1))
       :bitmap "a-property-sheet"
       :action-docu "Make property sheet")
      ))

(define-gio-palette 'containers
    :text "Containers"
    :documentation "Container objects"
    :class 'bitmap-menu
    :parts
    `((:view-of (:action ,#'create-popup-from-palette
		 :class shadow-borders-popup-container
		 :initargs (:width 100 :height 100 :border-width 1
			    :state :mapped
			    :adjust-size? nil
			    :client-window
			    (intel
			     :adjust-size? nil
			     :reactivity-entries
			     ((:meta-drag-and-drop) (:metasystem)))))
       :bitmap "a-popup-window"
       :action-docu "Make popup window")
      (:view-of (:action
		 ,#'create-popup-part-container-from-palette
		 :class window-icon-popup-part-container
		 :initargs (:width 100 :height 100 :border-width 1
			    :state :mapped
			    :adjust-size? nil
			    :client-window
			    (intel
			     :adjust-size? nil
			     :reactivity-entries
			     ((:meta-drag-and-drop) (:metasystem)))))
       :bitmap "a-popup-part-container"
       :action-docu "Make popup-part container")
      (:view-of (:action
		 ,#'create-window-icon-container-from-palette
		 :class window-icon-popup-part-container
		 :initargs (:width 100 :height 100 :border-width 1
			    :state :mapped
			    :adjust-size? nil
			    :client-window
			    (intel
			     :adjust-size? nil
			     :reactivity-entries
			     ((:meta-drag-and-drop) (:metasystem)))))
       :bitmap "a-window-icon-container"
       :action-docu "Make window-icon container")
      ))
