;;; -*- Mode: LISP; Syntax: COMMON-LISP; Base: 10.; Package: XIT -*-
;;;_____________________________________________________________________________
;;;
;;;                       System: XACT
;;;                       Module: Metasystem Extensions
;;;                       Version: 1.0
;;;
;;; Copyright (c): Forschungsgruppe DRUID, Juergen Herczeg
;;;                Universitaet Stuttgart
;;;
;;; File: /usr/local/lisp/xit/xact/metasystem-ext.lisp
;;; File Creation Date: 10/08/92 14:13:06
;;; Last Modification Time: 06/24/93 14:11:06
;;; Last Modification By: Juergen Herczeg
;;;
;;;
;;; Changes (worth to be mentioned):
;;; ================================
;;;
;;;_____________________________________________________________________________

(in-package :xit)

;___________________________________________________________________________
;
;                            definitions
;___________________________________________________________________________
      
(defmethod add-popup-part ((self contact))
  (with-slots (x y parent display) self
    (let ((container (create-new-part
		      'window-icon-popup-part-container
		      parent
		      `(:x ,x :y ,y :layouted? t
			:window-icon nil))))
      (update-state display)
      (setf (contact-parent self) container)
      ;(unless (reactivity-entry self :menu)
	;(change-reactivity self :menu "Menu" '(call :part-of select-from-popup-part)))
      (identify-popup-part-with-mouse container)
      )))

(defmethod add-popup-part ((self popup-part-connection))
  ;(identify-popup-part-with-mouse self)
  )

(defmethod add-window-icon ((self contact))
  (with-slots (x y parent display) self
    (let ((container (create-new-part
		      'window-icon-popup-part-container parent
		      `(:x ,x :y ,y :layouted? t))))
      (update-state display)
      (setf (contact-parent self) container)
      ;(identify-window-icon-with-mouse container)
      )))

(defmethod add-window-icon ((self window-icon-mixin))
  ;(identify-window-icon-with-mouse self)
  )

;___________________________________________________________________________
;
;                            extensions
;___________________________________________________________________________

(defmethod meta-operation-sheet-entries :around ((self contact))
  (append
   (call-next-method)
   '((:view-of totop-window
      :text "Totop"
      :action-docu "Put window on top")
     (:view-of tobottom-window
      :text "Tobottom"
      :action-docu "Put window to bottom"))
   (unless (or (root-p self) (shell-p self)
	       (typep self 'popup-part-connection))
     '((:view-of add-popup-part
	:text "Add Popup"
        :action-docu "Add Popup")))
   (unless (or (root-p self) (shell-p self)
	       (typep self 'window-icon-mixin))
     '((:view-of add-window-icon
        :text "Add Window Icon"
        :action-docu "Add Window Icon")))))