;;; -*- Mode: LISP; Syntax: COMMON-LISP; Package: CLUEI; Base: 10; -*-

;;; 07/07/1993 (Juergen) 
;;;
;;; (setf contact-sensitive) and owns-focus-p are now also defined for
;;; basic-contacts; so far they were only defined for contacts
 
(in-package :cluei)

(defmethod owns-focus-p ((contact basic-contact))
  (with-slots (display) contact
    (eq contact (input-focus display))))

(defmethod (setf contact-sensitive) (value (self basic-contact))
  (declare (type (member :off :on) value))
  (check-type value (member :off :on) ":ON or :OFF")
  (with-slots (x y width height sensitive parent display) self
    (let ((old sensitive))
      (setf sensitive value)

      ;; Redisplay when changing sensitive
      (when (and (not (eq old value)) (viewable-p self))
	(refresh self)

	;; Give up focus if insensitive
	(when (and (eq :off value) (owns-focus-p self))
	  ;; Send focus to parent.
	  (set-input-focus display parent :parent)))))
  value)