;;;
;;; Copyright (c) 1990 Regents of the University of California
;;; 
;;; $Author: bsmith $
;;; $Source: /n/mickey/cluster/picasso/new/widgets/menu/RCS/menu-pane.cl,v $
;;; $Revision: 1.3 $
;;; $Date: 1992/02/22 00:52:42 $
;;;

(in-package "PT")

;;;  THE DEFCLASS FOR MENU-PANE CAN BE FOUND IN menu-defclasses.cl

;;; these class event map mappings should never be used, but are here in case 
;;; of spurious X events.
;;; The only possible exception is for a panel menu, which may be activated
;;; though an enter-window event

(defmethod do-attach ((self menu-pane))
  (call-next-method)
  (dolist (me (synths self))
	  (me-attach me self))
  (setf (slot-value self 'synth-data) t)
  (calculate-min-size self)
  (setf (xlib:window-save-under (res self)) :on)
  (setf (xlib:window-override-redirect (res self)) :on)
  (setf (xlib:window-priority (res self)) :top-if))

(defmethod do-detach ((self menu-pane))
  (call-next-method)
  ;; don't want to erase the slot 'synths!
  ;; (setf (slot-value self 'synths))
  (mapcar #'me-detach (synths self))
  )

(defhandler ignore ((self menu-pane) &rest args
		    &default :button-release)
  (declare (ignore args self))
  t)

(defhandler motion ((self pane) &key y &allow-other-keys &aux current-cell temp
		    &default :pointer-motion) 
  (setq current-cell (slot-value self 'current-cell)) 
  (when (>= y 0) 
	(setq temp (aref (ptab self) y))
	(cond ((and (menu-entry-p temp) 
		    (menu-entry-p current-cell))
	       (unless (or (eql temp current-cell) 
			   (not (menu-entry-p temp)))
		       (unless (dimmed current-cell)
			       (me-uninvert current-cell
					    (res self) (gc-clear self) 
					    (width self)))
		       (setq current-cell temp)
		       (unless (dimmed current-cell)
			       (me-invert current-cell
					  (res self) (gc-res self)
					  (width self)))))
	      ((menu-entry-p current-cell)
	       (when (menu-entry-p current-cell) 
		     (unless (dimmed current-cell)
			     (me-uninvert current-cell
					  (res self) (gc-clear self)
					  (width self))))
	       (setq current-cell nil))
	      ((menu-entry-p temp)
	       (setq current-cell temp)
	       (unless (dimmed current-cell)
		       (me-invert current-cell
				  (res self) (gc-res self) (width self)))))
	(setf (slot-value self 'current-cell) current-cell)))

(defhandler deactivate ((self pane) &rest args &aux current-cell
			&default :leave-window) 
  (declare (ignore args))
  (setq current-cell (slot-value (pane self) 'current-cell))
  (when current-cell 
	(unless (dimmed current-cell)
		(me-uninvert current-cell
			     (res (pane self))
			     (gc-clear (pane self))
			     (width (pane self)))))
  (setf (slot-value (pane self) 'current-cell) nil))

(defun mp-enter (pane &key y &allow-other-keys &aux current-cell)
  (setq current-cell (aref (ptab pane) y))
  (unless (or (null current-cell) 
	      (dimmed current-cell))
	  (me-invert current-cell
		     (res pane) (gc-res pane) (width pane)))
  (setf (slot-value pane 'current-cell) current-cell))

(defhandler select ((self pane) &rest args &aux current-cell
		    &default :button-press)
  (declare (ignore args))
  (conceal self :transparent t)
  (setq current-cell (slot-value self 'current-cell))
  (when (and current-cell (not (dimmed current-cell)))
	(me-uninvert current-cell
		     (res self) (gc-clear self) (width self))
	(menu-execute current-cell))
  (detach self)
  (attach self))

(defhandler return ((self pane) &rest args
		    &default :visibility-notify)
  (declare (ignore args))
;;  (format t "return: ~s  viewable: ~s~%" self (viewable-p self))
  (unless (viewable-p self)
	  (detach self)
	  (conceal self)
	  (setf (background self) nil)
	  (attach self)))

(defhandler activate-panel ((self pane) &key y &allow-other-keys 
			    &aux current-cell
			    &default :enter-window)
  (setq current-cell (aref (ptab self) (max y 0))) 
  (unless (or (not current-cell) (dimmed current-cell))
	  (me-invert current-cell
		     (res self) (gc-res self)
		     (width self)))
  (setf (slot-value self 'current-cell) current-cell)
  (do-repaint self))

;;;
;;; New instance method for menu-panes
;;;

(defmethod new-instance ((self menu-pane)
			 &key
			 (menu nil)
			 &allow-other-keys)
  (unless (or (null menu) (menu-p menu))
	  (error "menu-pane.new-instance:  menu must be a menu!~%"))
  (call-next-method)
  (setf (ptab self) (make-array 256 :element-type t
				    :adjustable t :fill-pointer 0)))

(defun activate-pull-down-menu (pane menu-button event)
  (let* ((pane-res (res pane))
	 (menu-res (res menu-button))
	 (pane-width (base-width pane))
	 (pane-height (base-height pane))
	 (gc (gc-res pane))
	 (gc-clear (gc-clear pane))
	 (ptab (ptab pane))
	 (current-cell nil)
	 (in-menu t)
	 (temp nil)
	 (flag nil)
	 (button-x (getf event :x))
	 (button-y (getf event :y))
	 (display (getf event :display))
	 (root-x nil)
	 (root-y nil)
	 (root-window (root-window))
	 (root-width (width root-window))
	 (root-height (height root-window))
	 (x nil)
	 (y nil))
	(multiple-value-setq (root-x root-y)
			     (xlib:translate-coordinates 
			      menu-res button-x button-y (res root-window)))
	(setq x (- root-x button-x -5)
	      y (+ (- root-y button-y) (height menu-button)))
;;	(format t "X: ~s Y: ~s~%" root-x root-y)
;;	(format t "BX: ~s BY: ~s~%" button-x button-y)
;;	(repack-off (root-window))

	(if (> (+ x pane-width) root-width)
	    (setq x (- root-width pane-width)))
	(if (> (+ y pane-height) root-height)
	    (setq y (- root-height pane-height)))
	(reshape pane x y pane-width pane-height)
	(fix-region pane :x x :y y)
	(setf (xlib:window-priority pane-res) :top-if)
	(expose pane)
	(setf (xlib:window-priority (res pane)) :above)
	(do-repaint pane)
;;	(xlib:map-window (res pane))
	(xlib:display-finish-output display)
;;	(xlib:grab-server display)
	(xlib:grab-pointer pane-res '(:pointer-motion
				      :enter-window
				      :leave-window
				      :button-press
				      :button-release)
			   :owner-p t
			   :cursor (res (default-cursor)))
	;;; main loop 
	(event-sync
	 :display (display pane)
	 :discard-after-process t
	 :hang t
	 :handler
	 #'(lambda (&rest args &key event-window event-key
		      &allow-other-keys)
;;		   (format t "event: ~s~%" args)
		   (cond ((eq event-key :motion-notify)
;;			  (format t "inverting. . . ~s ~%" current-cell)
			  (when (and (>= (1- pane-height) 
					 (setq y (getf args :y)) 0) 
				     (eq event-window pane-res))
				(setq temp (aref ptab (getf args :y)))
				(cond ((and (menu-entry-p temp) 
					    (menu-entry-p current-cell))
				       (unless (or (eql temp current-cell) 
						   (not (menu-entry-p temp)))
					       (unless (dimmed current-cell)
						       (me-uninvert current-cell
								    pane-res
								    gc-clear
								    pane-width))
					       (setq current-cell temp)
					       (unless (dimmed current-cell)
						       (me-invert current-cell
								  pane-res gc
								  pane-width))))
				      ((menu-entry-p current-cell)
				       (when (menu-entry-p current-cell) 
					     (unless (dimmed current-cell)
						     (me-uninvert current-cell
								  pane-res
								  gc-clear
								  pane-width)))
				       (setq current-cell nil))
				      ((menu-entry-p temp)
				       (setq current-cell temp) 
				       (unless (dimmed current-cell)
						(me-invert current-cell
							   pane-res gc
							   pane-width))))))
			 ((eq event-key :leave-notify)
			  (unless (eq :grab (getf args :mode))
				  (when (eq event-window pane-res)
					(when current-cell 
					      (unless (dimmed current-cell)
						      (me-uninvert 
						       current-cell
						       pane-res
						       gc-clear
						       pane-width)))
					(setq current-cell nil))
				  (if (typep (find-window event-window) 'form)
				      (apply #'dispatch-event args))
				  (if (eq event-window menu-res)
				      (setq in-menu nil))))
			 ((eq event-key :enter-notify)
			  (unless (eq :grab (getf args :mode))
				  (setq temp event-window)
;;				  (format t "ARGS: ~S~%" args)
				  (unless (>= (setq y (getf args :y)) 0)
					  (setq y 0))
				  (unless (< y pane-height)
					  (setq y (1- pane-height)))
;;				  (format t "Y: ~s~%" y)
				  (cond ((equal temp pane-res)
					 (setq current-cell (aref ptab y))
					 (if (and (menu-entry-p current-cell)
						  (not (dimmed current-cell)))
						 (me-invert current-cell
							    pane-res gc
							    pane-width)))
					((equal temp menu-res)
					 (setq in-menu t))
					((typep (find-window temp) 'form)
					 (apply #'dispatch-event args))
					((eql (parent menu-button) 
					      (parent 
					       (setq temp (find-window temp))))
					 (progn (conceal pane :transparent t)
						(xlib:ungrab-pointer display)
						(xlib:display-finish-output 
						 display)
						(xlib:ungrab-server display)
						(event-sync :windows pane 
							    :discard-p t)
						(setf (inverted menu-button) 
						      nil)
						(setf (pushed temp) t)
						(apply #'dispatch-event args)
						(setq flag :abort))))))
			 ((and (eq event-key :button-release)
			       (eq (getf args :code) 1))
			  (conceal pane :transparent t)
			  (xlib:display-force-output display)
			  (xlib:ungrab-pointer display) 
			  (xlib:display-finish-output display) 
			  (xlib:ungrab-server display) 
			  (event-sync :windows pane :discard-p t)
			  (unless in-menu (setf (inverted menu-button) nil))
			  (setq flag :abort)
			  (when (and current-cell (not (dimmed 
							current-cell)))
				(me-uninvert current-cell
					     pane-res
					     gc-clear
					     pane-width)
				(menu-execute current-cell)))
			 ((and (eq event-key :button-press)
			       (eq (getf args :code) 3)
			       (tearable pane))
			  (when (and current-cell (not (dimmed 
							current-cell)))
				(me-uninvert current-cell
					     pane-res
					     gc-clear
					     pane-width)
				(xlib:display-force-output display))
			  (xlib:ungrab-pointer display) 
			  (xlib:ungrab-server display) 
			  (xlib:display-force-output display) 
			  (setf (xlib:window-save-under (res pane)) :on 
				(xlib:window-override-redirect (res pane)) :off)
			  (setf (background pane) "white")
			  (setf (inverted menu-button) nil)
			  (xlib:unmap-window (res pane))
			  (xlib:map-window (res pane))
			  (repaint menu-button)
			  (setq flag :abort)
			  (when current-cell
				(apply #'activate-panel (cons pane args)))))
		   ;;;  (t (apply #'dispatch-event args) )
		   flag))
	(repack-on (root-window))))

(defun activate-pop-up-menu (pane event)
  (let* ((pane-res (res pane))
	 (pane-width (base-width pane))
	 (pane-height (base-height pane))
	 (gc (gc-res pane))
	 (gc-clear (gc-clear pane))
	 (ptab (ptab pane))
	 (current-cell nil)
	 (temp nil)
	 (flag nil)
	 (root-window (root-window))
	 (root-width (width root-window))
	 (root-height (height root-window))
	 (display (getf event :display))
	 (x nil)
	 (y nil))
	(multiple-value-setq (x y)
			     (xlib:translate-coordinates 
			      (getf event :event-window)
			      (getf event :x) (getf event :y) 
			      (res root-window)))
;;	(setf (xlib:window-priority pane-res) :top-if)
;;	(repack-off (root-window))
	(if (> (+ x pane-width) root-width)
	    (setq x (- root-width pane-width)))
	(if (> (+ y pane-height) root-height)
	    (setq y (- root-height pane-height)))
	(reshape pane x y (base-width pane) (base-height pane))
	(fix-region pane :x x :y y)
;;	(format t "W: ~s	H: ~s~%" (width pane) (height pane))
;;	(xlib:grab-server display)
	(setf (xlib:window-priority pane-res) :top-if)
	(expose pane)
	(setf (xlib:window-priority (res pane)) :above)
	(repaint pane)
	(xlib:display-finish-output display)
	(xlib:warp-pointer pane-res 1 1)
;;	(repaint pane)
	(xlib:grab-pointer pane-res 
			   '(:pointer-motion
			     :enter-window
			     :leave-window
			     :button-press
			     :button-release)
			   :cursor (res (or (cursor pane) 
					    (default-cursor))))
	;;; main loop
	(event-sync
	 :discard-after-process t
	 :display (display pane)
	 :hang t
	 :handler
	 #'(lambda (&rest args &key event-window event-key &allow-other-keys)
		   (cond ((eq event-key :motion-notify)
;;			  (format t "inverting. . . ~s ~%" current-cell)
			  (when (and (>= (1- pane-height) 
					 (setq y (getf args :y)) 0) 
				     (eq event-window pane-res))
				(setq temp (aref ptab (getf args :y)))
				(cond ((and (menu-entry-p temp) 
					    (menu-entry-p current-cell))
				       (unless (or (eql temp current-cell) 
						   (not (menu-entry-p temp)))
					       (unless (dimmed current-cell)
						       (me-uninvert current-cell
								    pane-res
								    gc-clear
								    pane-width))
					       (setq current-cell temp)
					       (unless (dimmed current-cell)
						       (me-invert current-cell
								  pane-res gc
								  pane-width))))
				      ((menu-entry-p current-cell)
				       (when (menu-entry-p current-cell) 
					     (unless (dimmed current-cell)
						     (me-uninvert current-cell
								  pane-res
								  gc-clear
								  pane-width)))
				       (setq current-cell nil))
				      ((menu-entry-p temp)
				       (setq current-cell temp) 
				       (if (and current-cell 
						(dimmed current-cell))
					   (me-invert current-cell
						      pane-res gc
						      pane-width))))))

			 ((eq event-key :leave-notify)
;;			  (format t "Leave~%")
			  (when (eql event-window pane-res)
				(when current-cell 
				      (unless (dimmed current-cell)
					      (me-uninvert current-cell
							   pane-res
							   gc-clear
							   pane-width)))
				(setq current-cell nil))
			  (if (typep (find-window event-window) 'form)
			      (apply #'dispatch-event args)))
			 ((eq event-key :enter-notify)
			  (setq temp event-window)
			  (when (equal temp pane-res) 
				(unless (>= (setq y (getf args :y)) 0)
					(setq y 0))
				(unless (> pane-height y)
					(setq y (1- pane-height)))
				(setq current-cell (aref ptab y))
				(unless (or (null current-cell) 
					    (dimmed current-cell))
					(me-invert current-cell
						   pane-res gc pane-width)))
			  (if (typep (find-window temp) 'form)
			      (apply #'dispatch-event args)))
			 ((and (eq event-key :button-press)
			       (eq (getf args :code) 3))
			  (when (and current-cell (not (dimmed 
							current-cell)))
				(me-uninvert current-cell
					     pane-res gc-clear pane-width)
				(xlib:display-force-output display))
			  (xlib:ungrab-pointer display)
			  (xlib:ungrab-server display)
			  (xlib:display-force-output display)
			  (setq flag :abort)
			  (when current-cell
				(apply #'activate-panel (cons pane args))))
			 ((eq event-key :button-release) 
			  (conceal pane :transparent t)
			  (xlib:display-force-output display)
			  (xlib:ungrab-pointer display)
			  (xlib:display-finish-output display)
			  (xlib:ungrab-server display)
			  (event-sync :windows pane :discard-p t)
			  (setq flag :abort)
			  (when (and current-cell (not (dimmed 
							current-cell)))
				(me-uninvert current-cell
					     pane-res gc-clear pane-width)
				(menu-execute current-cell))))
		   flag))
	(repack-on (root-window))))

(defmethod (setf menu) ((new-menu menu-button) (self menu-pane))
  (setf (slot-value self 'menu) new-menu))

(defmethod (setf menu) ((new-menu null) (self menu-pane))
  (setf (slot-value self 'menu) new-menu))

(defmethod (setf menu) ((new-menu t) (self menu-pane))
  (error "menu-pane.(setf menu):  menu must be a menu or nil!~%"))

;;;  geometry management primitives

(defmethod gm-status-changed ((gm (eql 'menu-gm)) self child)
  (declare (ignore child))
  (do-repack self))

(defmethod gm-calculate-min-size ((gm (eql 'menu-gm)) self)
  (unless (slot-value self 'synth-data)
	  (return-from gm-calculate-min-size))
  (let* ((cells (exposed-mis-of (synths self)))
	 (triple-list (mapcar 
		       #'(lambda (c) (list (mi-width (left-item c))
					   (mi-width (center-item c)) 
					   (mi-width (right-item c))))
		       cells))
	 (wl (apply #'mapcar (cons #'max (cons '(0 0 0) triple-list))))
	 (temp nil)
	 (minh 0) 
	 (v-pad 6)
	 (w 0)
	 (h 0))
	(setf (slot-value self 'synth-data) (mapcar #'+ '(6 8 6) wl))
	(setq w (apply #'+ (slot-value self 'synth-data)))
	(dolist (col cells)
		;; Get min-height of menu-entry
		(when (> (setq temp (mi-height (left-item col))) minh)
		      (setq minh temp))
		(when (> (setq temp (mi-height (center-item col))) minh)
		      (setq minh temp))
		(when (> (setq temp (mi-height (right-item col))) minh)
		      (setq minh temp))
		(incf minh v-pad)
		(setf (height col) minh) 
		(incf h minh)
		(setq minh 0))

	(setf (min-size self) (list (+ w *menu-shadow-thickness* 2) 
				    (+ h *menu-shadow-thickness* 2)))))

(defmethod gm-repack ((gm (eql 'menu-gm)) self
		      &aux cells w h pt v-pad data lw cw rw minh
		      left center right)
  (setq cells (exposed-mes-of (synths self))
	w (- (width self) *menu-shadow-thickness* 2)
	h 1
	pt (ptab self)
	v-pad 6
	minh 0
	data (slot-value self 'synth-data))
  (setq lw (1+ (first data))
	cw (1+ (second data))
	rw (1+ (third data)))
  (setf (fill-pointer pt) 0)
  (dolist (col (reverse cells))
	  ;; Get min-height of menu-entry
	  (setq minh (height col))
	  (setf (y-offset col) h)
	  ;; Set dimensions
	  
	  ;; of left
	  (if (setq left (left-item col))
	      (setf (region left) (list 1 h lw minh)))
	  
	  ;; of center
	  (if (setq center (center-item col))
	      (setf (region center) (list lw h cw minh)))
	  
	  ;; of right
	  (if (setq right (right-item col))
	      (setf (region right) (list (+ lw cw) h rw minh)))
	  
	  (dotimes (i minh)
		   (vector-push-extend col pt 128))
	  (incf h minh)
	  (setq minh 0)))

(defmethod num-cells ((self menu-pane))
  (length (synths self)))

(defmethod do-repaint ((self menu-pane) 
		       &key 
		       &allow-other-keys
		       &aux temp res gc w h)
  (call-next-method)
  (setq res (res self)
	gc (gc-shadow self)
	w (width self)
	h (height self))

  (xlib:draw-rectangle res (gc-clear self) 1 1
		       (- w *menu-shadow-thickness* 1)
		       (- h *menu-shadow-thickness* 1) t)
  ;;	Draw items
  (dolist (col (synths self))
	  (setq temp (left-item col))
	  (when (and temp (exposed temp))
		(apply #'put (dlist temp)))
	  (setq temp (center-item col))
	  (when (and temp (exposed temp))
		(apply #'put (dlist temp)))
	  (setq temp (right-item col))
	  (when (and temp (exposed temp))
		(apply #'put (dlist temp))))

  ;;	Draw synthetic border
  (xlib:draw-rectangle res (gc-res self) 0 0 
		       (- w *menu-shadow-thickness* 1) 
		       (- h *menu-shadow-thickness* 1))

  ;;	Draw drop-shadow
  (xlib:draw-rectangle res gc 
		       *menu-shadow-thickness* 
		       (- h *menu-shadow-thickness*) 
		       w 
		       *menu-shadow-thickness* t)
  (xlib:draw-rectangle res gc 
		       (- w *menu-shadow-thickness*) 
		       *menu-shadow-thickness* 
		       *menu-shadow-thickness* 
		       h t))

