;;; -*- Mode: Lisp; Syntax: Common-lisp; Package: User; Base: 10; -*-

;;; This file is part of Express Windows.

;;; Express Windows is distributed in the hope that it will be useful,
;;; but WITHOUT ANY WARRANTY.  No author or distributor
;;; accepts responsibility to anyone for the consequences of using it
;;; or for whether it serves any particular purpose or works at all,
;;; unless he says so in writing.  Refer to the Express Windows General Public
;;; License for full details.

;;; Everyone is granted permission to copy, modify and redistribute
;;; Express Windows, but only under the conditions described in the
;;; Express Windows General Public License.   A copy of this license is
;;; supposed to have been given to you along with Express Windows so you
;;; can know your rights and responsibilities.  It should be in a
;;; file named COPYING.  Among other things, the copyright notice
;;; and this notice must be preserved on all copies.  */


;;; ****************************************************************************************
;;; ****************************************************************************************
;;; ********** (c) Copyright 1988, 1989, 1990 Liszt Programming Inc. All Rights Reserved *********
;;; ****************************************************************************************
;;; ****************************************************************************************

;;; ****************************************************************************************
;;; ****************************************************************************************
;;; **************** Written by Dr. Andrew L. Ressler **************************************
;;; ****************************************************************************************
;;; ****************************************************************************************

(in-package 'user)

(pushnew :X *Features*)
(pushnew :CLX *Features*)
(pushnew :UNIX *Features*)

#+symbolics
(pushnew :VISUAL-640 *Features*)

;(pushnew :meter *Features*)
(pushnew :EW-CLOS *Features*)


#+ignore
(progn
  (change-memory-management :growth-limit 400 :growth-rate 40)
  (change-memory-management :expand 100)
  (lucid::expand-reserved-memory 100))



(in-package 'user)

#+X
(in-package 'xfonts :USE '(lisp))
#+X
(in-package 'user)

#+pcl
(in-package 'fpcl :use '(lisp))

(in-package 'user)

(in-package 'express-windows :nicknames '(ew) :use '(lisp))



(in-package 'file-manager :USE '(lisp))

#-symbolics
(in-package 'process-manager :USE '(lisp))

#-symbolics
(progn

(unless (find-package "DW")
  (in-package 'dw :use 'ew))

(user::in-package 'user)

(unless (find-package "GRAPHICS")
  (in-package 'graphics :use 'ew))
(user::in-package 'user)

(unless (find-package "TV")
  (in-package 'tv :use 'ew))
(user::in-package 'user)

(unless (find-package "SI")
  (in-package 'si :use 'ew))
(user::in-package 'user)

(unless (find-package "SCL")
  (in-package 'scl :use 'ew))
(user::in-package 'user)

(unless (find-package "CP")
  (in-package 'cp :use 'ew))
(user::in-package 'user)

(unless (find-package "TIME")
  (in-package 'time :use 'ew))

(user::in-package 'user)

)

;; switch back to user for rest of file.
(in-package 'user)



(load (make-pathname :name #+symbolics "SYMBOLS" #-symbolics "symbols"
		     :type #+symbolics "LISP" #-symbolics "lisp"
		     :defaults *Default-EW-Code-Pathname*))


(eval-when (compile load eval)
  (when (and (find-package "EDITOR")
	     (fboundp (intern "BUFFERP" (find-package "EDITOR"))))
    (pushnew :LUCID-EDITOR *Features*)))


(defvar *EW-Files*)


(defvar *Optional-EW-Files*)


(setq *Ew-Files*
      (mapcar #'(lambda (file-name)
		  (make-pathname :NAME
				 #+symbolics (string-upcase file-name)
				 #-symbolics file-name
				 :TYPE #+symbolics "LISP" #-symbolics "lisp"
				 :DEFAULTS *Default-EW-Code-Pathname*))
	      '("clx-hacks"
		"meter"
		"cl-clos-macros"
		"fixnum-macros"
		"x-macros-interface"
		"fonts"
		"macros"
		"x-interface"
		"read-internal"
		"quad-trees"
		"base-presentations"
		"type"
		"scrolling"
		"graphic-primitives"
		"io-functions"
		"command-processor"
		"misc"
		"memo"
		"table"
		"query"
		"completion"
		"frames"
		"input-editor"
		"proprietary-presentation-types"
		"presentation-types"
		"lisp-window"
		)))


(setq *Optional-Ew-Files*
      (mapcar #'(lambda (file-name)
		  (make-pathname :NAME
				 #+symbolics (string-upcase file-name)
				 #-symbolics file-name
				 :TYPE #+symbolics "LISP" #-symbolics "lisp"
				 :DEFAULTS *Default-EW-Code-Pathname*))
	      '(#+pcl "flavors-to-pcl"
		"demos"
		"sym-comp"
		"time"
		"lisp-machine-lisp-compatible"
		"file-manager"
		#+lucid-editor "lucid-editor-interface"
		"menu-definer"
		#-symbolics "processes"
		)))


(defvar *Ew-Files-Copy* *Ew-Files*)

(defvar *Optional-Ew-Files-Copy* *Optional-Ew-Files*)


(defun load-ew (&OPTIONAL (reset NIL))
  (when reset (setq *Ew-Files-Copy* *Ew-Files*)
	(setq *Optional-Ew-Files-Copy* *Optional-Ew-Files*))
  (do ()((null *Ew-Files-Copy*))
    (load (make-pathname :TYPE #-symbolics "lbin" #+symbolics "BIN"
			 :defaults (first *Ew-Files-Copy*)))
    (pop *Ew-Files-Copy*))
  (do ()((null *Optional-Ew-Files-Copy*))
    (if (y-or-n-p "Load Optional File ~A." (first *Optional-Ew-Files-Copy*))
	(load (make-pathname :TYPE #-symbolics "lbin" #+symbolics "BIN"
			     :defaults (first *Optional-Ew-Files-Copy*))))
    (pop *Optional-Ew-Files-Copy*)))



(defun compile-ew ()
  (unless (fboundp 'compile-file-maybe)
    (load (make-pathname :NAME "defsystem" :TYPE "lisp"
			 :DEFAULTS *Default-EW-Code-Pathname*)))
  (dolist (file *Ew-Files*)
    (compile-file-maybe file)
    (load-file-maybe file))
  (dolist (file *Optional-Ew-Files*)
    (compile-file-maybe file)
    (load-file-maybe file)))


#+symbolics
(defsystem ew
    (:pretty-name "Express Windows"
     :maintain-journals NIL
     :patchable NIL
     :default-pathname "local:>ew>code>")
  (:SERIAL
    "clx-hacks"
    "meter"
    "cl-clos-macros"
    "fixnum-macros"
    "x-macros-interface"
    "fonts"
    "macros"
    "x-interface"
    "read-internal"
    "quad-trees"
    "base-presentations"
    "type"
    "scrolling"
    "graphic-primitives"
    "io-functions"
    "command-processor"
    "misc"
    "memo"
    "table"
    "query"
    "completion"
    "frames"
    "input-editor"
    #+pcl "flavors-to-pcl"
    "proprietary-presentation-types"
    "presentation-types"
    "time"
    "lisp-window"
    "file-manager"
    "menu-definer"
    "lisp-machine-lisp-compatible"
    #+lucid "processes.lisp"
    "demos"
    "sym-comp"
    ))
