;;; -*- Mode: LISP; Syntax: Common-lisp; Package: FPCL; Base: 10 -*-

;;; This file is part of Express Windows.

;;; Express Windows is distributed in the hope that it will be useful,
;;; but WITHOUT ANY WARRANTY.  No author or distributor
;;; accepts responsibility to anyone for the consequences of using it
;;; or for whether it serves any particular purpose or works at all,
;;; unless he says so in writing.  Refer to the Express Windows General Public
;;; License for full details.

;;; Everyone is granted permission to copy, modify and redistribute
;;; Express Windows, but only under the conditions described in the
;;; Express Windows General Public License.   A copy of this license is
;;; supposed to have been given to you along with Express Windows so you
;;; can know your rights and responsibilities.  It should be in a
;;; file named COPYING.  Among other things, the copyright notice
;;; and this notice must be preserved on all copies.  */


;;; ****************************************************************************************
;;; ****************************************************************************************
;;; ********** (c) Copyright 1988, 1989, 1990 Liszt Programming Inc. All Rights Reserved *********
;;; ****************************************************************************************
;;; ****************************************************************************************

;;; ****************************************************************************************
;;; ****************************************************************************************
;;; **************** Written by Dr. Andrew L. Ressler **************************************
;;; ****************************************************************************************
;;; ****************************************************************************************


(in-package 'fpcl)

(export '(defmethod defflavor instancep symbol-value-in-instance
		    defwhopper continue-whopper) 'fpcl)

(defun find-flavor-option (option options)
  (express-windows::fast)
  (dolist (opt options)
    (if (symbolp opt)
	(if (eq option opt) (return (values T NIL)))
	(if (eq option (first opt)) (return (values T (cdr opt)))))))

(defmacro defflavor (flavor-name instance-variables component-flavors &REST options)
  ;; first find slots to be accessed
  (multiple-value-bind (writer-slots reader-slots)
     (find-read-and-write-slots options instance-variables)
     (multiple-value-bind (found-it conc-name)
        (find-flavor-option :CONC-NAME options)
	(let ((conc-name (if found-it (if (first conc-name) (first conc-name) '||)
			     (intern (format NIL "~A-" flavor-name)))))
	  (multiple-value-bind (init-args-p init-args)
	     (find-flavor-option :DEFAULT-INIT-PLIST options)
	  (multiple-value-bind (slot-definitions slot-names)
	    (convert-flavor-slots-to-pcl-slots instance-variables
					       reader-slots writer-slots conc-name)
	    (declare (ignore slot-names))
	    (let ((class-options (if init-args-p `(:default-initargs . ,init-args))))
	      (let ((class-definition
		     `(pcl::defclass ,flavor-name ,component-flavors
				     ,slot-definitions
				     . ,(if class-options (list class-options)
					    NIL))))
		class-definition))))))))

(defun find-read-and-write-slots (options instance-variables)
  (let ((slot-names (mapcar #'(lambda (slot) (if (consp slot) (first slot) slot))
			    instance-variables)))
    (multiple-value-bind (found-writeable writeable-slots)
	(find-flavor-option :writable-instance-variables options)
      (if (and found-writeable (null writeable-slots))
	  (setq writeable-slots slot-names))
      (multiple-value-bind (found-readable readable-slots)
	  (find-flavor-option :readable-instance-variables options)
	(if (and found-readable (null readable-slots))
	    (setq readable-slots slot-names))
	(values writeable-slots (union readable-slots writeable-slots))))))
	

(defun convert-flavor-slots-to-pcl-slots (instance-variables
					  reader-slots writer-slots conc-name)
  (let ((slot-definitions NIL)
	(slot-names NIL))
    (dolist (instance-variable-description instance-variables)
      (let ((slot-definition NIL)
	    (slot-name NIL))
	(cond ((symbolp instance-variable-description)
	       (setq slot-definition (list instance-variable-description))
	       (setq slot-name instance-variable-description))
	      ((listp instance-variable-description)
	       (setq slot-name (first instance-variable-description))
	       (let ((initialization (second instance-variable-description)))
		 (setq slot-definition (list slot-name :INITFORM initialization)))))
	(when (member slot-name reader-slots)
	  (setq slot-definition
		(nconc slot-definition
		       (list :reader (intern (format NIL "~A~A" conc-name slot-name))))))
	(when (member slot-name writer-slots)
	  (setq slot-definition
		(nconc slot-definition
		       (list :writer (list 'setf
					   (intern (format NIL "~A~A" conc-name slot-name)))))))
	(push slot-definition slot-definitions)
	(push slot-name slot-names)))
    (values (nreverse slot-definitions) (nreverse slot-names))))


(defmacro defmethod ((generic-function flavor &REST options) arglist &BODY body
		     &AUX declarations documentation-string)
  ;(if options (error "Cannot handle options yet."))
  (when (and (consp body) (stringp (first body)) (cdr body))
    (setq documentation-string (list (first body))
	  body (cdr body)))
  (setq generic-function
	(cond ((eq generic-function 'pcl::make-instance)
	       ;; make sure this is an after or before method
	       (unless (or (member :before options)
			   (member :after options))
		 (push :AFTER options))
	       ;; make sure the argument is not an &rest arg.
	       (if (eq '&rest (first arglist))
		   (pop arglist)
		   (error "Should have been a &Rest arg as only arg to make-instance"))
	       'pcl::initialize)
	      ((equalp "PRINT-SELF" (symbol-name generic-function))
	       'pcl::print-object)
	      (t generic-function)))
  (when (and (consp body) (consp (first body)) (eq 'declare (first (first body))))
    (setq declarations (first body)
	  body (cdr body)))
  (let ((class (pcl::find-class flavor)))
    (if (not class) (error "No Class named ~A exists."))
    (let ((slot-names (mapcar #'(lambda (slot) (pcl::slotd-name slot))
			      (pcl::class-slots class))))
      `(pcl::defmethod ,generic-function ,@options ((express-windows::self ,flavor) . ,arglist)
	 ,@documentation-string ,declarations
	 (pcl::with-slots ,slot-names express-windows::self
	   . ,body)))))


(defmacro defwhopper ((generic-function flavor &REST options) arglist &BODY body
		     &AUX declarations documentation-string)
  ;(if options (error "Cannot handle options yet."))
  (when (and (consp body) (stringp (first body)) (cdr body))
    (setq documentation-string (list (first body))
	  body (cdr body)))
  (setq generic-function
	(cond ((eq generic-function 'pcl::make-instance)
	       ;; make sure the argument is not an &rest arg.
	       (if (eq '&rest (first arglist))
		   (pop arglist)
		   (error "Should have been a &Rest arg as only arg to make-instance"))
	       'pcl::initialize)
	      ((equalp "PRINT-SELF" (symbol-name generic-function))
	       'pcl::print-object)
	      (t generic-function)))
  (push :around options)
  (when (and (consp body) (consp (first body)) (eq 'declare (first (first body))))
    (setq declarations (first body)
	  body (cdr body)))
  (let ((class (pcl::find-class flavor)))
    (if (not class) (error "No Class named ~A exists."))
    (let ((slot-names (mapcar #'(lambda (slot) (pcl::slotd-name slot))
			      (pcl::class-slots class))))
      `(pcl::defmethod ,generic-function ,@options ((express-windows::self ,flavor) . ,arglist)
	 ,@documentation-string ,declarations
	 (pcl::with-slots ,slot-names express-windows::self
	   . ,body)))))

(defun class-slot-names (class-name)
  (express-windows::fast)
  (mapcar #'(lambda (slot) (pcl::slotd-name slot))
	  (pcl::class-slots (pcl::find-class class-name))))


(defmacro symbol-value-in-instance (instance symbol &OPTIONAL no-error-p)
  (declare (ignore no-error-p))
  `(pcl::slot-value ,instance ,symbol))


(defun instancep (x)
  (express-windows::fast)
  ;;(typep x 'pcl::iwmc-class)
  (pcl::iwmc-class-p x)
  )

(defmacro continue-whopper (&rest args)
  (if args
      `(pcl::call-next-method express-windows::self . ,args)
      `(pcl::call-next-method)))
