;;;-*-Mode:LISP; Package:(PCL LISP 1000); Base:10; Syntax:Common-lisp -*-
;;;
;;; *************************************************************************
;;; Copyright (c) 1985, 1986, 1987, 1988 Xerox Corporation.
;;; All rights reserved.
;;;
;;; Use and copying of this software and preparation of derivative works
;;; based upon this software are permitted.  Any distribution of this
;;; software or derivative works must comply with all applicable United
;;; States export control laws.
;;; 
;;; This software is made available AS IS, and Xerox Corporation makes no
;;; warranty about the software, its performance or its conformity to any
;;; specification.
;;; 
;;; Any person obtaining a copy of this software is requested to send their
;;; name and post office or electronic mail address to:
;;;   CommonLoops Coordinator
;;;   Xerox PARC
;;;   3333 Coyote Hill Rd.
;;;   Palo Alto, CA 94304
;;; (or send Arpanet mail to CommonLoops-Coordinator.pa@Xerox.arpa)
;;;
;;; Suggestions, comments and requests for improvements are also welcome.
;;; *************************************************************************
;;;

(in-package 'pcl)

(eval-when (load)
  (pre-make-caching-discriminating-functions
    ((1 NIL (0) 32)
     (2 NIL (0) 32)
     (2 NIL (1) 32)		;setf of accessor gfuns
     (2 NIL (0 1) 32)
     (3 NIL (0) 32)
     (3 NIL (1) 32)
     (3 NIL (0 1) 32)
     (4 NIL (0) 32)
     (4 NIL (1) 32)
     (5 NIL (0) 32)
     (5 NIL (0 1) 32)
     (6 NIL (0) 32)
     (6 NIL (0 1) 32)
     (7 NIL (0) 32)
     
     (1 T (0) 32)
     (2 T (0) 32)
     (2 T (0 1) 32)
     (3 T (0) 32)
     (4 T (0) 32))))

(eval-when (compile load eval)
  (defmacro precompile-effective-method-templates (templates)
    `(progn ,@(mapcar #'(lambda (x)
			  `(precompile-effective-method-template-1 ,x pcl))
		      templates))))

(precompile-effective-method-templates 
  (
   (_call-method_)				      ;1 or more :around
						      ;methods with 0 or
						      ;more next methods
						      ;This case happens
						      ;whenever there are
						      ;:around methods


   (PROGN (_call-method_)			      ;1 :before 1 :after
	  (MULTIPLE-VALUE-PROG1			      ;*** NO PRIMARY, COMMON
	    (error "No applicable primary method.")   ;*** INTERMEDIATE STATE
	    (_call-method_)))

   (PROGN (_call-method_)			      ;1 :before 0 :after
	  (MULTIPLE-VALUE-PROG1			      ;*** NO PRIMARY, COMMON
	    (error "No applicable primary method."))) ;*** INTERMEDIATE STATE


   (PROGN ()					      ;0 :before 1 :after
	  (MULTIPLE-VALUE-PROG1			      ;*** NO PRIMARY, COMMON
	    (error "No applicable primary method.")   ;*** INTERMEDIATE STATE
	    (_call-method_)))


   (PROGN (_call-method_)			      ;1 :before 1 :after
	  (MULTIPLE-VALUE-PROG1 (_call-method_)
				(_call-method_)))

   (PROGN ()					      ;0 :before 1 :after
	  (MULTIPLE-VALUE-PROG1 (_call-method_)
				(_call-method_)))

   (PROGN (_call-method_)			      ;1 :before 0 :after
	  (MULTIPLE-VALUE-PROG1 (_call-method_)
				()))


   (PROGN (_call-method_)			      ;2 :befores 2 :after
	  (_call-method_)
	  (MULTIPLE-VALUE-PROG1 (_call-method_)
				(_call-method_)
				(_call-method_)))


   (PROGN (_call-method_)			      ;2 :befores 1 :after
	  (_call-method_)
	  (MULTIPLE-VALUE-PROG1 (_call-method_)
				(_call-method_)))

   (PROGN (_call-method_)			      ;1 :before 2 :after
	  (MULTIPLE-VALUE-PROG1 (_call-method_)
				(_call-method_)
				(_call-method_)))


   (PROGN (_call-method_)			      ;2 :befores no :after
	  (_call-method_)
	  (MULTIPLE-VALUE-PROG1 (_call-method_)
				()))

   (PROGN (_call-method_)			      ;0 :before 2 :after
	  (MULTIPLE-VALUE-PROG1 (_call-method_)
				(_call-method_)
				(_call-method_)))
  
   ))