;;; -*- Mode: LISP; Syntax: Common-lisp; Package: Express-windows; Base: 10 -*-

;;; This file is part of Express Windows.

;;; Express Windows is distributed in the hope that it will be useful,
;;; but WITHOUT ANY WARRANTY.  No author or distributor
;;; accepts responsibility to anyone for the consequences of using it
;;; or for whether it serves any particular purpose or works at all,
;;; unless he says so in writing.  Refer to the Express Windows General Public
;;; License for full details.

;;; Everyone is granted permission to copy, modify and redistribute
;;; Express Windows, but only under the conditions described in the
;;; Express Windows General Public License.   A copy of this license is
;;; supposed to have been given to you along with Express Windows so you
;;; can know your rights and responsibilities.  It should be in a
;;; file named COPYING.  Among other things, the copyright notice
;;; and this notice must be preserved on all copies.  */


;;; ****************************************************************************************
;;; ****************************************************************************************
;;; ********** (c) Copyright 1988, 1989, 1990 Liszt Programming Inc. All Rights Reserved *********
;;; ****************************************************************************************
;;; ****************************************************************************************

;;; ****************************************************************************************
;;; ****************************************************************************************
;;; **************** Written by Dr. Andrew L. Ressler **************************************
;;; ****************************************************************************************
;;; ****************************************************************************************


(cl:in-package 'ew)

;; functions to emulate Lisp Machine Lisp


(defun  (&REST args)
  (not (apply #'= args)))

(defun  (&REST args)
  (not (apply #'> args)))

(defun  (&REST args)
  (not (apply #'< args)))


;*APROPOS-LIST*
;*COMPILE-FILE-SET-DEFAULT-PATHNAME*
;*CURRENT-PROCESS*
;*DEFAULT-CONS-AREA*
;*ERROR-MESSAGE-HOOK*
;*LOAD-PATHNAME-DEFAULTS*
;*LOAD-SET-DEFAULT-PATHNAME*
;*PRINT-ABBREVIATE-QUOTE*
;*PRINT-ARRAY-LENGTH*
;*PRINT-BIT-VECTOR-LENGTH*
;*PRINT-EXACT-FLOAT-VALUE*
;*PRINT-INTEGER-LENGTH*
;*PRINT-PRETTY-PRINTER*
;*PRINT-READABLY*
;*PRINT-STRING-LENGTH*
;*PRINT-STRUCTURE-CONTENTS*
;2D-ARRAY-BLT
;ABBREVIATING-OUTPUT

;QUERY			- implemented elsewhere
;QUERY-FROM-STRING	- implemented elsewhere

;ADD-INITIALIZATION
;ADVISE
;ADVISE-WITHIN

;ALIST-MEMBER		- implemented elsewhere

;ALLOCATE-RESOURCE

(defun alphalessp (x y)
  (cond ((stringp x))
	((symbolp x) (setq x (symbol-name x)))
	(T (setq x (format NIL "~D" x))))
  (cond ((stringp y))
	((symbolp y) (setq y (symbol-name y)))
	(T (setq y (format NIL "~D" y))))
  (string-lessp x y))

;ARGLIST
;ARGS-INFO
;ARRAY-HAS-LEADER-P
;ARRAY-LEADER
;ARRAY-LEADER-LENGTH
;ARRAY-LEADER-LENGTH-LIMIT
;ASCII-CODE
;ASCII-TO-CHAR
;ASCII-TO-STRING
;BEEP
;BIT-VECTOR-CARDINALITY
;BIT-VECTOR-DISJOINT-P
;BIT-VECTOR-EQUAL
;BIT-VECTOR-POSITION
;BIT-VECTOR-SUBSET-P
;BIT-VECTOR-ZERO-P
;BITBLT
;BOOLEAN
;BOUNDP-IN-CLOSURE
;BOUNDP-IN-INSTANCE
;BREAKON
;CATCH-ERROR
;CATCH-ERROR-RESTART
;CATCH-ERROR-RESTART-IF
;CHANGE-INSTANCE-FLAVOR
;CHAR
;CHAR
;CHAR
;CHAR-FAT-P
;CHAR-FLIPCASE
;CHAR-MOUSE-BITS
;CHAR-MOUSE-BUTTON
;CHAR-MOUSE-EQUAL
;CHAR-TO-ASCII
;CHARACTER-FACE-OR-STYLE
;CHARACTER-STYLE
;CHARACTER-STYLE-FOR-DEVICE
;CHOOSE-USER-OPTIONS
;CIRCULAR-LIST
;CLEAR-RESOURCE
;CLOSURE-FUNCTION
;COMPILE-FLAVOR-METHODS
;COMPILE-SYSTEM
;COND-EVERY

;CONDITION
;CONDITION-BIND
;CONDITION-BIND-DEFAULT
;CONDITION-BIND-DEFAULT-IF
;CONDITION-BIND-IF
;CONDITION-CALL
;CONDITION-CALL-IF
;CONDITION-CASE
;CONDITION-CASE-IF

;CONS-IN-AREA
;CONTINUE-WHOPPER
;COPY-ARRAY-CONTENTS
;COPY-ARRAY-CONTENTS-AND-LEADER
;COPY-ARRAY-PORTION
;COPY-DYNAMIC-CLOSURE
;COPY-FILE
;COPY-LIST*
;COPY-TREE-SHARE
;COSD
;DEALLOCATE-RESOURCE
;DEALLOCATE-WHOLE-RESOURCE
;DEBUGGING-INFO
;DECODE-RASTER-ARRAY
;DEF
;DEFF
;DEFFLAVOR
;DEFFUNCTION
;DEFGENERIC
;DEFINE-CP-COMMAND
;DEFINE-GLOBAL-HANDLER
;DEFINE-LOOP-MACRO
;DEFINE-LOOP-PATH
;DEFINE-LOOP-SEQUENCE-PATH
;DEFINE-METHOD-COMBINATION
;DEFINE-MODIFY-METHOD
;DEFINE-PROMPT-AND-READ-TYPE
;DEFINE-SIMPLE-METHOD-COMBINATION
;DEFINE-SYMBOL-MACRO
;DEFINE-USER-OPTION
;DEFINE-USER-OPTION-ALIST
;DEFLAMBDA-MACRO
;DEFLOCF
;DEFMACRO-IN-FLAVOR
;DEFMETHOD
;DEFPACKAGE
;DEFPROP
;DEFRESOURCE
;DEFSELECT
;DEFSTRUCT-DEFINE-TYPE
;DEFSUBST
;DEFSUBST-IN-FLAVOR
;DEFSUBSYSTEM
;DEFSYSTEM
;DEFUN-IN-FLAVOR
;DEFWHOPPER
;DEFWHOPPER-SUBST
;DEFWRAPPER
;DELETE-INITIALIZATION
;DEPOSIT-BYTE
;DESCRIBE-AREA
;DESCRIBE-DEFSTRUCT
;DESCRIBE-FUNCTION
;DESCRIBE-PACKAGE
;DESCRIBE-SYSTEM
;DESTRUCTURING-BIND
;DO-LOCAL-SYMBOLS
;DYNAMIC-CLOSURE-ALIST
;DYNAMIC-CLOSURE-VARIABLES
;EQUAL-TYPEP
;ERROR-RESTART
;ERROR-RESTART-IF
;ERROR-RESTART-LOOP
;ERRORP
;FALSE
;FDEFINE
;FDEFINEDP
;FDEFINITION
;FLAVOR-ALLOWS-INIT-KEYWORD-P
;FOLLOW-CELL-FORWARDING
;FOLLOW-STRUCTURE-FORWARDING
;FORMAT-CELL
;FORMAT-GRAPH-FROM-ROOT
;FORMATTING-COLUMN
;FORMATTING-GRAPH
;FORMATTING-GRAPH-NODE
;FORMATTING-MULTIPLE-COLUMNS
;FORWARD-VALUE-CELL
;FQUERY
;FUNDEFINE
;G-L-P
;GC-IMMEDIATELY
;GET-HANDLER-FOR
;GLOBALIZE
;GRINDEF
;IGNORE-ERRORS
;INHIBIT-STYLE-WARNINGS
;INITIALIZATIONS
;INSTANCE
;INSTANCEP
;INTERN-LOCAL
;INTERN-LOCAL-SOFT
;INTERN-SOFT
;INVERTED-BOOLEAN
;LAMBDA-MACRO
;LEAST-NEGATIVE-NORMALIZED-DOUBLE-FLOAT
;LEAST-NEGATIVE-NORMALIZED-LONG-FLOAT
;LEAST-NEGATIVE-NORMALIZED-SHORT-FLOAT
;LEAST-NEGATIVE-NORMALIZED-SINGLE-FLOAT
;LEAST-POSITIVE-NORMALIZED-DOUBLE-FLOAT
;LEAST-POSITIVE-NORMALIZED-LONG-FLOAT
;LEAST-POSITIVE-NORMALIZED-SHORT-FLOAT
;LEAST-POSITIVE-NORMALIZED-SINGLE-FLOAT
;LET-AND-MAKE-DYNAMIC-CLOSURE
;LET-GLOBALLY
;LET-GLOBALLY-IF
;LET-IF
;LETF
;LETF*
;LEXPR-CONTINUE-WHOPPER
;LEXPR-SEND
;LEXPR-SEND-IF-HANDLES
;LIST*-IN-AREA
;LIST-ARRAY-LEADER
;LIST-IN-AREA
;LOAD-BYTE
;LOAD-PATCHES
;LOAD-SYSTEM
;LOCATION-BOUNDP
;LOCATION-CONTENTS
;LOCATION-MAKUNBOUND
;LOCATIVE
;LOCATIVEP
;LOCF
;LOGIN-FORMS
;LOOP-FINISH
;LSH
;MACRO
;MAKE-AREA
;MAKE-CHARACTER
;MAKE-CONDITION
;MAKE-DYNAMIC-CLOSURE
;MAKE-HEAP
;MAKE-INSTANCE
;MAKE-MOUSE-CHAR
;MAKE-PLANE
;MAKE-PROCESS
;MAKE-RASTER-ARRAY
;MAKE-STACK-GROUP
;MAKUNBOUND-GLOBALLY
;MAKUNBOUND-IN-CLOSURE
;MAP-INTO
;MAP-RESOURCE
;MAXF
;MEXP
;MINF
;MODIFY-HASH
;MOUSE-CHAR-P
;NAMED-STRUCTURE-INVOKE
;NAMED-STRUCTURE-P
;NAMED-STRUCTURE-SYMBOL
;NCONS
;NCONS-IN-AREA
;NEQ
;NLEFT
;NLISTP
;NOTE-PRIVATE-PATCH
;NSTRING-CAPITALIZE-WORDS
;NSTRING-FLIPCASE
;NSUBSTRING
;NSYMBOLP
;NULL-OR-TYPE
;ONCE-ONLY
;OPERATION-HANDLED-P
;PACKAGE-EXTERNAL-SYMBOLS
;PKG-ADD-RELATIVE-NAME
;PKG-DELETE-RELATIVE-NAME
;PKG-FIND-PACKAGE
;PKG-KILL
;PLANE-AREF
;PLANE-DEFAULT
;PLANE-EXTENSION
;PRESENT-TO-STRING
;PRINT-COMPILER-WARNINGS
;PRINT-SENDS
;PROCESS-ABORT
;PROCESS-ACTIVE-P
;PROCESS-ALLOW-SCHEDULE
;PROCESS-DISABLE
;PROCESS-DISABLE-ARREST-REASON
;PROCESS-DISABLE-RUN-REASON
;PROCESS-ENABLE
;PROCESS-ENABLE-ARREST-REASON
;PROCESS-ENABLE-RUN-REASON
;PROCESS-FLUSH
;PROCESS-INITIAL-FORM
;PROCESS-INITIAL-STACK-GROUP
;PROCESS-INTERRUPT
;PROCESS-KILL
;PROCESS-LOCK
;PROCESS-NAME
;PROCESS-PRESET
;PROCESS-PRIORITY
;PROCESS-QUANTUM
;PROCESS-QUANTUM-REMAINING
;PROCESS-RESET
;PROCESS-RESET-AND-ENABLE
;PROCESS-RUN-FUNCTION
;PROCESS-SIMPLE-P
;PROCESS-STACK-GROUP
;PROCESS-UNLOCK
;PROCESS-WAIT
;PROCESS-WAIT-ARGUMENT-LIST
;PROCESS-WAIT-FOREVER
;PROCESS-WAIT-FUNCTION
;PROCESS-WAIT-WITH-TIMEOUT
;PROCESS-WARM-BOOT-ACTION
;PROCESS-WHOSTATE
;PROGW
;PROMPT-AND-QUERY
;PROMPT-AND-READ
;RANDOM-NORMAL
;RASTER-AREF
;RASTER-INDEX-OFFSET
;RASTER-WIDTH-AND-HEIGHT-TO-MAKE-ARRAY-DIMENSIONS
;READ-DELIMITED-STRING
;READ-LINE-NO-ECHO
;READ-LINE-TRIM
;READ-OR-END
;RECOMPILE-FLAVOR
;RECORD-SOURCE-FILE-NAME
;REMOVE-PROCLAIMS
;RESET-INITIALIZATIONS
;RESET-USER-OPTIONS
;ROT
;SELECT
;SELECTOR
;SELECTQ-EVERY
;SELF
;SEND
;SEND-IF-HANDLES
;SEQUENCE-ENUMERATED
;SET-CHARACTER-TRANSLATION
;SET-PROCESS-WAIT
;SIGNAL
;SIGNAL-PROCEED-CASE
;SIND
;SORT-GROUPED-ARRAY
;SORT-GROUPED-ARRAY-GROUP-KEY
;STACK-GROUP-PRESET
;STACK-GROUP-RESUME
;STACK-GROUP-RETURN
;STACK-LET
;STACK-LET*
;STEP-FORM
;STEP-VALUE
;STEP-VALUES
;STORE-CONDITIONAL
;STREAM-COPY-UNTIL-EOF
;STRING
;STRING
;STRING
;STRING-APPEND
;STRING-CAPITALIZE-WORDS
;STRING-COMPARE
;STRING-EXACT-COMPARE
;STRING-FAT-P
;STRING-FLIPCASE

(defun string-length (string)
  (declare (string string))
  (length string))

;STRING-NCONC
;STRING-NCONC-PORTION
;STRING-NREVERSE
;STRING-PLURALIZE
;STRING-REVERSE
;STRING-SEARCH
;STRING-SEARCH-CHAR
;STRING-SEARCH-EXACT
;STRING-SEARCH-EXACT-CHAR
;STRING-SEARCH-NOT-CHAR
;STRING-SEARCH-NOT-EXACT-CHAR
;STRING-SEARCH-NOT-SET
;STRING-SEARCH-SET
;STRING-THIN
;STRING-TO-ASCII
;STRUCTURE-FORWARD
;SUBSET
;SUBSTRING
;SURROUNDING-OUTPUT-WITH-BORDER
;SWAPHASH
;SYMBOL-VALUE-GLOBALLY
;SYMBOL-VALUE-IN-CLOSURE
;SYMBOL-VALUE-IN-INSTANCE
;SYMBOL-VALUE-IN-STACK-GROUP
;TABLE-SIZE
;TAND
;TIME-DIFFERENCE
;TIME-ELAPSED-P
;TIME-INCREMENT
;TIME-LESSP
;TOKEN-OR-TYPE
;TRUE
;TYPE-OR-STRING
;UNADVISE
;UNADVISE-WITHIN
;UNBOUND-LOGIC-VARIABLE
;UNBREAKON
;UNCOMPILE
;UNDEFINE-GLOBAL-HANDLER
;UNDEFUN
;UNDELETE-FILE
;UNWIND-PROTECT-CASE
;USING-RESOURCE
;VARIABLE-BOUNDP
;VARIABLE-MAKUNBOUND
;VECTOR-PUSH-PORTION-EXTEND
;WHAT-FILES-CALL
;WHERE-IS
;WHO-CALLS
;WHO-USES
;WITH-CHARACTER-FACE
;WITH-CHARACTER-FAMILY
;WITH-CHARACTER-SIZE
;WITH-CHARACTER-STYLE
;WITH-INPUT-EDITING
;WITH-INPUT-EDITING-OPTIONS
;WITH-INPUT-EDITING-OPTIONS-IF
;WITH-OPEN-FILE-CASE
;WITH-OPEN-FILE-CASE-IF
;WITH-OPEN-STREAM-CASE
;WITH-OPEN-STREAM-CASE-IF
;WITH-STACK-LIST
;WITH-STACK-LIST*
;WITH-STANDARD-IO-ENVIRONMENT
;WITH-UNDERLINING
;WITHOUT-FLOATING-UNDERFLOW-TRAPS
;WITHOUT-INTERRUPTS
;WRITE-USER-OPTIONS
;XCONS
;XCONS-IN-AREA


(defmacro with-lock-held ((lock &KEY mylock-ok soft (lock-value 'current-process)
				(whostate "Lock") cleanup (if T))
			  &BODY body)
  (declare (ignore lock mylock-ok soft lock-value whostate cleanup if))
  `(progn . ,body))

;;; -----------------------------------------------------------------
;;;	END OF FILE
;;; -----------------------------------------------------------------
