;;; -*- Mode: Lisp; Syntax: ANSI-Common-Lisp; Package: CLIM-USER; Base: 10; Lowercase: Yes -*-

(in-package :clim-user)

;;; Simple direct manipulation translators

(clim:define-drag-and-drop-translator dm-hardcopy-file
    (pathname command printer fsedit-comtab
     :documentation "Hardcopy this file")
    (object destination-object)
  `(com-hardcopy-file ,object ,destination-object))

(clim:define-drag-and-drop-translator dm-delete-file
    (pathname command trashcan fsedit-comtab
     :documentation "Delete this file")
    (object)
  `(com-delete-file ,object))

(clim:define-drag-and-drop-translator dm-copy-file
    (pathname command folder fsedit-comtab
     :documentation "Copy this file")
    (object destination-object)
  `(com-copy-file ,object ,(make-pathname :name (pathname-name object)
                                          :type (pathname-type object)
                                          :defaults destination-object)))
