;;; -*- Mode: Lisp;  Package: CLIM-USER; Base: 10; Lowercase: Yes -*-

(in-package "CLIM-USER")

(defmacro with-extrema ((data-array size x-min x-max y-min y-max)
                        &body body)
  `(let* ((,size (array-dimension ,data-array 0))
          (,x-min (aref ,data-array 0 0))
          (,x-max ,x-min)
          (,y-min (aref ,data-array 0 1))
          (,y-max ,y-min))
     (do ((i 1 (1+ i)))
         ((= i ,size))
       (let ((x (aref ,data-array i 0))
            (y (aref ,data-array i 1)))
        (cond ((< x ,x-min) (setq ,x-min x))
              ((> x ,x-max) (setq ,x-max x)))
        (cond ((< y ,y-min) (setq ,y-min y))
              ((> y ,y-max) (setq ,y-max y)))))
     ,@body))

(defun plot-data-set (data stream &key (view-x-min 0) (view-y-min 0)
                                       (view-x-max 200) (view-y-max 200))
  (with-extrema (data ndata data-x-min data-x-max
                            data-y-min data-y-max)
    (let* ((view-x-range (- view-x-max view-x-min))
           (view-y-range (- view-y-max view-y-min))
           (data-x-range (- data-x-max data-x-min))
           (data-y-range (- data-y-max data-y-min)))
      (with-translation (stream view-x-min view-y-max)
        (with-scaling (stream 1 -1)
          (draw-line* stream 0 0 view-x-range 0)
          (draw-line* stream 0 0 0 view-y-range)
          (with-scaling (stream (/ view-x-range data-x-range)
                                (/ view-y-range data-y-range))
            (with-translation (stream (- data-x-min) (- data-y-min))
              (do ((i 1 (1+ i))
                   (x0 (aref data 0 0) x1)
                   (y0 (aref data 0 1) y1)
                   x1 y1)
                  ((= i ndata))
                (setq x1 (aref data i 0) y1 (aref data i 1))
                (draw-line* stream x0 y0 x1 y1)))))))))

(defvar *test-data*
  (let ((data (make-array (list 200 2))))
    (loop for i below 200 do
	  (let ((r (+ 1.0 (* (/ (float i) 200.0) 2.0)))
                (theta (/ (float i) 20.0)))
            (setf (aref data i 0) (* r (sin theta))
                  (aref data i 1) (* r (cos theta)))))
    data))
