;;; -*- Mode: Lisp; Syntax: ANSI-Common-Lisp; Package: CLIM-USER; Base: 10; Lowercase: Yes -*-

(in-package :clim-user)

(defun rubber-band-line (&key (stream *standard-input*))
  (let (start-x start-y end-x end-y)
    (flet ((finish (event finish &optional press-p)
	     (let ((x (clim:pointer-event-x event))
		   (y (clim:pointer-event-y event))
		   (window (clim:event-sheet event)))
	       (when (eq window stream)
		 (cond (start-x
			(clim:with-output-recording-options (window :draw t :record nil)
			  (clim:draw-line* window start-x start-y end-x end-y
					   :ink clim:+flipping-ink+))
			(clim:draw-line* window start-x start-y end-x end-y)
			(when finish
			  (return-from rubber-band-line
			    (values start-x start-y end-x end-y))))
		       (press-p (setq start-x x start-y y)))))))
      (declare (dynamic-extent #'finish))
      (clim:tracking-pointer (stream)
	(:pointer-motion (window x y)
	 (when (and start-x (eq window stream))
	   (clim:with-output-recording-options (window :draw t :record nil)
	     (when end-x
	       (clim:draw-line* window start-x start-y end-x end-y
				:ink clim:+flipping-ink+))
	     (setq end-x x end-y y)
	     (clim:draw-line* window start-x start-y end-x end-y
			      :ink clim:+flipping-ink+))))
	(:pointer-button-press (event)
	 (finish event nil t))
	(:pointer-button-release (event)
	 (finish event t nil))))))

(defun place-circle (radius &optional (stream *standard-input*))
  (multiple-value-bind (x y) (clim:stream-pointer-position stream)
    (clim:dragging-output (stream)
      (clim:draw-circle* stream x y radius :filled nil))))
