;;; -*- Mode: Lisp; Syntax: ANSI-Common-Lisp; Package: CLIM-USER; Base: 10; Lowercase: Yes -*-

(in-package :clim-user)

;; CLIM could have implemented INDENTING-OUTPUT this way
(defmacro with-indentation ((stream indentation) &body body)
  `(let ((record
           (clim:with-output-recording-options (,stream :draw nil :record t)
             (clim:with-new-output-record (,stream)
               ,@body))))
    (multiple-value-bind (x y) (clim:output-record-position record)
      (clim:output-record-set-position record (+ x ,indentation) y))
    (clim:tree-recompute-extent record)
    (clim:replay record ,stream)
    record))

;; Here is how you can compute the size of the output generated by a body of code
(defmacro compute-output-size ((stream) &body body)
  `(let ((record
           (clim:with-output-to-output-record (,stream)
             ,@body)))
     (clim:bounding-rectangle-size record)))

;; This function maps over all of the records in an output record tree, calling
;; function on the record and its position
(defun map-over-output-record-tree (function record &optional (region clim:+everywhere+))
  (declare (dynamic-extent function))
  (labels ((map-internal (rec x-offset y-offset)
             (multiple-value-bind (start-x start-y)
                 (clim:output-record-position rec)
               (clim:translate-coordinates x-offset y-offset start-x start-y)
	       ;; Call the function on the record and the absolute
	       ;; position, but not on the root of the tree
               (unless (eql rec record)
                 (funcall function rec start-x start-y))
	       ;; Map over the children of this record, passing along
	       ;; the accumulated offsets
               (clim:map-over-output-records-overlapping-region
                 #'map-internal rec region 
                 (- x-offset) (- y-offset) start-x start-y))))
    (declare (dynamic-extent #'map-internal))
    (multiple-value-bind (x-offset y-offset)
        ;; Compute the initial offsets for the root record
	(clim:convert-from-relative-to-absolute-coordinates
          nil (output-record-parent record))
      (map-internal record x-offset y-offset))))
