;;; -*- Mode: Lisp; Syntax: ANSI-Common-Lisp; Package: CLIM-USER; Base: 10; Lowercase: Yes -*-

(in-package :clim-user)

;;; Gadget panes

;; Making a push button
(clim:make-pane 'clim:push-button 
  :label "Button"
  :activate-callback 'push-button-callback)

(clim:make-pane 'clim:push-button 
  :label "Another Button" :text-style '(nil :bold nil)
  :activate-callback 'push-button-callback)

(defun push-button-callback (button)
  (format t "~&Button ~A pushed" (clim:gadget-label button)))


;; Making a standalone toggle button
(clim:make-pane 'clim:toggle-button
  :label "Toggle" :width 80 
  :value-changed-callback 'toggle-button-callback)

(defun toggle-button-callback (button value)
  (format t "~&Button ~A toggled to ~S" (clim:gadget-label button) value))


;; Toggle buttons in a radio box
(clim:with-radio-box (:value-changed-callback 'radio-box-value-changed-callback)
  (clim:make-pane 'clim:toggle-button :label "Mono")
  (clim:radio-box-current-selection
    (clim:make-pane 'clim:toggle-button :label "Stereo"))
  (clim:make-pane 'clim:toggle-button :label "Quadraphonic"))

(defun radio-box-value-changed-callback (radio-box value)
  (declare (ignore radio-box))
  (format t "~&Radio box toggled to ~S" value))


;; Toggle buttons in a check box
(clim:with-radio-box (:type :some-of
		      :value-changed-callback 'check-box-value-changed-callback)
  (clim:make-pane 'clim:toggle-button :label "Sweet")
  (clim:radio-box-current-selection
    (clim:make-pane 'clim:toggle-button :label "Sour"))
  (clim:make-pane 'clim:toggle-button :label "Spicy")
  (clim:make-pane 'clim:toggle-button :label "Salty"))

(defun check-box-value-changed-callback (check-box value)
  (declare (ignore check-box))
  (format t "~&Check box toggled to ~S" value))


;; List panes
(clim:make-pane 'clim:list-pane
  :value "Symbolics"
  :test 'string=
  :value-changed-callback 'list-pane-changed-callback
  :items '("Franz" "Lucid" "Harlequin" "Symbolics"))

(clim:make-pane 'clim:list-pane
  :value '("Lisp" "C++")
  :mode :nonexclusive
  :value-changed-callback 'list-pane-changed-callback
  :items '("Lisp" "Fortran" "C" "C++" "Cobol" "Ada"))

(defun list-pane-changed-callback (tf value)
  (format t "~&List pane ~A changed to ~S"  tf value))


;; Option panes
(clim:make-pane 'clim:option-pane
  :label "Select a vendor"
  :value "Symbolics"
  :test 'string=
  :value-changed-callback 'option-pane-changed-callback
  :items '("Franz" "Lucid" "Harlequin" "Symbolics"))

(clim:make-pane 'clim:option-pane
  :label "Select some languages"
  :value '("Lisp" "C++")
  :mode :nonexclusive
  :value-changed-callback 'option-pane-changed-callback
  :items '("Lisp" "Fortran" "C" "C++" "Cobol" "Ada"))

(defun option-pane-changed-callback (tf value)
  (format t "~&Option menu ~A changed to ~S"  tf value))


;; Sliders
(clim:make-pane 'clim:slider
  :label "A slider"
  :value-changed-callback 'slider-changed-callback
  :drag-callback 'slider-dragged-callback)

(clim:make-pane 'clim:slider
  :label "A vertical slider with visible value"
  :orientation :vertical
  :show-value-p t
  :value-changed-callback 'slider-changed-callback
  :drag-callback 'slider-dragged-callback)

(defun slider-changed-callback (slider value)
  (format t "~&Slider ~A changed to ~S" (clim:gadget-label slider) value))

(defun slider-dragged-callback (slider value)
  (format t "~&Slider ~A dragged to ~S" (clim:gadget-label slider) value))


;;; Layout panes

(clim:horizontally
  (clim:make-pane 'clim:push-button 
    :label "Done" :activate-callback 'done-callback)
  (clim:make-pane 'clim:push-button 
    :label "Cancel" :activate-callback 'cancel-callback)
  (clim:make-pane 'clim:push-button 
    :label "Help" :activate-callback 'help-callback))

(clim:outlining ()
  (clim:vertically ()
    (setq red (clim:make-pane 'clim:slider
		:label "Red" :foreground clim:+red+
		:orientation :horizontal
		:min-value 0.0 :max-value 1.0 
		:show-value-p t :decimal-places 3
		:client 'color :id 'red))
    (setq green (clim:make-pane 'clim:slider
		  :label "Green" :foreground clim:+green+
		  :orientation :horizontal
		  :min-value 0.0 :max-value 1.0 
		  :show-value-p t :decimal-places 3
		  :client 'color :id 'green))
    (setq blue (clim:make-pane 'clim:slider
		 :label "Blue" :foreground clim:+blue+
		 :orientation :horizontal
		 :min-value 0.0 :max-value 1.0 
		 :show-value-p t :decimal-places 3
		 :client 'color :id 'blue))))
