;;; -*- Package: CLIM-USER -*-

" Written by John Aspinall at Harlequin, Inc.  (jga@harlequin.com)
  Harlequin hereby gives permission for unlimited use of this example code."

(defun sandwich (&optional (stream *query-io*))
  (with-simple-restart (abort "Forget the Sandwich")
    (let* ((s-type :steak)
           (steak-options (list :mustard :onions))
           (italian-options (list :lettuce :tomatoes))
           (options steak-options))
      (accepting-values (stream :own-window t
                                :exit-boxes '((:exit " Cool") (:abort " Forget It"))
                                :label "Choose a Sandwich")
        (setq s-type (accept '(member :steak :italian)
                             :stream stream
                             :prompt "Type"
                             :default s-type))
        (terpri stream)
        (setq options
              (if (eql s-type :steak)
                  (setq steak-options
                        (accept '(subset :mustard :onions :cheese :peppers)
                                :stream stream
                                :prompt "With"
                                :default steak-options))
                  (setq italian-options
                        (accept '(subset :lettuce :tomatoes :pickles)
                                :stream stream
                                :prompt "With"
                                :default italian-options)))))
      (return-from sandwich (cons s-type options))))
  nil)
