;;; -*- Mode: LISP; Syntax: Common-Lisp; Base: 10; Package: CLIM-USER -*-

#|

This code demonstrates how accepting-values can be used to let
the user interchange elements of two lists.  It was written by
William M. York <york@parc.xerox.com> following an email question
that I reproduced here under.

I personnaly decided to post it so it could be used as a small example
for CLIM beginners.  Please don't bother the author of the code.

This requires the clim-tests-framework.lisp file from the clim
library to work smoothly.  If you don't have it, you can also
pass your own window to shift-items.

How to use:
  1) evaluate clim-tests-framework.lisp
  2) evaluate this file
  3) evaluate (start-up-clim-tests-frame)
  4) select the "Test" command from the frame


Keunen Vincent                  MANEX sprl
manex@applelink.apple.com       rue Wagner, 93
tel: +32 41 380 368             B-4100 Boncelles
fax: +32 41 380 606             Belgium


----------------the mail message------------------

From: "William M. York" <york@parc.xerox.com>
To: jd05@gte.com
Cc: clim@BBN.COM
Subject: Can ACCEPTING-VALUES be used to move symbols between lists?
Date:   Mon, 7 Jun 1993 14:57:22 PDT

   Date:        Mon, 7 Jun 1993 13:37:58 -0700
   From:        John Doleac <jd05@gte.com>

   I am interested in using CLIM:ACCEPTING-VALUES to show two lists, allowing
   the user to click on items in one list, automatically moving them to the
   other list.

Build on this:

|#


(in-package :clim-user)

(defun shift-items (win)
  (unwind-protect
      (let ((foo (list 'a 'b 'c))
            (bar (list 'x 'y 'z)))
        ;; Accept the two lists independently, moving a selected item to
        ;; the other list.  Resynchronize so that the removed item really
        ;; goes away immediately.
        (accepting-values (win :own-window t :resynchronize-every-pass t) 
          (let* ((item (accept `(member ,@foo) :stream win :prompt "List 1" :default nil)))
            (when item
              (setq foo (remove item foo))
              (setq bar (push item bar))))
          (terpri win)
          (let* ((item (accept `(member ,@bar) :stream win :prompt "List 2" :default nil)))
            (when item
              (setq bar (remove item bar))
              (setq foo (push item foo))))))
    ;; pop the window down even when you abort
    (force-output win)))


(defun clim-test-function ()
  (shift-items *the-clim-tests-frame-main-window*)
  (format *query-io* "~&The test command has been executed."))

;start up by evaluating this
;(start-up-clim-tests-frame)