;;; -*- Mode: LISP; Syntax: Common-lisp; Package: CLIM-USER; Base: 10 -*-
#|
From: John Aspinall <jga@harlequin.com>
Date: Tue, 17 Aug 1993 17:16:37 -0400
Message-Id: <13632.199308172116@sonata.harlequin.com>
To: paolucci+@pitt.edu
Cc: clim@bbn.com
In-Reply-To: Massimo Paolucci's message of Wed, 28 Jul 1993 17:06:57 -0400 (EDT) <UgJidlC2AG3H8253EZ@pitt.edu>
Subject: dragging-output

   Date: Wed, 28 Jul 1993 17:06:57 -0400 (EDT)
   From: Massimo Paolucci <paolucci+@pitt.edu>

   is it possible to have an example of use of the functions
   dragging-output and dragging-output-record?

I didn't see any public replies to this query, although you may have
received some private ones.  In case you (or anyone else) is still
looking for something, here's a toy app illustrating the classical use
of dragging-output-record to move something around the screen.

For CLIM 1.1 - tested on Symbolics Genera 8.1, and Harlequin Lispworks 3.1.
|#

(defclass movable-object () ())

(define-presentation-type movable-object ())

(define-application-frame funbox
			  ()
    ((points :initform nil))
  (:panes ((title :title :display-string "Funbox")
	   (display :application
		    :display-function 'do-the-display
		    :display-after-commands nil)
	   (interactor :interactor)
	   (menu :command-menu)))
  (:layout ((only
	     (:column 1
	      (title :compute)
	      (display :rest)
	      (:row 1/5 (interactor 3/4) (menu :rest)))))))

(defmethod do-the-display ((frame funbox) pane)
  (with-output-as-presentation (:object 'xyzzy :stream pane :type 'movable-object)
    (draw-rectangle* pane 100 100 140 200 :ink +light-gray+))
  (with-output-as-presentation (:object 'gnorph :stream pane :type 'movable-object)
    (draw-triangle* pane 100 100 90 150 170 140 :ink +gray+)))

(define-funbox-command (com-exit-funbox :menu "Exit") ()
  (frame-exit *application-frame*))

(define-funbox-command (com-redraw-funbox :menu "Redraw") ()
  (let* ((frame *application-frame*)
	 (pane (get-frame-pane frame 'display)))
    (window-clear pane)
    (do-the-display *application-frame* pane)))

(define-presentation-action move-the-shape
    (movable-object nil funbox :gesture :select)
    (presentation window)
  (dragging-output-record window presentation :finish-on-release t))

;;; now make a drawer that simplifies the object as it moves it

(define-presentation-action move-the-shape-with-outline
    (movable-object nil funbox :gesture :describe)
    (presentation window)
  (flet ((drawer (record stream init-x init-y x y alu)
	   (declare (ignore alu init-x init-y x y))
	   (with-bounding-rectangle* (lef top rit bot) record
	     (draw-rectangle* stream lef top rit bot :filled nil :ink +flipping-ink+))))
    (dragging-output-record window presentation :finish-on-release t :feedback #'drawer)))

#|
()
(setq fb (make-application-frame 'funbox :parent *clim-root*
                                 :left 100 :right 500
                                 :top 100 :bottom 500))
(run-frame-top-level fb)
|#



