;;; -*- Mode: LISP; Syntax: Common-lisp; Package: USER; Base: 10 -*-


#|


Author:	        Jan Hesse
                copyright 1992 by FZI and Symbolics Systemhaus GmbH.
                All rights reserved.

	        Forschungszentrum Informatik (FZI), TEuR  
	        Haid-und Neu-Str. 10 - 14
	        7500 Karlsruhe 1
	        West Germany

                Symbolics Systemhaus GmbH
                Mergenthaleralle 77-81
                6236 Eschborn/Ts.
                West Germany

Creation date: 	28-JUL-92

Project:        CLIM-Interface-Builder 

Needs:          CL, 

Content:        load CLIM-Interface-Builder 

|#

(defvar *sweet-root-of-clib*
	#+lispm "ca:/fzi/robot/hesse/TEuR/demos/"
	#+Allegro "/fzi/robot/hesse/TEuR/demos/")

(defun binary-extension-of-clib ()
	#+3600 "bin"
	#+(and Genera (not 3600)) "ibin"
	#+Allegro "fasl")

(defun lisp-extension-of-clib ()
  "lisp")

(defun directory-separator ()
  "/")


(defun get-clib-file (name-list 
		      &optional 
		      (extension nil) 
		      (home *sweet-root-of-clib*))
  (let ((sep (directory-separator))
	(pathname home))
    (dolist (name name-list)
      (if (string-equal (subseq pathname (1- (length pathname))) sep)
	  (setf pathname (concatenate 'string pathname name))
	(setf pathname (concatenate 'string pathname sep name))))
    (when (stringp extension)
      (setf pathname (concatenate 'string pathname "." extension)))
    pathname))


(defun load-clib-file (name-list &optional 
			(extension (binary-extension-of-clib))
			(home *sweet-root-of-clib*))
  (load (get-clib-file name-list extension home)))

(defun clib-directory-pathname (name-list
				&optional (binary-dir-name (binary-extension-of-clib))
				(home *sweet-root-of-clib*))
  (when binary-dir-name
    (setf name-list (append name-list (list binary-dir-name))))
  (concatenate 'string (get-clib-file name-list nil home) (directory-separator)))

;;; ----------------
;; load defsystem

(unless (find-package 'make)
  (format t "Loading Defsystem ..... ")
  (let ((bin-path (get-clib-file '("CLIB-delta-version" "defsystem") (binary-extension-of-clib))))
  (unless (probe-file bin-path)
    #+Allegro (load-clib-file '("CLIB-delta-version" "defsystem") (lisp-extension-of-clib))
    (compile-file (get-clib-file '("CLIB-delta-version" "defsystem") (lisp-extension-of-clib))
		  :output-file bin-path))
  (load-clib-file '("CLIB-delta-version" "defsystem"))))


;;; --------------


(make::defsystem clim-builder
    :source-pathname (clib-directory-pathname '("CLIB-delta-version") nil) 
    :binary-pathname (clib-directory-pathname '("CLIB-delta-version"))
    :source-extension "lisp"
    :binary-extension
    #+3600 "bin"
    #+(and Genera (not 3600)) "ibin"
    #+Allegro "fasl"
    :components
   
    ((:module clos-database
      :source-pathname "clos-database"
      :components
      ((:file "clos-database-package") ;; package

       (:file "generics")              ;; global
       (:file "globals")
       (:file "compatibility")         ;; classes
       (:file "database-mixin")
       (:file "wrapper-classes")       ;; wrapper-classes
       (:file "database-io")           ;; io
       (:file "slot-type")             ;; slots
       (:file "class-managing")        ;; class-manager
       (:file "indexes")               ;; indexes
       (:file "instance-manager")      ;; inst-manager
       (:file "referencing")
       (:file "slot-access")
       (:file "database")              ;; database
       (:file "new-functions")         ;; addendum
       )
      :depends-on nil)
     
     (:module IFT
      :source-pathname "IFT"
      :components
      ((:file "ift-defpackage")
       (:file "globals")
       (:file "class-definition")

       (:file "macros-function")
       (:file "drawing-primitives")

       (:file "ift-element")
       (:file "scale-mixins")

       (:file "lcd")
       (:file "tacho&dial")
	
       (:file "button")
       (:file "evaluator&slide-bars")

       (:file "scales")
       (:file "clock")
       )
      :depends-on (clos-database)
      )

     (:module Package
      :source-pathname ""
      :components ((:file "clib-defpackage")
		   (:file "clib-file-access")      ;; global definition of file accessment.
		   )
      :depends-on (clos-database IFT))

     (:module Basics
      :source-pathname "Basics"
      :components
      (
       (:file "globals")
       (:file "drawing-stuff")
       (:file "window-stuff")
       (:file "color")
       (:file "listener")
       (:file "editor")
       (:file "accept-extension")
       (:file "non&modal")
       (:file "basic-menus")
       (:file "special-menus")
       (:file "palette")
       (:file "file-select")
       )
      :depends-on (Package)
      )
     (:module Database-Interface
       :source-pathname "Moduls-Interface"
       :components
       ((:file "database-handling"))
       :depends-on (clos-database)
       )
     (:module IFT-Interface
      :source-pathname "Moduls-Interface"
      :components
      ((:file "ift-interface"))
      :depends-on (IFT)
      )
     (:module DialogBuilder
       :source-pathname "DialogBuilder"
       :components
       (
	(:file "builder-appl")
	(:file "class-definition")
	(:file "cpd-dialog-obj")
	(:file "dialog-object")
	(:file "event-handling")
	(:file "save-open-dialogs")
	)
       :depends-on (Basics Database-Interface IFT-Interface)
       )

     (:module Layouter
       :source-pathname "Layouter"
       :components

       (
	(:file "classes-def")
	(:file "layout-object-methods")
	(:file "horiz-rect-methods")
	(:file "verti-rect-methods")
	(:file "appli-pane-methods")
	(:file "horiz-appli-pane-methods")
	(:file "verti-appli-pane-methods")
	(:file "basic-verti-appli-pane-methods")
	;; (:file "commands-def")
	(:file "utility-funct")
	)
       :depends-on (Basics Database-Interface)
       )

     (:module Generics&CodeGeneration
       :source-pathname "Moduls-Interface"
       :components
       (
	(:file "defgenerics")
	(:file "get-value")
	(:file "dialogbuilder")

	)
       :depends-on (DialogBuilder Layouter)
       )
     (:module ProjectManager
       :source-pathname "Project-Manager"
       :components
       (
	
	(:file "Manager-appl")
	(:file "../Layouter/commands-def")
	(:file "Pane-commands")
	(:file "menu-commands")
	(:file "layouter-commands")

	)
       :depends-on (Database-Interface DialogBuilder Layouter)
       )
     )
    
    )

(format t "Compiling the CLIM-BUILDER System......")

(make::compile-system 'clim-builder)


;;; kill the package shit
#+genera (si:com-set-package (find-package 'clib))
#-genera (setf *package* (find-package 'clib))

;; EOF
