;; packages-test
;  -------------   

;;testfile fuer kapitel 11

(packagep  *package*)
T 
;;list-all-packages und typtest
(let ((p (list-all-packages)))
     (every #'packagep p))
T

;;11.6 obligate Paketnamen u. deren Abkuerzungen

;;vorhandensein der standardpakete und find-package dafuer

(and (find-package 'lisp) t)
T
(and (find-package 'user) t)
T
(and (find-package 'keyword) t)
T
(and (find-package 'system) t)
T
(and (find-package 'sys) t)
T
(and (find-package "sys") t)
NIL 
(and (find-package "sys") t)
NIL 
(and (find-package "system") t)
NIL 
(and (find-package "SYSTEM") t)
T
(and (find-package "SYS") t)
T

;nicknames
(find "SYS" (package-nicknames 'sys) :test #'string=)
"SYS" 

;package-name
(package-name 'sys)
"SYSTEM" 
(package-name 'system)
"SYSTEM" 
(package-name "USER")
"USER" 
(package-name "SYS")
"SYSTEM" 


;;; 11.7 anlegen von paketen, export import ...

  ;package-funktionen mit nutzerdefinierten paketen

;falls test1 bereits existiert
(and (find-package 'test1)
     (in-package 'test1)
     (rename-package (find-package 'test1) 'test1-old) 
     nil)
nil

;make-package
(package-name (make-package 'test1 :nicknames '(t1 tst1)))
"TEST1"

;package-use-list
;(package-use-list (find-package 'test1))
;("LISP")


(and (in-package 'test1) T)
T


(export  '(test1::test1-x test1::test1-y test1::test1-z)(find-package 
'"TEST1"))
T

(export  '(test1::test1-a test1::test1-b test1::test1-c) (find-package 
'test1))
T

(setf test1-a -2 
      test1-b -1 
      test1-c  0 
      test1-x  1
      test1-y  2
      test1-z  3)
3

;falls test2 bereits existiert
(and 
	(find-package 'test2)
	(rename-package (find-package 'test2) 'test2-old) 
	nil)
nil

(package-name (in-package 'test2 :nicknames '("T2" "TST2") :use 'test1))
"TEST2"

(package-name (find-package 'test2))
"TEST2"

(package-name *package*)
"TEST2"

(and (boundp 'test1-x)test1-x)
NIL

(unintern 'test1-x)
T

(and (boundp 'test1:test1-x)test1:test1-x)
ERROR


(and (boundp 'test1::test1-x)test1::test1-x)
1

(import  '(test1::test1-x test1::test1-y) (find-package 'test2))
T

(and (boundp 'test1-x)test1-x)
1

(and (boundp 'test1:test1-x)test1:test1-x)
1

(and (boundp 'test1::test1-x)test1::test1-x)
1

(and (boundp 'test1-z)test1-z)
NIL

(unintern 'test1-z (find-package 'test2))
T

(and (boundp 'test1:test1-z)test1:test1-z)
ERROR

test1::test1-z
3

(unexport  '(test1::test1-x test1::test1-y) (find-package 'test1))
T

(and (boundp 'test1-x)test1-x)
NIL

(unintern 'test1-x (find-package 'test2))
T

test1:test1-x
ERROR

test1::test1-x
1

test1-z
ERROR

(unintern 'test1-z (find-package 'test2))
T

test1:test1-z
3

test1::test1-z
3

(import 'test1::test1-z (find-package 'test2))
T

test1-z
3

test1:test1-z
3

test1::test1-z
3

test1-c
ERROR

(unintern 'test-c (find-package 'test2))
T

test1:test1-c
0

test1::test1-c
0

(import '(test1::test1-a test1::test1-b test1::test1-c)  (find-package 
'test2))
T

test1-c
0

test1:test1-c
0

test1::test1-c
0

(eq 'test1-c 'test1::test1-c)
T

  ;Ende nutzerdefinierte Pakete

;; test in standardmaessig vorgegebenen paketen

; export | import | unintern

(and(in-package 'user)T)
T

(setf x 1 y 2 z 3)
3

(and(in-package 'editor)T)
T

(unintern 'x)
T

(unintern 'y)
T

(unintern 'z)
T

user::x
1

user:x
ERROR

x
error

(eq 'x 'user::x)
NIL

(unintern 'x)
T

(export '(user::x user::y) (find-package 'user))
T

user::x
1

user:x
1

x 
error

(unintern 'x)
T

(import 'user:x (find-package 'editor))
T

x
1

(eq 'x 'user::x)
t

(eq 'x 'user:x)
t

(eq 'editor::x 'user::x)
t

;; unexport

(and (in-package 'user) T)
T

(unexport 'y)
T

(and (in-package 'editor) T)
T

y
ERROR

user:y
ERROR

user::y
2

;; shadowing-import -- zunaechst ohne geerbte symbole!!

(and (in-package 'user)(package-name *package*))
"USER"

(setf d 4 e 5 f 6 y 111 x 222)
222

(export '(user::a user::b user::c user::y user::x) (find-package 'user))
T

(import '(user::a user::b user::c user::y) (find-package 'editor))
ERROR

(and (make-package 'shadow-test)(in-package 'shadow-test)t)
T

(setf x 'shadow-test)
shadow-test

(shadowing-import '(user::d user::e user::f user::x)(find-package 'shadow-test))
T

x
222

(eq user::x x)
T

; shadow

(shadow '(e f) (find-package 'shadow-test))
t

(setf e 'shadow-test-e)
shadow-test-e

(eq 'e 'user::e)
nil

e
shadow-test-e

user:e
error

user::e
5

; use-package | unuse-package

(and (make-package 'use-test)(in-package 'use-test) t)
t

(use-package '(user))
T

user::d
4

user:d
4

d
ERROR

(unuse-package 'user)
T

user::d
4

user:d
ERROR

d
ERROR

;make-package mit beutzung eines paketes, dass geerbte symbole enthaelt

(and (make-package 'inherit :nicknames '(inh i) )(in-package 'inherit)T)
T

(setf a 'inherita b 'inheritb)
inheritb

(export '(a b) (find-package 'inherit))
T

(and (make-package 'inherit1 :use 'inherit)(in-package 'inherit1)T)
T

a 
inherita 

b 
inheritb

(setf c 'inherit1c)
inherit1c

(and (make-package 'inherit2 :use 'inherit1)(in-package 'inherit2)T)
T

a 
inherita 

b 
inheritb

c
inherit1c

(eq 'c 'inherit1:c)
T

(eq 'a 'inherit:a)
T

(eq 'b 'inherit:b)
T

;find-all-symbols

(and (in-package 'user) T)
T

  find-all-symbols fehlerhaft
(and (member 'user::x (setf s (find-all-symbols 'x)))T)
T

(and (member 'editor:x s) t)
T

(and (member 'user::x (setf s1 (find-all-symbols 'x)))T)
T

(set-difference s s1)
nil				 ;Ende Kommentar

;do-symbols | do-external-symbols | do-all-symbols

(setf sym nil
      esym nil
;      asym nil ;do-all-symbols viel zu aufwendig!
)
nil

(setf sym (do-symbols (s (find-package 'user))(push (symbol-name s) 
sym))
      esym (do-symbols (s (find-package 'user))(push (symbol-name s) 
esym))
;      asym (do-symbols (s (find-package 'user) nil)(push (symbol-name 
s) asym))
      )
nil

(find "ESYM" sym :test #'string=)
"ESYM"

(find "ESYM" esym :test #'string=)
nil

(find "LAMBDA-LIST-KEYWORDS" esym :test #'string=)
"LAMBDA-LIST-KEYWORDS"

;(count "LAMBDA-LIST-KEYWORDS" asym :test #'string=) 
;T                                                  ;viel zu lang

; modules | provide | (require nicht getestet !)

(and *modules* T)
T

(and (provide 'provide-test) t)
t

(find "PROVIDE-TEST" *modules* :test #'string=)
"PROVIDE-TEST"

(format t "End of file")
nil
