;;;_________________________________________________________________________________
;;;
;;; File:		       read-pattern.lsp
;;; File Creation Date:        Mon Jan 25 16:37:33 1988
;;;
;;; Copyright (c): Forschungsgruppe INFORM, Matthias Ressel
;;;                Universitaet Stuttgart
;;;
;;; Last Modification Time:    Mon Jan 25 16:42:03 1988
;;; Last Modification By:      Matthias Ressel
;;;
;;; Changes (worth to be mentioned):
;;; ================================
;;;_________________________________________________________________________________

;(setq *pattern-name-area*
;      (make-array 100
;		  :element-type 'string-char
;		  :fill-pointer 0))

(defun read-pattern-name (instream)
  (declare (special *pattern-name-area*))
  (setf (fill-pointer *pattern-name-area*) 0)
  (with-output-to-string (outstream *pattern-name-area*)
      (do ((ch (peek-char nil instream)
	       (peek-char nil instream)))
	  ((or (null ch)
	       (not (or (alphanumericp ch)
			(member ch 
			    '(#\! #\# #\$ #\% #\@ #\* #\+ #\- #\/ 
			      #\. #\< #\> #\= #\& #\^ #\_ #\~))))))
	  (write-char (read-char instream) outstream)))
  *pattern-name-area*)

