;;; -*- Package: TRANSLISP; Mode: LISP; Syntax: Common-lisp; Base: 10 -*-
;;;_________________________________________________________________________________
;;;
;;;                       System: Translisp
;;;                       Module: MATCH14
;;;                       (Version 1.0)
;;;
;;; Copyright (c): Forschungsgruppe INFORM, Matthias Ressel
;;;                Universitaet Stuttgart
;;;
;;; File: ODIN:>matthias>translisp>match14.lisp
;;; File Creation Date: 1/18/88 22:26:06
;;; Last Modification Time: 1/18/88 22:26:06
;;; Last Modification By: matthias
;;;
;;;
;;; Changes (worth to be mentioned):
;;; ================================
;;; segm-fast-match : fixed bug for atomic tails -- andreasg
;;;________________________________________________________________________________ 

(in-package 'franzlisp-reader :nicknames '(flr))
(in-package 'translisp)

(export '(*dont-match-comma-splice* *bindings* Match1 Match all-matches)) 

#-system-translisp
(eval-when (compile eval)
  (load "pattern-macros")
  ;;(eval-when (compile load eval)
  (load "franz-macros"))

(defvar *dont-match-comma-splice* nil
  "falls auf t gesetzt, matchen Elementvariablen nicht mehr ,@irgendwas")

(defvar *bindings* () "Bindungsliste des Patternmatchers")

;___________________________________________________________________________________

(defmacro fail ()
  nil)

; nur atome
(defmacro is-non-nil-atom (object)
  `(and ,object
        (atom ,object)))	       

(defmacro is-list (object)
  `(and (listp ,object)
        (not (Var? ,object))))

;Funktionen auf Alist

(defmacro bind (var val alist)
  `(if (Nam? ,var)
       (cons (cons (Name ,var) ,val) ,alist)
       ,alist))

;test-eval prueft ob die Restriction auf Objekt zutrifft.
;
(defun test-eval (restriction item *bindings*)
  (or (null restriction)
      (funcall restriction item)))

;map-test-eval wendet test-eval auf eine Liste von Objekten an
;
(defun map-test-eval (restriction item-list *bindings*)
  (declare (special restriction))
  (or (null restriction)
      (map-test-eval-1 item-list)))

(defun map-test-eval-1 (item-list)
  (declare (special restriction))
  (or (null item-list)
      (and (funcall restriction (car item-list))
           (map-test-eval-1 (cdr item-list)))))

(defun tailc (head list)
  (cond ((null head) (list list))
        ((null list) nil)
        ((and (equal (car head) (car list))
              (tailc (cdr head) (cdr list))))))



(defun next-match (gen)
  (if gen
      (apply (car gen) (cdr gen))))

;Patternmatchfunktionen

(defun all-matches (pat dat)
  (let ((result (Match pat dat)))
    (and result
         (do ((r (next-match (cdr result))
                 (next-match (cdr r)))
              (ans (tconc nil (car result))))
             ((null r) (car ans))
           (tconc ans (car r))))))


(defun Match (pat dat)
  (Match1 pat dat nil))


(defun Match1 (pat dat bdgs)
  (cond ((is-list pat) (Match-list-pattern pat dat bdgs))
        ((Elem? pat) (Match-lists (list pat) (list dat) bdgs))
        ((eq pat dat) (cons bdgs nil))
        ((equal pat dat) (cons bdgs nil))))


(defun Match-list-pattern (pat dat bdgs)
  (if (null pat)
      (if (null dat)
          (cons bdgs nil)
          (fail))
      (if (listp dat)
          (Match-lists pat dat bdgs)
          (fail))))


(defun Match-lists (pat dat bdgs)
  (cond ((Segm? (car pat)) (segm-match pat dat bdgs))
        ((null dat) (fail))
        ((Elem? (car pat)) (elem-match pat dat bdgs))
        ((is-list (car pat)) (list-match pat dat bdgs))
        ((eq (car pat) (car dat))
         (Match1 (cdr pat) (cdr dat) bdgs))))


(defun list-match (pat dat bdgs)
  (match-first-rest-generator-1 pat
                                dat
                                bdgs
                                (Match-list-pattern (car pat)
                                                    (car dat)
                                                    bdgs)))

(defun match-first-rest-generator (pat dat bdgs gen)
  (match-first-rest-generator-1 pat dat bdgs (next-match gen)))

(defun match-first-rest-generator-1 (pat dat bdgs result)
  (if result
      (let ((result-2 (Match1 (cdr pat)
                              (cdr dat)
                              (car result))))
        (if result-2
            (cons
              (car result-2)
              `(match-generator-2
                 ,(cdr result-2)
                 (match-first-rest-generator ,pat
                                             ,dat
                                             ,bdgs
                                             ,(cdr result))))
            (match-first-rest-generator pat
                                        dat
                                        bdgs
                                        (cdr result))))))


(defun match-generator-2 (rest-gen gen)
  (let ((result (next-match rest-gen)))
    (if (null result)
        (next-match gen)
        (cons (car result)
              `(match-generator-2 ,(cdr result) ,gen)))))

(defun test-comma-splice (dat)
  (or (null *dont-match-comma-splice*)
      (not (and (listp dat)
                (member (car dat) '(flr::|,@| flr::|,.|) :test #'eq)))))

(defun elem-match (pat dat bdgs)
  (if (Nam? (car pat))
      (let ((bdg-pair (BindingOf (car pat) bdgs)))
        (if bdg-pair
            (and (equal (cdr bdg-pair) (car dat))
                 (Match1 (cdr pat) (cdr dat) bdgs))
            (let ((newbdgs (bind (car pat) (car dat) bdgs)))
              (and (test-comma-splice (car dat))
                   (test-eval (TheElemPredicate (car pat))
                              (car dat)
                              newbdgs)
                   (Match1 (cdr pat) (cdr dat) newbdgs)))))
      (and (test-comma-splice (car dat))
           (test-eval (TheElemPredicate (car pat))
                      (car dat)
                      bdgs)
           (Match1 (cdr pat) (cdr dat) bdgs))))



(defun segm-match (pat dat bdgs)
  (if (Nam? (car pat))
      (let ((bdg-pair (BindingOf (car pat) bdgs)))
        (if bdg-pair
            (let ((tailcell (tailc (cdr bdg-pair) dat)))
              (if tailcell
                  (Match1 (cdr pat) (car tailcell) bdgs)
                  (fail)))
            (segm-match-try-bind pat dat bdgs)))
      (segm-match-try-bind pat dat bdgs)))


(defun segm-match-try-bind (pat dat bdgs)
  (cond ((null (cdr pat))
         (if (real-listp dat)
             (let ((newbdgs (bind (car pat) dat bdgs)))
               (if (and (map-test-eval
                          (TheElemPredicate (car pat))
                          dat
                          newbdgs)
                        (test-eval (TheSegmPredicate (car pat))
                                   dat
                                   newbdgs))
                   (cons newbdgs nil)
                   (fail)))))
        ((listp (cdr pat))
         (let ((p2 (cadr pat)))
           (segm-fast-match pat
                            (lconc nil nil)
                            dat
                            bdgs
                            (cond ((not (real-listp dat))
                                   'length)
                                  ((is-non-nil-atom p2)
                                   'const)
                                  ((is-list p2) 'list)
                                  ((and (BindingOf p2 bdgs)
                                        (not (Segm? p2)))
                                   'bound)
                                  ((and (RestrictElem? p2)
                                        (not (Segm? p2)))
                                   'restr)
                                  ('length)))))
        (t (segm-fast-match pat
                            (lconc nil nil)
                            dat
                            bdgs
                            'length))))

(defun segm-fast-match (pat segm-value dattail bdgs modus)
  (let* ((newdattail (next-tail pat dattail bdgs modus))
         (expansion (and (not (eq dattail newdattail))
			 (ldiff dattail newdattail))))
    (setq segm-value (lconc segm-value expansion))
    (if (map-test-eval (TheElemPredicate (car pat))
                       expansion
                       bdgs)
        (let* ((newbdgs (bind (car pat)
                              (car segm-value)
                              bdgs))
               (result
                 (and (test-eval (TheSegmPredicate (car pat))
                                 (car segm-value)
                                 newbdgs)
                      (Match1 (cdr pat) newdattail newbdgs))))
          (if (and (consp newdattail)
                   (test-eval (TheElemPredicate (car pat))
                              (car newdattail)
                              bdgs))
              (if (null result)
                  (segm-fast-match pat
                                   (tconc segm-value
                                          (car newdattail))
                                   (cdr newdattail)
                                   bdgs
                                   modus)
                  (cons
                    (car result)
                    `(match-generator-2
                       ,(cdr result)
                       (segm-fast-match
                         ,pat
                         ,(tconc
                            (lconc
                              nil
                              (copy-list (car segm-value)))
                            (car newdattail))
                         ,(cdr newdattail)
                         ,bdgs
                         ,modus))))
              result)))))
  

(defun next-tail (pat dattail bdgs modus)
  (if (atom dattail)
      dattail
      (case modus
	(length dattail)
	(const (member (cadr pat) dattail :test #'eq))
	(list (member-if #'listp dattail))
	(restr (let ((p2 (cadr pat)))
		 (member-if-2 (TheElemPredicate p2) dattail bdgs)))
	(bound (let ((value (lookup (cadr pat) bdgs)))
		 (if (consp value)
		     (member-if #'consp dattail)
		     (member value dattail :test #'eq)))))))



; Voraussetzung fuer das korrekte Arbeiten vom alten member-if-2 war, 
; dass die zu testende
; Bindung ganz vorne in der Bindungsliste stand
; das ist jetzt nicht mehr so
;
(defun member-if-2 (restr list bdgs)
 " (do ((restlist list (cdr restlist)))
      ((or (null restlist)
           (test-eval restr (car restlist) bdgs))
       restlist)"
 (member-if #'(lambda (item) (test-eval restr item bdgs)) list))
       

(setf (get 'match14 'version) '1.6)
