;;; -*- Package: TRANSLISP; Mode: LISP; Syntax: Common-lisp;  Base: 10 -*-

;;; Useful Franz Lisp functions with no equivalents in Common Lisp
;;; they are written in Common Lisp

(in-package 'translisp)

(export '(tconc lconc tab protocol-msg protocol-pp-form date))

(defun tconc (t-list item)
  (unless t-list (setf t-list (cons nil nil)))
  (let ((new-cons (cons item nil)))
    (if (car t-list)
	(setf (cddr t-list) new-cons)
	(setf (car t-list) new-cons))
    (setf (cdr t-list) new-cons)
    t-list))

(defun lconc (t-list tail-list)
  (when tail-list
    (unless t-list (setf t-list (cons nil nil)))
    (if (car t-list)
	(setf (cddr t-list) tail-list)
	(setf (car t-list) tail-list))
    (setf (cdr t-list) (last tail-list)))
  t-list)

(defmacro tab (col &optional (stream '*standard-output*))
  `(let ((st ,stream))
    ; (format (or st t) "~&~VT" ,col)
     (fresh-line st)
     (dotimes (var ,col)
       (write-char #\Space st))))

(defmacro msg (&rest args &aux (stream '*standard-output*))
  (do* ((args args (cdr args))
	(item (car args) (car args))
	(list-of-prints '()))
       ((null args)
	(cond ((null list-of-prints) nil)
	      ((null (cdr list-of-prints))
	       (car list-of-prints))
	      (t (cons 'progn (nreverse list-of-prints)))))
    (cond ((and (listp item)
		(eq (car item) 'P))
	   (setq stream (cadr item)))
	  ((eq item 'B) (push `(princ " " ,stream) list-of-prints))
	  ((eq item 'N) (push `(terpri ,stream) list-of-prints))
	  (t (push `(princ ,item ,stream) list-of-prints)))))

(defmacro protocol-msg (&rest args)
  `(if (protocol?)
       (msg (P *protocolport*) ,.args)))

(defmacro protocol-pp-form (expr)
  `(if (protocol?)
       (pprint ,expr)))

(defun date ()
  (multiple-value-bind (second minute hour date month year) (get-decoded-time)
    (declare (ignore second))
    (format nil "~2,'0d.~2,'0d.~d, ~2d:~2,'0d" date month year hour minute)))

