;;; -*- Mode: LISP; Syntax: Common-lisp; Package: User; Base: 10 -*-

;;; Rule Base: Franz to Common Lisp

;;;----------------------------------------------------------------------
;;; Package
;;;----------------------------------------------------------------------

; (in-package 'franz-to-common) ; in a version to come

;;;------------------------------------------------------------------------------------------
;;; Laden der Read-Macros und Rule-Macros
;;;------------------------------------------------------------------------------------------

(eval-when (compile eval)
  (unless (get 'tl::init-rule-handling 'tl::version)
    (load "../kernel/init-rule-handling")))

(init-rule-file)

;;;------------------------------------------------------------------------------------------
;;; ProgForms
;;;------------------------------------------------------------------------------------------

(defruleset MyProg (progform))

(defrule  prog-expr-trigger MyProg 1		; Bug !!???
	?x:(not (symbolp IT))
	==>
	?,(let ((result (TransformIgnoreResult ?x)))
	    (if (symbolp result)
		`(fl::|progn| ,result)
		result))			
	(Franz-Trigger)
	(NoProtocol)
	((author "Matthias Ressel") (created "Sat Dec 20 19:15:55 1986")
	 (modified-by "Matthias Ressel") (modified "Wed Apr 15 23:17:37 1987")))

(defrule prog-label MyProg 1
   ?label:symbolp
   ==>
   ?,(Symbol ?label)
   (Franz-Trigger)
   (NoProtocol)
 ((author "Andreas Girgensohn") (created "29.10.1987, 14:49")))

;;; Korrekter Platz unbekannt -- Andreas

(defrule convert-quote-to-function MyFunction 1
   (?foo:{quote fl::|quote|} ?func)
   ==>
   (function ?func)
   (Franz-to-Common)
   (Protocol)
 ((author "Andreas Girgensohn") (created "16.10.1987, 19:44")))



;;;------------------------------------------------------------------------------------------
;;; Version
;;;------------------------------------------------------------------------------------------

(setf (get 'franz-to-common 'version) '1.0)

#||
;;; all FranzLisp functions

'(fl::|$patom1| fl::|$prd1| fl::|$prdf| fl::|$prpr| fl::|%:format-handler|
  fl::|&:format-handler| fl::* fl::*$ fl::|*:format-handler| fl::|*array| fl::|*break|
  fl::|*catch| fl::|*dif| fl::|*invmod| fl::|*makhunk| fl::|*mod| fl::|*process|
  fl::|*process-receive| fl::|*process-send| fl::|*quo| fl::|*rplacx| fl::|*rset|
  fl::|*throw|  fl::+ fl::+$ fl::- fl::-$ fl::/ fl::/$ fl::1+ fl::1+$ fl::1- fl::1-$
  fl::|:=|  fl::|;:format-handler| fl::< fl::<& fl::<= fl::<=& fl::= fl::=& fl::>
  fl::>& fl::>= fl::>=&  fl::|?th| fl::|Cnth| fl::|Divide| fl::|Emuldiv|
  fl::|I-throw-err| fl::|If|  fl::|Sharpm'g00150| fl::|Sharpm'g00160|
  fl::|Sharpm+g00125| fl::|Sharpm+g00139|  fl::|Sharpm,g00155| fl::|Sharpm,g00164|
  fl::|Sharpm-g00132| fl::|Sharpm-g00145|  fl::|Sharpm/g00139| fl::|Sharpm/g00151|
  fl::|SharpmMg00176| fl::|SharpmMg00182|  fl::|Sharpm\\g00160| fl::|Sharpm\\g00168|
  fl::|Sharpm^g00144| fl::|Sharpm^g00155|  fl::|Sharpmog00097| fl::|Sharpmog00113|
  fl::|Sharpmtg00171| fl::|Sharpmtg00178|  fl::|Sharpmxg00102| fl::|Sharpmxg00117|
  fl::|[:format-handler| fl::\\ fl::|]:format-handler|  fl::^ fl::|^:format-handler|
  fl::|a:format-handler| fl::|abs| fl::|absval| fl::|acos|  fl::|add|
  fl::|add-syntax-class| fl::|add1| fl::|aexplode| fl::|aexplodec| fl::|aexploden|
  fl::|allocate| fl::|allsym| fl::|alphalessp| fl::|and| fl::|any-zerop| fl::|append|
  fl::|append1| fl::|apply| fl::|apply*| fl::|arg| fl::|argv| fl::|arrac-nD|
  fl::|arrac-oneD|  fl::|arrac-twoD| fl::|array| fl::|array-type| fl::|arraycall|
  fl::|arraydims| fl::|arrayp|  fl::|arrayref| fl::|ascii| fl::|asin| fl::|assoc|
  fl::|assq| fl::|atan| fl::|atom|  fl::|attach| fl::|back-quote-ch-macro|
  fl::|back-quote-comma-macro| fl::|back=quotify|  fl::|baktrace| fl::|baktraceprint|
  fl::|bcdad| fl::|bcdcall| fl::|bcdp|  fl::|bignum-leftshift| fl::|bignum-to-list|
  fl::|bigp| fl::|boole| fl::|boundp|  fl::|bq-print-macro| fl::|break|
  fl::|break-err-handler| fl::|c:format-handler| fl::|caar|  fl::|caddddr|
  fl::|cadddr| fl::|caddr| fl::|cadr| fl::|car| fl::|case-scan| fl::|caseq|
  fl::|catch| fl::|cdar| fl::|cddddddr| fl::|cdddddr| fl::|cddddr| fl::|cdddr|
  fl::|cddr|  fl::|cdr| fl::|cfasl| fl::|ch10:format-handler| fl::|charcnt|
  fl::|charsinbuf| fl::|chdir|  fl::|cib| fl::|close| fl::|command-line-args|
  fl::|comment| fl::|compile| fl::|concat|  fl::|concatl| fl::|cond|
  fl::|condclosefile| fl::|cons| fl::|construct-list*| fl::|copy|  fl::|copyint*|
  fl::|copysymbol| fl::|cos| fl::|cprintf| fl::|cputim| fl::|cpy1| fl::|cr|
  fl::|cvttofranzlisp| fl::|cvttointlisp| fl::|cvttomaclisp| fl::|cvttoucilisp|
  fl::|cxr|  fl::|d:format-handler| fl::|de| fl::|de-compose| fl::|debug|
  fl::|debug-err-handler|  fl::|debugging| fl::|declare| fl::|decr| fl::|def|
  fl::|defcmacro| fl::|defformat|  fl::|defmacro| fl::|defmcrooption|
  fl::|defmcrosrch| fl::|defprop| fl::|defsetf|  fl::|defsharp| fl::|defsharp-expand|
  fl::|defun| fl::|defv| fl::|defvar| fl::|delete|  fl::|delq| fl::|deref|
  fl::|desetq| fl::|df| fl::|diff| fl::|difference| fl::|dm| fl::|do|
  fl::|double-to-float| fl::|drain| fl::|drm| fl::|dsm| fl::|dsubst| fl::|dtpr|
  fl::|dumplisp|  fl::|english-print| fl::|english-print-thousand| fl::|environment|
  fl::|environment-files|  fl::|environment-lmlisp| fl::|environment-maclisp|
  fl::|environment-syntax| fl::|eq|  fl::|eq-tyimode| fl::|eqstr| fl::|equal|
  fl::|err| fl::|err-with-message| fl::|error|  fl::|errset| fl::|ev-arraycall|
  fl::|eval| fl::|eval-when| fl::|eval1| fl::|evalframe|  fl::|evalhook| fl::|evenp|
  fl::|every| fl::|ex| fl::|exec| fl::|exece| fl::|exit| fl::|exl|  fl::|exp|
  fl::|explode| fl::|explodec| fl::|exploden| fl::|expt| fl::|exvi|
  fl::|f:format-handler| fl::|fact| fl::|fake| fl::|fasl| fl::|fasl-a-file|
  fl::|fclosure|  fl::|fclosure-alist| fl::|fclosure-function| fl::|fclosure-list|
  fl::|fclosurep|  fl::|feature-present| fl::|ferror| fl::|ffasl| fl::|fileopen|
  fl::|filepos| fl::|filestat|  fl::|filestat:atime| fl::|filestat:ctime|
  fl::|filestat:dev| fl::|filestat:gid|  fl::|filestat:ino| fl::|filestat:mode|
  fl::|filestat:mtime| fl::|filestat:nlink|  fl::|filestat:rdev| fl::|filestat:size|
  fl::|filestat:type| fl::|filestat:uid|  fl::|fillarray| fl::|fillarrayarray|
  fl::|fix| fl::|fixp| fl::|flatc| fl::|flatsize|  fl::|float| fl::|float-to-double|
  fl::|floatp| fl::|for| fl::|fork| fl::|format|  fl::|format-binpr|
  fl::|format-binpr1| fl::|format-ctl-ascii| fl::|format-ctl-justify|
  fl::|format-ctl-list| fl::|format-ctl-octal| fl::|format-ctl-op|
  fl::|format-ctl-repeat-char|  fl::|format-ctl-string| fl::|format-prc|
  fl::|format-test| fl::|format:anyradix-printer|  fl::|format:fresh-line|
  fl::|format:nsubstring| fl::|format:patom| fl::|format:print|
  fl::|format:printorpatom| fl::|format:string-search-char| fl::|format:terpr|
  fl::|format:tyo|  fl::|framedump| fl::|franz-reset| fl::|franz-top-level|
  fl::|freturn| fl::|frexp| fl::|fseek|  fl::|funcall| fl::|funcallhook|
  fl::|function| fl::|g00249::car| fl::|g00255::caar|  fl::|g00261::cadr|
  fl::|g00267::cdr| fl::|g00273::cdar| fl::|g00279::cddr| fl::|g00285::cxr|
  fl::|g00291::vref| fl::|g00297::vrefi-byte| fl::|g00303::vrefi-word|
  fl::|g00309::vrefi-long|  fl::|g00315::nth| fl::|g00321::nthelem|
  fl::|g00327::nthcdr| fl::|g00333::arraycall|  fl::|g00339::get| fl::|g00345::plist|
  fl::|g00351::symeval| fl::|g00357::arg|  fl::|g00363::args| fl::|g:format-handler|
  fl::|gc| fl::|gcafter| fl::|gensym| fl::|get|  fl::|get_pname| fl::|getaccess|
  fl::|getaddress| fl::|getaux| fl::|getchar| fl::|getcharn|  fl::|getd| fl::|getdata|
  fl::|getdelta| fl::|getdisc| fl::|getentry| fl::|getenv| fl::|getl|  fl::|getlength|
  fl::|getsyntax| fl::|go| fl::|greaterp| fl::|haipart| fl::|hashtabstat|
  fl::|haulong| fl::|help| fl::|hunk| fl::|hunk-to-list| fl::|hunkp| fl::|hunksize|
  fl::|if|  fl::|implode| fl::|in-tyimode| fl::|include| fl::|include-file|
  fl::|include-if|  fl::|includef| fl::|includef-if| fl::|incr| fl::|infile|
  fl::|initsym| fl::|initsym1|  fl::|insert| fl::|int:cfasl| fl::|int:fasl|
  fl::|int:fclosure-stack-stuff| fl::|int:fileopen|  fl::|int:franz-call|
  fl::|int:getsyntax| fl::|int:infile| fl::|int:memreport|  fl::|int:outfile|
  fl::|int:setsyntax| fl::|int:showstack| fl::|int:tyimode|
  fl::|int:vector-range-error| fl::|int:vref| fl::|int:vset| fl::|int:vsize|
  fl::|int:wrong-number-of-args-error| fl::|intern| fl::|killcopy| fl::|kwote|
  fl::|lambdacvt|  fl::|last| fl::|lconc| fl::|ldiff| fl::|length| fl::|lessp|
  fl::|let| fl::|let*|  fl::|lexpr-funcall| fl::|linelength| fl::|lineread| fl::|list|
  fl::|list*|  fl::|list-to-bignum| fl::|listarray| fl::|listify| fl::|listp|
  fl::|liszt-declare|  fl::|liszt-define| fl::|litatom| fl::|load|
  fl::|load-autorunobject| fl::|load-file|  fl::|load-if-needed| fl::|log| fl::|loop|
  fl::|lsh| fl::|lsubst| fl::|macroexpand|  fl::|make-equivalent|
  fl::|make-fclosure-with-alist| fl::|make-list-array|  fl::|makereadtable|
  fl::|makhunk| fl::|maknam| fl::|maknum| fl::|makunbound| fl::|map|  fl::|mapc|
  fl::|mapcan| fl::|mapcar| fl::|mapcon| fl::|maplist| fl::|marray| fl::|max|
  fl::|member| fl::|memq| fl::|merge| fl::|merge1| fl::|mergelists| fl::|mfunction|
  fl::|min|  fl::|minus| fl::|minusp| fl::|mod| fl::|monitor| fl::|msg|
  fl::|msg-print| fl::|msg-tyo-char|  fl::|nconc| fl::|nconc1| fl::|ncons| fl::|neq|
  fl::|nequal| fl::|new-sharp-sign-macro|  fl::|new-vector| fl::|new-vectori-byte|
  fl::|new-vectori-long| fl::|new-vectori-word|  fl::|newsym| fl::|not| fl::|nreconc|
  fl::|nreverse| fl::|nth| fl::|nthcdr| fl::|nthchar|  fl::|nthelem| fl::|null|
  fl::|numberp| fl::|numbp| fl::|nwritn| fl::|o:format-handler|  fl::|oblist|
  fl::|oddp| fl::|old-baktrace| fl::|old-reset-function| fl::|old-showstack|
  fl::|oldsym| fl::|onep| fl::|opval| fl::|or| fl::|outfile| fl::|p:format-handler|
  fl::|patom|  fl::|plist| fl::|plus| fl::|plusp| fl::|pntlen| fl::|pop| fl::|portp|
  fl::|pp| fl::|pp-form|  fl::|pp-function| fl::|pp-prop| fl::|pp-value| fl::|princ|
  fl::|print| fl::|print-lambda|  fl::|printaccross| fl::|printblanks| fl::|printdef|
  fl::|printmacrochar| fl::|printprog|  fl::|printret| fl::|probef| fl::|process|
  fl::|product| fl::|prog| fl::|prog1| fl::|prog2|  fl::|progn| fl::|progv|
  fl::|prtpagesused| fl::|ptime| fl::|ptr| fl::|purcopy| fl::|purep|  fl::|push|
  fl::|putaccess| fl::|putaux| fl::|putd| fl::|putdata| fl::|putdelta| fl::|putdisc|
  fl::|putlength| fl::|putprop| fl::|pv%| fl::|q:format-handler| fl::|qu*| fl::|quote|
  fl::|quote!| fl::|quote!-expr-mac| fl::|quotient| fl::|quotify| fl::|quotify1|
  fl::|r:format-handler| fl::|random| fl::|rassq| fl::|ratom| fl::|read|
  fl::|read-in-lisprc-file| fl::|readc| fl::|readlist| fl::|remainder| fl::|rematom|
  fl::|remob| fl::|remove| fl::|removeaddress| fl::|remprop| fl::|remq| fl::|remsym|
  fl::|remsym1| fl::|replace| fl::|reset| fl::|resetio| fl::|return| fl::|reverse|
  fl::|roman-char| fl::|roman-step| fl::|rot| fl::|rplaca| fl::|rplacd| fl::|rplacx|
  fl::|s:format-handler| fl::|sassoc| fl::|sassq| fl::|scons| fl::|segment|
  fl::|selectq|  fl::|set| fl::|set-in-fclosure| fl::|setarg| fl::|setf|
  fl::|setf-check-cad+r| fl::|setplist|  fl::|setq| fl::|setsyntax| fl::|shell|
  fl::|showstack| fl::|showstack-baktrace| fl::|signal|  fl::|signp| fl::|sin|
  fl::|sizeof| fl::|sl-print| fl::|sload| fl::|small-segment| fl::|some|  fl::|sort|
  fl::|sortcar| fl::|sortcarhelp| fl::|sortmerge| fl::|splitlist| fl::|sprintf|
  fl::|sqrt| fl::|sstatus| fl::|status| fl::|sticky-bignum-leftshift| fl::|store|
  fl::|storeintern| fl::|stringp| fl::|strip-extension| fl::|sub1| fl::|sublis|
  fl::|sublishelp| fl::|subpair| fl::|subpr| fl::|subst| fl::|subst-eq|
  fl::|subst-eqp|  fl::|substeq| fl::|substequal| fl::|substring| fl::|substringn|
  fl::|sum| fl::|symbolp|  fl::|symeval| fl::|symeval-in-fclosure| fl::|symstat|
  fl::|sys:access| fl::|sys:chmod|  fl::|sys:fpeint-serv| fl::|sys:gethostname|
  fl::|sys:getpid| fl::|sys:getpwnam|  fl::|sys:getpwnam-dir| fl::|sys:int-serv|
  fl::|sys:link| fl::|sys:time| fl::|sys:unlink|  fl::|syscall| fl::|tab| fl::|tailp|
  fl::|tconc| fl::|termcapexe| fl::|termcapinit|  fl::|terpr| fl::|terpri| fl::|throw|
  fl::|tilde-expand| fl::|time-string| fl::|times|  fl::|top-eval| fl::|top-init|
  fl::|top-level| fl::|top-print| fl::|top-prompt| fl::|top-read|  fl::|trace-funp|
  fl::|truename| fl::|tyi| fl::|tyimode| fl::|tyipeek| fl::|tyo| fl::|type|
  fl::|typep| fl::|uconcat| fl::|uncompile| fl::|undef-func-handler| fl::|unpush|
  fl::|untyi|  fl::|unwind-protect| fl::|username-to-dir|
  fl::|username-to-dir-flush-cache| fl::|valuep|  fl::|vector| fl::|vector-dump|
  fl::|vectori-byte| fl::|vectori-long| fl::|vectori-word|  fl::|vectorip|
  fl::|vectorp| fl::|vget| fl::|vi| fl::|vil| fl::|vprop| fl::|vputprop|  fl::|vref|
  fl::|vrefi-byte| fl::|vrefi-long| fl::|vrefi-word| fl::|vset| fl::|vseti-byte|
  fl::|vseti-long| fl::|vseti-word| fl::|vsetprop| fl::|vsize| fl::|vsize-byte|
  fl::|vsize-word| fl::|wait| fl::|without-path| fl::|x:format-handler| fl::|xcons|
  fl::|zapline| fl::|zerop| fl::|{:format-handler| fl::|\|:format-handler|
  fl::|}:format-handler| fl::|~:format-handler|)

;;; all FranzLisp lambdas

'(fl::|$patom1| fl::|$prd1| fl::|$prdf| fl::|$prpr| fl::|%:format-handler|
  fl::|&:format-handler| fl::* fl::*$ fl::|*:format-handler| fl::|*array| fl::|*break|
  fl::|*dif| fl::|*invmod| fl::|*makhunk| fl::|*mod| fl::|*process|
  fl::|*process-receive|  fl::|*process-send| fl::|*quo| fl::|*rplacx| fl::|*rset|
  fl::|*throw| fl::+ fl::+$ fl::-  fl::-$ fl::/ fl::/$ fl::1+ fl::1+$ fl::1- fl::1-$
  fl::|;:format-handler| fl::< fl::<& fl::=  fl::=& fl::> fl::>& fl::|?th| fl::|Cnth|
  fl::|Divide| fl::|Emuldiv| fl::|I-throw-err|  fl::|Sharpm'g00150|
  fl::|Sharpm'g00160| fl::|Sharpm+g00125| fl::|Sharpm+g00139|  fl::|Sharpm,g00155|
  fl::|Sharpm,g00164| fl::|Sharpm-g00132| fl::|Sharpm-g00145|  fl::|Sharpm/g00139|
  fl::|Sharpm/g00151| fl::|SharpmMg00176| fl::|SharpmMg00182|  fl::|Sharpm\\g00160|
  fl::|Sharpm\\g00168| fl::|Sharpm^g00144| fl::|Sharpm^g00155|  fl::|Sharpmog00097|
  fl::|Sharpmog00113| fl::|Sharpmtg00171| fl::|Sharpmtg00178|  fl::|Sharpmxg00102|
  fl::|Sharpmxg00117| fl::|[:format-handler| fl::\\ fl::|]:format-handler|  fl::^
  fl::|^:format-handler| fl::|a:format-handler| fl::|abs| fl::|absval| fl::|acos|
  fl::|add| fl::|add-syntax-class| fl::|add1| fl::|aexplode| fl::|aexplodec|
  fl::|aexploden|  fl::|allocate| fl::|allsym| fl::|alphalessp| fl::|any-zerop|
  fl::|append| fl::|append1|  fl::|apply| fl::|apply*| fl::|arg| fl::|argv|
  fl::|arrac-nD| fl::|arrac-oneD|  fl::|arrac-twoD| fl::|array-type| fl::|arraydims|
  fl::|arrayp| fl::|arrayref| fl::|ascii|  fl::|asin| fl::|assoc| fl::|assq|
  fl::|atan| fl::|atom| fl::|attach|  fl::|back-quote-ch-macro|
  fl::|back-quote-comma-macro| fl::|back=quotify| fl::|baktraceprint|  fl::|bcdad|
  fl::|bcdcall| fl::|bcdp| fl::|bignum-leftshift| fl::|bignum-to-list| fl::|bigp|
  fl::|boole| fl::|boundp| fl::|bq-print-macro| fl::|break-err-handler|
  fl::|c:format-handler|  fl::|caar| fl::|caddddr| fl::|cadddr| fl::|caddr| fl::|cadr|
  fl::|car| fl::|case-scan|  fl::|cdar| fl::|cddddddr| fl::|cdddddr| fl::|cddddr|
  fl::|cdddr| fl::|cddr| fl::|cdr|  fl::|cfasl| fl::|ch10:format-handler|
  fl::|charcnt| fl::|charsinbuf| fl::|chdir| fl::|close|  fl::|command-line-args|
  fl::|compile| fl::|concat| fl::|concatl| fl::|condclosefile|  fl::|cons|
  fl::|construct-list*| fl::|copy| fl::|copyint*| fl::|copysymbol| fl::|cos|
  fl::|cprintf| fl::|cputim| fl::|cpy1| fl::|cr| fl::|cvttofranzlisp|
  fl::|cvttointlisp|  fl::|cvttomaclisp| fl::|cvttoucilisp| fl::|cxr|
  fl::|d:format-handler| fl::|de-compose|  fl::|debug-err-handler| fl::|debugging|
  fl::|defmcrooption| fl::|defmcrosrch|  fl::|defsharp-expand| fl::|delete| fl::|delq|
  fl::|deref| fl::|diff| fl::|difference|  fl::|double-to-float| fl::|drain|
  fl::|dsubst| fl::|dtpr| fl::|english-print|  fl::|english-print-thousand| fl::|eq|
  fl::|eq-tyimode| fl::|eqstr| fl::|equal| fl::|err|  fl::|err-with-message|
  fl::|error| fl::|ev-arraycall| fl::|eval| fl::|eval1| fl::|evalframe|
  fl::|evalhook| fl::|evenp| fl::|exece| fl::|exit| fl::|exp| fl::|explode|
  fl::|explodec|  fl::|exploden| fl::|expt| fl::|exvi| fl::|f:format-handler|
  fl::|fact| fl::|fake| fl::|fasl|  fl::|fasl-a-file| fl::|fclosure|
  fl::|fclosure-alist| fl::|fclosure-function|  fl::|fclosure-list| fl::|fclosurep|
  fl::|feature-present| fl::|ferror| fl::|ffasl|  fl::|fileopen| fl::|filepos|
  fl::|filestat| fl::|filestat:atime| fl::|filestat:ctime|  fl::|filestat:dev|
  fl::|filestat:gid| fl::|filestat:ino| fl::|filestat:mode|  fl::|filestat:mtime|
  fl::|filestat:nlink| fl::|filestat:rdev| fl::|filestat:size|  fl::|filestat:type|
  fl::|filestat:uid| fl::|fillarray| fl::|fillarrayarray| fl::|fix|  fl::|fixp|
  fl::|flatc| fl::|flatsize| fl::|float| fl::|float-to-double| fl::|floatp|
  fl::|fork| fl::|format| fl::|format-binpr| fl::|format-binpr1|
  fl::|format-ctl-ascii|  fl::|format-ctl-justify| fl::|format-ctl-list|
  fl::|format-ctl-octal| fl::|format-ctl-op|  fl::|format-ctl-repeat-char|
  fl::|format-ctl-string| fl::|format-prc| fl::|format-test|
  fl::|format:anyradix-printer| fl::|format:fresh-line| fl::|format:nsubstring|
  fl::|format:patom| fl::|format:print| fl::|format:printorpatom|
  fl::|format:string-search-char| fl::|format:terpr| fl::|format:tyo| fl::|framedump|
  fl::|franz-reset| fl::|franz-top-level| fl::|freturn| fl::|frexp| fl::|fseek|
  fl::|funcall|  fl::|funcallhook| fl::|g00249::car| fl::|g00255::caar|
  fl::|g00261::cadr| fl::|g00267::cdr|  fl::|g00273::cdar| fl::|g00279::cddr|
  fl::|g00285::cxr| fl::|g00291::vref|  fl::|g00297::vrefi-byte|
  fl::|g00303::vrefi-word| fl::|g00309::vrefi-long| fl::|g00315::nth|
  fl::|g00321::nthelem| fl::|g00327::nthcdr| fl::|g00333::arraycall| fl::|g00339::get|
  fl::|g00345::plist| fl::|g00351::symeval| fl::|g00357::arg| fl::|g00363::args|
  fl::|g:format-handler| fl::|gensym| fl::|get| fl::|get_pname| fl::|getaccess|
  fl::|getaddress| fl::|getaux| fl::|getchar| fl::|getcharn| fl::|getd| fl::|getdata|
  fl::|getdelta| fl::|getdisc| fl::|getentry| fl::|getenv| fl::|getl| fl::|getlength|
  fl::|getsyntax| fl::|greaterp| fl::|haipart| fl::|hashtabstat| fl::|haulong|
  fl::|hunk|  fl::|hunk-to-list| fl::|hunkp| fl::|hunksize| fl::|implode|
  fl::|includef| fl::|infile|  fl::|initsym| fl::|initsym1| fl::|insert|
  fl::|int:cfasl| fl::|int:fasl|  fl::|int:fclosure-stack-stuff| fl::|int:fileopen|
  fl::|int:franz-call| fl::|int:getsyntax|  fl::|int:infile| fl::|int:memreport|
  fl::|int:outfile| fl::|int:setsyntax|  fl::|int:showstack|
  fl::|int:vector-range-error| fl::|int:vref| fl::|int:vset|  fl::|int:vsize|
  fl::|int:wrong-number-of-args-error| fl::|intern| fl::|killcopy| fl::|kwote|
  fl::|lambdacvt| fl::|last| fl::|lconc| fl::|ldiff| fl::|length| fl::|lessp|
  fl::|lexpr-funcall| fl::|lineread| fl::|list| fl::|list-to-bignum| fl::|listarray|
  fl::|listp| fl::|load| fl::|load-autorunobject| fl::|load-file| fl::|load-if-needed|
  fl::|log| fl::|lsh| fl::|lsubst| fl::|macroexpand| fl::|make-fclosure-with-alist|
  fl::|make-list-array| fl::|makereadtable| fl::|makhunk| fl::|maknam| fl::|maknum|
  fl::|makunbound| fl::|map| fl::|mapc| fl::|mapcan| fl::|mapcar| fl::|mapcon|
  fl::|maplist|  fl::|marray| fl::|max| fl::|member| fl::|memq| fl::|merge|
  fl::|merge1| fl::|mergelists|  fl::|mfunction| fl::|min| fl::|minus| fl::|minusp|
  fl::|mod| fl::|monitor| fl::|msg-print|  fl::|msg-tyo-char| fl::|nconc| fl::|ncons|
  fl::|nequal| fl::|new-sharp-sign-macro|  fl::|new-vector| fl::|new-vectori-byte|
  fl::|new-vectori-long| fl::|new-vectori-word|  fl::|newsym| fl::|not| fl::|nreconc|
  fl::|nreverse| fl::|nth| fl::|nthcdr| fl::|nthchar|  fl::|nthelem| fl::|null|
  fl::|numberp| fl::|numbp| fl::|nwritn| fl::|o:format-handler|  fl::|oblist|
  fl::|oddp| fl::|old-baktrace| fl::|old-showstack| fl::|oldsym| fl::|onep|
  fl::|opval| fl::|outfile| fl::|p:format-handler| fl::|patom| fl::|plist| fl::|plus|
  fl::|plusp| fl::|pntlen| fl::|portp| fl::|pp-form| fl::|pp-function| fl::|pp-prop|
  fl::|pp-value| fl::|princ| fl::|print| fl::|print-lambda| fl::|printaccross|
  fl::|printblanks| fl::|printdef| fl::|printmacrochar| fl::|printprog| fl::|probef|
  fl::|product| fl::|prog1| fl::|prtpagesused| fl::|ptime| fl::|ptr| fl::|purcopy|
  fl::|purep|  fl::|putaccess| fl::|putaux| fl::|putd| fl::|putdata| fl::|putdelta|
  fl::|putdisc|  fl::|putlength| fl::|putprop| fl::|pv%| fl::|q:format-handler|
  fl::|quote!-expr-mac|  fl::|quotient| fl::|quotify| fl::|quotify1|
  fl::|r:format-handler| fl::|random| fl::|rassq|  fl::|ratom| fl::|read|
  fl::|read-in-lisprc-file| fl::|readc| fl::|readlist| fl::|remainder|  fl::|rematom|
  fl::|remob| fl::|remove| fl::|removeaddress| fl::|remprop| fl::|remq|  fl::|remsym|
  fl::|remsym1| fl::|replace| fl::|reset| fl::|return| fl::|reverse|  fl::|roman-char|
  fl::|roman-step| fl::|rot| fl::|rplaca| fl::|rplacd| fl::|rplacx|
  fl::|s:format-handler| fl::|scons| fl::|segment| fl::|set| fl::|set-in-fclosure|
  fl::|setarg|  fl::|setf-check-cad+r| fl::|setplist| fl::|setsyntax| fl::|shell|
  fl::|showstack-baktrace|  fl::|signal| fl::|sin| fl::|sizeof| fl::|sload|
  fl::|small-segment| fl::|some| fl::|sort|  fl::|sortcar| fl::|sortcarhelp|
  fl::|sortmerge| fl::|splitlist| fl::|sprintf| fl::|sqrt|
  fl::|sticky-bignum-leftshift| fl::|storeintern| fl::|stringp| fl::|strip-extension|
  fl::|sub1| fl::|sublis| fl::|sublishelp| fl::|subpair| fl::|subpr| fl::|subst|
  fl::|subst-eq|  fl::|subst-eqp| fl::|substeq| fl::|substequal| fl::|substring|
  fl::|substringn| fl::|sum|  fl::|symbolp| fl::|symeval| fl::|symeval-in-fclosure|
  fl::|symstat| fl::|sys:access|  fl::|sys:chmod| fl::|sys:fpeint-serv|
  fl::|sys:gethostname| fl::|sys:getpid|  fl::|sys:getpwnam| fl::|sys:getpwnam-dir|
  fl::|sys:int-serv| fl::|sys:link| fl::|sys:time|  fl::|sys:unlink| fl::|syscall|
  fl::|tab| fl::|tailp| fl::|tconc| fl::|termcapexe|  fl::|termcapinit| fl::|terpr|
  fl::|terpri| fl::|tilde-expand| fl::|time-string| fl::|times|  fl::|top-level|
  fl::|trace-funp| fl::|truename| fl::|tyi| fl::|tyimode| fl::|tyipeek|  fl::|tyo|
  fl::|type| fl::|typep| fl::|uconcat| fl::|uncompile| fl::|undef-func-handler|
  fl::|untyi| fl::|username-to-dir| fl::|username-to-dir-flush-cache| fl::|valuep|
  fl::|vector|  fl::|vector-dump| fl::|vectori-byte| fl::|vectori-long|
  fl::|vectori-word| fl::|vectorip|  fl::|vectorp| fl::|vget| fl::|vprop|
  fl::|vputprop| fl::|vref| fl::|vrefi-byte|  fl::|vrefi-long| fl::|vrefi-word|
  fl::|vset| fl::|vseti-byte| fl::|vseti-long|  fl::|vseti-word| fl::|vsetprop|
  fl::|vsize| fl::|vsize-byte| fl::|vsize-word| fl::|wait|  fl::|without-path|
  fl::|x:format-handler| fl::|xcons| fl::|zapline| fl::|zerop|
  fl::|{:format-handler| fl::|\|:format-handler| fl::|}:format-handler|
  fl::|~:format-handler|)

;;; all FranzLisp nlambdas

'(fl::|*catch| fl::|and| fl::|baktrace| fl::|comment| fl::|cond| fl::|debug|
  fl::|declare|  fl::|def| fl::|defprop| fl::|defv| fl::|do| fl::|dumplisp|
  fl::|environment-files|  fl::|environment-syntax| fl::|errset| fl::|eval-when|
  fl::|ex| fl::|exec| fl::|exl|  fl::|function| fl::|gc| fl::|gcafter| fl::|go|
  fl::|help| fl::|include| fl::|linelength|  fl::|liszt-declare|
  fl::|old-reset-function| fl::|or| fl::|pp| fl::|process| fl::|prog|  fl::|prog2|
  fl::|progn| fl::|progv| fl::|quote| fl::|resetio| fl::|setq| fl::|showstack|
  fl::|sstatus| fl::|status| fl::|vi| fl::|vil|)

;;; all FranzLisp macros

'(fl::|:=| fl::<= fl::<=& fl::>= fl::>=& fl::|If| fl::|array| fl::|arraycall|
  fl::|break|  fl::|caseq| fl::|catch| fl::|de| fl::|decr| fl::|defcmacro|
  fl::|defformat| fl::|defmacro|  fl::|defsetf| fl::|defsharp| fl::|defun|
  fl::|defvar| fl::|desetq| fl::|df| fl::|dm|  fl::|drm| fl::|dsm| fl::|environment|
  fl::|environment-lmlisp| fl::|environment-maclisp|  fl::|every| fl::|for| fl::|if|
  fl::|in-tyimode| fl::|include-file| fl::|include-if|  fl::|includef-if| fl::|incr|
  fl::|let| fl::|let*| fl::|list*| fl::|listify|  fl::|liszt-define| fl::|litatom|
  fl::|loop| fl::|make-equivalent| fl::|msg| fl::|nconc1|  fl::|neq| fl::|pop|
  fl::|printret| fl::|push| fl::|qu*| fl::|quote!| fl::|sassoc| fl::|sassq|
  fl::|selectq| fl::|setf| fl::|signp| fl::|sl-print| fl::|store| fl::|throw|
  fl::|top-eval|  fl::|top-init| fl::|top-print| fl::|top-prompt| fl::|top-read|
  fl::|unpush|
  fl::|unwind-protect|)

;;; all FranzLisp foreigns (c-functions)

'(fl::|cib| fl::|int:tyimode|)
||#

;;;------------------------------------------------------------------------------------------
;;; Uebertragung von einfachen Funktion
;;;------------------------------------------------------------------------------------------

(defruleset mylambda1 (expr)
  :special *assumed-user-defined-collision*)

(defruleset mylambda2 (expr)
    :special *assumed-user-defined-collision*)

(defrule same-functions (MyLambda1 MyLambda2) 2
   ?foo:{fl::* fl::+ fl::1+ fl::1- fl::< fl::<= fl::= fl::> fl::>= fl::|abs|
         fl::|and| fl::|append| fl::|apply|  fl::|atan| fl::|atom|
	 fl::|boundp| fl::|caaaar| fl::|caaadr| fl::|caaar|
         fl::|caadar| fl::|caaddr| fl::|caadr| fl::|caar| fl::|cadaar| fl::|cadadr|
         fl::|cadar| fl::|caddar| fl::|cadddr| fl::|caddr| fl::|cadr| fl::|car| fl::|cdaaar|
         fl::|cdaar| fl::|cdadar| fl::|cdaddr| fl::|cdadr| fl::|cdar| fl::|cddaar|
         fl::|cddadr| fl::|cddar| fl::|cdddar| fl::|cddddr| fl::|cdddr| fl::|cddr| fl::|cdr|
         fl::|close| fl::|cond| fl::|cons| fl::|defun| fl::|defmacro| fl::|do| fl::|eq|
	 fl::|equal| fl::|eval| fl::|eval-when| fl::|evenp|
	 fl::|exp| fl::|expt| fl::|float| fl::|floatp| fl::|format| fl::|funcall|
         fl::|function| fl::|get| fl::|go| fl::|if| fl::|intern| fl::|last| fl::|length|
         fl::|let| fl::|let*| fl::|list| fl::|list*| fl::|listp| fl::|load| fl::|macroexpand|
         fl::|makunbound| fl::|mapc| fl::|mapcan| fl::|mapcar| fl::|mapcon| fl::|maplist|
         fl::|max| fl::|min| fl::|minusp| fl::|nconc| fl::|not| fl::|nreconc| fl::|nreverse|
         fl::|nthcdr|
         fl::|null| fl::|numberp| fl::|oddp| fl::|or| fl::|plusp| fl::|pop| fl::|princ|
	 fl::|print| fl::|prog|
         fl::|prog1| fl::|prog2| fl::|progn| fl::|push| fl::|quote|
	 fl::|remprop| fl::|return|
	 fl::|reverse| fl::|rplaca|
         fl::|rplacd| fl::|set| fl::|setf| fl::|setq| fl::|sort| fl::|sqrt| fl::|stringp|
	 fl::|symbolp| fl::|terpri| fl::|unwind-protect| fl::|zerop|}
   ==>
   ?,(transform-franz-symbol ?foo)
   (Franz-to-Common)
   (NoProtocol)
 ((modified-by "Matthias Ressel")(modified "16.12.1987, 23:34")
  (author "Matthias Ressel") (created "09.09.1987, 13:04")))

(defrule fl-<&-lessp (MyLambda1 MyLambda2) 1
   ?foo:{fl::|<&| fl::|lessp|}
   ==>
   <
   (Franz-to-Common)
   (Protocol)
 ((modified-by "Andreas Girgensohn")(modified "21.10.1987, 16:21")
  (author "Matthias Ressel") (created "09.09.1987, 13:10")))

(defrule fl-<=& (MyLambda1 MyLambda2) 1
   fl::|<=&|
   ==>
   <=
   (Franz-to-Common)
   (Protocol)
 ((modified-by "Andreas Girgensohn")(modified "21.10.1987, 16:21")
  (author "Matthias Ressel") (created "09.09.1987, 13:10")))

(defrule fl->&-greaterp (MyLambda1 MyLambda2) 1
   ?foo:{fl::|>&| fl::|greaterp|}
   ==>
   >
   (Franz-to-Common)
   (Protocol)
 ((modified-by "Andreas Girgensohn")(modified "21.10.1987, 16:21")
  (author "Matthias Ressel") (created "09.09.1987, 13:10")))

(defrule fl->=& (MyLambda1 MyLambda2) 1
   fl::|>=&|
   ==>
   >=
   (Franz-to-Common)
   (Protocol)
 ((modified-by "Andreas Girgensohn")(modified "21.10.1987, 16:21")
  (author "Matthias Ressel") (created "09.09.1987, 13:10")))

(defrule add (MyLambda1 MyLambda2) 1
   ??:{fl::|add| fl::|plus| fl::|sum|}
   ==>
   +
   (Franz-to-Common)
   (Protocol)
 ((author "Andreas Girgensohn") (created "21.10.1987, 17:06")))

(defrule diff (MyLambda1 MyLambda2) 1
   ??:{fl::|diff| fl::|difference| fl::|minus|}	; minus with 1 arg
   ==>
   -
   (Franz-to-Common)
   (Protocol)
 ((modified-by "Matthias Ressel")(modified "16.12.1987, 23:35")
  (author "Andreas Girgensohn") (created "21.10.1987, 17:06")))

(defrule  add1 (MyLambda1 MyLambda2) 1
	fl::|add1|
	==>
	1+
	(Franz-to-Common)
	(Protocol)
((modified-by "Andreas Girgensohn")(modified "22.10.1987, 15:08")
 (author "Andreas Girgensohn") (created "Tue Jan 20 18:06:16 1987")))

(defrule  sub1 (MyLambda1 MyLambda2) 1
	fl::|sub1|
	==>
	1-
	(Franz-to-Common)
	(Protocol)
((modified-by "Andreas Girgensohn")(modified "22.10.1987, 15:08")
 (author "Andreas Girgensohn") (created "Tue Jan 20 18:06:38 1987")))

(defrule  product (MyLambda1 MyLambda2) 1
	??:{fl::|product| fl::|times|}
	==>
	*
	(Franz-to-Common)
	(Protocol)
((modified-by "Andreas Girgensohn")(modified "22.10.1987, 15:11")
 (author "Andreas Girgensohn") (created "Tue Jan 20 17:56:05 1987")))

(defrule  quotient.1 (MyLambda1 MyLambda2) 1
	fl::|quotient|
	==>
	/
	(protocol-format "%Warning: With integer args use truncate (with reduce)")
	(Franz-to-Common)
	(Protocol)
((modified-by "Andreas Girgensohn")(modified "22.10.1987, 15:11")
 (author "Andreas Girgensohn") (created "Tue Jan 20 17:56:36 1987")))

(defrule *quo (MyLambda1 MyLambda2) 1
   ??:{fl::|*quo| fl::/}
   ==>
   truncate
   (Franz-to-Common)
   (Protocol)
 ((author "Andreas Girgensohn") (created "22.10.1987, 14:01")))

(defrule  mod (MyLambda1 MyLambda2) 1
	??:{fl::|mod| fl::|remainder|}
	==>
	rem
	(Franz-to-Common)
	(Protocol)
((modified-by "Andreas Girgensohn")(modified "22.10.1987, 15:13")
 (author "Andreas Girgensohn") (created "Thu Jan 22 12:44:43 1987")))

;CCC die folgende Regel nimmt alphalessp.1 die Kandidaten weg:

(defrule fl-alphalessp MyLambda1 1
   fl::|alphalessp|
   ==>
   (lambda (x y)
     (string< (string x) (string y)))
   (Franz-to-Common)
   (Protocol)
 ((modified-by "Andreas Girgensohn")(modified "20.10.1987, 16:03")
  (author "Matthias Ressel") (created "09.09.1987, 13:10")))

;;; these are ALL FranzLisp functions

(defrule not-transformed-franz-function (MyLambda1 MyLambda2) -50
   ??:{fl::|$patom1| fl::|$prd1| fl::|$prdf| fl::|$prpr| fl::|%:format-handler|
       fl::|&:format-handler| fl::* fl::*$ fl::|*:format-handler| fl::|*array| fl::|*break|
       fl::|*catch| fl::|*dif| fl::|*invmod| fl::|*makhunk| fl::|*mod| fl::|*process|
       fl::|*process-receive| fl::|*process-send| fl::|*quo| fl::|*rplacx| fl::|*rset|
       fl::|*throw| fl::+ fl::+$ fl::- fl::-$ fl::/ fl::/$ fl::1+ fl::1+$ fl::1- fl::1-$
       fl::|:=| fl::|;:format-handler| fl::< fl::<& fl::<= fl::<=& fl::= fl::=& fl::> fl::>&
       fl::>= fl::>=& fl::|?th| fl::|Cnth| fl::|Divide| fl::|Emuldiv| fl::|I-throw-err|
       fl::|If| fl::|Sharpm'g00150| fl::|Sharpm'g00160| fl::|Sharpm+g00125|
       fl::|Sharpm+g00139| fl::|Sharpm,g00155| fl::|Sharpm,g00164| fl::|Sharpm-g00132|
       fl::|Sharpm-g00145| fl::|Sharpm/g00139| fl::|Sharpm/g00151| fl::|SharpmMg00176|
       fl::|SharpmMg00182| fl::|Sharpm\\g00160| fl::|Sharpm\\g00168| fl::|Sharpm^g00144|
       fl::|Sharpm^g00155| fl::|Sharpmog00097| fl::|Sharpmog00113| fl::|Sharpmtg00171|
       fl::|Sharpmtg00178| fl::|Sharpmxg00102| fl::|Sharpmxg00117| fl::|[:format-handler|
       fl::\\ fl::|]:format-handler| fl::^ fl::|^:format-handler| fl::|a:format-handler|
       fl::|abs| fl::|absval| fl::|acos| fl::|add| fl::|add-syntax-class| fl::|add1|
       fl::|aexplode| fl::|aexplodec| fl::|aexploden| fl::|allocate| fl::|allsym|
       fl::|alphalessp| fl::|and| fl::|any-zerop| fl::|append| fl::|append1| fl::|apply|
       fl::|apply*| fl::|arg| fl::|argv| fl::|arrac-nD| fl::|arrac-oneD| fl::|arrac-twoD|
       fl::|array| fl::|array-type| fl::|arraycall| fl::|arraydims| fl::|arrayp|
       fl::|arrayref| fl::|ascii| fl::|asin| fl::|assoc| fl::|assq| fl::|atan| fl::|atom|
       fl::|attach| fl::|back-quote-ch-macro| fl::|back-quote-comma-macro| fl::|back=quotify|
       fl::|baktrace| fl::|baktraceprint| fl::|bcdad| fl::|bcdcall| fl::|bcdp|
       fl::|bignum-leftshift| fl::|bignum-to-list| fl::|bigp| fl::|boole| fl::|boundp|
       fl::|bq-print-macro| fl::|break| fl::|break-err-handler| fl::|c:format-handler|
       fl::|caar| fl::|caddddr| fl::|cadddr| fl::|caddr| fl::|cadr| fl::|car| fl::|case-scan|
       fl::|caseq| fl::|catch| fl::|cdar| fl::|cddddddr| fl::|cdddddr| fl::|cddddr|
       fl::|cdddr| fl::|cddr| fl::|cdr| fl::|cfasl| fl::|ch10:format-handler| fl::|charcnt|
       fl::|charsinbuf| fl::|chdir| fl::|cib| fl::|close| fl::|command-line-args|
       fl::|comment| fl::|compile| fl::|concat| fl::|concatl| fl::|cond| fl::|condclosefile|
       fl::|cons| fl::|construct-list*| fl::|copy| fl::|copyint*| fl::|copysymbol| fl::|cos|
       fl::|cprintf| fl::|cputim| fl::|cpy1| fl::|cr| fl::|cvttofranzlisp| fl::|cvttointlisp|
       fl::|cvttomaclisp| fl::|cvttoucilisp| fl::|cxr| fl::|d:format-handler| fl::|de|
       fl::|de-compose| fl::|debug| fl::|debug-err-handler| fl::|debugging| fl::|declare|
       fl::|decr| fl::|def| fl::|defcmacro| fl::|defformat| fl::|defmacro| fl::|defmcrooption|
       fl::|defmcrosrch| fl::|defprop| fl::|defsetf| fl::|defsharp| fl::|defsharp-expand|
       fl::|defun| fl::|defv| fl::|defvar| fl::|delete| fl::|delq| fl::|deref| fl::|desetq|
       fl::|df| fl::|diff| fl::|difference| fl::|dm| fl::|do| fl::|double-to-float|
       fl::|drain| fl::|drm| fl::|dsm| fl::|dsubst| fl::|dtpr| fl::|dumplisp|
       fl::|english-print| fl::|english-print-thousand| fl::|environment|
       fl::|environment-files| fl::|environment-lmlisp| fl::|environment-maclisp|
       fl::|environment-syntax| fl::|eq| fl::|eq-tyimode| fl::|eqstr| fl::|equal| fl::|err|
       fl::|err-with-message| fl::|error| fl::|errset| fl::|ev-arraycall| fl::|eval|
       fl::|eval-when| fl::|eval1| fl::|evalframe| fl::|evalhook| fl::|evenp| fl::|every|
       fl::|ex| fl::|exec| fl::|exece| fl::|exit| fl::|exl| fl::|exp| fl::|explode|
       fl::|explodec| fl::|exploden| fl::|expt| fl::|exvi| fl::|f:format-handler| fl::|fact|
       fl::|fake| fl::|fasl| fl::|fasl-a-file| fl::|fclosure| fl::|fclosure-alist|
       fl::|fclosure-function| fl::|fclosure-list| fl::|fclosurep| fl::|feature-present|
       fl::|ferror| fl::|ffasl| fl::|fileopen| fl::|filepos| fl::|filestat|
       fl::|filestat:atime| fl::|filestat:ctime| fl::|filestat:dev| fl::|filestat:gid|
       fl::|filestat:ino| fl::|filestat:mode| fl::|filestat:mtime| fl::|filestat:nlink|
       fl::|filestat:rdev| fl::|filestat:size| fl::|filestat:type| fl::|filestat:uid|
       fl::|fillarray| fl::|fillarrayarray| fl::|fix| fl::|fixp| fl::|flatc| fl::|flatsize|
       fl::|float| fl::|float-to-double| fl::|floatp| fl::|for| fl::|fork| fl::|format|
       fl::|format-binpr| fl::|format-binpr1| fl::|format-ctl-ascii| fl::|format-ctl-justify|
       fl::|format-ctl-list| fl::|format-ctl-octal| fl::|format-ctl-op|
       fl::|format-ctl-repeat-char| fl::|format-ctl-string| fl::|format-prc| fl::|format-test|
       fl::|format:anyradix-printer| fl::|format:fresh-line| fl::|format:nsubstring|
       fl::|format:patom| fl::|format:print| fl::|format:printorpatom|
       fl::|format:string-search-char| fl::|format:terpr| fl::|format:tyo| fl::|framedump|
       fl::|franz-reset| fl::|franz-top-level| fl::|freturn| fl::|frexp| fl::|fseek|
       fl::|funcall| fl::|funcallhook| fl::|function| fl::|g00249::car| fl::|g00255::caar|
       fl::|g00261::cadr| fl::|g00267::cdr| fl::|g00273::cdar| fl::|g00279::cddr|
       fl::|g00285::cxr| fl::|g00291::vref| fl::|g00297::vrefi-byte| fl::|g00303::vrefi-word|
       fl::|g00309::vrefi-long| fl::|g00315::nth| fl::|g00321::nthelem| fl::|g00327::nthcdr|
       fl::|g00333::arraycall| fl::|g00339::get| fl::|g00345::plist| fl::|g00351::symeval|
       fl::|g00357::arg| fl::|g00363::args| fl::|g:format-handler| fl::|gc| fl::|gcafter|
       fl::|gensym| fl::|get| fl::|get_pname| fl::|getaccess| fl::|getaddress| fl::|getaux|
       fl::|getchar| fl::|getcharn| fl::|getd| fl::|getdata| fl::|getdelta| fl::|getdisc|
       fl::|getentry| fl::|getenv| fl::|getl| fl::|getlength| fl::|getsyntax| fl::|go|
       fl::|greaterp| fl::|haipart| fl::|hashtabstat| fl::|haulong| fl::|help| fl::|hunk|
       fl::|hunk-to-list| fl::|hunkp| fl::|hunksize| fl::|if| fl::|implode| fl::|in-tyimode|
       fl::|include| fl::|include-file| fl::|include-if| fl::|includef| fl::|includef-if|
       fl::|incr| fl::|infile| fl::|initsym| fl::|initsym1| fl::|insert| fl::|int:cfasl|
       fl::|int:fasl| fl::|int:fclosure-stack-stuff| fl::|int:fileopen| fl::|int:franz-call|
       fl::|int:getsyntax| fl::|int:infile| fl::|int:memreport| fl::|int:outfile|
       fl::|int:setsyntax| fl::|int:showstack| fl::|int:tyimode| fl::|int:vector-range-error|
       fl::|int:vref| fl::|int:vset| fl::|int:vsize| fl::|int:wrong-number-of-args-error|
       fl::|intern| fl::|killcopy| fl::|kwote| fl::|lambdacvt| fl::|last| fl::|lconc|
       fl::|ldiff| fl::|length| fl::|lessp| fl::|let| fl::|let*| fl::|lexpr-funcall|
       fl::|linelength| fl::|lineread| fl::|list| fl::|list*| fl::|list-to-bignum|
       fl::|listarray| fl::|listify| fl::|listp| fl::|liszt-declare| fl::|liszt-define|
       fl::|litatom| fl::|load| fl::|load-autorunobject| fl::|load-file| fl::|load-if-needed|
       fl::|log| fl::|loop| fl::|lsh| fl::|lsubst| fl::|macroexpand| fl::|make-equivalent|
       fl::|make-fclosure-with-alist| fl::|make-list-array| fl::|makereadtable| fl::|makhunk|
       fl::|maknam| fl::|maknum| fl::|makunbound| fl::|map| fl::|mapc| fl::|mapcan|
       fl::|mapcar| fl::|mapcon| fl::|maplist| fl::|marray| fl::|max| fl::|member| fl::|memq|
       fl::|merge| fl::|merge1| fl::|mergelists| fl::|mfunction| fl::|min| fl::|minus|
       fl::|minusp| fl::|mod| fl::|monitor| fl::|msg| fl::|msg-print| fl::|msg-tyo-char|
       fl::|nconc| fl::|nconc1| fl::|ncons| fl::|neq| fl::|nequal| fl::|new-sharp-sign-macro|
       fl::|new-vector| fl::|new-vectori-byte| fl::|new-vectori-long| fl::|new-vectori-word|
       fl::|newsym| fl::|not| fl::|nreconc| fl::|nreverse| fl::|nth| fl::|nthcdr|
       fl::|nthchar| fl::|nthelem| fl::|null| fl::|numberp| fl::|numbp| fl::|nwritn|
       fl::|o:format-handler| fl::|oblist| fl::|oddp| fl::|old-baktrace|
       fl::|old-reset-function| fl::|old-showstack| fl::|oldsym| fl::|onep| fl::|opval|
       fl::|or| fl::|outfile| fl::|p:format-handler| fl::|patom| fl::|plist| fl::|plus|
       fl::|plusp| fl::|pntlen| fl::|pop| fl::|portp| fl::|pp| fl::|pp-form| fl::|pp-function|
       fl::|pp-prop| fl::|pp-value| fl::|princ| fl::|print| fl::|print-lambda|
       fl::|printaccross| fl::|printblanks| fl::|printdef| fl::|printmacrochar|
       fl::|printprog| fl::|printret| fl::|probef| fl::|process| fl::|product| fl::|prog|
       fl::|prog1| fl::|prog2| fl::|progn| fl::|progv| fl::|prtpagesused| fl::|ptime|
       fl::|ptr| fl::|purcopy| fl::|purep| fl::|push| fl::|putaccess| fl::|putaux| fl::|putd|
       fl::|putdata| fl::|putdelta| fl::|putdisc| fl::|putlength| fl::|putprop| fl::|pv%|
       fl::|q:format-handler| fl::|qu*| fl::|quote| fl::|quote!| fl::|quote!-expr-mac|
       fl::|quotient| fl::|quotify| fl::|quotify1| fl::|r:format-handler| fl::|random|
       fl::|rassq| fl::|ratom| fl::|read| fl::|read-in-lisprc-file| fl::|readc| fl::|readlist|
       fl::|remainder| fl::|rematom| fl::|remob| fl::|remove| fl::|removeaddress|
       fl::|remprop| fl::|remq| fl::|remsym| fl::|remsym1| fl::|replace| fl::|reset|
       fl::|resetio| fl::|return| fl::|reverse| fl::|roman-char| fl::|roman-step| fl::|rot|
       fl::|rplaca| fl::|rplacd| fl::|rplacx| fl::|s:format-handler| fl::|sassoc| fl::|sassq|
       fl::|scons| fl::|segment| fl::|selectq| fl::|set| fl::|set-in-fclosure| fl::|setarg|
       fl::|setf| fl::|setf-check-cad+r| fl::|setplist| fl::|setq| fl::|setsyntax| fl::|shell|
       fl::|showstack| fl::|showstack-baktrace| fl::|signal| fl::|signp| fl::|sin|
       fl::|sizeof| fl::|sl-print| fl::|sload| fl::|small-segment| fl::|some| fl::|sort|
       fl::|sortcar| fl::|sortcarhelp| fl::|sortmerge| fl::|splitlist| fl::|sprintf|
       fl::|sqrt| fl::|sstatus| fl::|status| fl::|sticky-bignum-leftshift| fl::|store|
       fl::|storeintern| fl::|stringp| fl::|strip-extension| fl::|sub1| fl::|sublis|
       fl::|sublishelp| fl::|subpair| fl::|subpr| fl::|subst| fl::|subst-eq| fl::|subst-eqp|
       fl::|substeq| fl::|substequal| fl::|substring| fl::|substringn| fl::|sum| fl::|symbolp|
       fl::|symeval| fl::|symeval-in-fclosure| fl::|symstat| fl::|sys:access| fl::|sys:chmod|
       fl::|sys:fpeint-serv| fl::|sys:gethostname| fl::|sys:getpid| fl::|sys:getpwnam|
       fl::|sys:getpwnam-dir| fl::|sys:int-serv| fl::|sys:link| fl::|sys:time|
       fl::|sys:unlink| fl::|syscall| fl::|tab| fl::|tailp| fl::|tconc| fl::|termcapexe|
       fl::|termcapinit| fl::|terpr| fl::|terpri| fl::|throw| fl::|tilde-expand|
       fl::|time-string| fl::|times| fl::|top-eval| fl::|top-init| fl::|top-level|
       fl::|top-print| fl::|top-prompt| fl::|top-read| fl::|trace-funp| fl::|truename|
       fl::|tyi| fl::|tyimode| fl::|tyipeek| fl::|tyo| fl::|type| fl::|typep| fl::|uconcat|
       fl::|uncompile| fl::|undef-func-handler| fl::|unpush| fl::|untyi| fl::|unwind-protect|
       fl::|username-to-dir| fl::|username-to-dir-flush-cache| fl::|valuep| fl::|vector|
       fl::|vector-dump| fl::|vectori-byte| fl::|vectori-long| fl::|vectori-word|
       fl::|vectorip| fl::|vectorp| fl::|vget| fl::|vi| fl::|vil| fl::|vprop| fl::|vputprop|
       fl::|vref| fl::|vrefi-byte| fl::|vrefi-long| fl::|vrefi-word| fl::|vset|
       fl::|vseti-byte| fl::|vseti-long| fl::|vseti-word| fl::|vsetprop| fl::|vsize|
       fl::|vsize-byte| fl::|vsize-word| fl::|wait| fl::|without-path| fl::|x:format-handler|
       fl::|xcons| fl::|zapline| fl::|zerop| fl::|{:format-handler| fl::|\|:format-handler|
       fl::|}:format-handler| fl::|~:format-handler|}
   ==>
   ?$left$
   (Franz-to-Common)
   (NoProtocol)
 ((author "Andreas Girgensohn") (created "20.10.1987, 19:42")))

(defun common-function-p (sym)
  (and (symbolp sym)
       (or (functionp sym)
	   (special-form-p sym)
	   (macro-function sym))))

(defrule user-defined-foos-collision (myLambda1 Mylambda2) 20
   ?foo:(and (user-defined-p IT) (common-function-p (symbol IT)))
   ==>
   ?foo						; Note already with definition
   (Franz-to-common)
   (NoProtocol)
 ((modified-by "Matthias Ressel")(modified "17.12.1987, 0:18")
  (author "Matthias Ressel") (created "16.12.1987, 22:46")))

(defrule user-defined-foos (myLambda1 Mylambda2) 10
   ?foo:user-defined-p
   ==>
   ?,(Symbol ?foo)
   (Franz-to-common)
   (NoProtocol)
 ((modified-by "Matthias Ressel")(modified "17.12.1987, 0:18")
  (author "Matthias Ressel") (created "16.12.1987, 22:46")))

(defrule assumed-user-defined-collision (myLambda1 Mylambda2) -70	; nach not-trans...
   ?foo:(common-function-p (symbol IT))
   ==>
   ?foo
   (progn (pushnew ?foo *assumed-user-defined-collision*)
	  ;; (protocol-format "%Note: Assumed user defined function ~s could collide~%       with CommonLisp function~%" ?foo)
)
   (Franz-to-common)
   (NoProtocol)
 ((modified-by "Matthias Ressel")(modified "16.12.1987, 22:55")
  (author "Matthias Ressel") (created "16.12.1987, 22:49")))

(defrule default-user-defined-foos (MyLambda1 MyLambda2) -100
	 ?foo:franz-symbol-p
	 ==>
	 ?,(Symbol ?foo)
	 (progn (pushnew ?foo *assumed-user-functions*)
		;; (protocol-format "%Note: Assuming ~s to be a user defined function~%" ?foo)
		)
	 (Franz-to-Common)
	 (NoProtocol)
  ((author "Matthias Ressel")))

(defrule transform-lambda (MyLambda1 MyLambda2) 1
   (fl::|lambda| ?arglist ?*body)
   ==>
   (lambda ?arglist ?*body)
   (Franz-to-Common)
   (NoProtocol)
 ((author "Andreas Girgensohn") (created "16.10.1987, 19:44")))

(setf (get 'franz-to-common-rules 'version) 6.1)

;;;------------------------------------------------------------------------------------------
;;; Ruecksetzen der Readersyntax
;;;------------------------------------------------------------------------------------------

(clean-rule-file)				; resets Reader-Syntax
						; if file compiles up to here
