;;; -*- Mode: LISP; Syntax: Common-lisp; Package: User; Base: 10 -*-

;;; Rule Base: Franz to Common Lisp

;;;----------------------------------------------------------------------
;;; Package
;;;----------------------------------------------------------------------

; (in-package 'franz-to-common) ; in a version to come

;;;------------------------------------------------------------------------------------------
;;; Laden der Read-Macros und Rule-Macros
;;;------------------------------------------------------------------------------------------

(eval-when (compile eval)
  (unless (get 'tl::init-rule-handling 'tl::version)
    (load "../kernel/init-rule-handling")))

(init-rule-file)

;;;------------------------------------------------------------------------------------------
;;; Backquote Trigger Stuff
;;;------------------------------------------------------------------------------------------

(defruleset MyTriggerBackquoteLevel (bq-expr *level* *bq-goal*)
  :special (*level* *bq-goal*))

(defrule  trigger-backquote-level MyTriggerBackquoteLevel 1
	?x
	==>
	?,(MyTriggerBackquote ?x)
	(Franz-Trigger)
	(NoProtocol)
((author "Matthias Ressel") (created "Tue Feb 17 20:02:21 1987")))


(defruleset MyTriggerBackquote (bq-expr)
  :special (*level* *bq-goal*))

(defrule  backquote-comma-trigger MyTriggerBackquote 1
	, ?arg                          ; (|,| . ?arg)
	(zerop *level*)
	==>			       ;
	?,(InBackquote ?`, ?,(TransformStandard ?arg)) ; ?,(InBackquote ?`(|,| . ?,(Si)))
	(Franz-Trigger) 
	(NoProtocol)
	((author "Matthias Ressel") (created "Wed Dec  3 18:40:49 1986")
	 (modified-by "Matthias Ressel") (modified "Tue Feb 17 20:05:51 1987")))

(defrule  backquote-comma-trigger-2 MyTriggerBackquote 1
	, ?arg                          ; (|,| . ?arg)
	(not (zerop *level*))
	==>			       
	, ?,(MyTriggerBackquoteLevel ?arg (1- *level*) *bq-goal*)    
	(Franz-Trigger) 
	(NoProtocol)
	((author "Matthias Ressel") (created "Wed Dec  3 18:40:49 1986")
	 (modified-by "Matthias Ressel") (modified "Tue Feb 17 20:06:01 1987")))

(defrule  backquote-comma-@-trigger MyTriggerBackquote 1
	,@?arg
	(zerop *level*)
	==>
	?,(InBackquote ?` ,@?,(TransformListIgnoreTopCopy ?arg))
	(Franz-Trigger)
	(NoProtocol)
((modified-by "Matthias Ressel") (modified "Sun Apr 26 19:44:05 1987")
 (author "Matthias Ressel") (created "Fri Jan 23 17:34:19 1987")))

(defrule  backquote-comma-@-trigger-2 MyTriggerBackquote 1
	,@?arg
	(not (zerop *level*))
	==>
	,@?,(MyTriggerBackquoteLevel ?arg (1- *level*) *bq-goal*)
	(Franz-Trigger)
	(NoProtocol)
((modified-by "Matthias Ressel") (modified "Tue Feb 17 20:07:54 1987")
 (author "Matthias Ressel") (created "Fri Jan 23 17:34:19 1987")))

(defrule  backquote-comma-dot-trigger MyTriggerBackquote 1
	,.?arg
	(zerop *level*)
	==>
	?,(InBackquote ?` ,.?,(TransformStandard ?arg))
	(Franz-Trigger)
	(NoProtocol)
((modified-by "Matthias Ressel") (modified "Sun Apr 26 19:44:34 1987")
 (author "Matthias Ressel") (created "Fri Jan 23 17:34:58 1987")))

(defrule  backquote-comma-dot-trigger-2 MyTriggerBackquote 1
	,.?arg
	(not (zerop *level*))
	==>
	,.?,(MyTriggerBackquoteLevel ?arg (1- *level*) *bq-goal*)
	(Franz-Trigger)
	(NoProtocol)
((modified-by "Matthias Ressel") (modified "Tue Feb 17 20:08:06 1987")
 (author "Matthias Ressel") (created "Fri Jan 23 17:34:58 1987")))

(defrule  backquote-backquote-trigger MyTriggerBackquote 2
	`?arg
	==>
	`?,(MyTriggerBackquoteLevel ?arg (1+ *level*) *bq-goal*)
	(Franz-Trigger)
	(NoProtocol)
((author "Matthias Ressel") (created "Tue Feb 17 20:10:45 1987")))

(defrule  backquote-list-trigger MyTriggerBackquote 1
	(?*args)
	==>
	(?*,(mapcar #'MyTriggerBackquote ?*args))
	(Franz-Trigger) 
	(NoProtocol)
((author "Matthias Ressel") (created "Wed Dec  3 18:45:54 1986")))

(defrule  backquote-dotted-trigger MyTriggerBackquote 1
	(?first . ?rest)
	==>
	(?,(MyTriggerBackquote ?first) . ?,(MyTriggerBackquote ?rest))
	(Franz-Trigger)
	(NoProtocol)
((modified-by "Matthias Ressel") (modified "Thu Jan 29 15:46:42 1987")
 (author "Matthias Ressel") (created "Fri Jan 23 17:37:54 1987")))

(defrule backquote-constant MyTriggerBackquote 0
   ?atom:atom
   (eq *bq-goal* 'Data)
   ==>
   ?,(Data ?atom)
   (Franz-Trigger)
   (NoProtocol)
 ((modified-by "Matthias Ressel")(modified "16.12.1987, 19:55")
  (author "Andreas Girgensohn") (created "20.10.1987, 19:58")))

(defruleset MyTriggerSelectClause (clause)
  :special *outer*)

(defrule  trigger-selectq-clause MyTriggerSelectClause 1
	(?key ?*body)
	==>
	(?,(Data ?key) ?*,(TransformPrognBody ?*body *outer*))
	(Franz-Trigger) 
	(NoProtocol)
	((author "Matthias Ressel") (created "Sun Nov 30 16:54:31 1986")))

;;; Hilfsregeln fuer Backquote:

(defruleset InBackquote (commaform))

(defrule  drop-comma-quote InBackquote 1
	,?x
	==>
	?,(Comma ?x)
	(Franz-to-Common Size)
	(NoProtocol)
((author "Matthias Ressel") (created "Sun Apr 26 19:46:42 1987")))

(defrule  drop-splice-quote InBackquote 1
	,@ ?x
	==>
	?,(CommaAppend ?x)
	(Franz-to-Common Size)
	(NoProtocol)
((author "Matthias Ressel") (created "Sun Apr 26 19:48:58 1987")))

(defrule  drop-dot-splice-quote InBackquote 1
	,. ?x
	==>
	?,(CommaNconc ?x)
	(Franz-to-Common Size)
	(NoProtocol)
((author "Matthias Ressel") (created "Sun Apr 26 19:50:46 1987")))

(defruleset commaappend (expr))
(defruleset commanconc (expr))

(defrule  comma-splice-quote (CommaAppend CommaNconc) 2
	(??:{quote fl::|quote|} (?*x:no-visible-comma-p))
	==>
	?*x                     ; disgusting
	(Franz-Trigger)
	(NoProtocol)
	((modified-by "Matthias Ressel") (modified "Wed Jan 28 19:02:44 1987")
 (author "Matthias Ressel") (created "Sun Dec 21 18:37:41 1986")
 ($needed$)))

(defruleset Commaquote (expr))

(defrule  comma-splice-quote-2 (CommaAppend CommaNconc) 1
	(??:{quote fl::|quote|} (?*x:no-comma-splice))
	==>
	?*, (mapcar #'CommaQuote ?*x)                     ; disgusting
	(Franz-Trigger)
	(NoProtocol)
	((modified-by "Matthias Ressel") (modified "Wed Mar 11 15:25:41 1987")
 (author "Matthias Ressel") (created "Sun Dec 21 18:37:41 1986")
 ($needed$)))

(defrule  comma-quote.comma CommaQuote 1
	?x:(not (no-visible-comma-p IT))
	==>
	,'?x
	(Franz-Trigger)
	(NoProtocol)
((author "Matthias Ressel") (created "Wed Feb  4 21:33:52 1987")
 ($needed$)))

(defrule  comma-splice-qu* (CommaAppend CommaNconc) 2
	(qu* (?*x))
	==>
	?*x    
	(Franz-Trigger)
	(NoProtocol)
	((modified-by "Matthias Ressel") (modified "Wed Jan 28 19:02:44 1987")
 (author "Matthias Ressel") (created "Sun Dec 21 18:37:41 1986")
 ($needed$)))

(defrule  comma-splice-list/ncons (CommaAppend CommaNconc) 2
	(?list:{list ncons} ?*x:no-comma-splice)
	==>
	?*,(mapcar #'Comma ?*x)
	(Franz-Trigger)
	(NoProtocol)
	((modified-by "Matthias Ressel") (modified "Wed Jan 28 19:03:09 1987")
 (author "Matthias Ressel") (created "Sun Dec 21 18:40:01 1986")
 ($needed$)))

(defrule  splice-non-list CommaAppend 1
	?x
	==>
	,@ ?x
	(Franz-Trigger)
	(NoProtocol)
	((author "Matthias Ressel") (created "Sun Dec 21 18:40:52 1986")
	 (modified-by "Matthias Ressel") (modified "Wed Jan 28 19:03:49 1987")
	 ($needed$)))

(defrule  splice-non-list-2 CommaNconc 1
	?x
	==>
	,. ?x
	(Franz-Trigger)
	(NoProtocol)
((author "Matthias Ressel") (created "Wed Jan 28 19:05:05 1987")
 ($needed$)))

(defruleset comma (expr))

(defrule  comma-quote Comma 2
	(??:{quote fl::|quote|} ?x:(and (not (eq IT 'qu*)) (no-visible-comma-p IT)))
	==>
	?x
	(Franz-Trigger)
	(NoProtocol)
	((author "Matthias Ressel") (created "Sun Dec 21 18:53:32 1986")
	 ($needed$)))

(defrule  comma-qu* Comma 2
	(qu* ?x)
	==>
	?x
	(Franz-Trigger)
	(NoProtocol)
	((author "Matthias Ressel") (created "Sun Dec 21 18:53:32 1986")
	 ($needed$)))

(defrule  comma-t-or-nil Comma 2
	?x:{t nil}
	==>
	?x
	(Franz-Trigger)
	(NoProtocol)
((author "Matthias Ressel") (created "Tue Feb 17 19:52:38 1987")
 ($needed$)))

(defrule  comma-number Comma 2
	?x:numberp
	==>
	?x
	(Franz-Trigger)
	(NoProtocol)
((author "Matthias Ressel") (created "Tue Feb 17 19:53:03 1987")
 ($needed$)))

(defrule  comma-non-quote Comma 1
	?x
	==>
	, ?x
	(Franz-Trigger)
	(NoProtocol)
	((modified-by "Matthias Ressel") (modified "Fri Jan 23 19:17:33 1987")
 (author "Matthias Ressel") (created "Sun Dec 21 18:54:10 1986")
 ($needed$)))

;;;------------------------------------------------------------------------------------------
;;; Trigger fuer Regeln:
;;;------------------------------------------------------------------------------------------

(defrule |Ruleset:|-MyTrigger MyTrigger 1
   (fl::|Ruleset:| ?name ?param-list ?until ?*)
   ==>
   (defruleset ?,(Symbol ?name) ?,(cons 'expr ?param-list)
     :loop ?,(Symbol ?until))
   (Franz-to-Common)
   (Protocol)
 ((author "Matthias Ressel") (created "16.10.1987, 17:06")))

(defrule  Rule\:-MyTrigger MyTrigger  1
	(fl::|Rule:| ?name ?ruleset ?prio
     ?pattern
     ?*cond::(null (cdr IT))
     fl::==>
     ?repl
     ?*action::(null (cdr IT))
     ?goal
     ?prot
     ?att)
	==>
	(defrule ?,(Symbol ?name) ?,(Symbol ?ruleset) ?prio
		 ?pattern
		 ?*,(if ?*cond 
			(list (TransformStandard ?*cond)))			
		 ==>
		 ?repl
		 ?*,(if ?*action
			(list (TransformStandard ?*action)))
		 ?,(Symbol ?goal)
		 ?,(Symbol ?prot)
		 ?,(Symbol ?att))
	(Franz-to-Common)
	(NoProtocol)
((author "Matthias Ressel") (created "Sat Aug  8 16:33:07 1987")))

;;;------------------------------------------------------------------------------------------
;;; Trafo Regeln
;;;------------------------------------------------------------------------------------------

;;;------------------------------------------------------------------------------------------
;;; Symbol, Standard etc.
;;;------------------------------------------------------------------------------------------

(defrule  var.readtable TransformVariable 1
	fl::|readtable|
	==>
	*readtable*
	(Franz-to-Common)
	(Protocol)
((author "Andreas Girgensohn") (created "Fri Jan 23 13:33:36 1987")))

(defrule  var.piport TransformVariable 1
	fl::|piport|
	==>
	*standard-input*
	(Franz-to-Common)
	(Protocol)
((author "Andreas Girgensohn") (created "Fri Jan 23 13:33:59 1987")))

(defrule  var.poport TransformVariable 1
	fl::|poport|
	==>
	*standard-output*
	(Franz-to-Common)
	(Protocol)
((author "Andreas Girgensohn") (created "Fri Jan 23 13:34:20 1987")))

(defrule var.prinlength TransformVariable 1
   fl::|prinlength|
   ==>
   *print-length*
   (Franz-to-Common)
   (Protocol)
 ((author "Andreas Girgensohn") (created "30.10.1987, 10:24")))

(defrule var.prinlevel TransformVariable 1
   fl::|prinlevel|
   ==>
   *print-level*
   (Franz-to-Common)
   (Protocol)
 ((author "Andreas Girgensohn") (created "30.10.1987, 10:24")))

(defrule variable-collision TransformVariable 0
   ?var:(and (franz-symbol-p IT) (member (symbol IT) *common-special-variables*))
   ==>
   ?var
   (progn (pushnew ?var *variable-collision*)
	  ;; (protocol-format "%Note: There may be a conflict with the CommonLisp special~%       variable ~a~%" ?var)
)
   (Franz-to-common)
   (NoProtocol)
 ((author "Matthias Ressel") (created "17.12.1987, 0:48")))

(defrule data-franz-function-no-difference Data 3
   ?foo:{fl::* fl::+ fl::1+ fl::1- fl::< fl::<= fl::= fl::> fl::>= fl::|abs|
         fl::|and| fl::|append| fl::|apply| fl::|atan|
	 fl::|atom| fl::|boundp| fl::|caaaar| fl::|caaadr| fl::|caaar|
         fl::|caadar| fl::|caaddr| fl::|caadr| fl::|caar| fl::|cadaar| fl::|cadadr|
         fl::|cadar| fl::|caddar| fl::|cadddr| fl::|caddr| fl::|cadr| fl::|car| fl::|cdaaar|
         fl::|cdaar| fl::|cdadar| fl::|cdaddr| fl::|cdadr| fl::|cdar| fl::|cddaar|
         fl::|cddadr| fl::|cddar| fl::|cdddar| fl::|cddddr| fl::|cdddr| fl::|cddr| fl::|cdr|
         fl::|close| fl::|cond| fl::|cons| fl::|cos| fl::|defvar| fl::|defun| fl::|defmacro| fl::|do| fl::|eq|
	 fl::|equal| fl::|eval| fl::|eval-when| fl::|evenp|
	 fl::|exp| fl::|expt| fl::|float| fl::|floatp| fl::|format| fl::|funcall|
         fl::|function| fl::|get| fl::|go| fl::|if| fl::|intern| fl::|last| fl::|length|
         fl::|list| fl::|list*| fl::|listp| fl::|load| fl::|macroexpand|
         fl::|makunbound| fl::|mapc| fl::|mapcan| fl::|mapcar| fl::|mapcon| fl::|maplist|
         fl::|max| fl::|min| fl::|minusp| fl::|nconc| fl::|not| fl::|nreconc| fl::|nreverse|
         fl::|nthcdr|
         fl::|null| fl::|numberp| fl::|oddp| fl::|or| fl::|plusp| fl::|pop| fl::|princ|
	 fl::|print| fl::|prog|
         fl::|prog1| fl::|prog2| fl::|progn| fl::|push| fl::|remprop| fl::|return|
	 fl::|reverse| fl::|rplaca| fl::|rplacd|
	 fl::|set| fl::|setf| fl::|setq| fl::|sin| fl::|sort| fl::|sqrt|
	 fl::|stringp| fl::|symbolp| fl::|terpri| fl::|unwind-protect| fl::|zerop|}
   ==>
   ?,(transform-franz-symbol ?foo)
   (Franz-to-Common)
   (NoProtocol)
 ((modified-by "Matthias Ressel")(modified "16.12.1987, 23:34")
  (author "Andreas Girgensohn") (created "21.10.1987, 15:52")))

;;; these are ALL FranzLisp functions

(defrule data-franz-function-name Data 2
   ??:{fl::|$patom1| fl::|$prd1| fl::|$prdf| fl::|$prpr| fl::|%:format-handler|
       fl::|&:format-handler| fl::* fl::*$ fl::|*:format-handler| fl::|*array| fl::|*break|
       fl::|*catch| fl::|*dif| fl::|*invmod| fl::|*makhunk| fl::|*mod| fl::|*process|
       fl::|*process-receive| fl::|*process-send| fl::|*quo| fl::|*rplacx| fl::|*rset|
       fl::|*throw| fl::+ fl::+$ fl::- fl::-$ fl::/ fl::/$ fl::1+ fl::1+$ fl::1- fl::1-$
       fl::|:=| fl::|;:format-handler| fl::< fl::<& fl::<= fl::<=& fl::= fl::=& fl::> fl::>&
       fl::>= fl::>=& fl::|?th| fl::|Cnth| fl::|Divide| fl::|Emuldiv| fl::|I-throw-err|
       fl::|If| fl::|Sharpm'g00150| fl::|Sharpm'g00160| fl::|Sharpm+g00125|
       fl::|Sharpm+g00139| fl::|Sharpm,g00155| fl::|Sharpm,g00164| fl::|Sharpm-g00132|
       fl::|Sharpm-g00145| fl::|Sharpm/g00139| fl::|Sharpm/g00151| fl::|SharpmMg00176|
       fl::|SharpmMg00182| fl::|Sharpm\\g00160| fl::|Sharpm\\g00168| fl::|Sharpm^g00144|
       fl::|Sharpm^g00155| fl::|Sharpmog00097| fl::|Sharpmog00113| fl::|Sharpmtg00171|
       fl::|Sharpmtg00178| fl::|Sharpmxg00102| fl::|Sharpmxg00117| fl::|[:format-handler|
       fl::\\ fl::|]:format-handler| fl::^ fl::|^:format-handler| fl::|a:format-handler|
       fl::|abs| fl::|absval| fl::|acos| fl::|add| fl::|add-syntax-class| fl::|add1|
       fl::|aexplode| fl::|aexplodec| fl::|aexploden| fl::|allocate| fl::|allsym|
       fl::|alphalessp| fl::|and| fl::|any-zerop| fl::|append| fl::|append1| fl::|apply|
       fl::|apply*| fl::|arg| fl::|argv| fl::|arrac-nD| fl::|arrac-oneD| fl::|arrac-twoD|
       fl::|array| fl::|array-type| fl::|arraycall| fl::|arraydims| fl::|arrayp|
       fl::|arrayref| fl::|ascii| fl::|asin| fl::|assoc| fl::|assq| fl::|atan|
       fl::|atom|
       fl::|attach| fl::|back-quote-ch-macro| fl::|back-quote-comma-macro| fl::|back=quotify|
       fl::|baktrace| fl::|baktraceprint| fl::|bcdad| fl::|bcdcall| fl::|bcdp|
       fl::|bignum-leftshift| fl::|bignum-to-list| fl::|bigp| fl::|boole| fl::|boundp|
       fl::|bq-print-macro| fl::|break| fl::|break-err-handler| fl::|c:format-handler|
       fl::|caar| fl::|caddddr| fl::|cadddr| fl::|caddr| fl::|cadr| fl::|car| fl::|case-scan|
       fl::|caseq| fl::|catch| fl::|cdar| fl::|cddddddr| fl::|cdddddr| fl::|cddddr|
       fl::|cdddr| fl::|cddr| fl::|cdr| fl::|cfasl| fl::|ch10:format-handler| fl::|charcnt|
       fl::|charsinbuf| fl::|chdir| fl::|cib| fl::|close| fl::|command-line-args|
       fl::|comment| fl::|compile| fl::|concat| fl::|concatl| fl::|cond| fl::|condclosefile|
       fl::|cons| fl::|construct-list*| fl::|copy| fl::|copyint*| fl::|copysymbol| fl::|cos|
       fl::|cprintf| fl::|cputim| fl::|cpy1| fl::|cr| fl::|cvttofranzlisp| fl::|cvttointlisp|
       fl::|cvttomaclisp| fl::|cvttoucilisp| fl::|cxr| fl::|d:format-handler| fl::|de|
       fl::|de-compose| fl::|debug| fl::|debug-err-handler| fl::|debugging| fl::|declare|
       fl::|decr| fl::|def| fl::|defcmacro| fl::|defformat| fl::|defmacro| fl::|defmcrooption|
       fl::|defmcrosrch| fl::|defprop| fl::|defsetf| fl::|defsharp| fl::|defsharp-expand|
       fl::|defun| fl::|defv| fl::|defvar| fl::|delete| fl::|delq| fl::|deref| fl::|desetq|
       fl::|df| fl::|diff| fl::|difference| fl::|dm| fl::|do| fl::|double-to-float|
       fl::|drain| fl::|drm| fl::|dsm| fl::|dsubst| fl::|dtpr| fl::|dumplisp|
       fl::|english-print| fl::|english-print-thousand| fl::|environment|
       fl::|environment-files| fl::|environment-lmlisp| fl::|environment-maclisp|
       fl::|environment-syntax| fl::|eq| fl::|eq-tyimode| fl::|eqstr| fl::|equal| fl::|err|
       fl::|err-with-message| fl::|error| fl::|errset| fl::|ev-arraycall| fl::|eval|
       fl::|eval-when| fl::|eval1| fl::|evalframe| fl::|evalhook| fl::|evenp| fl::|every|
       fl::|ex| fl::|exec| fl::|exece| fl::|exit| fl::|exl| fl::|exp| fl::|explode|
       fl::|explodec| fl::|exploden| fl::|expt| fl::|exvi| fl::|f:format-handler| fl::|fact|
       fl::|fake| fl::|fasl| fl::|fasl-a-file| fl::|fclosure| fl::|fclosure-alist|
       fl::|fclosure-function| fl::|fclosure-list| fl::|fclosurep| fl::|feature-present|
       fl::|ferror| fl::|ffasl| fl::|fileopen| fl::|filepos| fl::|filestat|
       fl::|filestat:atime| fl::|filestat:ctime| fl::|filestat:dev| fl::|filestat:gid|
       fl::|filestat:ino| fl::|filestat:mode| fl::|filestat:mtime| fl::|filestat:nlink|
       fl::|filestat:rdev| fl::|filestat:size| fl::|filestat:type| fl::|filestat:uid|
       fl::|fillarray| fl::|fillarrayarray| fl::|fix| fl::|fixp| fl::|flatc| fl::|flatsize|
       fl::|float| fl::|float-to-double| fl::|floatp| fl::|for| fl::|fork| fl::|format|
       fl::|format-binpr| fl::|format-binpr1| fl::|format-ctl-ascii| fl::|format-ctl-justify|
       fl::|format-ctl-list| fl::|format-ctl-octal| fl::|format-ctl-op|
       fl::|format-ctl-repeat-char| fl::|format-ctl-string| fl::|format-prc| fl::|format-test|
       fl::|format:anyradix-printer| fl::|format:fresh-line| fl::|format:nsubstring|
       fl::|format:patom| fl::|format:print| fl::|format:printorpatom|
       fl::|format:string-search-char| fl::|format:terpr| fl::|format:tyo| fl::|framedump|
       fl::|franz-reset| fl::|franz-top-level| fl::|freturn| fl::|frexp| fl::|fseek|
       fl::|funcall| fl::|funcallhook| fl::|function| fl::|g00249::car| fl::|g00255::caar|
       fl::|g00261::cadr| fl::|g00267::cdr| fl::|g00273::cdar| fl::|g00279::cddr|
       fl::|g00285::cxr| fl::|g00291::vref| fl::|g00297::vrefi-byte| fl::|g00303::vrefi-word|
       fl::|g00309::vrefi-long| fl::|g00315::nth| fl::|g00321::nthelem| fl::|g00327::nthcdr|
       fl::|g00333::arraycall| fl::|g00339::get| fl::|g00345::plist| fl::|g00351::symeval|
       fl::|g00357::arg| fl::|g00363::args| fl::|g:format-handler| fl::|gc| fl::|gcafter|
       fl::|gensym| fl::|get| fl::|get_pname| fl::|getaccess| fl::|getaddress| fl::|getaux|
       fl::|getchar| fl::|getcharn| fl::|getd| fl::|getdata| fl::|getdelta| fl::|getdisc|
       fl::|getentry| fl::|getenv| fl::|getl| fl::|getlength| fl::|getsyntax| fl::|go|
       fl::|greaterp| fl::|haipart| fl::|hashtabstat| fl::|haulong| fl::|help| fl::|hunk|
       fl::|hunk-to-list| fl::|hunkp| fl::|hunksize| fl::|if| fl::|implode| fl::|in-tyimode|
       fl::|include| fl::|include-file| fl::|include-if| fl::|includef| fl::|includef-if|
       fl::|incr| fl::|infile| fl::|initsym| fl::|initsym1| fl::|insert| fl::|int:cfasl|
       fl::|int:fasl| fl::|int:fclosure-stack-stuff| fl::|int:fileopen| fl::|int:franz-call|
       fl::|int:getsyntax| fl::|int:infile| fl::|int:memreport| fl::|int:outfile|
       fl::|int:setsyntax| fl::|int:showstack| fl::|int:tyimode| fl::|int:vector-range-error|
       fl::|int:vref| fl::|int:vset| fl::|int:vsize| fl::|int:wrong-number-of-args-error|
       fl::|intern| fl::|killcopy| fl::|kwote| fl::|lambdacvt| fl::|last| fl::|lconc|
       fl::|ldiff| fl::|length| fl::|lessp| fl::|let| fl::|let*| fl::|lexpr-funcall|
       fl::|linelength| fl::|lineread| fl::|list| fl::|list*| fl::|list-to-bignum|
       fl::|listarray| fl::|listify| fl::|listp| fl::|liszt-declare| fl::|liszt-define|
       fl::|litatom| fl::|load| fl::|load-autorunobject| fl::|load-file| fl::|load-if-needed|
       fl::|log| fl::|loop| fl::|lsh| fl::|lsubst| fl::|macroexpand| fl::|make-equivalent|
       fl::|make-fclosure-with-alist| fl::|make-list-array| fl::|makereadtable| fl::|makhunk|
       fl::|maknam| fl::|maknum| fl::|makunbound| fl::|map| fl::|mapc| fl::|mapcan|
       fl::|mapcar| fl::|mapcon| fl::|maplist| fl::|marray| fl::|max| fl::|member| fl::|memq|
       fl::|merge| fl::|merge1| fl::|mergelists| fl::|mfunction| fl::|min| fl::|minus|
       fl::|minusp| fl::|mod| fl::|monitor| fl::|msg| fl::|msg-print| fl::|msg-tyo-char|
       fl::|nconc| fl::|nconc1| fl::|ncons| fl::|neq| fl::|nequal| fl::|new-sharp-sign-macro|
       fl::|new-vector| fl::|new-vectori-byte| fl::|new-vectori-long| fl::|new-vectori-word|
       fl::|newsym| fl::|not| fl::|nreconc| fl::|nreverse| fl::|nth| fl::|nthcdr|
       fl::|nthchar| fl::|nthelem| fl::|null| fl::|numberp| fl::|numbp| fl::|nwritn|
       fl::|o:format-handler| fl::|oblist| fl::|oddp| fl::|old-baktrace|
       fl::|old-reset-function| fl::|old-showstack| fl::|oldsym| fl::|onep| fl::|opval|
       fl::|or| fl::|outfile| fl::|p:format-handler| fl::|patom| fl::|plist| fl::|plus|
       fl::|plusp| fl::|pntlen| fl::|pop| fl::|portp| fl::|pp| fl::|pp-form| fl::|pp-function|
       fl::|pp-prop| fl::|pp-value| fl::|princ| fl::|print| fl::|print-lambda|
       fl::|printaccross| fl::|printblanks| fl::|printdef| fl::|printmacrochar|
       fl::|printprog| fl::|printret| fl::|probef| fl::|process| fl::|product| fl::|prog|
       fl::|prog1| fl::|prog2| fl::|progn| fl::|progv| fl::|prtpagesused| fl::|ptime|
       fl::|ptr| fl::|purcopy| fl::|purep| fl::|push| fl::|putaccess| fl::|putaux| fl::|putd|
       fl::|putdata| fl::|putdelta| fl::|putdisc| fl::|putlength| fl::|putprop| fl::|pv%|
       fl::|q:format-handler| fl::|qu*| fl::|quote| fl::|quote!| fl::|quote!-expr-mac|
       fl::|quotient| fl::|quotify| fl::|quotify1| fl::|r:format-handler| fl::|random|
       fl::|rassq| fl::|ratom| fl::|read| fl::|read-in-lisprc-file| fl::|readc| fl::|readlist|
       fl::|remainder| fl::|rematom| fl::|remob| fl::|remove| fl::|removeaddress|
       fl::|remprop| fl::|remq| fl::|remsym| fl::|remsym1| fl::|replace| fl::|reset|
       fl::|resetio| fl::|return| fl::|reverse| fl::|roman-char| fl::|roman-step| fl::|rot|
       fl::|rplaca| fl::|rplacd| fl::|rplacx| fl::|s:format-handler| fl::|sassoc| fl::|sassq|
       fl::|scons| fl::|segment| fl::|selectq| fl::|set| fl::|set-in-fclosure| fl::|setarg|
       fl::|setf| fl::|setf-check-cad+r| fl::|setplist| fl::|setq| fl::|setsyntax| fl::|shell|
       fl::|showstack| fl::|showstack-baktrace| fl::|signal| fl::|signp| fl::|sin|
       fl::|sizeof| fl::|sl-print| fl::|sload| fl::|small-segment| fl::|some| fl::|sort|
       fl::|sortcar| fl::|sortcarhelp| fl::|sortmerge| fl::|splitlist| fl::|sprintf|
       fl::|sqrt| fl::|sstatus| fl::|status| fl::|sticky-bignum-leftshift| fl::|store|
       fl::|storeintern| fl::|stringp| fl::|strip-extension| fl::|sub1| fl::|sublis|
       fl::|sublishelp| fl::|subpair| fl::|subpr| fl::|subst| fl::|subst-eq| fl::|subst-eqp|
       fl::|substeq| fl::|substequal| fl::|substring| fl::|substringn| fl::|sum| fl::|symbolp|
       fl::|symeval| fl::|symeval-in-fclosure| fl::|symstat| fl::|sys:access| fl::|sys:chmod|
       fl::|sys:fpeint-serv| fl::|sys:gethostname| fl::|sys:getpid| fl::|sys:getpwnam|
       fl::|sys:getpwnam-dir| fl::|sys:int-serv| fl::|sys:link| fl::|sys:time|
       fl::|sys:unlink| fl::|syscall| fl::|tab| fl::|tailp| fl::|tconc| fl::|termcapexe|
       fl::|termcapinit| fl::|terpr| fl::|terpri| fl::|throw| fl::|tilde-expand|
       fl::|time-string| fl::|times| fl::|top-eval| fl::|top-init| fl::|top-level|
       fl::|top-print| fl::|top-prompt| fl::|top-read| fl::|trace-funp| fl::|truename|
       fl::|tyi| fl::|tyimode| fl::|tyipeek| fl::|tyo| fl::|type| fl::|typep| fl::|uconcat|
       fl::|uncompile| fl::|undef-func-handler| fl::|unpush| fl::|untyi| fl::|unwind-protect|
       fl::|username-to-dir| fl::|username-to-dir-flush-cache| fl::|valuep| fl::|vector|
       fl::|vector-dump| fl::|vectori-byte| fl::|vectori-long| fl::|vectori-word|
       fl::|vectorip| fl::|vectorp| fl::|vget| fl::|vi| fl::|vil| fl::|vprop| fl::|vputprop|
       fl::|vref| fl::|vrefi-byte| fl::|vrefi-long| fl::|vrefi-word| fl::|vset|
       fl::|vseti-byte| fl::|vseti-long| fl::|vseti-word| fl::|vsetprop| fl::|vsize|
       fl::|vsize-byte| fl::|vsize-word| fl::|wait| fl::|without-path| fl::|x:format-handler|
       fl::|xcons| fl::|zapline| fl::|zerop| fl::|{:format-handler| fl::|\|:format-handler|
       fl::|}:format-handler| fl::|~:format-handler|}
   ==>
   ?$left$
   (Franz-to-Common)
   (NoProtocol)
 ((author "Andreas Girgensohn") (created "20.10.1987, 15:46")))

(defrule data-cad*r Data 2
   ??:cad*rp
   ==>
   ?$left$
   (Franz-to-Common)
   (NoProtocol)
 ((author "Andreas Girgensohn") (created "20.10.1987, 15:49")))

(defrule data-symbol Data 1
   ?sym:symbolp
   ==>
   ?,(symbol ?sym)
   (Franz-to-Common)
   (NoProtocol)
 ((author "Andreas Girgensohn") (created "20.10.1987, 15:47")))

(defrule data-list Data 2
   (?*elems)
   ==>
   (?*,(mapcar #'Data ?*elems))
   (Franz-to-Common)
   (NoProtocol)
 ((author "Andreas Girgensohn") (created "20.10.1987, 15:51")))

(defrule data-cons Data 1
   (?first . ?rest)
   ==>
   (?,(Data ?first) . ?,(Data ?rest))
   (Franz-to-Common)
   (NoProtocol)
 ((author "Andreas Girgensohn") (created "20.10.1987, 15:52")))

;;;------------------------------------------------------------------------------------------
;;; Ruecksetzen der Readersyntax
;;;------------------------------------------------------------------------------------------

(clean-rule-file)				; resets Reader-Syntax
						; if file compiles up to here
