;;; -*- Mode: LISP; Syntax: Common-lisp; Package: User; Base: 10 -*-

;;; Rule Base: Franz to Common Lisp

;;;----------------------------------------------------------------------
;;; Package
;;;----------------------------------------------------------------------

; (in-package 'franz-to-common) ; in a version to come

;;;------------------------------------------------------------------------------------------
;;; Laden der Read-Macros und Rule-Macros
;;;------------------------------------------------------------------------------------------

(eval-when (compile eval)
  (unless (get 'tl::init-rule-handling 'tl::version)
    (load "../kernel/init-rule-handling")))


(init-rule-file)

;;;------------------------------------------------------------------------------------------
;;; Trigger
;;;------------------------------------------------------------------------------------------


;;;------------------------------------------------------------------------------------------
;;; Globale Variable fuer Prog Koerper
;;;------------------------------------------------------------------------------------------

(defvar *return* nil "Transformationsmodus des innersten prog-Koerpers")

;;;------------------------------------------------------------------------------------------
;;; fuer FranzLisp:
;;;------------------------------------------------------------------------------------------

(defrule and-fl-trigger MyTrigger 1
	(fl::|and| ?*body ?last)
	==>
	(fl::|and| ?*,(mapcar #'TransformToBoolean ?*body)
		   ?,(TransformForm ?last *outer*))
	(Franz-Trigger)
	(NoProtocol)
	((author "Matthias Ressel") (created "Sun Nov 30 17:11:49 1986")))

(defrule append-fl-trigger MyTrigger 1
	(fl::|append| ?*body ?last)
	==>
	(fl::|append| ?*,(mapcar #'TransformListIgnoreTopCopy ?*body)
		?,(TransformStandard ?last))
	(Franz-Trigger)
	(NoProtocol)
((author "Matthias Ressel") (created "Tue Feb 3 17:41:32 1987")))

(defrule apply-fl-trigger MyTrigger 1
   (fl::|apply| ?foo ?arg)
   ==>
   (fl::|apply| ?,(TransformMyFunction ?foo *outer*)
		?,(TransformStandard ?arg))
   (Franz-Trigger)
   (noprotocol)
   ((author "Matthias Ressel")(created "16.10.1987, 16:00")))

(defrule array-fl-trigger MyTrigger 1
   (fl::|array| ?name ?type ?*dims)
   ==>
   (fl::|array| ?,(TransformVariable ?name)
    ?,(TransformType ?type)
    ?*,(mapcar #'TransformInteger ?*dims))
   (Franz-Trigger)
   (NoProtocol)
 ((author "Matthias Ressel") (created "16.09.1987, 22:41")))

(defrule backquote-fl-trigger.1 MyTrigger 1
	`?arg ; (qu* ?arg)
	(eq *outer* 'MyMacro)
	==>
	`?,(MyTriggerBackquoteLevel ?arg 0 'Code) ; (qu* ?,(MyTrigger...))
	(Franz-Trigger)
	(NoProtocol)
	((author "Matthias Ressel") (created "Wed Dec 3 18:35:48 1986")
	 (modified-by "Andreas Girgensohn") (modified "22.10.1987, 13:50")))

(defrule backquote-fl-trigger.2 MyTrigger 1
	`?arg ; (qu* ?arg)
	(not (eq *outer* 'MyMacro))
	==>
	`?,(MyTriggerBackquoteLevel ?arg 0 'Data) ; (qu* ?,(MyTrigger...))
	(Franz-Trigger)
	(NoProtocol)
	((author "Matthias Ressel") (created "Wed Dec 3 18:35:48 1986")
	 (modified-by "Andreas Girgensohn") (modified "22.10.1987, 13:50")))

(defrule break-fl-trigger MyTrigger 1
	(fl::|break| ?message ?pred)
	==>
	(fl::|break| ?message ?,(TransformToBoolean ?pred))
	(Franz-Trigger)
	(NoProtocol)
	((author "Matthias Ressel") (created "Fri Dec 26 19:20:31 1986")
	 ($needed$)))

(defrule catch-fl-trigger MyTrigger 1
	(fl::|catch| ?expr ?*tag)
	==>
	(fl::|catch| ?,(TransformStandard ?expr) ?*,(if ?*tag (TransformTag ?*tag)))
	(Franz-Trigger)
	(NoProtocol)
	((author "Matthias Ressel") (created "Fri Dec 26 19:15:48 1986")
	 ($needed$)))

(defrule comma-trigger MyTrigger 1
   , ??
   ==>
   ?$left$
   (Franz-Trigger)
   (NoProtocol)
 ((author "Matthias Ressel") (created "09.10.1987, 17:54")))

(defrule comment-trigger MyTrigger 1
   (fl::|comment| ?*args)
   ==>
   (fl::|comment| ?*,(TransformPrognBody ?*args 'Standard))
   (protocol-format "I think you would like to have the content of~
                   ~% a comment converted, too~%")
   (Franz-Trigger)
   (NoProtocol)
 ((author "Matthias Ressel") (created "09.10.1987, 18:09")))

(defrule cond-fl-trigger MyTrigger 1
	(fl::|cond| ?*clauses)
	==>
	(fl::|cond| ?*,(mapcar #'MyTriggerCondClauses ?*clauses))
	(Franz-Trigger)
	(NoProtocol)
	((author "Matthias Ressel") (created "Sun Nov 23 18:54:10 1986")
	 ($needed$)))


(defrule declare-fl-Trigger MyTrigger 1
	(fl::|declare| ?*declarations)
	==>
        ?,(TransformDeclaration ?$left$)
	(Franz-Trigger)
	(NoProtocol)
((modified-by "Matthias Ressel")(modified "07.09.1987, 21:31")
 (author "Andreas Girgensohn") (created "Fri Jan 23 14:26:51 1987")))

(defrule def-macro-fl-trigger MyTrigger 2
	(fl::|def| ?foo (fl::|macro| ?args ?*body))
	==>
	(fl::|def| ?,(TransformFunctionVariable ?foo)
(fl::|macro| ?,(MyTriggerFlMacroArgList ?args)
		 ?*,(TransformBody ?*body 'MyMacro)))
	(Franz-Trigger)
	(NoProtocol)
	((modified-by "Matthias Ressel")(modified "07.09.1987, 20:18")
	 (author "Matthias Ressel") (created "Tue Feb 3 18:28:21 1987")
 ($needed$)))

(defrule def-lambda-fl-trigger MyTrigger 2
	(fl::|def| ?foo (fl::|lambda| ?args ?*body))
	==>
	(fl::|def| ?,(transformfunctionvariable ?foo)
(fl::|lambda| ?,(MyTriggerFlLambdaArgList ?args)
		 ?*,(TransformBody ?*body 'Standard)))
	(Franz-Trigger)
	(NoProtocol)
	((modified-by "Matthias Ressel") (modified "07.09.1987, 20:18")
 (author "Matthias Ressel") (created "Fri Dec 26 19:12:29 1986")
 ($needed$)))

(defrule def-fl-trigger MyTrigger 1
	(fl::|def| ?foo (?type ?args ?*body))
	==>
	(fl::|def| ?,(TRANSFORMFUNCTIONVARIABLE ?foo)
(?type ?,(MyTriggerFlArgList ?args)	; CCC nlambda lexpr ???
		 ?*,(TransformBody ?*body 'Standard)))
	(Franz-Trigger)
	(NoProtocol)
	((modified-by "Matthias Ressel") (modified "07.09.1987, 20:18")
 (author "Matthias Ressel") (created "Fri Dec 26 19:12:29 1986")
 ($needed$)))

(defrule defmacro-fl-trigger MyTrigger 1
	(fl::|defmacro| ?foo ?args-list ?*body)
	==>
	(fl::|defmacro| ?,(TransformFunctionVariable ?foo)
			?,(MyTriggerFlMacroArgList ?args-list)
?*,(TransformBody ?*body 'MyMacro))
	(Franz-Trigger)
	(NoProtocol)
((modified-by "Matthias Ressel") (modified "07.09.1987, 20:19")
 (author "Matthias Ressel") (created "Tue Feb 3 17:49:41 1987")
 ($needed$)))

(defrule defprop-fl-trigger MyTrigger 1
   (fl::|defprop| ?sym ?value ?index)
   ==>
   (fl::|defprop| ?,(Data ?sym) ?,(Data ?value) ?,(Data ?index))
   (Franz-Trigger)
   (NoProtocol)
 ((modified-by "Matthias Ressel")(modified "16.12.1987, 19:53")
  (author "Andreas Girgensohn") (created "19.10.1987, 9:38")))

(defrule defun-fl-trigger MyTrigger 2
	(?def:{fl::|defun| fl::|de|} ?foo ?arg-list:listp ?*body)
	==>
	(?def ?,(TransformFunctionVariable ?foo) ?,(MyTriggerFlLambdaArgList ?arg-list)
?*,(TransformBody ?*body 'Standard))
	(Franz-Trigger)
	(NoProtocol)
	((author "Matthias Ressel") (created "Wed Nov 19 16:17:15 1986")
	 (modified-by "Schwab, Thomas") (modified "16.10.1987, 15:04")
	 ($needed$)))
;
;(defrule defun-fl-trigger.2 MyTrigger 1
;   (?def:{fl::|defun| fl::|de|} ?foo fl::|nil| ?*body)
;   ==>
;   (?def ?,(TransformFunctionVariable ?foo) nil ?*,(TransformBody ?*body 'Standard))
;   (Franz-Trigger)
;   (NoProtocol)
; ((author "") (created "17.11.1987, 11:31")))

(defrule defun-macro-fl-trigger MyTrigger 1
	(fl::|defun| ?foo fl::|macro| ?args-list ?*body)
	==>
	(fl::|defun| ?,(TransformFunctionVariable ?foo) fl::|macro| ?,(MyTriggerFlMacroArgList ?args-list)
?*,(TransformBody ?*body 'MyMacro))
	(Franz-Trigger)
	(NoProtocol)
	((modified-by "Matthias Ressel") (modified "07.09.1987, 20:23")
 (author "Matthias Ressel") (created "Tue Feb 3 17:59:59 1987")
 ($needed$)))

(defrule defun-else-fl-trigger MyTrigger 1
	(fl::|defun| ?foo ?type:{fl::|fexpr| fl::|expr| fl::|args|} ?args-list ?*body)
	==>
	(fl::|defun| ?,(TransformFunctionVariable ?foo) ?type ?,(MyTriggerFlArgList ?args-list)
?*,(TransformPrognBody ?*body 'Standard))
	(Franz-Trigger)
	(NoProtocol)
	((modified-by "Matthias Ressel") (modified "Wed Apr 15 21:15:19 1987")
 (author "Matthias Ressel") (created "Wed Nov 19 16:20:47 1986")
 ($needed$)))

(defrule desetq-fl-trigger MyTrigger 1
	(fl::|desetq| ?*body::(not (null IT)))
	==>
	(fl::|desetq| ?*,(MyTriggerDesetq ?*body))
	(Franz-Trigger)
	(NoProtocol)
	((author "Matthias Ressel") (created "Fri Dec 26 19:27:26 1986")
	 ($needed$)))
;
;;
;;(defrule do-type1-nil-fl-trigger MyTrigger 2
;;	 (fl::|do| fl::|nil|
;;		   (?condition)
;;		   ?*body)
;;	 ==>
;;	 (fl::|do| nil
;;		   (?,(TransformStandard ?condition))
;;		   ?*,(TransformProgBody ?*body *outer*))	; prog body !!!!
;;	 (Franz-Trigger)
;;	 (NoProtocol)
;;	 ((modified-by "Dieter Holz") (modified "17.11.1987, 11:42")
;;	  ($needed$)))
;
;(defrule do-type2-nil-fl-trigger MyTrigger 2
;	 (fl::|do| fl::|nil|
;		   (?test ?*testacts)
;		   ?*body)
;	 ==>
;	 (fl::|do| nil
;		   (?,(TransformToBoolean ?test)
;		     ?*,(TransformPrognBody ?*testacts *outer*))
;		   ?*,(TransformProgBody ?*body *outer*))
;	 (Franz-Trigger)
;	 (NoProtocol)
;	 ((modified-by "Dieter Holz") (modified "17.11.1987, 11:42")
;	  ($needed$)))

(defrule do-simple-fl-trigger MyTrigger 1
	(fl::|do| ?symbol:(and (symbolp IT) IT) ?init ?repeat ?test ?*body)
	==>
	(fl::|do| ?symbol
  ?,(TransformStandard ?init)
  ?,(TransformStandard ?repeat)
  ?,(TransformToBoolean ?test)
  ?*,(TransformProgBody ?*body *outer*)) ; do body = prog body !!!
	(Franz-Trigger)
	(NoProtocol)
	((author "Matthias Ressel") (created "Sun Nov 23 19:37:16 1986")
	 (modified-by "Matthias Ressel") (modified "07.09.1987, 20:41")
	 ($needed$)))

(defrule do-type1-fl-trigger MyTrigger 1
	(fl::|do| (?*params)
  (?condition)
  ?*body)
	==>
	(fl::|do| ?,(mapcar #'MyTriggerDoBindings ?*params)
  (?,(TransformStandard ?condition))
  ?*,(TransformProgBody ?*body *outer*)) ; prog body !!!!
	(Franz-Trigger)
	(NoProtocol)
	((modified-by "Matthias Ressel") (modified "Mon Dec 22 19:17:29 1986")
	 ($needed$)))

(defrule do-type2-fl-trigger MyTrigger 1
	(fl::|do| (?*params)
  (?test ?*testacts)
  ?*body)
	==>
	(fl::|do| (?*,(mapcar #'MyTriggerDoBindings ?*params))
  (?,(TransformToBoolean ?test)
   ?*,(TransformPrognBody ?*testacts *outer*))
  ?*,(TransformProgBody ?*body *outer*))
	(Franz-Trigger)
	(NoProtocol)
	((modified-by "Matthias Ressel") (modified "Wed Apr 15 21:23:34 1987")
	 ($needed$)))

(defrule eval-when-fl-trigger MyTrigger 1
	(fl::|eval-when| (?*tags) ?*body)
	==>
	(fl::|eval-when| (?*,(mapcar #'TransformTag ?*tags))
		   ?*,(TransformPrognBody ?*body 'Standard))
	(Franz-Trigger)
	(NoProtocol)
	((modified-by "Matthias Ressel") (modified "07.09.1987, 20:46")
 (author "Matthias Ressel") (created "Fri Dec 26 19:33:16 1986")
	 ($needed$)))

(defrule for-fl-trigger MyTrigger 1
	(fl::|for| ?*for-clauses)
	==>
	(fl::|for| ?*,(mapcar #'MyTriggerForClauses ?*for-clauses))
	(Franz-Trigger)
	(NoProtocol)
((author "Matthias Ressel") (created "Sun Apr 26 20:16:18 1987")))

(defruleset MyTriggerForClauses (forclause))

(defrule for-clause-when-fl-trigger MyTriggerForClauses 3
	(fl::|when| ?x)
	==>
	(fl::|when| ?,(TransformToBoolean ?x))
	(Franz-Trigger)
	(NoProtocol)
((author "Matthias Ressel") (created "Sun Apr 26 20:17:21 1987")))

(defrule for-clause-in-fl-trigger MyTriggerForClauses 2
	(?var fl::|in| ?list)
	==>
	(?,(TransformVariable ?var) fl::|in| ?,(TransformListIgnoreTopCopy ?list))
	(Franz-Trigger)
	(NoProtocol)
((modified-by "Andreas Girgensohn")(modified "20.10.1987, 21:14")
 (author "Matthias Ressel") (created "Sun Apr 26 20:18:03 1987")))

(defrule for-clause-save-fl-trigger MyTriggerForClauses 1
	(fl::|save| ?x)
	==>
	(fl::|save| ?,(TransformStandard ?x))
	(Franz-Trigger)
	(NoProtocol)
((author "Matthias Ressel") (created "Sun Apr 26 20:19:00 1987")))

(defrule for-clause-splice-fl-trigger MyTriggerForClauses 1
	(fl::|splice| ?x)
	==>
	(fl::|splice| ?,(TransformListIgnoreTopCopy ?x))
	(Franz-Trigger)
	(NoProtocol)
((author "Matthias Ressel") (created "Sun Apr 26 20:19:35 1987")))

(defrule for-clause-do-fl-trigger MyTriggerForClauses 1
	(fl::|do| ?*x)
	==>
	(fl::|do| ?*,(TransformPrognBody ?*x 'IgnoreResult))
	(Franz-Trigger)
	(NoProtocol)
((author "Matthias Ressel") (created "Sun Apr 26 20:21:24 1987")))

(defrule for-clause-filter-fl-trigger MyTriggerForClauses 1
	(fl::|filter| ?*x)
	==>
	(fl::|filter| ?*,(TransformPrognBody ?*x 'TransformStandard))	; ??
	(Franz-Trigger)
	(NoProtocol)
((author "Andreas Girgensohn")(created "22.10.1987, 13:49")))

(defrule funcall-fl-trigger MyTrigger 1
   (fl::|funcall| ?foo ?*args)
   ==>
   (fl::|funcall| ?,(TransformMyFunction ?foo *outer*)
		?*,(mapcar #'TransformStandard ?*args))
   (Franz-Trigger)
   (noprotocol)
   ((author "Matthias Ressel")(created "16.10.1987, 16:00")))

(defrule function-fl-trigger MyTrigger 1
	(?func:{fl::|function| function} ?arg)	; #' --> function
	==>
	(?func ?,(Transformlambda1 ?arg *outer*))
	(Franz-Trigger)
	(NoProtocol)
((modified-by "Andreas Girgensohn") (modified "16.10.1987, 20:29")
 (author "Matthias Ressel") (created "Wed Jan 28 17:03:09 1987")))

(defrule if-fl-trigger MyTrigger 1
	(fl::|if| ?test ?then)
	==>
	(fl::|if| ?,(TransformToBoolean ?test) ?,(TransformForm ?then *outer*))
	(Franz-Trigger)
	(NoProtocol)
	((author "Matthias Ressel") (created "Fri Dec 26 19:37:26 1986")))

(defrule if-fl-trigger-2 MyTrigger 1
	(fl::|if| ?test ?then ?else)
	==>
	(fl::|if| ?,(TransformToBoolean ?test)
  ?,(TransformForm ?then *outer*)
  ?,(TransformForm ?else *outer*))
	(Franz-Trigger)
	(NoProtocol)
	((author "Matthias Ressel") (created "Fri Dec 26 19:38:17 1986")))

(defrule insert-fl-trigger MyTrigger 1
   (fl::|insert| ?obj ?list ?func ?nodups)
   ==>
   (fl::|insert| ?,(TransformStandard ?obj) ?,(TransformStandard ?list)
		 ?,(TransformMyFunction ?func 'TransformToBoolean)
		 ?,(TransformToBoolean ?nodups))
   (Franz-Trigger)
   (NoProtocol)
 ((modified-by "Matthias Ressel")(modified "16.12.1987, 19:54")
  (author "Andreas Girgensohn") (created "18.10.1987, 19:49")))

(defrule  let-fl-trigger MyTrigger 1
	(?foo:{fl::|let| fl::|let*|} (?*params) ?*body)
	==>
	(?foo (?*,(mapcar #'MyTriggerLetBindings ?*params))
    ?*,(TransformBody ?*body *outer*))
	(Franz-Trigger) 
	(NoProtocol)
	((modified-by "Matthias Ressel") (modified "07.09.1987, 20:52")
 (author "Matthias Ressel") (created "Sun Nov 23 19:28:11 1986")
 ($needed$)))

(defrule map-ignore-result-fl-trigger MyTrigger 1
   (?map-foo:{fl::|mapc| fl::|map|}
       ?foo ?*args)
   ==>
   (?map-foo ?,(TransformMyFunction ?foo 'IgnoreResult)
		?*,(mapcar #'TransformStandard ?*args))
   (Franz-Trigger)
   (noprotocol)
   ((author "Matthias Ressel")(created "16.10.1987, 16:00")))

(defrule map-fl-trigger MyTrigger 1
   (?map-foo:{fl::|mapcar| fl::|mapcan|
    fl::|mapcon| fl::|maplist|}
       ?foo ?*args)
   ==>
   (?map-foo ?,(TransformMyFunction ?foo *outer*)
		?*,(mapcar #'TransformStandard ?*args))
   (Franz-Trigger)
   (noprotocol)
   ((author "Matthias Ressel")(created "16.10.1987, 16:00")))

(defrule merge-fl-trigger MyTrigger 1
   (fl::|merge| ?list-1 ?list-2 ?func)
   ==>
   (fl::|merge| ?,(TransformStandard ?list-1) ?,(TransformStandard ?list-2)
		?,(TransformMyFunction ?func 'TransformToBoolean))
   (Franz-Trigger)
   (NoProtocol)
 ((author "Andreas Girgensohn") (created "18.10.1987, 19:56")))

(defrule msg-trigger MyTrigger 1
   (fl::|msg| ?*msg-forms)
   ==>
   (fl::|msg| ?*,(mapcar #'TransformMsgForms ?*msg-forms))
   (Franz-Trigger)
   (NoProtocol)
 ((author "Matthias Ressel") (created "08.11.1987, 18:59")))

(defrule keep-N TransformMsgForms 1
   fl::N
   ==>
   N
   (Franz-Trigger)
   (NoProtocol)
 ((author "Matthias Ressel") (created "08.11.1987, 19:01")))

(defrule keep-B TransformMsgForms 1
   fl::B
   ==>
   B
   (Franz-Trigger)
   (NoProtocol)
 ((author "Matthias Ressel") (created "08.11.1987, 19:01")))

(defrule msg-port TransformMsgForms 1
   (fl::P ?port)
   ==>
   (P ?,(TransformPort ?port))
   (Franz-Trigger)
   (NoProtocol)
 ((author "Matthias Ressel") (created "08.11.1987, 19:03")))

(defrule  not-fl-trigger-1 MyTrigger 1
	(?foo:{fl::|null| fl::|not|} ?a)
	(eq *outer* 'IgnoreResult)
	==>
	(?foo ?,(TransformIgnoreResult ?a))
	(Franz-Trigger) 
	(NoProtocol)
	((modified-by "Matthias Ressel") (modified "07.09.1987, 20:53")))

(defrule  not-fl-trigger-2 MyTrigger 1
	(?foo:{fl::|null| fl::|not|} ?a)
	(not (eq *outer* 'IgnoreResult))
	==>
	(?foo ?,(TransformToBoolean ?a))          
	(Franz-Trigger) 
	(NoProtocol)
	((author "Matthias Ressel") (created "Wed Jan 28 17:20:28 1987")
	 (modified-by "Matthias Ressel") (modified "Wed Jan 28 17:18:48 1987")))

(defrule  or-fl-trigger-1 MyTrigger 1
	(fl::|or| ?*body ?last)
        (eq *outer* 'IgnoreResult)
	==>
	(fl::|or| ?*,(mapcar #'TransformToBoolean ?*body)
  ?,(TransformForm ?last *outer*))
	(Franz-Trigger) 
	(NoProtocol)
	((author "Matthias Ressel") (created "Sun Nov 30 17:22:21 1986")
	 (modified-by "Matthias Ressel") (modified "Mon Dec 22 19:08:33 1986")))

(defrule  or-fl-trigger-2 MyTrigger 1
	(fl::|or| ?*body ?last)
        (not (eq *outer* 'IgnoreResult))
	==>
	(fl::|or| ?*,(map-on-first 'TransformForm ?*body *outer*)
  ?,(TransformForm ?last *outer*))
	(Franz-Trigger) 
	(NoProtocol)
	((author "Matthias Ressel") (created "Mon Dec 22 19:09:21 1986")))

(defrule pop-fl-trigger MyTrigger 1
   (fl::|pop| ?stack)
   ==>
   (fl::|pop| ?,(TransformVariable ?stack))
   (Franz-Trigger)
   (NoProtocol)
 ((author "Matthias Ressel") (created "16.09.1987, 21:47")))

(defrule  prog-fl-trigger MyTrigger 1
	(fl::|prog| ?params ?*body)
	==>
	(fl::|prog| ?,(Symbol ?params) ?*,(TransformProgBody ?*body *outer*))
	(Franz-Trigger) 
	(NoProtocol)
((modified-by "Matthias Ressel") (modified "07.09.1987, 20:59")
 ($needed$)))

(defrule  prog1-fl-trigger MyTrigger 1
	(fl::|prog1| ?first-expr ?*body)
	==>
	(fl::|prog1| ?,(TransformForm ?first-expr *outer*)
     ?*,(TransformPrognBody ?*body 'IgnoreResult))
	(Franz-Trigger) 
	(NoProtocol)
	((modified-by "Matthias Ressel") (modified "Wed Apr 15 21:22:45 1987")))

(defrule  prog2-fl-trigger MyTrigger 1
	(fl::|prog2| ?first-expr ?second-expr ?*rest)
	==>
	(fl::|prog2| ?,(TransformIgnoreResult ?first-expr) 
     ?,(TransformForm ?second-expr *outer*)
     ?*,(TransformPrognBody ?*rest 'IgnoreResult))
	(Franz-Trigger) 
	(NoProtocol)
	((modified-by "Matthias Ressel") (modified "Wed Apr 15 21:22:33 1987")))

(defrule progn-compile-trigger MyTrigger 10 
	(fl::|progn| 'fl::|compile| ?*body)
        ==>
	(fl::|progn| 'fl::|compile| ?*,(TransformPrognBody ?*body *outer*))
	(Franz-Trigger) 
	(NoProtocol)
	((author "Matthias Ressel") (created "Thu Dec  4 13:14:41 1986")
	 (modified-by "Matthias Ressel") (modified "Wed Apr 15 23:31:53 1987")
	 ($needed$)))

(defrule  progn-fl-trigger MyTrigger 1
	(fl::|progn| ?*body)
	==>
	(fl::|progn| ?*,(TransformPrognBody ?*body *outer*))
	(Franz-Trigger) 
	(NoProtocol)
((modified-by "Matthias Ressel") (modified "Wed Apr 15 21:25:59 1987")))

(defrule  progv-fl-trigger MyTrigger 1
	(fl::|progv| ?localvars (?*initexpr) ?*body)
	==>
	(fl::|progv| ?,(Symbol ?localvars) (?*,(mapcar #'TransformStandard ?*initexpr))
     ?*,(TransformPrognBody ?*body *outer*))
	(Franz-Trigger)
	(NoProtocol)
((modified-by "Matthias Ressel") (modified "07.09.1987, 20:59")
 (author "Matthias Ressel") (created "Wed Jan 28 16:56:16 1987")
 ($needed$)))

(defrule push-fl-trigger MyTrigger 1
   (fl::|push| ?form ?stack)
   ==>
   (fl::|push| ?,(TransformStandard ?form)
   ?,(TransformVariable ?stack)) 
   (Franz-Trigger)
   (NoProtocol)
 ((author "Matthias Ressel") (created "16.09.1987, 21:49")))

(defrule putd-fl-trigger MyTrigger 1
   (fl::|putd| ?sym ?func)
   ==>
   (fl::|putd| ?,(TransformStandard ?sym) ?,(TransformMyFunction ?func 'TransformToBoolean))
   (Franz-Trigger)
   (NoProtocol)
 ((modified-by "Matthias Ressel")(modified "16.12.1987, 19:54")
  (author "Andreas Girgensohn") (created "18.10.1987, 19:56")))

(defrule  quote/function-fl-trigger MyTrigger 2
	(?quote:{quote fl::|quote| function fl::|function|} ?arg)
	(eq *outer* 'MyFunction)
	==>
	(?quote ?,(Transformlambda1 ?arg *fouter*))
	(Franz-Trigger) 
	(NoProtocol)
	((modified-by "Andreas Girgensohn")(modified "19.10.1987, 9:07")
	 ($needed$)))

(defrule  quote-fl-trigger-2 MyTrigger 1
	(?quote:{quote fl::|quote|} ?arg)
	(not (eq *outer* 'MyFunction))
	==>
	(?quote ?,(Data ?arg))
	(Franz-Trigger) 
	(NoProtocol)
	((modified-by "Andreas Girgensohn")(modified "19.10.1987, 9:07")
	 ($needed$)))

(defrule  return-fl-trigger MyTrigger 2
	(fl::|return| ?x)
	*return*
	==>
	(fl::|return| ?,(TransformForm ?x *return*))	; *return* = Standard, ... ?????
	(Franz-Trigger) 
	(NoProtocol)
	((author "Matthias Ressel") (created "Sun Nov 23 19:46:12 1986")
	 (modified-by "Matthias Ressel") (modified "Wed Mar 11 16:45:24 1987")))

(defrule  return-nil-fl-trigger MyTrigger 2
	(fl::|return|)
	(null *return*)
	==>
	?$left$
	(Franz-Trigger) 
	(NoProtocol)
	((author "Matthias Ressel") (created "Sun Apr 26 17:32:56 1987")))

(defrule  return-fl-trigger-unawaited MyTrigger 1
	(fl::|return| ?*)
	==>
	?$left$
	(protocol-format "%Warning: ~s~%~
                  no enclosing prog or do" ?$left$)
	(Franz-to-Common Space Speed Port)
	(NoProtocol)
((modified-by "Matthias Ressel")(modified "16.12.1987, 19:11")
 (author "Matthias Ressel") (created "Wed Apr 15 21:29:10 1987")))

(defrule  selectq-fl-trigger MyTrigger 1
	(?selectq:{fl::|selectq| fl::|caseq|} ?expr ?*selectclauses)
	==>
	(?selectq ?,(TransformStandard ?expr)
		 ?*,(mapcar #'MyTriggerSelectClause ?*selectclauses))
	(Franz-Trigger) 
	(NoProtocol)
	((author "Matthias Ressel") (created "Sun Nov 30 16:52:06 1986")
	 ($needed$)))

(defrule setf-MyTrigger MyTrigger 1
   (fl::|setf| ?*updatings)
   ==>
   (fl::|setf| ?*,(MyTriggerUpdatings ?*updatings)) 
   (Franz-Trigger)
   (NoProtocol)
 ((author "Matthias Ressel") (created "16.09.1987, 21:58")))

(defrule setq-MyTrigger MyTrigger 1
   (fl::|setq| ?*assignments)
   ==>
   (fl::|setq| ?*,(MyTriggerAssignments ?*assignments)) 
   (Franz-Trigger)
   (NoProtocol)
 ((author "Matthias Ressel") (created "01.09.1987,  0:47")))

(defrule sort-fl-trigger MyTrigger 1
   (?sort:{fl::|sort| fl::|sortcar|} ?list ?func)
   ==>
   (?sort ?,(TransformStandard ?list) ?,(TransformMyFunction ?func 'TransformToBoolean))
   (Franz-Trigger)
   (NoProtocol)
 ((modified-by "Matthias Ressel")(modified "16.12.1987, 19:54")
  (author "Andreas Girgensohn") (created "18.10.1987, 19:56")))

(defrule  unwind-protect-fl-trigger MyTrigger 1
	(fl::|unwind-protect| ?first-expr ?*body)
	==>
	(fl::|unwind-protect|
	  ?,(TransformForm ?first-expr *outer*)
	  ?*,(TransformPrognBody ?*body 'IgnoreResult))
	(Franz-Trigger) 
	(NoProtocol)
	((created-by "Matthias Ressel")(created "16.09.1987, 22:07")))

(defrule  pure-function-fl-trigger MyTrigger 0
	(?foo:pure-function? ?*args)		
        (eq *outer* 'IgnoreResult)
	==>
	(?,(TransformLambda2 ?foo *outer*) ?*,(TransformIgnoreResult ?*args))
	(Franz-Trigger) 
	(NoProtocol)
	((author "Matthias Ressel") (created "Thu Dec  4 13:15:52 1986")
	 (modified-by "Matthias Ressel") (modified "Wed Feb  4 22:05:57 1987")))

;;; CCC Die naechsten beiden Regeln werden noch etwas zerplueckt werden:
;;; CCC z.B. eine Unterscheidung von Standard Non-Standard (nach Foderaro et al.)

;;; zunaechst die Regeln fuer Standard Funktionen
;;; CCC vgl. File standard.types in translisp:doc;

(defrule  franz-common-lambdas-trigger MyTrigger -10
	  (?foo:{fl::|1+| fl::|1-| fl::|*| fl::|<|   
		 fl::|>=| fl::|abs| fl::|append| fl::|apply| fl::|atom| fl::|boundp| fl::|car|
		 fl::|cdr| fl::|caar| fl::|cadr| fl::|cdar| fl::|cddr| fl::|caaar| fl::|caadr|
		 fl::|cadar| fl::|cdaar| fl::|caddr| fl::|cdadr| fl::|cddar| fl::|cdddr|
		 fl::|caaaar| fl::|caaadr| fl::|caadar| fl::|cadaar| fl::|cdaaar|
		 fl::|caaddr| fl::|cadadr| fl::|caddar| fl::|cdadar| fl::|cddaar|
		 fl::|cadddr| fl::|cdaddr| fl::|cddadr| fl::|cdddar| fl::|cddddr| fl::|close|
		 fl::|cons| fl::|eq| fl::|equal| fl::|eval| fl::|evenp| fl::|exp| fl::|expt|
		 fl::|fixp| fl::|float| fl::|floatp| fl::|format| fl::|funcall|
		 fl::|get| fl::|intern| fl::|last| fl::|length|
		 fl::|list| fl::|listp| fl::|load|
		 fl::|macroexpand| fl::|makunbound| fl::|mapc| fl::|mapcan| fl::|mapcar|
		 fl::|mapcon| fl::|maplist| fl::|max| fl::|min| fl::|nconc| fl::|not|
		 fl::|nreconc| fl::|nreverse| fl::|nthcdr| fl::|null| fl::|numberp|
		 fl::|oddp| fl::|princ| fl::|print| fl::|reverse| fl::|rplaca| fl::|rplacd|
		 fl::|set| fl::|sort| fl::|sqrt| fl::|stringp| fl::|terpri|
		 fl::|unwind-protect| fl::|zerop|}
		?*args)
	  ==>
	  (?,(TransformLambda2 ?foo *outer*) ?*,(mapcar #'TransformStandard ?*args))
	  (Franz-Trigger)
	  (NoProtocol)
  ((author "Matthias Ressel")(created-by "08.11.1987, 17:15")))

(defrule franz-standard-lambdas-trigger MyTrigger -10
   (?foo:{fl::* fl::|*array| fl::|*break| fl::|*makhunk| fl::|*mod| fl::|*quo| fl::|*rplacx|
          fl::|*rset| fl::|*throw| fl::1+ fl::1- fl::< fl::<= fl::= fl::> fl::>= fl::|abs|
          fl::|add-syntax-class| fl::|aexplode| fl::|aexplodec| fl::|aexploden| fl::|allocate|
          fl::|append| fl::|arg| fl::|argv| fl::|arraydims| fl::|arrayp| fl::|arrayref|
          fl::|assoc| fl::|assq| fl::|atom| fl::|bignum-leftshift| fl::|bignum-to-list|
          fl::|bigp| fl::|boundp| fl::|caaaar| fl::|caaadr| fl::|caaar| fl::|caadar|
          fl::|caaddr| fl::|caadr| fl::|caar| fl::|cadaar| fl::|cadadr| fl::|cadar|
          fl::|caddar| fl::|cadddr| fl::|caddr| fl::|cadr| fl::|car| fl::|cdaaar| fl::|cdaar|
          fl::|cdadar| fl::|cdaddr| fl::|cdadr| fl::|cdar| fl::|cddaar| fl::|cddadr|
          fl::|cddar| fl::|cdddar| fl::|cddddr| fl::|cdddr| fl::|cddr| fl::|cdr| fl::|cfasl|
          fl::|close| fl::|concat| fl::|concatl| fl::|condclosefile| fl::|cons| fl::|copy|
          fl::|copyint*| fl::|cprintf| fl::|debugging| fl::|delete| fl::|delq| fl::|divide|
          fl::|drain| fl::|dtpr| fl::|emuldiv| fl::|eq| fl::|equal| fl::|eval| fl::|evenp|
          fl::|exece| fl::|exit| fl::|exp| fl::|explode| fl::|explodec| fl::|exploden|
          fl::|expt| fl::|fasl| fl::|ffasl| fl::|fileopen| fl::|filepos| fl::|fillarray|
          fl::|fixp| fl::|float| fl::|floatp| fl::|fork| fl::|format| fl::|franz-top-level|
          fl::|freturn| fl::|frexp| fl::|get| fl::|getaccess| fl::|getaddress| fl::|getaux|
          fl::|getdata| fl::|getdelta| fl::|getdisc| fl::|getentry| fl::|getenv| fl::|getl|
          fl::|getlength| fl::|getsyntax| fl::|haipart| fl::|hashtabstat| fl::|haulong|
          fl::|i-throw-err| fl::|if| fl::|implode| fl::|includef| fl::|infile| fl::|insert|
          fl::|intern| fl::|kwote| fl::|last| fl::|lconc| fl::|length| fl::|lessp| fl::|let|
          fl::|let*| fl::|list| fl::|list*| fl::|list-to-bignum| fl::|listarray| fl::|listp|
          fl::|load| fl::|lsubst| fl::|macroexpand| fl::|maknam| fl::|maknum| fl::|makunbound|
          fl::|marray| fl::|max| fl::|member| fl::|memq| fl::|mfunction| fl::|min|
          fl::|monitor| fl::|nconc| fl::|neq| fl::|nequal| fl::|not| fl::|nreconc|
          fl::|nreverse| fl::|nthcdr| fl::|null| fl::|numberp| fl::|nwritn| fl::|oblist|
          fl::|oddp| fl::|opval| fl::|or| fl::|outfile| fl::|pop| fl::|princ| fl::|print|
          fl::|probef| fl::|ptime| fl::|ptr| fl::|purcopy| fl::|purep| fl::|putaccess|
          fl::|putaux| fl::|putdata| fl::|putdelta| fl::|putdisc| fl::|putlength|
          fl::|putprop| fl::|ratom| fl::|read| fl::|readlist| fl::|rematom| fl::|remove|
          fl::|removeaddress| fl::|replace| fl::|reset| fl::|reverse| fl::|rot| fl::|rplaca|
          fl::|rplacd| fl::|scons| fl::|segment| fl::|set| fl::|setarg| fl::|setsyntax|
          fl::|shell| fl::|signal| fl::|sizeof| fl::|sload| fl::|small-segment| fl::|sort|
          fl::|sqrt| fl::|sticky-bignum-leftshift| fl::|stringp| fl::|subpair|
          fl::|substringn| fl::|syscall| fl::|tab| fl::|tconc| fl::|terpri| fl::|valuep|
          fl::|wait| fl::|xcons| fl::|zapline| fl::|zerop|} ?*args)
   ==>
   (?,(TransformLambda2 ?foo *outer*) ?*,(mapcar #'TransformStandard ?*args))
   (Franz-Trigger)
   (NoProtocol)
 ((author "Matthias Ressel") (created "16.09.1987, 22:18")))

(defrule franz-standard-nlambdas-with-no-args-trigger MyTrigger -10
   (?foo:{fl::|baktrace| fl::|gc| fl::|resetio| fl::|showstack|})
   ==>
   ?$left$
   (Franz-Trigger)
   (NoProtocol)
 ((author "Matthias Ressel") (created "16.09.1987, 22:32")))

(defrule franz-standard-nlambdas-else-trigger MyTrigger -10
   (?foo:{fl::|comment| fl::|debug|
          fl::|dumplisp| fl::|exec| fl::|gcafter| fl::|help|
          fl::|include| fl::|pp| fl::|process|
	  fl::|sstatus| fl::|status|} ?*args)
   ==>
   ?$left$
   (Franz-Trigger)
   (NoProtocol)
 ((author "Matthias Ressel") (created "16.09.1987, 22:18")))

(defrule no-args-trigger MyTrigger -15
   (?foo)
   ==>
   (?,(TransformLambda2 ?foo *outer*))
   (Franz-Trigger)
   (NoProtocol)
 ((modified-by "Andreas Girgensohn")(modified "25.11.1987, 17:49")
  (author "Andreas Girgensohn") (created "20.10.1987, 20:08")))

(defrule franz-non-standard-lambda-trigger MyTrigger -19
   (?foo:{fl::|load-if-needed| fl::|load-file| fl::|include-file|} ?*args)
   ==>
   (?,(TransformLambda2 ?foo *outer*) ?*,(mapcar 'TransformStandard ?*args))
   (Franz-Trigger)
   (NoProtocol)
 ((author "Matthias Ressel") (created "09.10.1987, 18:52")))

(defrule franz-foos-trigger MyTrigger -20	       ; zuletzt probieren
   (?foo:{fl::|*array| fl::|*break| fl::|*catch| fl::|*dif| fl::|*invmod|
          fl::|*makhunk| fl::|*mod| fl::|*quo| fl::|*rplacx| fl::|*rset| fl::|*throw|
          fl::|Divide| fl::|Emuldiv| fl::|I-throw-err| fl::|add-syntax-class|
          fl::|aexplode| fl::|aexplodec| fl::|aexploden| fl::|allocate| fl::|allsym|
          fl::|any-zerop| fl::|apply*| fl::|arg| fl::|argv| fl::|array|
          fl::|array-type| fl::|arraycall| fl::|arraydims| fl::|arrayp| fl::|arrayref|
          fl::|baktrace| fl::|baktraceprint| fl::|bcdcad| fl::|bcdcall|
          fl::|bignum-leftshift| fl::|bignum-to-list| fl::|bigp| fl::|bindstack|
          fl::|break-err-handler| fl::|case-scan| fl::|charcnt| fl::|charsinbuf|
          fl::|cib| fl::|comment| fl::|compile| fl::|concatl| fl::|condclosefile|
          fl::|copyint*| fl::|cprintf| fl::|cputim| fl::|cpy1| fl::|cr|
          fl::|de-compose| fl::|debug| fl::|debug-err-handler| fl::|debugging|
          fl::|def| fl::|defcmacro| fl::|defsetf| fl::|defun| fl::|deref| fl::|desetq|
          fl::|df| fl::|dir-home| fl::|dir-lisplib| fl::|dm| fl::|double-to-float|
          fl::|drain| fl::|drm| fl::|dsm| fl::|dumplisp| fl::|environment|
          fl::|environment-files| fl::|environment-syntax| fl::|eq-tyimode|
          fl::|err-with-message| fl::|errset| fl::|ev-arraycall| fl::|eval1|
          fl::|every| fl::|ex| fl::|exec| fl::|exece| fl::|exit| fl::|exl|
          fl::|explode| fl::|explodec| fl::|exploden| fl::|fasl-a-file| fl::|fclosure|
          fl::|fclosure-alist| fl::|fclosure-function| fl::|fclosure-list|
          fl::|fclosurep| fl::|feature-present| fl::|ffasl| fl::|fileopen|
          fl::|filepos| fl::|filestat| fl::|fillarray| fl::|fillarrayarray|
          fl::|float-to-double| fl::|fork| fl::|framedump| fl::|franz-reset|
          fl::|franz-top-level| fl::|freturn| fl::|frexp| fl::|gc| fl::|gcafter|
          fl::|getaccess| fl::|getaddress| fl::|getaux| fl::|getdata| fl::|getdelta|
          fl::|getdisc| fl::|getentry| fl::|getenv| fl::|getl| fl::|getlength|
          fl::|getsyntax| fl::|haipart| fl::|hashtabstat| fl::|haulong| fl::|help|
          fl::|hunk-to-list| fl::|implode| fl::|in-tyimode| fl::|include|
          fl::|include-file| fl::|include-if| fl::|includef| fl::|includef-if|
          fl::|initsym| fl::|initsym1| fl::|insert| fl::|killcopy| fl::|kwote|
          fl::|lambdacvt| fl::|lconc| fl::|linelength| fl::|lineread|
          fl::|list-to-bignum| fl::|listarray| fl::|listify| fl::|liszt-declare|
          fl::|liszt-define| fl::|litatom| fl::|load-autorunobject| fl::|loop|
          fl::|lsubst| fl::|make-equivalent| fl::|make-fclosure-with-alist|
          fl::|make-list-array| fl::|maknam| fl::|maknum| fl::|marray| fl::|merge1|
          fl::|mergelists| fl::|mfunction| fl::|monitor| fl::|msg| fl::|msg-print|
          fl::|msg-tyo-char| fl::|namestack| fl::|new-vectori-byte|
          fl::|new-vectori-long| fl::|new-vectori-word| fl::|newsym| fl::|nwritn|
          fl::|oblist| fl::|opval| fl::|pp| fl::|process| fl::|prtpageused|
          fl::|ptime| fl::|ptr| fl::|purcopy| fl::|purep| fl::|putaccess| fl::|putaux|
          fl::|putdata| fl::|putdelta| fl::|putdisc| fl::|putlength| fl::|pv%|
          fl::|quote!| fl::|quote!-expr-mac| fl::|quotify| fl::|quotify1| fl::|ratom|
          fl::|rematom| fl::|removeaddress| fl::|remq| fl::|remsym| fl::|remsym1|
          fl::|replace| fl::|reset| fl::|resetio| fl::|roman-char| fl::|roman-step|
          fl::|rot| fl::|sassoc| fl::|sassq| fl::|scons| fl::|segment|
          fl::|set-in-closure| fl::|setarg| fl::|setf-check| fl::|cad+r|
          fl::|setsyntax| fl::|shell| fl::|showstack| fl::|showstack-baktrace|
          fl::|signal| fl::|signp| fl::|sizeof| fl::|sl-print| fl::|sload|
          fl::|small-segment| fl::|some| fl::|sortcarhelp| fl::|sortmerge|
          fl::|splitlst| fl::|sprintf| fl::|sstatus| fl::|status|
          fl::|sticky-bignum-leftshift| fl::|storeintern| fl::|strip-extension|
          fl::|sublishelp| fl::|subpair| fl::|subpr| fl::|subst-eq| fl::|subst-eqp|
          fl::|substeq| fl::|substequal| fl::|substringn| fl::|symeval-in-fclosure|
          fl::|symstat| fl::|syscall| fl::|tab| fl::|tconc| fl::|termcapexe|
          fl::|termcapinit| fl::|tilde-expand| fl::|time-string| fl::|top-eval|
          fl::|top-init| fl::|top-level| fl::|top-print| fl::|top-prompt|
          fl::|top-read| fl::|top-reader-off| fl::|top-reader-on| fl::|trace-funp|
          fl::|truename| fl::|tyimode| fl::|uncompile| fl::|undef-fun-handler|
          fl::|valuep| fl::|vector-dump| fl::|vectori-byte| fl::|vectori-long|
          fl::|vectori-word| fl::|vectorip| fl::|vget| fl::|vi| fl::|vil| fl::|vprop|
          fl::|vputprop| fl::|vsetprop| fl::|vsize-byte| fl::|vsize-word| fl::|wait|
          fl::|without-path| fl::|xcons| fl::|zapline|}
	 ?*args)
   ==>
   (?,(TransformLambda2 ?foo *outer*) ?*,(mapcar #'TransformStandard ?*args))
   (debug-format "%Warning: Assuming ~s~:* to be a lambda~%~
                            If not, insert a MyTrigger rule for ~s~%" ?foo)
   (Franz-Trigger)
   (NoProtocol)
((author "Andreas Girgensohn") (created "Tue Jan 20 17:22:52 1987")))

(defrule cad*rp-MyTrigger MyTrigger 1
   (?foo:cad*rp ?x)
   ==>
   (?foo ?,(TransformStandard ?x))
   (Franz-Trigger)
   (NoProtocol)
 ((author "Matthias Ressel") (created "09.10.1987, 18:05")))

(defrule  general-lambda-MyTrigger MyTrigger -100
	(?foo:lambdap ?*args)
	==>
	(?,(TransformLambda2 ?foo *outer*) ?*,(mapcar #'TransformStandard ?*args))
	(Speed Space Portability Readability Franz-to-Common Machine) 
	(NoProtocol)
((modified-by "Andreas Girgensohn") (modified "20.10.1987, 19:14")))

(defrule  general-MyTrigger MyTrigger -200
	(?foo ?*args)
	==>
	(?,(TransformLambda2 ?foo *outer*) ?*,(mapcar #'TransformStandard ?*args))
	(progn (pushnew ?foo *assumed-lambdas*)
	       ;; (protocol-format "%Note: Assuming ~s~:* to be a lambda~%" ?foo)
	       )
	(Speed Space Portability Readability Franz-to-Common Machine) 
	(NoProtocol)
((modified-by "Andreas Girgensohn") (modified "20.10.1987, 19:14")))

; CCC DIe folgende REgeln verletzen Design-Regeln
;(defrule  general-lambda-standard Standard -100
;	(?foo:lambdap ?*args)
;	==>
;	(?,(Transformlambda2 ?foo *outer*) ?*args)
;	(Speed Space Portability Readability Franz-to-Common Machine) 
;	(NoProtocol)
;((modified-by "Andreas Girgensohn") (modified "20.10.1987, 19:13")))
;
;(defrule  general-standard Standard -200
;	(?foo ?*args)
;	==>
;	(?,(Transformlambda2 ?foo *outer*) ?*args)
;	(Speed Space Portability Readability Franz-to-Common Machine) 
;	(NoProtocol)
;((modified-by "Andreas Girgensohn") (modified "20.10.1987, 19:13")))

;;;------------------------------------------------------------------------------------------
;;; Hilfsregeln fuer Trigger
;;;------------------------------------------------------------------------------------------

;;;------------------------------------------------------------------------------------------
;;; FranzLisp let, do, lambda-body
;;;------------------------------------------------------------------------------------------

;;; MyTriggerMacroBody: MyTriggerDefBody mit *last* = Macro


(defruleset MyTriggerLetBody (body *last*)
  :special *last*
  ;:used-by (let-MyTrigger trigger-def-body-1 trigger-def-body-3)
  )

(defrule trigger-let-body-with-declare MyTriggerLetBody 1
	(?decl:(match '(declare ?*) IT) ?*rest)
	==>
	(?,(TransformDeclaration ?decl)
	 ?*,(MyTriggerLetBody ?*body *last*))
	(Franz-to-Common Machine)
	(NoProtocol)
((modified "01.09.1987,  1:24")(modified-by "Matthias Ressel")
 (author "Andreas Girgensohn") (created "Thu Jan 22 12:28:37 1987")))

(defrule trigger-let-body-without-declare MyTriggerLetBody 0	       ; zuletzt probieren
	(?*body)
	==>
	(?*,(TransformPrognBody ?*body *last*))
	(Franz-to-Common Machine)
	(NoProtocol)
((modified "01.09.1987,  1:25")(modified-by "Matthias Ressel")
 (author "Andreas Girgensohn") (created "Thu Jan 22 12:29:33 1987")))


(defruleset MyTriggerPrognBody (body *last*) ""
  :special *last*
  :used-by (catch-MyTrigger compiler-let-MyTrigger progn-MyTrigger flet-MyTrigger
  if-MyTrigger eval-when-MyTrigger))

(defrule Trigger-progn-body MyTriggerPrognBody 1
   (?*forms ?last)
   ==>
   (?*,(mapcar #'TransformIgnoreResult ?*forms)
     ?,(TransformForm ?last *last*))
   (Franz-Trigger)
   (NoProtocol)
 ((author "Matthias Ressel") (created "01.09.1987,  1:18")))

;;;------------------------------------------------------------------------------------------
;;; Arglists
;;;------------------------------------------------------------------------------------------

(defruleset MyTriggerFlLambdaArglist (arglist)
  :else (MyTriggerFlArgList arglist))

(defruleset MyTriggerFlMacroArglist (arglist)
  :else (MyTriggerFlArgList arglist))

(defruleset MyTriggerFlArgList (arglist))

(defruleset MyTriggerFlArgKeywords (arglist))

(defruleset MyTriggerFlArgOptional (arglist))

(defruleset MyTriggerFlArgKey (arglist))

(defrule  lambda-list-MyTrigger-1 MyTriggerFlArgList 2
	(?*params ?lambda-keyword:{fl::|&optional| fl::|&rest| fl::|&key| fl::|&aux|} ?*rest)
	==>
	(?*,(mapcar #'TransformDestructuringVariable ?*params)
?*,(MyTriggerFlArgKeywords ?`(?lambda-keyword ?*rest)))
	(Franz-Trigger)
	(NoProtocol)
((modified-by "Matthias Ressel")(modified "03.09.1987, 19:33")
 (author "Andreas Girgensohn,,") (created "Sat Jan 24 12:07:31 1987")))

(defrule  lambda-list-MyTrigger-2 MyTriggerFlArgList 1
	(?*params)
	==>
	(?*,(mapcar #'TransformDestructuringVariable ?*params))
	(Franz-Trigger)
	(NoProtocol)
((author "Andreas Girgensohn,,") (created "Sat Jan 24 12:07:31 1987")))

(defrule  lambda-list-MyTrigger-3 MyTriggerFlArgList 1
	fl::|nil|
	==>
	nil
	(debug-format "%Warning: Diese Regel lambda-list-MyTrigger-3~%~
                       sollte eigentlich nie triggern")
	(Franz-Trigger)
	(NoProtocol)
((modified-by "Andreas Girgensohn")(modified "17.11.1987, 11:33")
 (author "Andreas Girgensohn,,") (created "Sat Jan 24 12:07:31 1987")))

(defrule  lambda-list-optional-MyTrigger-1 MyTriggerFlArgKeywords 2
	(fl::|&optional| ?*opt-params ?lambda-keyword:{fl::|&rest| fl::|&key| fl::|&aux|} ?*rest)
	==>
	(&optional ?*,(mapcar #'MyTriggerFlArgOptional ?*opt-params)
		   ?*,(MyTriggerFlArgKeywords ?`(?lambda-keyword ?*rest)))
	(Franz-Trigger)
	(NoProtocol)
((modified-by "Matthias Ressel")(modified "03.09.1987, 19:34")
 (author "Andreas Girgensohn,,") (created "Sat Jan 24 12:07:31 1987")))

(defrule  lambda-list-optional-MyTrigger-2 MyTriggerFlArgKeywords 1
	(fl::|&optional| ?*opt-params)
	==>
	(&optional ?*,(mapcar #'MyTriggerFlArgOptional ?*opt-params))
	(Franz-Trigger)
	(NoProtocol)
((modified-by "Matthias Ressel")(modified "03.09.1987, 19:34")
 (author "Andreas Girgensohn,,") (created "Sat Jan 24 12:07:31 1987")))

(defrule  lambda-list-rest-MyTrigger-1 MyTriggerFlArgKeywords 2
	(fl::|&rest| ?rest-param ?lambda-keyword:{fl::|&key| fl::|&aux|} ?*rest)
	==>
	(&rest ?,(TransformDestructuringVariable ?rest-param)
     ?*,(MyTriggerFlArgKeywords ?`(?lambda-keyword ?*rest)))
	(Franz-Trigger)
	(NoProtocol)
((modified-by "Matthias Ressel")(modified "03.09.1987, 19:34")
 (author "Andreas Girgensohn,,") (created "Sat Jan 24 12:07:31 1987")))

(defrule  lambda-list-rest-MyTrigger-2 MyTriggerFlArgKeywords 1
	(fl::|&rest| ?rest-param)
	==>
	(&rest ?,(TransformDestructuringVariable ?rest-param))
	(Franz-Trigger)
	(NoProtocol)
((modified-by "Matthias Ressel")(modified "03.09.1987, 19:34")
 (author "Andreas Girgensohn,,") (created "Sat Jan 24 12:07:31 1987")))

(defrule  lambda-list-key-MyTrigger-1 MyTriggerFlArgKeywords 2
	(fl::|&key| ?*key-params fl::|&aux| ?*aux-vars)
	==>
	(&key ?*,(mapcar #'MyTriggerFlArgKey ?*key-params)
    &aux ?*,(mapcar #'MyTriggerFlArgOptional ?*aux-vars))
	(Franz-Trigger)
	(NoProtocol)
((modified-by "Matthias Ressel")(modified "03.09.1987, 19:34")
 (author "Andreas Girgensohn,,") (created "Sat Jan 24 12:07:31 1987")))

(defrule  lambda-list-key-MyTrigger-2 MyTriggerFlArgKeywords 1
	(fl::|&key| ?*key-params)
	==>
	(&key ?*,(mapcar #'MyTriggerFlArgKey ?*key-params))
	(Franz-Trigger)
	(NoProtocol)
((modified-by "Matthias Ressel")(modified "03.09.1987, 19:34")
 (author "Andreas Girgensohn,,") (created "Sat Jan 24 12:07:31 1987")))

(defrule  lambda-list-aux-MyTrigger MyTriggerFlArgKeywords 1
	(fl::|&aux| ?*aux-vars)
	==>
	(&aux ?*,(mapcar #'MyTriggerFlArgOptional ?*aux-vars))
	(Franz-Trigger)
	(NoProtocol)
((modified-by "Matthias Ressel")(modified "03.09.1987, 19:34")
 (author "Andreas Girgensohn,,") (created "Sat Jan 24 12:07:31 1987")))

(defrule  &optional-MyTrigger-1 MyTriggerFlArgOptional 1
	?param:symbolp
	==>
	?,(TransformVariable ?param)
	(Franz-Trigger)
	(NoProtocol)
((author "Andreas Girgensohn,,") (created "Sat Jan 24 12:40:20 1987")))

(defrule  &optional-MyTrigger-2 MyTriggerFlArgOptional 1
	(?param:symbolp ?init ?*supplied-p)
	==>
	(?,(TransformDestructuringVariable ?param)
?,(TransformStandard ?init)
?*,(TransformVariable ?*supplied-p))
	(Franz-Trigger)
	(NoProtocol)
((author "Andreas Girgensohn,,") (created "Sat Jan 24 12:43:48 1987")))

(defrule  &key-MyTrigger-1 MyTriggerFlArgKey 1
	((?keyword ?param))
	==>
	((?,(TransformKeyword ?keyword) ?,(TransformDestructuringVariable ?param)))
	(Franz-Trigger)
	(NoProtocol)
((author "Andreas Girgensohn,,") (created "Sat Jan 24 12:47:23 1987")))

(defrule  &key-MyTrigger-2 MyTriggerFlArgKey 1
	((?keyword ?param) ?init ?*supplied-p)
	==>
	((?,(TransformKeyword ?keyword)
 ?,(TransformDestructuringVariable ?param))
	 ?,(TransformStandard ?init)
	 ?*,(TransformVariable ?*supplied-p))
	(Franz-Trigger)
	(NoProtocol)
((author "Andreas Girgensohn,,") (created "Sat Jan 24 12:49:09 1987")))

;;;------------------------------------------------------------------------------------------
;;; destructuring special forms and macros
;;;------------------------------------------------------------------------------------------

(defruleset MyTriggerAssignments (assignments)
  :used-by (setq-mytrigger))

(defrule Trigger-assignments MyTriggerAssignments 1
   (?var ?form ?*assignments)
   ==>
   (?,(TransformVariable ?var) ?,(TransformStandard ?form)
      ?*,(MyTriggerAssignments ?*assignments))
   (Franz-Trigger)
   (NoProtocol)
 ((author "Matthias Ressel") (created "01.09.1987,  1:02")))

(defruleset MyTriggerCondClauses (clause)
  :special *outer*)

(defrule  condclauses-trigger-1 MyTriggerCondClauses 1
	(?x)
	==>
	(?,(if (member *outer* '(Boolean IgnoreResult))	; CCC ??????!!!
     (TransformToBoolean ?x)
     (TransformStandard ?x)))
	(Franz-Trigger) 
	(NoProtocol)
	((modified-by "Matthias Ressel")(modified "08.09.1987, 16:20")
	 (author "Matthias Ressel") (created "Sun Nov 23 18:57:04 1986")))

(defrule  condclauses-trigger-2 MyTriggerCondClauses 1
	(?x ?y)
	==>
	(?,(TransformToBoolean ?x)
	 ?,(TransformForm ?y *outer*))
	(Franz-Trigger) 
	(NoProtocol)
	((author "Matthias Ressel") (created "Sun Nov 23 18:59:02 1986")))

(defrule  condclauses-trigger-n MyTriggerCondClauses 1
	(?x ?*y)
	==>
	(?,(TransformToBoolean ?x)
	 ?*,(TransformPrognBody ?*y *outer*))
	(Franz-Trigger) 
	(NoProtocol)
	((modified-by "Matthias Ressel") (modified "Wed Apr 15 21:29:54 1987")
 (author "Matthias Ressel") (created "Sun Nov 23 19:01:30 1986")))

(defruleset MyTriggerDesetq  (desetqassignments))

(defrule desetq-assignments-trigger MyTriggerDesetq 1
   (?destructured-var ?form ?*rest)
   ==>
   (?,(Symbol ?destructured-var)
     ?,(transformstandard ?form)
     ?*,(MyTriggerDesetq ?*rest))
   (Franz-Trigger)
   (NoProtocol)
 ((author "Matthias Ressel") (created "07.09.1987, 20:40")))

(defruleset mytriggerdobindings (expr))

(defrule  do-bindings-trigger-1 MyTriggerDoBindings 1
	(?x ?*y)
	==>
	(?,(TransformVariable ?x) ?*,(mapcar #'TransformStandard ?*y))
	(Franz-Trigger) 
	(NoProtocol)
	((author "Matthias Ressel") (created "Sun Nov 23 19:42:20 1986")
	 (modified-by "Matthias Ressel") (modified "Fri Dec 26 19:42:55 1986")))

(defruleset mytriggerletbindings (expr))

(defrule  letbindings-trigger-1 MyTriggerLetBindings 2
	(?x ?y)
	==>
	(?,(TransformVariable ?x) ?,(TransformStandard ?y))
	(Franz-Trigger) 
	(NoProtocol)
	((author "Matthias Ressel") (created "Sun Nov 23 19:34:11 1986")))

(defrule  letbindings-trigger-2 MyTriggerLetBindings 2
	(?x)
	==>
	(?,(TransformVariable ?x))
	(Franz-Trigger) 
	(NoProtocol)
	((author "Andreas Girgensohn") (created "18.10.1987, 21:45")))

(defrule  letbindings-trigger-3 MyTriggerLetBindings 1
	?x
	==>
	?,(TransformVariable ?x)
	(Franz-Trigger) 
	(NoProtocol)
	((author "Andreas Girgensohn") (created "18.10.1987, 21:45")))


(defruleset Mytriggerlambda (lambda-expr)
  :special *louter*)

(defrule  lambda-trigger MyTriggerLambda 1
	(fl::|lambda| ?params ?*body)
	==>
	(fl::|lambda| ?,(MyTriggerFlLambdaArgList ?params)
 ?*,(TransformPrognBody ?*body *louter*))
	(Franz-Trigger) 
	(NoProtocol)
	((author "Matthias Ressel") (created "Wed Jan 28 17:06:09 1987")
	 (modified-by "Matthias Ressel") (modified "Wed Jan 28 17:03:58 1987")))

(defruleset MyTriggerUpdatings (updatings)
  :used-by (setf-mytrigger))

(defrule Trigger-updatings MyTriggerUpdatings 1
   (?place ?form ?*updatings)
   ==>
   (?,(TransformPlace ?place) ?,(TransformStandard ?form)
      ?*,(MyTriggerUpdatings ?*updatings))
   (Franz-Trigger)
   (NoProtocol)
 ((author "Matthias Ressel") (created "16.09.1987, 22:03")))

;;;------------------------------------------------------------------------------------------
;;; Ruecksetzen der Readersyntax
;;;------------------------------------------------------------------------------------------

(clean-rule-file)				; resets Reader-Syntax
						; if file compiles up to here
