; -*- mode:     CL -*- ----------------------------------------------------- ;
; File:         zebu-mg-hierarchy.l
; Description:  types and printers for the meta grammar
; Author:       Joachim H. Laubsch
; Created:      13-May-92
; Modified:     Fri Mar 12 12:10:57 1993 (Joachim H. Laubsch)
; Language:     CL
; Package:      ZEBU
; Status:       Experimental (Do Not Distribute) 
; RCS $Header: $
;
; (c) Copyright 1992, Hewlett-Packard Company
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Revisions:
; RCS $Log: $
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(in-package "ZEBU")
(provide "zebu-mg-domain")
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;                   Top of hierarchy for ZEBU META-Grammar
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


(DEFSTRUCT (ZEBU-MG (:INCLUDE KB-DOMAIN)
                    (:CONSTRUCTOR NIL)))

(proclaim '(special *kb-empty-sequence* *KB-SEPARATOR-HT*))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;                                 KB-SEQUENCE
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defstruct (KB-SEQUENCE (:include ZEBU-MG)
			(:constructor make-kb-sequence-aux (first rest))
			(:print-function
			 (lambda (ITEM STREAM LEVEL)
			   (DECLARE (IGNORE LEVEL))
			   (unless (eq ITEM *kb-empty-sequence*)
			     (let ((first (KB-SEQUENCE-first ITEM))
				   (rest  (KB-SEQUENCE-rest ITEM)))
			       (if (eq rest *kb-empty-sequence*)
				   (format STREAM "~S" first)
				 (let ((separator (KB-SEQUENCE-separator ITEM)))
				   (format STREAM "~S" first)
				   (do-kb-sequence
				       #'(lambda (it)
					   (format STREAM "~A~S" separator it))
				     rest)))))))) 
  first
  (rest *kb-empty-sequence*))

(defun make-kb-sequence (&key (first nil first-p)
			      (rest *kb-empty-sequence* rest-p)
			      (separator " " separator-p))
  (if (and (null first-p) (null rest-p))
      *kb-empty-sequence*
    (let ((seq (make-kb-sequence-aux first rest)))
      (when separator-p
	(when rest-p (remhash rest *kb-separator-HT*))	  
	(setf (gethash seq *kb-separator-HT*) separator))
      seq)))


(defvar *kb-empty-sequence* (make-kb-sequence :first nil :rest nil))
(defvar *kb-separator-HT* (make-hash-table))

(defun KB-SEQUENCE-separator (seq)
  (or (gethash seq *kb-separator-HT*)
      " "))

(defun do-kb-sequence (fn seq)
  (if (kb-sequence-p seq)
      (if (eq seq *kb-empty-sequence*)
	  nil
	(progn (funcall fn (KB-SEQUENCE-first seq))
	       (do-kb-sequence fn (KB-SEQUENCE-rest seq))))
    (funcall fn seq)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;                                  FEAT-TERM
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(DEFSTRUCT (FEAT-TERM (:INCLUDE Zebu-mg)
		      #||
		      (:print-function
		       (lambda (ITEM STREAM LEVEL)
			 (DECLARE (IGNORE LEVEL))
			 (format STREAM
				 "~@[type: ~S ~][~{~S~^ ~}]"
				 (FEAT-TERM--type ITEM)
				 (FEAT-TERM--slots ITEM))))
		      ||#
		      )
  -TYPE
  -SLOTS)

(DEFSTRUCT (LABEL-VALUE-PAIR (:INCLUDE ZEBU-MG)
			     #||
			     (:print-function
			      (lambda (ITEM STREAM LEVEL)
				(DECLARE (IGNORE LEVEL))
				(format STREAM
					"(~S ~S)"
					(Label-value-pair--label ITEM)
					(Label-value-pair--value ITEM))))
			     ||#
			     )
           -LABEL
           (-VALUE nil))

#|| Not used yet
(DEFSTRUCT (GENERAL-VAR (:INCLUDE ZEBU-MG)
			#||
			(:print-function
			 (lambda (ITEM STREAM LEVEL)
			   (DECLARE (IGNORE LEVEL))
			   (format STREAM
				   "%~S"
				   (General-Var--name ITEM))))
			||#
			)
           -NAME)

(DEFSTRUCT (TAGGED-TERM (:INCLUDE ZEBU-MG)
			#||
			(:print-function
			 (lambda (ITEM STREAM LEVEL)
			   (DECLARE (IGNORE LEVEL))
			   (format STREAM
				   "~S=~S"
				   (Tagged-Term--tag ITEM)
				   (Tagged-Term--term ITEM))))
			||#
			)
           -TERM
           -TAG)
||#

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;                               PRODUCTION-RHS
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(DEFSTRUCT (PRODUCTION-RHS (:INCLUDE ZEBU-MG)
			   #||
			   (:print-function print-production-rhs)
			   ||#
			   )
  (-SYNTAX nil)
  -SEMANTICS
  -BUILD-FN)

(defun print-production-rhs (ITEM STREAM LEVEL)
  (DECLARE (IGNORE LEVEL))
  (format STREAM
	  "~{~S ~}~@[ { ~S }~];"
	  (production-rhs--syntax ITEM)
	  (production-rhs--semantics ITEM)))

(DEFSTRUCT (Kleene (:INCLUDE ZEBU-MG) )
           -constituent
           -separator)

(DEFSTRUCT (Kleene* (:INCLUDE Kleene) ))
(DEFSTRUCT (Kleene+ (:INCLUDE Kleene) ))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;                              Type definitions
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defstruct (domain-type (:include zebu-mg))
  -supertype -type -slots print-function)

(defun cons-domain-type (name avm print-function)
  ;; Return: [supertype type slots print-function]
  (let ((type (if (feat-term-p avm)
		  (feat-term--type avm)
		'KB-Domain))
	(slots (if (feat-term-p avm)
		   (feat-term--slots avm)
		 avm)))
    (make-domain-type
     :-supertype type
     :-type name
     :-slots (mapcar #'(lambda (slot)
			 (let ((v (label-value-pair--value slot)))
			   (if (null v)
			       (label-value-pair--label slot)
			     (list (label-value-pair--label slot) v))))
		     slots)
     :print-function print-function)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;                        End of zebu-mg-hierarchy.l
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
