; -*- mode:     CL -*- ----------------------------------------------------- ;
; File:         regex-test.lisp
; Description:  some tests for the regular expression compiler
; Author:       Joachim H. Laubsch
; Created:       9-Feb-93
; Modified:     Tue Feb 23 14:43:00 1993 (Joachim H. Laubsch)
; Language:     CL
; Package:      ZEBU
; Status:       Experimental (Do Not Distribute) 
; RCS $Header: $
;
; (c) Copyright 1993, Hewlett-Packard Company
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Revisions:
; RCS $Log: $
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(in-package "ZEBU")
(setq *regex-debug* nil)
(defun match-end (n)
  (second (AREF *REGEX-GROUPS* n)))

(defun regex-test (n pat string result &key invert)
  (let ((f (regex-compile pat :anchored t))
	*print-circle*)
    (princ ".")
    (setf *foo* f)
    (if (funcall f string 0 (length string))
	(let ((matched-string (subseq string 0 (match-end 0))))
	  (if (string= matched-string result)
	      (if invert
		  (warn "In ~S ~A did not match correctly" n pat)
		t)
	    (if invert
		t
	      (warn "In ~S ~A did not match correctly~%Only ~S was matched!"
		    n pat matched-string))))
      (if invert
	  t
	(warn "In ~S ~A did not compile correctly" n pat)))))
       
(regex-test 1 "\\(na\\)x+\\1" "naxna" "naxna")
(regex-test 2 "\\(na\\)x+\\1" "naxna123" "naxna")

(regex-test 3 "\\(na\\)x+" "naxxos" "naxx")
(regex-test 4 "\\(na\\)x+" "naxos" "nax")
(regex-test 5 "\\(na\\)x+" "naos" "na" :invert t)

(regex-test 6 "\\(na\\)x*" "naxxos" "naxx")
(regex-test 7 "\\(na\\)x*" "naxos" "nax")
(regex-test 8 "\\(na\\)x*" "naos" "na")

(regex-test 9 "[0-9]+" "123ab" "123")
(regex-test 10 "[a-zA-Z]+" "aAbb123" "aAbb")
(regex-test 11 "[0-9a-z]+" "1234&&*" "1234")
(regex-test 12 "[0-9a-z]+" "1234a&&*" "1234a")

(regex-test 13 "[0-9a-zA-Z]+" "a1234a" "a1234a")
(regex-test 14 "[0-9a-zA-Z&]+" "aAbb123&&*" "aAbb123&&")

(regex-test 15 "[0-9]+\\.[0-9]*" "0.123cm" "0.123")

(regex-test 16 "{[^}\\n]*}"
	    "{M.D. Harrison and A. Monk (Ed.)} \n\t foo: 2"
	    "{M.D. Harrison and A. Monk (Ed.)}")

(regex-test 17 "{[^}\\n]*}"
	    "{M.D. Harrison and
A. Monk (Ed.)} \n\t foo: 2"
	    "{M.D. Harrison and A. Monk (Ed.)}" :invert t)


(regex-test 18 "{[^}\\n]*}"
	    "{M.D. Harrison and {A. Monk} (Ed.)} \n\t foo: 2"
	    "{M.D. Harrison and {A. Monk} (Ed.)}" :invert t)

(regex-test 19 "ca?r" "car" "car")

(regex-test 20 "ca?r" "cr" "cr")

(regex-test 21 "c[ad]+r" "caaar" "caaar")

(regex-test 22 "c[ad]+r" "caaar aa1" "caaar")

(regex-test 23 "c[ad]+r$" "caaar" "caaar")

(regex-test 24 ".*" "" "")

(regex-test 25 ".*" "aa" "aa")

(regex-test 26 ".*" "aa" "aa")

(regex-test 27 "c[ad]?r" "cr" "cr")

(regex-test 28 "c[ad]?r" "car" "car")

(regex-test 29 "c[ad]?r" "cdr" "cdr")

(regex-test 30 "c[0-9]?r" "cr" "cr")

(regex-test 31 "c[0-9]?r" "c9rxx" "c9r")

(regex-test 32 "c[0-9]?r" "crxx" "cr")


;;(regex-test 27 "a\\|b" "a" "a")
;;(pprint *foo*)

(regex-test 33 "ab.yz" "ab yz" "ab yz")

(regex-test 34 "ab.yz" "ab
yz" "ab" :invert t)

(regex-test 35 "\\(abc\\)\\1" "abcabc" "abcabc")

(regex-test 36 "\\(abc\\)\\1x*\\(def\\)y*\\2" "abcabcxxxxdefyyyyyyydef$%%%%%"
	    "abcabcxxxxdefyyyyyyydef")

;;(regex-test 37 "a|bc*" "a" "a")

(eval (def-regex-parser 'number "[0-9]+"))
(unless (equal (number "11aab" 0 4) 2)
  (warn "No match"))

(unless (equal (number "11aab" 1 4) 2)
  (warn "No match"))

(when (equal (number "1aab" 1 4) 2)
  (warn "wrong match"))

(eval (def-regex-parser 'Rest_of_line ".+\$"))
(let* ((s "abcdef") (n (length s)))
  (unless (equal (REST_OF_LINE s 1 n) n)
    (warn "Rest_of_line did not compile correctly")))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;                           End of regex-test.lisp
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
