;;; -*- Mode: Lisp; Syntax: Common-Lisp; Package: GNODE -*-

;;; $Header: /afs/athena.mit.edu/course/other/allp/nlp/tools/RCS/gref.lisp,v 3.2 92/07/08 16:29:04 sfelshin Exp $

;;; Copyright (c) 1986-92 Massachusetts Institute of Technology.
;;; All rights reserved.
;;; Brought to you by the Athena Language Learning Project.
;;; "Bigger!  Better!  Slower!  28% More Fun!"

(in-package :gnode)

;;; Graphically display interlingua.
(provide-module :gref)

#||(global '(gref *gnode-all-warps-p*))||#

(require-module :nords :accessors t)
#||(use-package :grammar)||#

(require-module :interlingua :accessors t)
#||(use-package :interlingua)||#

(require-module :time-support)
#||(use-package :tardis)||#

(require-module :gnode-support)


;;; ================================================================

(defvar *gnode-all-warps-p* nil)

(defun gref (obj &key mod-p
		 ((:all-warps-p *gnode-all-warps-p*) *gnode-all-warps-p*)
		 ((:node-features *gnode-node-features*)
		  *gnode-node-features*))
  (etypecase obj
    (list
     (dolist (it obj)
       (gref it :mod-p mod-p)))
    (paragraph
     (let ((*current-node-plist* '()))
       (declare (special *current-node-plist*))
       (with-gnode-child "PARAGRAPH"
         (let ((*reported-snags* ()))
	   (declare (special *reported-snags*))
	   (local-penalty "e" (paragraph-snags obj)))
         (dolist (ref (paragraph-references obj))
	   (gref2 ref :mod-p mod-p)))
       (window-title
        (let ((box (paragraph-snord-box obj)))
          (mapcan #'(lambda (ref)
                      (when (ref-node ref)
                        (collect-leaves (ref-node ref) box)))
                  (paragraph-references obj)))
        "IL: ")
       #+:ccl (make-instance 'tree-window
                :window-title (getf *current-node-plist* :window-title)
                :node (first (getf *current-node-plist* :children)))))
    (reference
     (let ((*current-node-plist* '()))
       (declare (special *current-node-plist*))
       (gref2 obj :mod-p mod-p)
       (window-title (if (ref-node obj)
                       (collect-leaves (ref-node obj) nil)
                       '())
                     "IL: ")
       #+:ccl (make-instance 'tree-window
                :window-title (getf *current-node-plist* :window-title)
                :node (first (getf *current-node-plist* :children))))))
  obj)

(defun gref2 (obj &key mod-p line-type)
  (etypecase obj
    ;; 	     type    INTERR,EXCLAM,WH
    ;;		 pred
    ;;        rel    first warp or number
    (phrase
     (with-gnode-child (format nil "~(~S~)" (phrase-pred obj))
       (gnode-command (or line-type "b5"))
       (gnode-command "e" (type-of obj))		;upper left
       (let ((stuff ()))
	 (when (phrase-rel obj)
	   (push (phrase-rel obj) stuff)) 
	 (gnode-format "f~{~A~}" stuff))		;lower left
       (let ((stuff ()))
	 (when (phrase-interr-p obj)
	   (push "INTERR" stuff))
	 (when (phrase-exclam-p obj)
	   (when stuff (push "," stuff))
	   (push "EXCLAM" stuff))
	 (when (phrase-wh-p obj)
	   (when stuff (push "," stuff))
	   (push "WH" stuff))
	 (gnode-format "t~{~A~}" stuff))		;upper right
       (typecase obj
	 (v-phrase
	  (cond (*gnode-all-warps-p*
		 (with-gnode-child "WARPS"
		   (labels ((next (warps)
			      (unless (endp warps)
				(let ((warp (first warps)))
				  (with-gnode-child (warp-string warp)
				    (let ((*reported-snags* ()))
				      (declare (special *reported-snags*))
				      (local-penalty "e" (warp-snags warp)))
				    (gnode-command "l1")
				    (gnode-command "a4")
				    (next (rest warps)))))))
		     (next (v-phrase-tma obj))))
		 (unless (eq (v-phrase-voice obj) :active)
		   (gnode-format "s~A" (v-phrase-voice obj))))
		(t (let ((warp (first (v-phrase-tma obj))))
		     (gnode-format	;lower right
		      "s~:[~A; ~;~*~]~@[~D: ~]~A"
		      (eq (v-phrase-voice obj) :active) (v-phrase-voice obj)
		      (warp-penalty warp) (warp-string warp))))))
	 (n-phrase
	  (when (n-phrase-number obj)
	    (gnode-format "s~A" (n-phrase-number obj))))) ;lower right
       (dolist (arg (phrase-args obj))
	 (gref2 arg))
       (dolist (mod (phrase-mods obj))
	 (gref2 mod :mod-p t))))
    (quote-phrase
     (with-gnode-child (format nil "~(~S~)" (type-of obj))
       (gnode-command "b5")
       (gref2 (quote-phrase-quotation obj))))
    (essential-phrase
     (with-gnode-child (format nil "~(~S~)" (type-of obj))
       (gnode-command "b5")
       (gref2 (essential-phrase-pred obj))))
    (reference
     (with-gnode-child (ref-role obj)
       (let ((*reported-snags* ()))
	 (declare (special *reported-snags*))
	 (local-penalty "e" (ref-snags obj)))			;upper left
       (gnode-command (or line-type "b1"))
       (let ((instance (ref-instance obj)))
	 (when instance						;upper right
	   (gnode-format "t~S" instance))
	 (when mod-p
	   (gnode-command "l1"))
	 ;; If we don't use the lower right for the features, we can use it
	 ;; for the prominence.  Otherwise, make the prominence share the
	 ;; lower left with the how and via.
	 (let ((prom (case (ref-prominence obj)
		       (:emph-topic "EMPH-TOP")
		       (:topic-p "TOP?")
		       (:topic "TOP")
		       (:emph-focus "EMPH-FOC")
		       (:focus-p "FOC?")
		       (:focus "FOC")
		       (t nil)))
	       (used-s nil))
	   (when (and (ref-node obj)
		      *gnode-node-features*)
	     (setq used-s t)
	     (gnode-format "s~A"				;lower right
			   (nord-features (ref-node obj))))
	   (cond
	     (used-s
	      (when (or (ref-how obj) (ref-via obj) (ref-name-p obj)
			prom)
		(gnode-format
		 "f~@[~A~]~:[~; NAME~]~@[ via ~A~]~@[;~A~]" ;lower left
		 (ref-how obj) (ref-name-p obj) (ref-via obj) prom)))
	     (t
	      (when (or (ref-how obj) (ref-name-p obj) (ref-via obj))
		(gnode-format
		 "f~@[~A~]~:[~; NAME~]~@[ via ~A~]"		;lower left
		 (ref-how obj) (ref-name-p obj) (ref-via obj)))
	      (when prom
		(gnode-format "s~A" prom))))		;lower right
	   ;; Also put the role in boldface it the obj is prominent.
	   (when prom
	     (gnode-command "a3")))
	 (cond ((ref-phrase obj)
		(gref2 (ref-phrase obj)))
	       ((canned-node-p (ref-node obj))
		(gref2 (ref-node obj)))))))
    (canned-node
      (with-gnode-child (canned-node-surface-string obj)
	(gnode-command "b4")))
    ((or symbol string)
     (with-gnode-child obj))))
