
(in-package :CLIP-USER)

#|

This code is somewhat reconstructed, since I had to bypass a lot of stuff to get
my experiment to run, but I think it's all correct.  If it doesn't demonstrate
the behavior, let me know and I'll recreate it.

|#

(defclip tl-action-execution-duration (tl-entry)
  (:time-series t
   :output-file "execution-duration.clasp"
   :components (action-name action-start-time action-duration))
  (values (f:name-of tl-entry)
	  (tl-start-execution-time tl-entry)
	  (tl-execution-duration tl-entry)))

(clip:define-experiment PROJECTION-ATTEMPTS (seconds exp?)
  "Experiment to test the performance of ii-projection.  It varies the maximum number of attempts and
measures performance such as area burned, fireline built and shutdown time."
  :simulator PHOENIX
  
  :IVS ((max-attempts from 1 to 5)
	(fire-no      from 0 to 3))
  
  :SCRIPT
  ((start-fire #.(* 60 30) (send (fire-system) :start-fire 50 (cdr *point-lit*))))
  
  :AFTER-TRIAL
  (progn (collect-execution-duration)
	 (clip:write-current-experiment-data))
  
  :INSTRUMENTATION
  (point-lit
    ii-projection-attempts-made
    ii-projection-duration
    ii-projection-safety
    shutdown-time
    total-fireline-built
    area-contained
    area-burned
    tl-action-execution-duration  ; **** time-series clip ****
    ))

(defun collect-execution-duration ()
      (f:using-frame-system ((name-of (find-agent-by-name 'fireboss)))
	;; collect the execution duration of all ii-projections
	(let ((plan-step-name  (f:get-value 'act-ii-projection 'ako+inv)))
	  (dolist (tl-entry (f:get-values plan-step-name 'instance+inv))
	    '(clip:collect 'tl-action-execution-duration tl-entry)))))

