;;;; -*- Mode:Common-Lisp; Package:DSS; Base:10 -*-
;;;; *-* File: Titanic: /usr/users/eksl/mac-files/clips/demos/delay-experiment.lisp *-*
;;;; *-* Last-edit: Tuesday, February 2, 1993  20:21:19; Edited-By: WESTY *-* 
;;;; *-* Machine: Count (Explorer II, Microcode 489) *-*
;;;; *-* Software: TI Common Lisp System 6.49 *-*
;;;; *-* Lisp: TI Common Lisp System 6.49  *-*

;;;; **************************************************************************
;;;; **************************************************************************
;;;; *                                                                        *
;;;; *                            DELAY EXPERIMENT                            *
;;;; *                                                                        *
;;;; **************************************************************************
;;;; **************************************************************************
;;;
;;; Written by: Zachary B. Rubinstein
;;;             Department of Computer and Information Science
;;;             University of Massachusetts
;;;             Amherst, Massachusetts 01003.
;;;
;;; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
;;;
;;;  01-29-93 File Created.  (RUBINSTEIN)
;;;
;;; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

(in-package 'DSS)

;;; ---------------------------------------------------------------------------
;;; Clips
;;; ---------------------------------------------------------------------------

(clips:defclip total-delay ()
  "Overall Delay"
  ()
  (loop for order in (find-units 'order (make-paths '(scheduler * order)) :ALL)
	for local-delay-time = (- (task-network$finish-time (order$network order)) 
                                  (order$due-date-time order))
	summing local-delay-time))

;;; ---------------------------------------------------------------------------

(clips:defclip number-of-delays ()
  "Total Number of Delays"
  ()
  (loop for order in (find-units 'order (make-paths '(scheduler * order)) :ALL) 
	when (plusp (- (task-network$finish-time (order$network order)) 
		       (order$due-date-time order)))
	sum 1))

;;; ---------------------------------------------------------------------------
;;; Experiment
;;; ---------------------------------------------------------------------------

(clips:define-experiment uniform-constrained-resources-experiment (resource-type resource-count start-perc 
                                                                                 end-perc increment 
                                                                                 travel-time)
  "Using the OPPORTUNISTIC and ORDER-BY-ORDER rating schemes, constrain the resources and report the delays."
  ;; The function `run-arm' intializes and starts the system
  :start-system run-arm
  ;; Declare the independant variables
  :ivs ((rating-scheme '(:OPPORTUNISTIC :ORDER-BY-ORDER))
        (perc from start-perc downto end-perc by increment))
  ;; The local variable `last-resource-count' is used to keep track of actual resource usage
  :locals ((last-resource-count resource-count))
  ;; Declare what clips we will be collecting and reporting
  :instrumentation (trial-number rating-scheme perc total-delay number-of-delays)

  :before-experiment (when (not (or resource-count (= start-perc 100)))
		       (error "You must either specify resource-count or a start-perc of 100."))
  
  :before-trial (progn 
		  ;; Change the resource creation limits
		  (setf (get (resource-on-demand-entry resource-type) :max-creation-limit)
			(if last-resource-count
			    (round (* perc last-resource-count) 100)
			    nil)))

  :after-trial (progn
		 ;; `write-reports' is part of the ARM system, not CLIPS
		 (write-reports 
		   (generate-report-filename 
		     rating-scheme
		     travel-time
		     (length (all-orders *loaded-application*))
		     perc))
		 ;; This is where the data file is produced
		 (clips:write-current-experiment-data)
		 (unless last-resource-count 
		   (setf last-resource-count (number-of-existing-resources resource-type)))))

;;; ---------------------------------------------------------------------------
;;; Example Invocation
;;; ---------------------------------------------------------------------------

;; (clips:run-experiment 'uniform-constrained-resources-experiment 
;;                        :args '(arm::baggage-truck 4 90 50 20 :uni)
;;	                  :output-file "hillary:rubinstein.dss-arm.reports;test-results.text"

;;; ---------------------------------------------------------------------------
;;; Example Datafile
;;; ---------------------------------------------------------------------------



;;; ***************************************************************************
;;; *                              End of File                                *
;;; ***************************************************************************
