;;;; -*- Mode:Common-Lisp; Package:CLIP-USER; Fonts:(MEDFNT); Base:10 -*-
;;;; *-* File: Titanic: /usr/users/eksl/systems/clip/demos/agent-simulator/agent-experiment.lisp *-*
;;;; *-* Last-edit: Tuesday, December 7, 1993  15:49:22; Edited-By: File Server *-* 
;;;; *-* Machine: Count (Explorer II, Microcode 489) *-*
;;;; *-* Software: TI Common Lisp System 6.49 *-*
;;;; *-* Lisp: TI Common Lisp System 6.49  *-*

;;;; **************************************************************************
;;;; **************************************************************************
;;;; *                                                                        *
;;;; *               CLIPS agent Simulator Experiment Example                 *
;;;; *                                                                        *
;;;; **************************************************************************
;;;; **************************************************************************
;;;
;;; Written by: David L. Westbrook
;;;             Department of Computer and Information Science
;;;             University of Massachusetts
;;;             Amherst, Massachusetts 01003.
;;;
;;; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
;;;
;;;  01-19-93 File Created.  (WESTY)
;;;
;;; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
;;; --*--

(in-package #+CLTL2 clip-user #-CLTL2 'clip-user)

;;; --*--
;;; ***************************************************************************

;; Needs super-agent experiment definitions, but we will not load them here.
;(load (merge-pathnames "super-agent-experiment" (user::clip-load-pathname)))

(define-simulator agent-sim
  :start-system (run-agent-simulation :reset nil)
  :reset-system (reset-agent-simulation)
  :stop-system (stop-simulation)
  ;; a function that places functions to run on the queue of events.
  :schedule-function (lambda (function time period name &rest options)
                       (declare (ignore name options))
                       (schedule-event function nil time period))
  ;; a function that removes functions from the queue of events.
  :deactivate-scheduled-function unschedule-event
  :seconds-per-time-unit 60
  :timestamp current-time)

;;;----------------------------------------------------------------------------
;;;----------------------------------------------------------------------------
;;; Clip Definitions

;;;----------------------------------------------------------------------------
;;; Multiple columns

(defclip highest-agent-state ()
  (:components (highest-state highest-agent))
  
  (loop 
    with agents = (find-agents)
    with highest-agent = (first agents)
    with highest-state = (state highest-agent)
    for agent in (rest agents)
    for agent-state = (state agent) do
    (when (state< highest-state agent-state)
      (setf highest-state agent-state
	    highest-agent agent))
    finally (return (values highest-state highest-agent))))

;;;----------------------------------------------------------------------------
;;; Periodic collection

(defclip periodic-agent-state-snapshot ()
  (:output-file "snapshot.clasp"
   :schedule (:period "12 minutes")
   :map-function (clip::find-instances 'agent)
   :components   (each-agent-state-snapshot)))

(defclip each-agent-state-snapshot (agent)
  "Record the state at an agent."
  ()
  (state agent))

;;;----------------------------------------------------------------------------
;;; Event Based Clips

(defclip change-of-state (agent-name new-state)
  (:output-file "state-change.clasp"
   :trigger-event (change-of-state-event-function :BEFORE)
   :components (new-state agent-name))
  (values new-state agent-name))

;;;----------------------------------------------------------------------------

(defclip change-of-state-pred ()
  (:output-file "state-change-pred.clasp"
   :trigger-event (change-of-state-event-function :AFTER :PREDICATE #'(lambda () (evenp (trial-number))))
   :components (fred barney))
  (values :FRED :BARNEY))

;;;----------------------------------------------------------------------------
;;; Example of multiple levels of multiple-column clips.

(defclip change-of-state-3 ()
  (:output-file "state-change-3.clasp"
   :trigger-event change-of-state-event-function
   :components (wilma betty)))

(defclip wilma ()
  (:components (pebbles bam-bam))
  (values :PEBBLES :BAM-BAM))

(defclip betty ()
  (:components (dino the-cat))
  (values :DINO :THE-CAT))

;;;----------------------------------------------------------------------------
;;; This examples shows the use of the `clip::collect' function to explicitly
;;; collect some values. 

(defclip self-collection (two-item-list)
  (:time-series t
   :output-file "self-collect.clasp"
   :components (value1 value2))

  (values (first two-item-list) (second two-item-list)))

(defun collect-self-collector ()
  (clip::collect 'self-collection '(:FIRST :SECOND)))

;;; ***************************************************************************
;;; The Experiment Definition

(define-experiment agent-experiment (&key (verbose t))
  "A test experiment."
  :simulator agent-sim
  :variables ((transition-probability in '(.01 .1))
	      (cost-factor from 1 to 5 by 2))
  :instrumentation (agents-cost all-agents-costs completion-time
				highest-agent-state
                                change-of-state-pred
                                change-of-state-3
				change-of-state
				periodic-agent-state-snapshot
				self-collection)
  :before-experiment (setf *verbose* verbose)
  
  :before-trial (setf *transition-probability* transition-probability 
		      *relative-cost* cost-factor)

  ;; Set up a script that will call a function (in this case one that
  ;; will do a collection of the `self-collection' clip) at time 5.
  :script ((do-a-collection 5 (collect-self-collector)))

  :after-trial
    (progn
      (collect-self-collector) ; do one final collection of the `self-collection' clip
      (write-current-experiment-data))
    
  :after-experiment (setf *verbose* nil))

(define-experiment sae ()
  "A test experiment."
  :simulator agent-sim
  :variables ((transition-probability in '(.01 .1))
	      (cost-factor from 1 to 5 by 2))
  :instrumentation (agents-cost all-agents-costs completion-time 
                                highest-agent-state)
  :before-trial (setf *transition-probability* transition-probability 
		      *relative-cost* cost-factor)
  :after-trial
    (write-current-experiment-data))


;;;----------------------------------------------------------------------------

;; Execute this to run the demo experiment. Be sure to change the output file
;; to something reasonable.

(defun rexp ()
  (run-experiment 'agent-experiment
		  :output-file #-Explorer "data.clasp"
                               #+Explorer "ed-buffer:data.clasp"
		  :length-of-trial "500 minutes"))


  
;;; ***************************************************************************
;;; EOF






