;;;; -*- Mode:Common-Lisp; Package:CLIP; Fonts:(MEDFNT); Base:10 -*-
;;;; *-* File: Titanic: /usr/users/eksl/mac-files/clip/super-intrinisic-mixins.lisp *-*
;;;; *-* Last-edit: Tuesday, January 19, 1993  16:37:07; Edited-By: Westy *-* 
;;;; *-* Machine: Count (Explorer II, Microcode 489) *-*
;;;; *-* Software: TI Common Lisp System 6.49 *-*
;;;; *-* Lisp: TI Common Lisp System 6.49  *-*

;;;; **************************************************************************
;;;; **************************************************************************
;;;; *                                                                        *
;;;; *                          Metaclass definitions                         *
;;;; *                                                                        *
;;;; **************************************************************************
;;;; **************************************************************************
;;;
;;; Written by: David L. Westbrook
;;;             Experimental Knowledge Systems Laboratory
;;;             Paul R. Cohen, Principal Investigator
;;;             David L. Westbrook, Systems Manager
;;;             David M. Hart, Laboratory Manager
;;;             Department of Computer Science
;;;             University of Massachusetts
;;;             Amherst, Massachusetts 01003.
;;;
;;; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
;;;
;;;  01-19-93 File Created.  (Westy)
;;;
;;; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
;;; --*--

(in-package #+CLTL2 CLIP #-CLTL2 'CLIP)

;;; --*--
;;; ***************************************************************************

;; define a metaclass that automatically defines a method for accessing
;; objects by their name.

(defclass our-standard-class (standard-class)
  ())

(defvar *all-class-names* nil)

(defmethod initialize-instance :after ((the-class our-standard-class) &key)
  (pushnew (class-name the-class) *all-class-names*))

(defclass named-class (our-standard-class)
  ())

(defmethod initialize-instance :after ((the-named-class named-class) &key)
  #-lcl4.0 ; punt in lucid since the night grows long
  (eval `(defmethod ,(class-name the-named-class) ((name symbol))
	   (get name ',(class-name the-named-class)))))

;; An alternative to `named-class' that can be used to build classes
;; that can be mixed in with classes built with `named-class'.

(defclass basic-class (our-standard-class)
  ())

;; This indicates that it is OK to build a class that has `named-class' as its
;; meta-class and includes classes built on `basic-class' in its superclasses.
(defmethod validate-superclass
	   ((class-prototype named-class) (superclass basic-class))
  t)

(defmethod validate-superclass
	   ((class-prototype named-class) (superclass standard-class))
  t)

(defmethod validate-superclass
	   ((class-prototype basic-class) (superclass standard-class))
  t)

;;; ***************************************************************************
;;; EOF
