;;;; -*- Mode:Common-Lisp; Package:CLIP; Fonts:(MEDFNT); Base:10 -*-
;;;; *-* File: Titanic: /usr/users/eksl/systems/clip/development/experiment-runner.lisp *-*
;;;; *-* Last-edit: Monday, September 27, 1993  18:09:13; Edited-By: Westy *-* 
;;;; *-* Machine: Count (Explorer II, Microcode 489) *-*
;;;; *-* Software: TI Common Lisp System 6.49 *-*
;;;; *-* Lisp: TI Common Lisp System 6.49  *-*

;;;; **************************************************************************
;;;; **************************************************************************
;;;; *                                                                        *
;;;; *                       CLIP Class Definitions                           *
;;;; *                                                                        *
;;;; **************************************************************************
;;;; **************************************************************************
;;;
;;; Copyright (c) 1993 University of Massachusetts
;;; Department of Computer Science
;;; Experimental Knowledge Systems Laboratory
;;; Professor Paul Cohen, Director
;;; All rights reserved.
;;;
;;; Written by: David L. Westbrook
;;;             Experimental Knowledge Systems Laboratory
;;;             Paul R. Cohen, Director
;;;             Department of Computer Science
;;;             University of Massachusetts
;;;             Amherst, Massachusetts 01003.
;;;
;;; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
;;;
;;;  10-14-93 File created.  (Westy)
;;;
;;; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
;;; --*--

(in-package :CLIP)

;;; --*--
;;; ***************************************************************************

(defclass experiment (named-object-mixin remember-instances object-with-properties)
  ((status                :initform :idle)
   (trial-number
     :initform nil
     :documentation "In a run of trials, this is the number of the trial that is currently being run.")
   
   (first-trial-number
     :initarg :first-trial-number
     :initform nil
     :documentation "The starting trial number.")
   (last-trial-number
     :initarg :last-trial-number
     :initform nil
     :documentation "The number of trials in a run of trials.")
   (end-of-trial-time
     :initarg :end-of-trial-time
     :initform nil
     :accessor end-of-trial-time
     :documentation "The absolute time at which a trial ends.  At that time, the system is stopped
and the `after-experiment-run' function is executed.")
   (output-file-name
     :initarg :output-file-name
     :initform nil
     :accessor output-file-name
     :documentation "Bound by `run-experiment' to the file used for data output.")
   (error-file-name
     :initform nil
     :initarg :error-file-name
     :accessor error-file-name
     :documentation "Bound by `run-experiment' to the file used for error output.")
   (extra-header-string :initform nil :initarg :extra-header-string)
   
   (headers-output-already :initform nil)
   ;; Currently unused...
   (scenario
     :initarg :scenario
     :initform nil
     :accessor experiment.scenario
     :documentation "Bound to the scenario being utilitized by the current experiment.")
   (script-name
     :initarg :script-name
     :initform nil
     :accessor experiment.script-name
     :documentation "Bound to the script-name which is being used to guide the current experiment.")
   (instrumentation-names     :initform nil :initarg :instrumentation-names)
   (instrumentation           :initform nil :initarg :instrumentation)
   (before-experiment-function  :initarg :before-experiment-function)
   (before-trial-function       :initarg :before-trial-function)
   (after-trial-function        :initarg :after-trial-function)
   (after-experiment-function   :initarg :after-experiment-function)
   (ivs-element-init-function :initarg :ivs-element-init-function)
   (script-setup-function :initarg :script-setup-function)
   (arguments    :initarg :arguments)
   (argument-values)
   (ivs          :initarg :ivs)
   (ivs-elements :initarg :ivs-elements)
   (locals       :initarg :locals)
   (locals-init-function :initarg :locals-init-function)
   (system-name         :initarg :system-name)
   (system-version-hook :initarg :system-version-hook)
   (reset-system-hook   :initarg :reset-system-hook)
   (start-system-hook   :initarg :start-system-hook)
   (stop-system-hook    :initarg :stop-system-hook)
   (schedule-function-hook :initarg :schedule-function-hook)
   (deactivate-scheduled-function-hook :initarg :deactivate-scheduled-function-hook)
   (seconds-per-time-unit :initarg :seconds-per-time-unit)
   (ivs-and-args)
   (timestamp-function :initarg :timestamp-function)
   (timestamp-clip)
   (timestamp-clip-name :initarg :timestamp-clip-name)
   )
  (:metaclass named-class))

;;;----------------------------------------------------------------------------

(defclass record-call-tree-mixin ()
	  ())

;;;----------------------------------------------------------------------------

(defclass instrumentation (record-call-tree-mixin named-object-mixin remember-instances)
  ((status        :initarg :status       :reader status)
   (arguments     :initarg :arguments    :reader instr.arguments)
   (enable-function   :initform nil :initarg :enable-function  :reader instr.enable-function)
   (disable-function  :initform nil :initarg :disable-function :reader instr.disable-function)
   (reset-function    :initform nil :initarg :reset-function   :reader instr.reset-function)
   (display-function  :initform nil :initarg :display-function :reader instr.display-function)
   (report-function   :initform nil :initarg :report-function  :reader instr.report-function)
   (report-key    :initarg :report-key)
   (documentation :initarg :documentation)
   ;; This particular combiner assumes that *uncollected-value* is NIL. Fix this?
   (combiner      :initarg :combiner :initform 'push-value-combiner)
   (extracter     :initarg :extracter :initform 'average-of-values-extracter)
   (value         :initform *uncollected-value*)
   (number-of-samples :initform nil)
   ;; Could be in time series class
   (time-series? :initform nil :initarg :time-series? :reader time-series-p)
   (output-file-name :initarg :output-file-name :initform nil :reader output-file-name)
   )
  (:metaclass named-class)
  (:default-initargs
    :status :disabled))

;;; ----------------------------------------------------------------------------

(defclass periodic-instrumentation (instrumentation)
  ((scheduler-args   :initarg :scheduler-args  :reader instr.scheduler-args)
   (collection-event :initarg :collection-event) ;; so we can deactivate it
   )
  (:metaclass named-class))

(defclass functional-instrumentation (instrumentation)
  ((trigger-events :initarg :trigger-events))
  (:metaclass named-class))

(defclass column-producing-instrumentation (instrumentation)
  ((components     :initarg :components :reader instr.components)
   ;; note that I decided to star calling them columns 
   ;; but did not change the old names
   (unmapped-columns :initarg :unmapped-columns :initform nil))
  (:metaclass named-class))

(defclass super-instrumentation (column-producing-instrumentation instrumentation)
  ((map-function       :initarg :map-function :reader instr.map-function)
   ;; This is used to produce parens in the data file. The lowest level
   ;; super-instrumentation produces a distinct line of data.
   (lowest?        :initform nil :accessor  instr.lowest?)
   (congruity-already-checked? :initform nil :accessor   instr.congruity-already-checked?))
  (:metaclass named-class))

;; These produce multiple lines of data for each call to report.
(defclass time-series-instrumentation (instrumentation)
  ()
  (:default-initargs
    :time-series? t
    :combiner 'push-value-combiner)
  (:metaclass named-class))

(defclass periodic-super-instrumentation (time-series-instrumentation
                                          periodic-instrumentation
                                          super-instrumentation)
  ()
  (:metaclass named-class))

(defclass composite-instrumentation (column-producing-instrumentation instrumentation)
  ()
  (:metaclass named-class)
  (:default-initargs :combiner 'last-value-combiner 
		     :extracter 'last-value-extracter))
          
(defclass periodic-composite-instrumentation (time-series-instrumentation
                                               periodic-instrumentation
                                               composite-instrumentation)
  ()
  (:metaclass named-class))

(defclass functional-composite-instrumentation (time-series-instrumentation
                                                 functional-instrumentation
                                                 composite-instrumentation)
  ()
  (:metaclass named-class))

(defclass child-of-composite-instrumentation (instrumentation)
  ((parent        :initarg :parent       :accessor parent))
  (:metaclass named-class))

(defclass composite-child-of-composite-instrumentation 
     (composite-instrumentation child-of-composite-instrumentation)
  ()
  (:metaclass named-class))

(defclass composite-child-of-functional-composite-instrumentation 
     (time-series-instrumentation
      functional-instrumentation
      composite-instrumentation
      child-of-composite-instrumentation)
  ()
  (:metaclass named-class))

;;;----------------------------------------------------------------------------

(defclass simple-instrumentation (instrumentation)
  ()
  (:metaclass named-class))

;;;----------------------------------------------------------------------------
