;;; -*- Mode:Common-Lisp; Package:INP; Base:10 -*-
 
;;Torture test for sloop
;;After compiling this file do (test).--W. Schelter
 
(require "SLOOP")
(IN-PACKAGE "IN-TEST" :USE '("SLOOP" "LISP"))
;;lets use some random package.

;;dec20 has feature bughash
#+tops-20 (progn  (push :bughash *features*) (format t "~%Deleting the hash table tests because
of a clisp bug"))

(defun test ( &aux  test-cases errors)
  "Alternating sequence of forms and answers to be tested with EQUAL"
 (setq test-cases
       '(
	 (te-1 '((1 . nil) (3 . 4) (7 . 8)))
	 13
	 (te0 '(1 3 4 2 1 6 7 3 0 22))
	 (1 0 1 1 7 0 1 2 3 4 5 6 7 8 9 10 11
	     12 13 14 15 16 17 18 19 20 21)
	 (te1 5)
	 9
	 (te2 '(1 3 4 2 1 6 7 3 0 22))
	 244
	 (te3 '(1 3 4 2 1 6 7 3 0 22))
	  (2 3 8 2 2 6)
	 (te4 '(1 3 4 2 1 6 7 3 0 22))
	 (2 3 8 2 2 6 14 3 3 22)
	 (te3 '( 11 43 72 1 22 33))
	  (22 43 144 1 44 33)
#-:bughash (te8)
#-:bughash (14 18)				
#-:bughash (te9)
#-:bughash cons
	 (te10)
	 ((0 0) (1 0) (1 1) (2 0) (2 1) (2 2) (3 0) (3 1) (3 2) (3 3) (4 0) (4 1) (4 2) (4 3) (4 4))
	 (te11)
	 4778
	 (te12)
	 (0 1 2 3 4 5 6 7 8 9 10 12 14 15 16 18 20 21 24 27 28 32 36 48 64)
	 (te-13)
         (1 3 5 7 9 11)
	 (te-14)
	 (97 98 100 101 102 104 105)
	 (te-15)
	 (1 2 3 8 9 7 4)
	 (te-16)
	 (1 2 3 1 2 3 1 2 3)
	 (te-17)
	 (25 20)
	 (te-18)
         (5 4 5	 )
	 (te-19)
	 (0 1 2 3)
	 ))
       (sloop for (a b) on test-cases by 'cddr
	      with val
	      for i from 0
	      do (format t "~%Evaluating ~a ..." a)
	      do (setq val (eval a))
	      when (equal val b) do (format t "~%~a)Correct answer: ~a" i b)
	      else do (push i errors) (format t "~%~a)****INCORRECT ANSWER: ~a unequal to ~a" i val b)
	      finally (format t  (cond (errors "Found errors ~a")
				       (t "ALL CORRECT" )) errors)))

(defun te-1 (lis)
    (sloop named sue  for (i . j) in-carefully lis
	  sum i  count j))

(defun te0 (lis)
   (sloop for (i a) on lis by 'cddr
	    when (oddp i)
	    collecting i
	    else
	append
	(sloop for j below a
	      collecting j)))

;(defun te2 (n) (sloop for i below n with x do (setq x i)))



(defun te1 (lis)
   (sloop for  i below lis
	 for a below (* 2 lis)
	    unless (oddp i)
	    sum i
	    else
	    sum
       	(sloop for j below a
	      sum j)))
;(sloop for i in '(2 3 4) when (oddp i)  sum i  and averaging i else do (print i) do (print j))
(defun te2 (lis)
   (sloop for (i a) on lis by 'cddr
	    when (oddp i)
	    sum i
	    and count i
	    else
	    sum
       	(sloop for j below a
	      sum j)))

(defun te3 (lis)
    (sloop for (a i) on lis by 'cddr
	  when (not (zerop a))
	  nconc (list (* 2 a) i)
	  else nconc (list 3 i)
	  while (not (eql i 6))))

(defun te4 (lis)
    (sloop for (a i) on lis by 'cddr
	;  declare (int a) declare (special tem)
	  when (not (zerop a))
	  nconc (list (* 2 a) i) into tem
	  else nconc (list 3 i) into tel
	  finally (loop-return (append tem tel))))

(defun te8 ()
  (let ((table (make-hash-table)))
    (setf (gethash 3 table) 11)
        (setf (gethash 11 table) 7)
  (sloop for (key elt) in-table table sum elt into tot sum key into keys
	 finally (loop-return (list keys tot) ))))  ;check multiple

(defun te9 ()
  (sloop for sym in-package 'lisp
	 when (eql sym 'cons) do (loop-return sym)))

(defun te10 ()
  (sloop for i below 5
	 sloop (for j  to i collecting (list i j))))
 

(defun te11 ()
  (round (* 1000  (sloop for i below 10
			 sloop (for j below i
				    while (< i 54)
				    when (oddp i)
				    averaging i 
				    else averaging j)))))

(defun te12 ()
  (sloop for i below 10
	 sloop (for j below 5
		    when (oddp i) collate (* i j)
		    else collate (* i 2 j))))


(defun te-13 ()
  (sloop for v in-fringe '(1  (7 3 (2 . 2) 9 (4 11)) 5 . 3)
	 when (oddp v)
	 collate v))

(defun te-15 ()
  (sloop for v in-fringe '(1  (7 3 (2 . 2) 9 (4 11)) 5 . 3)  declare (fixnum v)
	 collect (print v)))




(defun te-14 ()
  (let ((foo "abdeaaabfhi"))
    (sloop for elt in-array foo
	   collate (char-code elt))))


(defun te-16 ()
  (sloop for i below 3
	 sloop 
	 (for v in '(1 (2 . 3) (8 9 7 ( 4)))
	      sloop (for w in-fringe v
			 when (> w 3) do (local-finish)
			 collecting w 
			 ))))


(defun te-15 ()
   (sloop for v in '(1 (2 . 3) (8 9 7 ( 4)))

	  sloop (for w in-fringe v
		     collecting w)))

(defun te-17 ()
  (sloop for i below 10
	 when (oddp i) sum i into joe
	 when (evenp i) sum i into sue
	 finally (return (list joe sue))))

(defun te-18 ()
  (sloop with i = 3 with x = (incf i) and y = (incf i)
	 collecting i collecting x collecting y
	 while nil))

(defun te-19()
  (let ((Repeat 7)(below 4)(from 0))
    (sloop repeat repeat
	   for i from from below below
	   collecting i into collecting finally (return collecting))))



(format t "~%To run test do> (in-test::test)")