;-*- mode:lisp; package:boxer;base: 10.; fonts:cptfont -*-

;;; (C) Copyright 1985 Massachusetts Institute of Technology
;;;
;;; Permission to use, copy, modify, distribute, and sell this software
;;; and its documentation for any purpose is hereby granted without fee,
;;; provided that the above copyright notice appear in all copies and that
;;; both that copyright notice and this permission notice appear in
;;; supporting documentation, and that the name of M.I.T. not be used in
;;; advertising or publicity pertaining to distribution of the software
;;; without specific, written prior permission.  M.I.T. makes no
;;; representations about the suitability of this software for any
;;; purpose.  It is provided "as is" without express or implied warranty.
;;;

;;; Utilities for making life easier for Boxer system programmers
;;; Feel free to add to this file

(DEFUN RECOMPILE-BOXER (&OPTIONAL (UPDATE-VERSION NIL))
  (WITH-MORE-P-NIL
    (FORMAT TERMINAL-IO "~%Recompiling system (without recompiling components)...~%")
    (IF UPDATE-VERSION
	(MAKE-SYSTEM 'BOXER ':COMPILE ':NOCONFIRM ':DO-NOT-DO-COMPONENTS :NOWARN)
	(MAKE-SYSTEM 'BOXER ':COMPILE ':NOCONFIRM ':NO-INCREMENT-PATCH #+SYMBOLICS '(:VERSION :NEWEST)
		     ':DO-NOT-DO-COMPONENTS :NOWARN))))

;; This is good for putting in INIT-FILES
(DEFUN INIT-FILE-BOXER ()
  (INIT-FILE-EVAL '(BOXER)))

(DEFUN INIT-FILE-EVAL (FORM)
  (LET ((INIT-FILE (CAR (FS:ALL-OPEN-FILES))))
    (PROCESS-RUN-FUNCTION "Init File Eval" #'INIT-FILE-EVAL-1 INIT-FILE FORM)))

(DEFUN INIT-FILE-EVAL-1 (INIT-FILE FORM)
  (PROCESS-WAIT "Wait" #'INIT-FILE-EVAL-1-WAIT-FN INIT-FILE)
  (SEND (SEND TV:INITIAL-LISP-LISTENER ':PROCESS) ':INTERRUPT #'EVAL FORM))

(DEFUN INIT-FILE-EVAL-1-WAIT-FN (INIT-FILE)
  (NOT (MEMQ INIT-FILE (FS:ALL-OPEN-FILES))))


;;;;BOXER-HACKS
(LET ((ERROR-OUTPUT 'SI:NULL-STREAM))
  (GLOBALIZE 'DEFBOXER-HACK)
  (GLOBALIZE 'HACK-BOXER))

(DEFVAR *BOXER-HACKS* NIL)

(DEFMACRO DEFBOXER-HACK (NAME NICE-NAME FN)
  `(IF (NOT (ASSOC ',NAME *BOXER-HACKS*))
       (SETQ *BOXER-HACKS* (NCONC *BOXER-HACKS*
				(LIST (LIST ',NAME ',NICE-NAME ,FN))))
       (SETF (CADR (ASSOC ',NAME *BOXER-HACKS*)) ',NICE-NAME)
       (SETF (CADDR (ASSOC ',NAME *BOXER-HACKS*)) ,FN)))

(DEFUN HACK-BOXER ()
  (LET ((CHOICES (MULTIPLE-VALUE-CHOOSE-BOXER-FILES
		   (MAPCAR #'(LAMBDA (X) (FIRSTN 2 X)) *BOXER-HACKS*))))
    ;; Loop through the choices, see what was asked for, and do it.
    (DOLIST (CHOICE CHOICES)
      (LET ((FILE (CAR CHOICE))
	    (OPTIONS (CDR CHOICE)))
	(DOLIST (OPTION OPTIONS)
	  (LET ((BOXER-HACKS-ENTRY (ASSQ OPTION *BOXER-HACKS*)))
	    ;; Make sure that the option is really a Boxer Hack,
	    ;; and if it is, call the function on the file.
	    (AND (NOT (NULL BOXER-HACKS-ENTRY))
		 (FUNCALL (THIRD BOXER-HACKS-ENTRY) FILE))))))))

(DEFUN MULTIPLE-VALUE-CHOOSE-BOXER-FILES (&OPTIONAL (KEYWORDS-&-NAMES '((:CHOOSE "Choose?"))))
  (LET* ((SOURCES (SI:SYSTEM-SOURCE-FILES 'BOXER))
	 (KEYWORDS (MAPCAR #'CAR KEYWORDS-&-NAMES))
	 (KEYWORDS-&-NAMES-&-IMPLICATIONS
	   (MAPCAR #'(LAMBDA (X) (APPEND X (COPYLIST '(NIL NIL NIL NIL))))
		   KEYWORDS-&-NAMES))
	 (ITEM-LIST
	   (MAPCAR #'(LAMBDA (X) `(,X ,(FUNCALL X ':STRING-FOR-PRINTING) ,KEYWORDS))
		   SOURCES)))
    (TV:MULTIPLE-CHOOSE "Filename" ITEM-LIST KEYWORDS-&-NAMES-&-IMPLICATIONS)))

(DEFBOXER-HACK EDIT "Edit?" #'ZWEI:LOAD-FILE-INTO-ZMACS)

(DEFBOXER-HACK COMPILE "Compile?" #-3600 #'QC-FILE #+3600 #'COMPILER:COMPILE-FILE)

;(DEFBOXER-HACK PRINT "Print?" 'PRESS:PRINT-FILE)



(DEFUN SYSTEM-WRITE-ATSIGN-XFILE (SYSTEM-NAME &OPTIONAL (COMPONENT-SYSTEMS-TOO? NIL))
  (LET* ((SYSTEM (SI:FIND-SYSTEM-NAMED SYSTEM-NAME))
	 (SOURCE-FILES (SI:SYSTEM-SOURCE-FILES SYSTEM-NAME))
	 (ATSIGN-XFILE-NAME (SEND (CAR SOURCE-FILES) ':NEW-PATHNAME ':TYPE "ATSIGN")))
    ;; If we don't want @ to generate listings of all the files
    ;; from all the component systems (default case); then take
    ;; those files out of source-files. Note that this loses if
    ;; a file is part of a system and one of its component systems.
    (IF (NULL COMPONENT-SYSTEMS-TOO?)
	(DOLIST (COMPONENT-SYSTEM-NAME (SI:SYSTEM-COMPONENT-SYSTEMS SYSTEM))
	  (DOLIST (COMPONENT-SOURCE-FILE (SI:SYSTEM-SOURCE-FILES COMPONENT-SYSTEM-NAME))
	    (SETQ SOURCE-FILES (DELETE COMPONENT-SOURCE-FILE SOURCE-FILES)))))
    ;; Go ahead and write the atsign file out.	  
    (WITH-OPEN-FILE (STREAM ATSIGN-XFILE-NAME ':OUT)
      (FORMAT STREAM
	      ":@ ~{~A, ~}(l[lisp] D[DOVER] s e z)~%"
	      (MAPCAR #'(LAMBDA (X) (SEND X ':STRING-FOR-HOST)) SOURCE-FILES)))))

(DEFUN SYSTEM-SET-DONT-REAP-BITS (SYSTEM-NAME &OPTIONAL (VERSION ':NEWEST))
  (LET* ((SOURCE-FILES (SI:SYSTEM-SOURCE-FILES SYSTEM-NAME))
	 (COMPILED-FILES (SI:SYSTEM-SOURCE-FILES SYSTEM-NAME '("BIN" "QFASL" "QBIN") T)))
    (SELECTQ VERSION
      (:NEWEST
       (DOLIST (FILE (APPEND SOURCE-FILES COMPILED-FILES))
	 (LET ((NEWEST-PATHNAME (SEND FILE ':NEW-PATHNAME ':VERSION :'NEWEST)))
	   (FS:CHANGE-FILE-PROPERTIES NEWEST-PATHNAME NIL ':DONT-REAP T)
	   (FORMAT T
		   "Setting dont reap bit for file ~A.~%"
		   (SEND NEWEST-PATHNAME ':STRING-FOR-PRINTING))))))))

(DEFUN SYSTEM-UNSET-DONT-REAP-BITS (SYSTEM-NAME)
  (LET* ((SOURCE-FILES (SI:SYSTEM-SOURCE-FILES SYSTEM-NAME))
	 (COMPILED-FILES (SI:SYSTEM-SOURCE-FILES SYSTEM-NAME '("BIN" "QBIN" "QFASL") T)))
    (DOLIST (FILE (APPEND SOURCE-FILES COMPILED-FILES))
      (LET* ((WILD-FILE (SEND FILE ':NEW-PATHNAME ':VERSION ':WILD))
	     (VERSIONS (CDR (MAPCAR #'CAR (FS:DIRECTORY-LIST WILD-FILE)))))
	(DOLIST (VERSION VERSIONS)
	  (FS:CHANGE-FILE-PROPERTIES VERSION NIL ':DONT-REAP NIL))))))

;;; Save on typing macros and defs
(DEFMACRO WFM (&BODY BODY)
  `(WITH-FONT-MAP-BOUND (*BOXER-PANE*)
     . ,BODY))

(DEFF D #'DESCRIBE)

(DEFVAR **TEST NIL "avoid special variable warnings")

;;; Functions for debugging things

;;; for looking (non-destructively) at streams

(DEFFLAVOR STORAGE-STREAM
	()
	(PDL-STREAM))

(DEFMACRO EXAMINING-STREAM ((STREAM) &BODY BODY)
  `(LET ((BUFFER (MAKE-INSTANCE 'STORAGE-STREAM)))
     (UNWIND-PROTECT
       (PROGN
	 . ,BODY)
       (LOOP FOR STUFF = (TELL BUFFER :TYI)
	     UNTIL (NULL STUFF)
	     DO (TELL ,STREAM :UNTYI STUFF)))))

(DEFUN LOOK-AT-STREAM (STREAM)
  (EXAMINING-STREAM (STREAM)
    (LOOP INITIALLY (TERPRI STANDARD-OUTPUT)
	  FOR INDEX = 1 THEN (1+ INDEX)
	  FOR SSTUFF = (TELL STREAM :TYI)
	  UNTIL (OR (NULL SSTUFF) (AND (ZEROP (\ INDEX 100.))(Y-OR-N-P "stop ?")))
	  DO (TELL BUFFER :UNTYI SSTUFF) (FORMAT T "~C" SSTUFF))))



;;;; for backing up

(DEFUN GET-FILES-TO-BACKUP (SYSTEM FILTER)
  (LOOP FOR THING IN #-LMITI(SI:SYSTEM-ALL-FILES SYSTEM)
                     ;; a crock so that at least the source files can get backed up
	             #+LMITI (MAPCAR #'(LAMBDA (F) (LIST F (FS:MAKE-PATHNAME :DEFAULTS F :TYPE #+TI':XFASL #+LMIT ':QBIN
									     :VERSION ':NEWEST)))
				     (SI:SYSTEM-SOURCE-FILES SYSTEM))
	APPENDING (FUNCALL FILTER THING)))
	

;;; these are heavily implementation dependent an will probably break in
;;; a future release.  They depend upon the fact that the elements of
;;; the list returned by si:system-all-files are lists consisting of lists
;;; of source and lists of object pathnames

(DEFUN BINARIES-ONLY (PAIR)
  (CADR PAIR))

(DEFUN SOURCES-ONLY (PAIR)
  (CAR PAIR))

(DEFUN SOURCES-AND-BINARIES (PAIR)
  ;; flatten out the list
  (APPEND (CAR PAIR) (CADR PAIR)))

(DEFUN FILTER-FOR-MIGRATION (FILES TO-DIRECTORY)
  (LET ((FROM-PLISTS (FS:MULTIPLE-FILE-PLISTS FILES))
	(TO-PLISTS   (FS:MULTIPLE-FILE-PLISTS (MAPCAR #'(LAMBDA (PATHNAME)
							  (FS:MERGE-PATHNAMES TO-DIRECTORY
									      PATHNAME))
							  FILES))))
    (LOOP FOR FROM-PLIST IN FROM-PLISTS
	  FOR TO-PLIST   IN TO-PLISTS
	  FOR FROM-DATE = (GET FROM-PLIST :CREATION-DATE)
	  FOR TO-DATE   = (GET TO-PLIST :CREATION-DATE)
	  WHEN (OR (NULL TO-DATE) (TIME:TIME-LESSP TO-DATE FROM-DATE))
	    COLLECT (CAR FROM-PLIST))))

(DEFUN PRINT-FILES (FILES)
  (LOOP FOR FILE IN FILES
	DO (FORMAT T "~% ~A " (SEND FILE :STRING-FOR-PRINTING))
	FINALLY
	  (TERPRI)))



;;; this doesn't work
(DEFUN BACKUP-PATCH-FILES (TO-DIRECTORY)
  (LET ((PATCH-DIR (CAR (SI:SYSTEM-PATCH-DIRECTORY (SI:FIND-SYSTEM-NAMED "BOXER")))))
    (MULTIPLE-VALUE-BIND (MAJ MIN)
	(SI:GET-SYSTEM-VERSION)
      (COPYF (FS:MERGE-PATHNAMES "boxer.patch-dir" PATCH-DIR)
	     (FS:MERGE-PATHNAMES "boxer.patch-dir" TO-DIRECTORY))
      (COPYF (FS:MERGE-PATHNAMES (FORMAT NIL "boxer-~D.directory" MAJ) PATCH-DIR)
	     (FS:MERGE-PATHNAMES (FORMAT NIL "boxer-~D.directory" MAJ) TO-DIRECTORY)))))

(DEFUN BACKUP-BOXER (&OPTIONAL (FILTER #'SOURCES-AND-BINARIES)
		     (TO-DIRECTORY "MC:BOXER;") (TO-PATCH-DIRECTORY "MC:ICE;"))
  (LET* ((ALL-FILES  (GET-FILES-TO-BACKUP 'BOXER FILTER))

	 (CANDIDATES (FILTER-FOR-MIGRATION ALL-FILES TO-DIRECTORY)))
    (PRINT-FILES CANDIDATES)
    (SELECTQ
      (FQUERY '(:TYPE
	      :TYI
	      :CHOICES
	      (((:YES "Yes") #\Y #\SPACE #\y)
	       ((:NO "No") #\N #\n #\CR #\RUBOUT)
	       ((:SELECTIVE "Select") #\S #\s)))
	      "Backup all the files above ? ")
      (:SELECTIVE (LOOP FOR FILE IN CANDIDATES
			UNLESS (Y-OR-N-P
				 (FORMAT NIL "Backup ~A ? " (SEND FILE :STRING-FOR-PRINTING)))
			  DO (SETQ CANDIDATES (DELQ FILE CANDIDATES))
			FINALLY
			  (DOLIST (FILE CANDIDATES)
			    (FS:COPYF FILE (FS:MERGE-PATHNAMES TO-DIRECTORY
							       (SEND FILE :TRUENAME))))))
      (:YES (LOOP FOR FILE IN CANDIDATES
		   DO   (FS:COPYF FILE (FS:MERGE-PATHNAMES TO-DIRECTORY
							   (SEND FILE :TRUENAME)))))
      (OTHERWISE NIL))))


;;;; Metering 

;;; USeful macros

(DEFMACRO WITH-TIMING (&BODY BODY)
  "Executes body and returns the amount of time (in microseconds) it took for
the body to execute. "
  `(WITHOUT-INTERRUPTS
     (LET ((START-TIME (TIME:MICROSECOND-TIME)))
       ,@BODY
       (- (TIME:MICROSECOND-TIME) START-TIME))))

(DEFMACRO WITH-MULTIPLE-TIMING ((ITERATIONS) &BODY BODY)
    "Executes body and returns the amount of time (in microseconds) it took for
the body to execute ITERATIONS times. The overhead is about 300 microsecond per iteration"
    `(DO ((I 0 (1+ I)) (TIME 0))
	 ((= I ,ITERATIONS) TIME)
       (WITHOUT-INTERRUPTS
	 (LET ((START-TIME (TIME:MICROSECOND-TIME)))
	   ,@BODY
	   (SETQ TIME (+ (- (TIME:MICROSECOND-TIME) START-TIME) TIME))))))

;; assumes that we are running with the ephemeral GC on.  should probably check for gc-status
;; instead
(DEFMACRO NOGC (&BODY BODY)
  `(UNWIND-PROTECT
       (PROGN (GC-OFF)
	      ,@BODY)
     #+LMITI(GC-ON)
     #-LMITI(GC-ON :EPHEMERAL T)))

;;; temporarily redefine a method to be something else
;;   (METHOD-LET (((BOX :FOO) (:METHOD BOX :BAR))
;;		((ROW :BAZ) OTHER-BAZ))
;;       <the body>)
;;; makes the :FOO method of a BOX be the same as the :BAR method and
;;; the :BAZ method of a ROW be the same as the OTHER-BAZ function for the execution of
;;; the body
	    
(DEFMACRO METHOD-LET (METHODS &BODY BODY)
  `(LET ((OLD-METHODS))
     (UNWIND-PROTECT
	 (PROGN (DOLIST (METHOD ',METHODS)
		  (PUSH (FDEFINITION `(:METHOD ,@(CAR METHOD))) OLD-METHODS)
		  (FDEFINE `(:METHOD ,@(CAR METHOD)) (EVAL `(FDEFINITION ',(CADR METHOD)))))
		,@BODY)
       (LOOP FOR M IN (NREVERSE OLD-METHODS)
	     FOR METHOD IN ',METHODS
	     DO (FDEFINE `(:METHOD ,@(CAR METHOD)) M)))))

(EVAL-WHEN (LOAD)
  (PUSH 'ZWEI:METHOD-LET ZWEI:*INDENT-NOT-FUNCTION-SUPERIORS*)
  )
  
(DEFUN NON-CACHING-ROW-EVROW (ROW IGNORE IGNORE)
  (BOXER-READ (MAKE-ROW-STREAM ROW) nil))

(DEFUN NON-CACHING-ROW-ENTRIES (ROW IGNORE IGNORE)
  (PARSE-LIST-FOR-EVAL (BOXER-READ (MAKE-ROW-STREAM ROW) nil)))

(DEFUN NON-CACHING-ROW-ELEMENTS (ROW IGNORE IGNORE)
  (MAPCAR #'ROW-ENTRY-ELEMENT (PARSE-LIST-FOR-EVAL (BOXER-READ (MAKE-ROW-STREAM ROW) nil))))

(DEFMACRO NO-READ-CACHING (&BODY BODY)
  `(METHOD-LET (((ROW :EVROW) NON-CACHING-ROW-EVROW)
		((ROW :ENTRIES) NON-CACHING-ROW-ENTRIES)
		((ROW :ELEMENTS) NON-CACHING-ROW-ELEMENTS))
     ,@BODY))



;;;; Top level metering functions

(DEFUN TIME-EXECUTION (&OPTIONAL (THING (TELL (POINT-ROW) :ENTRIES)) (STREAM STANDARD-OUTPUT)
		       (CACHING-ON? T) (COPYING-ON? T))
  "Thing should be something acceptable to EV-THING"
  (LET ((*EVALUATOR-COPYING-ON?* COPYING-ON?))
    (NOGC
      (FORMAT STREAM "~%Time to execute ~A:~:D microseconds"
	      THING
	      (IF CACHING-ON? (WITH-TIMING (EV-THING THING))
		  (NO-READ-CACHING (WITH-TIMING (EV-THING THING))))))))

(DEFUN TIME-MULTIPLE-EXECUTION (&OPTIONAL (ITERATIONS 500) (THING (TELL (POINT-ROW) :ENTRIES))
				&KEY (STREAM STANDARD-OUTPUT) (CACHING-ON? T) (COPYING-ON? T))
  (LET ((*EVALUATOR-COPYING-ON?* COPYING-ON?))
    (NOGC
      (FORMAT STREAM "~%Time to execute ~A ~:D times :~:D microseconds"
	      THING
	      ITERATIONS
	      (IF CACHING-ON? (WITH-TIMING (EV-THING THING))
		  (NO-READ-CACHING (WITH-TIMING (EV-THING THING))))))))

;;; if the world breaks use this...

(DEFMACRO GENERALIZED-WITH-BUG-BOXER-WINDOW-SELECTED (VAR &BODY BODY)
  `(USING-RESOURCE (,VAR BUG-BOXER-WINDOW)
     (LET ((OLD-SELECTED-WINDOW TV:SELECTED-WINDOW))
       (UNWIND-PROTECT
	 (PROGN (EXPOSE-WINDOW-OVER-WINDOW ,VAR OLD-SELECTED-WINDOW)
		(TELL ,VAR :SELECT)
		. ,BODY)
	 (TELL ,VAR :KILL)
	 (TELL OLD-SELECTED-WINDOW :SELECT)))))

(DEFUN SALVAGE-BOXER-WORLD ()
  (LET ((PACKAGE (PKG-FIND-PACKAGE 'BOXER)))
    (SAVE-BOX-INTO-FILE *INITIAL-BOX* "broken")
    (WHEN (Y-OR-N-P "Do you want to send a bug report ? ")
      (GENERALIZED-WITH-BUG-BOXER-WINDOW-SELECTED BUG-WINDOW
	(BUG-BOXER-PRINT-INSTRUCTIONS BUG-WINDOW)
	(BUG-BOXER-SEND-MESSAGE (BUG-BOXER-GET-BUG-MESSAGE BUG-WINDOW) BUG-WINDOW)))))


(GLOBALIZE "SALVAGE-BOXER-WORLD")
