;-*- mode:lisp; package: Boxer;Base:10.; fonts: cptfont, cptfontb -*-

;;; (C) Copyright 1985 Massachusetts Institute of Technology
;;;
;;; Permission to use, copy, modify, distribute, and sell this software
;;; and its documentation for any purpose is hereby granted without fee,
;;; provided that the above copyright notice appear in all copies and that
;;; both that copyright notice and this permission notice appear in
;;; supporting documentation, and that the name of M.I.T. not be used in
;;; advertising or publicity pertaining to distribution of the software
;;; without specific, written prior permission.  M.I.T. makes no
;;; representations about the suitability of this software for any
;;; purpose.  It is provided "as is" without express or implied warranty.
;;;

;; some primitives for the new evaluator

;; control primitives 

(DEFBOXER-FUNCTION REPEAT (TIMES (LIST-REST STUFF))
  (*CATCH 'REPEAT
    (DOTIMES (I (NUMBERIZE TIMES))
      (EV-THING STUFF))))

(DEFBOXER-FUNCTION REPEATX (TIMES STUFF)
  (*CATCH 'REPEAT
    (DOTIMES (I (NUMBERIZE TIMES))
      (EVAL-BOX-ROWS STUFF))))

(DEFBOXER-FUNCTION STOP ()
  (*THROW 'REPEAT :NOPRINT))

(DEFBOXER-FUNCTION RETURN (VALUE)
  (*THROW 'REPEAT VALUE))

(DEFBOXER-FUNCTION IF (PRED (DATAFY THEN) (LIST-REST ELSE)) 
  (IF (TRUE? PRED) (EVAL-BOX-ROWS THEN) (EV-THING ELSE)))

(DEFBOXER-FUNCTION IFS ((DATAFY BOX))
  (LET ((ROWS (GET-BOX-ROWS-FOR-EVAL (CAR (GET-FIRST-ROW BOX)))))
    (DOLIST (ROW ROWS)
      (MULTIPLE-VALUE-BIND (PRED REST)
	  (RETURN-VALUE ROW)
	(COND ((TRUE? PRED)
	       (RETURN (EV-EXPRESSION REST)))
	      ((NOT (FALSE? PRED))
	       (FERROR "The Predicate ~S, was neither TRUE nor FALSE" PRED)))))))

(DEFBOXER-FUNCTION RUN (BOX)
  (EVAL-BOX-ROWS BOX))

(DEFBOXER-FUNCTION PORT-TO ((PORTIFY BOX))
  BOX)

;;; this still needs to hack top level !'s
(DEFBOXER-FUNCTION TELL ((PORT-TO WHO) (LIST-REST WHAT))
  (WITH-STATIC-ROOT-BOUND (GET-LEXICAL-ROOT WHO)
    (if (evbox? *boxer-static-variables-root*)
	(ferror "You can't do TELL on the result of a Boxer computation until 1//1//88.")
	(EV-THING WHAT))))

(DEFBOXER-FUNCTION TELL-ALL ((PORT-TO WHOS) (LIST-REST WHAT))
  (LOOP FOR WHO IN (MAPCAR #'(LAMBDA (X) (EV-THING X '(PORTIFY DONT-IGNORE)))
			   (SUBSET #'(LAMBDA (B) (AND (OR (EVAL-BOX? B) (EVAL-PORT? B))
						      (NOT (LL-BOX? B))))
				   (IF (EVAL-PORT? WHOS)
				       (get-box-elements (get-port-target whos))
				       (get-box-elements whos))))
	DO  (WITH-STATIC-ROOT-BOUND (GET-LEXICAL-ROOT WHO)
	      (EV-THING WHAT))))

;;; call the debugger from 1BOXER
0(DEFBOXER-FUNCTION LISPM-ERROR () (FSIGNAL "Boxer Error"))

;;; call the redisplay from 1BOXER0. This should be provided for somehow but right now it is
;;; just too expensive to call the redisplay automatically in order to pick up intermediate
;;; results of mutations
(DEFBOXER-FUNCTION REDISPLAY REDISPLAY)



(DEFBOXER-FUNCTION EXPORT-ALL ((PORTIFY BOX))
  (TELL (GET-PORT-TARGET BOX) :EXPORT-ALL-VARIABLES)
  ':NOPRINT)



;;; I/O

(DEFBOXER-FUNCTION GET-INPUT ((LIST-REST PROMPT))
  (GET-BOXER-INPUT PROMPT))

;; file sys

(DEFBOXER-FUNCTION READ ((PORTIFY BOX) (PORTIFY FILENAME))
  (READ-FILE-INTO-BOX (GET-PORT-TARGET BOX) (TEXT-STRING (GET-PORT-TARGET FILENAME)))
  :NOPRINT)

(DEFBOXER-FUNCTION SAVE ((PORTIFY BOX) (PORTIFY FILENAME))
  (SAVE-BOX-INTO-FILE (GET-PORT-TARGET BOX) (TEXT-STRING (GET-PORT-TARGET FILENAME)))
  :NOPRINT)

(DEFBOXER-FUNCTION SAVE-BOX-INTO-FILE ((PORTIFY BOX) (PORTIFY FILENAME))
  (SAVE-BOX-INTO-FILE (GET-PORT-TARGET BOX) (TEXT-STRING (GET-PORT-TARGET FILENAME)))
  :NOPRINT)

(DEFBOXER-FUNCTION READ-FILE-INTO-BOX ((PORTIFY BOX) (PORTIFY FILENAME))
  (READ-FILE-INTO-BOX (GET-PORT-TARGET BOX) (TEXT-STRING (GET-PORT-TARGET FILENAME)))
  :NOPRINT)

(DEFBOXER-FUNCTION SAVE-WORLD ((PORTIFY FILENAME))
  (SAVE-BOX-INTO-FILE *INITIAL-BOX* (TEXT-STRING (GET-PORT-TARGET FILENAME)))
  :NOPRINT)



(DEFUN PRINT-BOXER-PRIMITIVES (&optional (stream terminal-io))
  (LET ((PACKAGE (PKG-FIND-PACKAGE "USER")))
    (LOOP FOR FN IN *BOXER-FUNCTIONS*
	  DO (FORMAT stream "~% ~3T~s  ~15T--   ~:S" FN (BOXER-ARGLIST FN)))))




;(DEFBOXER-FUNCTION BU:MAKE (VARIABLE VALUE) (BOXER-MAKE VARIABLE VALUE) ':NOPRINT)
;(DEFBOXER-FUNCTION BU:SET (VARIABLE VALUE) (BOXER-SET VARIABLE VALUE) ':NOPRINT)

(DEFBOXER-FUNCTION BU:GET-KBD-CHAR ()
  (STRING (TELL TERMINAL-IO :TYI)))

(DEFBOXER-FUNCTION BU:READCHARACTER ()
    (STRING (TELL TERMINAL-IO :TYI)))

(DEFBOXER-FUNCTION BU:RC? ()
  (BOXER-BOOLEAN (TELL TERMINAL-IO :LISTEN)))

(DEFBOXER-FUNCTION BU:RUN-KBD-CHAR ()
  (HANDLE-BOXER-INPUT (TELL TERMINAL-IO :TYI)))

(DEFBOXER-FUNCTION BU:KBD-CHAR? ()
  (TELL TERMINAL-IO :LISTEN))

(DEFBOXER-FUNCTION BU:GET-CHA-NO-WAIT ()
  (LET ((CHA (TELL TERMINAL-IO :TYI-NO-HANG)))
    (OR CHA (BOXER-BOOLEAN CHA))))

(DEFBOXER-FUNCTION BU:GENSYM () (GENSYM 'B))

(DEFBOXER-FUNCTION BU:PRINT (ignore) (ferror "Print doesn't work these days."))

(DEFBOXER-FUNCTION BU:BOX? (box) (boxer-boolean (EVAL-BOX? BOX)))

(DEFBOXER-FUNCTION BU:DOIT-BOX? (box) (boxer-boolean (EVAL-DOIT? BOX)))

(DEFBOXER-FUNCTION BU:DATA-BOX? (box) (boxer-boolean (EVAL-DATA? BOX)))



;MISCELLANEOUS

(DEFBOXER-FUNCTION BU:HARDCOPY-BOX ((PORTIFY BOX))
  (PBOX:HARDCOPY-BOX (BOX-OR-PORT-TARGET BOX)))

(DEFBOXER-FUNCTION WRITE-BOX-INTO-ZWEI-BUFFER ((PORTIFY BOX) ZWEI-BUFFER-NAME)
  (WHEN (EVAL-PORT? BOX)
    (ZWEI:WITH-EDITOR-STREAM
      (OUT ':BUFFER-NAME (TEXT-STRING ZWEI-BUFFER-NAME) ':CREATE-P T)
      (PBOX:PRINT-BOXES-FROM-STREAM-TO-STREAM (MAKE-BOXER-STREAM BOX) OUT
					      72. 100. USER-ID
					      (TELL (BOX-OR-PORT-TARGET BOX) :NAME)))))

(DEFBOXER-FUNCTION BEEP () (BEEP))

(DEFUN NUMBER-TO-STRING (NUMBER)			;THIS CROCK
    (FORMAT NIL "~D" NUMBER))

(DEFBOXER-FUNCTION POINT-BOX POINT-BOX)

(DEFBOXER-FUNCTION UPDATE-BOXER-SYSTEM ()
  (LOAD-PATCHES 'BOXER :VERBOSE :NOSELECTIVE))

(DEFBOXER-FUNCTION DIRECTORY ((PORT-TO NAME))
  (MAKE-BOX (MAPCAR #'(LAMBDA (F) (WHEN (CL:PATHNAMEP (CAR F))
				    (NCONS (TELL (CAR F) :STRING-FOR-PRINTING))))
		    (FS:DIRECTORY-LIST
		      (fs:parse-pathname (TELL (GET-PORT-TARGET NAME) :TEXT-STRING))))))

(DEFBOXER-FUNCTION FIX-REGIONS ()
  ;;first flush any regions that we might have
  (DOLIST (R REGION-LIST)
    (FLUSH-REGION R))
  ;; now flush blinkers
  (DOLIST (BL (TV:SHEET-BLINKER-LIST *BOXER-PANE*))
    (WHEN (REGION-ROW-BLINKER? BL)
      (SEND BL :SET-VISIBILITY NIL)
      (SETF (TV:SHEET-BLINKER-LIST *BOXER-PANE*)
	    (DELQ BL (TV:SHEET-BLINKER-LIST *BOXER-PANE*))))))

(defboxer-function toggle-box-border-appearance ()
  (cond ((string= "" (BOX-BORDERS-FN-TYPE-LABEL-STRING ':data-box))
	 (BOX-BORDERS-FN-SET-TYPE-LABEL-STRING ':data-box "Data")
	 (BOX-BORDERS-FN-SET-TYPE-LABEL-STRING ':doit-box ""))
	(t
	 (BOX-BORDERS-FN-SET-TYPE-LABEL-STRING ':data-box "")
	 (BOX-BORDERS-FN-SET-TYPE-LABEL-STRING ':doit-box "Doit")))
  (force-redisplay))



(defboxer-function doit->data ((list-rest line))
     (let* ((thing (car line))
            (new (copy-box (if (symbolp thing) (boxer-symeval thing) thing))))
  (tell new :set-type ':data-box)
      new))

(defboxer-function port-to-doit ((list-rest line))
    (port-to-internal (if (symbolp (car line)) (boxer-symeval (car line)) (car line))))

