;;; -*- Mode: Lisp; Base: 10.; Package: BOXER -*-

;;; (C) Copyright 1985 Massachusetts Institute of Technology
;;;
;;; Permission to use, copy, modify, distribute, and sell this software
;;; and its documentation for any purpose is hereby granted without fee,
;;; provided that the above copyright notice appear in all copies and that
;;; both that copyright notice and this permission notice appear in
;;; supporting documentation, and that the name of M.I.T. not be used in
;;; advertising or publicity pertaining to distribution of the software
;;; without specific, written prior permission.  M.I.T. makes no
;;; representations about the suitability of this software for any
;;; purpose.  It is provided "as is" without express or implied warranty.
;;;

;Send mail
(defboxer-function mail ((datafy to) (datafy msg))
  (let ((header-box (car (evrow-items (car (evbox-rows to)))))
	(message-box (car (evrow-items (car (evbox-rows msg))))))
    (with-output-to-string (confirmation)
      (mail-text-string
	(send (send header-box :row-at-row-no 0) :text-string)
	(or (tell (tell header-box :row-at-row-no 1) :text-string) " ")	;subject
	(tell message-box :text-string))
      confirmation)))

;;Read Mail function
;Maybe we can use some zmail flavors for this.  This thing just reads twenex mail files.
;We really need to snarf something from Zmail to do all this.

(defboxer-function read-mail ()
  (read-mail-from-file-to-boxes (user-mail-file)))

(defboxer-function read-mail-from-file ((portify filename))
  (read-mail-from-file-to-boxes (text-string (get-port-target filename))))

(defun read-mail-from-file-to-boxes (file)
  (with-open-file (in file '(in))
    (do ((mail (ncons nil))
	 (system-type (send (send (send in :truename) :host) :system-type))
	 (message))
	(())
      (setq message (read-one-message in '*EOF* system-type))
      (if (eq message '*EOF*)
	  (return (simple-make-box (cdr mail))))
      (setq message (make-box message))
      (tell message :set-display-style ':shrunk)
      (nconc mail (ncons message)))))

(defun read-one-message (stream eof-option system-type)
  (selectq system-type
    (:tops-20 (read-one-twenex-message stream eof-option))
    (:its (read-one-its-message stream eof-option))
    (:otherwise (ferror "Can't yet read mail from a ~A site" system-type))))


(defun read-one-twenex-message (stream &optional (eof-option nil))
  (let ((info (readline stream eof-option)))
    (if (equal info eof-option)
	eof-option
	(let* ((ibase 10.)
	       (index-start (+ 1 (string-search #/, info)))
	       (index-limit (string-search #/; info index-start))
	       (length (with-input-from-string (stream info index-start index-limit)
			 (read stream))))
	  (do* ((line (tell stream :line-in) (tell stream :line-in))
		(count (string-length line)
		       (+ 2 count (string-length line)))
		(message (ncons nil)))
	       ((eq line '*EOF*)
		(if (not (equal '(nil) message))
		    message
		    line))
	    (if (> count length)
		(let ((diff (- count length))
		      (slenm1 (1-  (string-length line))))
		  (send stream ':untyi #\return)
		  (dotimes (i diff)
		    (send stream ':untyi (aref line (- slenm1 i))))
		  (setq line (nsubstring line 0 (- (1+ slenm1) diff)))))
	    (nconc message (ncons (ncons (quote-any-funnies line))))
	    (if (>= count (- length 2))
		(return (cdr message))))))))


(defun read-one-its-message (stream &optional (eof-option nil))
  (loop for line = (readline stream t) then (readline stream t)
	collecting (ncons (quote-any-funnies line)) into list
	until (or (not (stringp line)) (string-equal "" line))
	finally (return (if (stringp line) list eof-option))))


;takes a list of boxes (or chas) and returns a box containing
;those actual objects.
(defun simple-make-box (list)
  (let* ((result (make-box '()))
	 (row (tell result :row-at-row-no 0)))
    (do ((list list (cdr list)))
	((null list) result)
      (tell row :append-cha (car list)))))

(DEFUN USER-MAIL-FILE ()
  (LET ((FILE))
    (ZWEI:VIEW-MAIL-INTERNAL #'(LAMBDA (U) (SETQ FILE U)))
    FILE))

;Currently the quoting code in boxer is broken so we must remove all bad chars.
(defun quote-any-funnies (string)
  (loop for place = (string-search-set *boxer-stream-special-characters* string)
	    then (string-search-set *boxer-stream-special-characters* string)
	until (null place)
	do (aset #/! string place)
	finally (return string)))

;  (if (null (string-search-set *boxer-stream-special-characters* string))
;      string
;      (let ((length (string-length string)))
;	(do ((new-string (MAKE-ARRAY 100 ':TYPE 'ART-STRING ':LEADER-LIST '(0)))
;	     (index 0 (1+ index)))
;	    ((= length index) new-string)
;	  (if (string-search-set *boxer-stream-special-characters*
;				 (aref string index))
;	      (array-push-extend new-string #/))
;	  (array-push-extend new-string (aref string index))))))






