;;;-*- Mode:LISP; Package:SI; Base:8; Readtable:ZL; -*-

;;; (C) Copyright 1985 Massachusetts Institute of Technology
;;;
;;; Permission to use, copy, modify, distribute, and sell this software
;;; and its documentation for any purpose is hereby granted without fee,
;;; provided that the above copyright notice appear in all copies and that
;;; both that copyright notice and this permission notice appear in
;;; supporting documentation, and that the name of M.I.T. not be used in
;;; advertising or publicity pertaining to distribution of the software
;;; without specific, written prior permission.  M.I.T. makes no
;;; representations about the suitability of this software for any
;;; purpose.  It is provided "as is" without express or implied warranty.
;;;

#+LMI
(EVAL-WHEN (LOAD COMPILE)
(SETQ XR-SPECIAL-CHARACTER-NAMES
      (APPEND '((:NULL . #o200) (:NULL-CHARACTER . #o200)
		(:BREAK . #o201) (:SUSPEND . #o201)
		(:CLEAR-INPUT . #o202) (:CLEAR . #o202) (:CLR . #o202)
		(:CALL . #o203)
		(:TERMINAL . #o204) (:ESC . #o204) (:ESCAPE . #o204) (:TERMINAL-ESCAPE . #o204)
		(:FUNCTION . #o204)
		(:MACRO . #o205) (:BACK-NEXT . #o205) (:BACKNEXT . #o205)
		(:HELP . #o206)
		(:RUBOUT . #o207)
		(:OVERSTRIKE . #o210) (:BACKSPACE . #o210) (:BS . #o210)
		(:TAB . #o211)
		(:LINE . #o212) (:LF . #o212) (:LINEFEED . #o212) (:LINE-FEED . #o212)
		(:DELETE . #o213) (:VT . #o213)
		;; The keyboard says "CLEAR SCREEN", but it should type out as "PAGE".
		(:PAGE . #o214) (:CLEAR-SCREEN . #o214) (:FORM . #o214) (:FF . #o214)
		(:RETURN . #o215) (:NEWLINE . #o215) (:CR . #o215)
		(:QUOTE . #o216)
		(:HOLD-OUTPUT . #o217)
		(:STOP-OUTPUT . #o220)
		(:ABORT . #o221)
		(:RESUME . #o222)
		(:STATUS . #o223)
		(:END . #o224)
		(:ROMAN-I . #o225) (:ROMAN-II . #o226) (:ROMAN-III . #o227) (:ROMAN-IV . #o230)
		(:ARROW-UP . #o231) (:ARROW-DOWN . #o232)
		(:ARROW-LEFT . #o233) (:ARROW-RIGHT . #o234)
		(:SYSTEM . #o235) (:SELECT . #o235)
		(:NETWORK . #o236)
		(:UNDO . #o237)
		(:LEFT . #o240)
		(:MIDDLE . #o241)
		(:RIGHT . #o242)
		(:KEYPAD-EQUAL . #o243)
		(:KEYPAD-PLUS . #o244)
		(:KEYPAD-SPACE . #o245)
		(:KEYPAD-TAB . #o246)
		(:KEYPAD-7 . #o247)
		(:KEYPAD-8 . #o250)
		(:KEYPAD-9 . #o251)
		(:KEYPAD-MINUS . #o252)
		(:KEYPAD-4 . #o253)
		(:KEYPAD-5 . #o254)
		(:KEYPAD-6 . #o255)
		(:KEYPAD-COMMA . #o256)
		(:KEYPAD-1 . #o257)
		(:KEYPAD-2 . #o260)
		(:KEYPAD-3 . #o261)
		(:KEYPAD-ENTER . #o262)
		(:KEYPAD-0 . #o263)
		(:KEYPAD-PERIOD . #o264)
		(:ARROW-MIDDLE . #o265) 
		(:F1 . #o266)
		(:F2 . #o267)
		(:F3 . #o270)
		(:F4 . #o271)
		
		(:CENTER-DOT . 0) (:CENTRE-DOT . 0)	;Amerikans can't spell...
		(:DOWN-ARROW . 1)
		(:ALPHA . 2) (:BETA . 3) (:AND-SIGN . 4) (:NOT-SIGN . 5)
		(:EPSILON . 6) (:PI . 7) (:LAMBDA . #o10) (:GAMMA . #o11) (:DELTA . #o12)
		(:UP-ARROW . #o13) (:UPARROW . #o13)
		(:PLUS-MINUS . #o14) (:CIRCLE-PLUS . #o15)
		(:INFINITY . #o16) (:PARTIAL-DELTA . #o17)
		(:LEFT-HORSESHOE . #o20) (:RIGHT-HORSESHOE . #o21) 
		(:UP-HORSESHOE . #o22) (:DOWN-HORSESHOE . #o23)
		(:UNIVERSAL-QUANTIFIER . #o24) (:FOR-ALL . #o24)
		(:EXISTENTIAL-QUANTIFIER . #o25) (:THERE-EXISTS . #o25)
		(:CIRCLE-X . #o26) (:CIRCLE-CROSS . #o26) (:TENSOR . #o26)
		(:DOUBLE-ARROW . #o27) (:LEFT-ARROW . #o30) (:RIGHT-ARROW . #o31)
		(:NOT-EQUAL . #o32)(:NOT-EQUALS . #o32)
		(:ALTMODE . #o33) (:ALT . #o33) (:DIAMOND . #o33)
		(:LESS-OR-EQUAL . #o34) (:GREATER-OR-EQUAL . #o35) (:EQUIVALENCE . #o36)
		(:OR-SIGN . #o37) (:OR . #o37)
		
		(:SPACE . #o40) (:SP . #o40)
		(:INTEGRAL . #o177)
		(:COKE-BOTTLE . 259.) (:COKEBOTTLE . 259.)
		)
	      (MAPCAR (LAMBDA (X) (CONS (CAR X)
					(DPB 1 %%XR-SPECIAL-CHARACTER-NAMES-MOUSE-BIT
					     (CDR X))))
		      '((:MOUSE-L . 0) (:MOUSE-L-1 . 0) (:MOUSE-L-2 . #o10) (:MOUSE-L-3 . #o20)
			(:MOUSE-M . 1) (:MOUSE-M-1 . 1) (:MOUSE-M-2 . #o11) (:MOUSE-M-3 . #o21)
			(:MOUSE-R . 2) (:MOUSE-R-1 . 2) (:MOUSE-R-2 . #o12) (:MOUSE-R-3 . #o22)
			(:MOUSE-1-1 . 0) (:MOUSE-1-2 . #o10)
			(:MOUSE-2-1 . 1) (:MOUSE-2-2 . #o11)
			(:MOUSE-3-1 . 2) (:MOUSE-3-2 . #o12)))))
)
#+LMI
(EVAL-WHEN (LOAD COMPILE)
(SETQ kbd-ti-bd-table-list
	'(
	  ;;x00
	  (140000 140000 140000 140000 140000)	;none
	  (#/HELP #/HELP #/HELP #/HELP #/HELP)	;HELP
	  (140000 140000 140000 140000 140000)	;none
	  (100003 100003 100003 100003 100003)	;CAPS-LOCK
	  (140000 140000 140000 140000 140000)	;BOLD-LOCK
	  (140000 140000 140000 140000 140000)	;ITALIC-LOCK
	  (100011 100011 100011 100011 100011)	;MODE-LOCK
	  (100007 100007 100007 100007 100007)	;left HYPER
	  ;;x08
	  (#/SYSTEM #/SYSTEM #/SYSTEM #/SYSTEM #/SYSTEM)
	  (#/NETWORK #/NETWORK #/NETWORK #/NETWORK #/NETWORK)
	  (#/STATUS #/STATUS #/STATUS #/STATUS #/STATUS)
	  (#/TERMINAL #/TERMINAL #/TERMINAL #/TERMINAL #/TERMINAL)
	  (140000 140000 140000 140000 140000)	;none
	  (#/PAGE #/PAGE #/PAGE #/PAGE #/PAGE)	;CLEAR-SCREEN
	  (#/CLEAR-INPUT #/CLEAR-INPUT #/CLEAR-INPUT #/CLEAR-INPUT #/CLEAR-INPUT)
	  (#/UNDO #/UNDO #/UNDO #/UNDO #/UNDO)
	  ;;x10
	  (#/END #/END #/END #/END #/END)
	  (#/ROMAN-I #/ROMAN-I #/ROMAN-I #/ROMAN-I #/ROMAN-I)	;LEFT
	  (#/ROMAN-II #/ROMAN-II #/ROMAN-II #/ROMAN-II #/ROMAN-II)	;MIDDLE
	  (#/ROMAN-III #/ROMAN-III #/ROMAN-III #/ROMAN-III #/ROMAN-III)	;RIGHT
	  (#/F1 #/F1 #/F1 #/F1 #/F1)
	  (#/F2 #/F2 #/F2 #/F2 #/F2)
	  (#/F3 #/F3 #/F3 #/F3 #/F3)
	  (#/F4 #/F4 #/F4 #/F4 #/F4)
	  ;;x18
	  (140000 140000 140000 140000 140000)	;none
	  (140000 140000 140000 140000 140000)	;none
	  (100006 100006 100006 100006 100006)	;LEFT SUPER
	  (100005 100005 100005 100005 100005)	;LEFT META
	  (100004 100004 100004 100004 100004)	;LEFT CONTROL
	  (100044 100044 100044 100044 100044)	;RIGHT CONTROL
	  (100045 100045 100045 100045 100045)	;RIGHT META
	  (100046 100046 100046 100046 100046)	;RIGHT SUPER
	  ;;x20
	  (100047 100047 100047 100047 100047)	;RIGHT HYPER
	  (#/RESUME #/RESUME #/RESUME #/RESUME #/RESUME)
	  (140000 140000 140000 140000 140000)	;none
	  (#/ALTMODE #/ALTMODE #/ALTMODE #/ALTMODE #/ALTMODE)	;ESCAPE
	  (#/1 #/! #/! 140000 140000)
	  (#/2 #/@ #/@ 140000 140000)
	  (#/3 #/# #/# 140000 140000)
	  (#/4 #/$ #/$ 140000 140000)
	  ;;x28
	  (#/5 #/% #/% 140000 140000)
	  (#/6 #/^ #/^ 140000 140000)
	  (#/7 #/& #/& 140000 140000)
	  (#/8 #/* #/* 140000 140000)
	  (#/9 #/( #/( 140000 140000)
	  (#/0 #/) #/) 140000 140000)
	  (#/- #/_ #/_ 140000 140000)
	  (#/= #/+ #/+ 140000 140000)
	  ;;x30
	  (#/` #/{ #/{ 140000 140000)
	  (#/~ #/} #/} 140000 140000)
	  (#/= #/= #/= 140000 140000)	;= on keypad
	  (#/+ #/+ #/+ 140000 140000)	;+ on keypad
	  (#/SPACE #/SPACE #/SPACE #/SPACE #/SPACE)	;space on keypad
	  (#/TAB #/TAB #/TAB #/TAB #/TAB)	;tab on keypad
	  (#/BREAK #/BREAK #/BREAK #/BREAK #/BREAK)
	  (140000 140000 140000 140000 140000)	;none
	  ;;x38
	  (#/TAB #/TAB #/TAB #/TAB #/TAB)
	  (#/q #/Q #/ 140000 140000)
	  (#/w #/W #/ 140000 140000)
	  (#/e #/E #/ #/ 140000)
	  (#/r #/R #/ 140000 140000)
	  (#/t #/T #/ 140000 140000)
	  (#/y #/Y #/ 140000 140000)
	  (#/u #/U #/ 140000 140000)
	  ;;x40
	  (#/i #/I #/ 140000 140000)
	  (#/o #/O #/ 140000 140000)
	  (#/p #/P #/ #/ 140000)
	  (#/( #/[ #/[ 140000 140000)
	  (#/) #/] #/] 140000 140000)
	  (140000 140000 140000 140000 140000)	;none
	  (#/\ #/| #/| 140000 140000)
	  (#/ARROW-UP #/ARROW-UP #/ARROW-UP 140000 140000)	;arrow up
	  ;;x48
	  (#/7 #/7 #/7 140000 140000)	;7 on keypad
	  (#/8 #/8 #/8 140000 140000)	;8 on keypad
	  (#/9 #/9 #/9 140000 140000)	;9 on keypad
	  (#/- #/- #/- 140000 140000)	;- on keypad
	  (#/ABORT #/ABORT #/ABORT #/ABORT #/ABORT)
	  (140000 140000 140000 140000 140000)	;none
	  (140000 140000 140000 140000 140000)	;none
	  (#/RUBOUT #/RUBOUT #/RUBOUT #/RUBOUT #/RUBOUT)
	  ;;x50
	  (#/a #/A 140000 #/ 140000)
	  (#/s #/S 140000 140000 140000)
	  (#/d #/D 140000 #/
 140000)
	  (#/f #/F 140000 140000 140000)
	  (#/g #/G #/ #/	 140000)
	  (#/h #/H #/ 140000 140000)
	  (#/j #/J #/ 140000 140000)
	  (#/k #/K #/ 140000 140000)
	  ;;x58
	  (#/l #/L #/ #/ 140000)
	  (#/; #/: #/: 140000 140000)
	  (#/' #/" #/" #/ 140000)
	  (#/RETURN #/RETURN #/RETURN #/RETURN #/RETURN)
	  (#/LINE #/LINE #/LINE #/LINE #/LINE)
	  (#/ARROW-left #/ARROW-left #/ARROW-left 140000 140000)	;arrow left
	  (#/ARROW-MIDDLE #/ARROW-MIDDLE #/ARROW-MIDDLE #/ARROW-MIDDLE #/ARROW-MIDDLE)
	  (#/ARROW-right #/ARROW-right #/ARROW-right 140000 140000)	;arrow right
	  ;;x60
	  (#/4 #/4 #/4 140000 140000)	;4 on keypad
	  (#/5 #/5 #/5 140000 140000)	;5 on keypad
	  (#/6 #/6 #/6 140000 140000)	;6 on keypad
	  (#/, #/, #/, 140000 140000)	;, on keypad
	  (140000 140000 140000 140000 140000)	;none
	  (140000 140000 140000 140000 140000)	;none
	  (100001 100001 100001 100001 100001)	;left SYMBOL
	  (100000 100000 100000 100000 100000)	;left SHIFT
	  ;;x68
	  (#/z #/Z 140000 140000 140000)
	  (#/x #/X 140000 140000 140000)
	  (#/c #/C #/ 140000 140000)
	  (#/v #/V 140000 140000 140000)
	  (#/b #/B #/ #/ 140000)
	  (#/n #/N #/ 140000 140000)
	  (#/m #/M #/ 140000 140000)
	  (#/, #/< #/< 140000 140000)
	  ;;x70
	  (#/. #/> #/> 140000 140000)
	  (#// #/? #/? #/ 140000)
	  (100040 100040 100040 100040 100040)	;right SHIFT
	  (140000 140000 140000 140000 140000)	;none
	  (100041 100041 100041 100041 100041)	;right SYMBOL
	  (#/ARROW-down #/ARROW-down #/ARROW-down 140000 140000)	;arrow down
	  (#/1 #/1 #/1 140000 140000)	;1 on keypad
	  (#/2 #/2 #/2 140000 140000)	;2 on keypad
	  ;;x78
	  (#/3 #/3 #/3 140000 140000)	;3 on keypad
	  (140000 140000 140000 140000 140000)	;none
	  (140000 140000 140000 140000 140000)	;none
	  (#/SPACE #/SPACE #/SPACE #/SPACE #/SPACE)
	  (140000 140000 140000 140000 140000)	;none
	  (#/0 #/0 #/0 140000 140000)	;0 on keypad
	  (#/. #/. #/. 140000 140000)	;. on keypad
	  (#/return #/return #/return 140000 140000)	;enter on keypad
	  )
  )
)

#+LMI
(EVAL-WHEN (LOAD)
  (TI-KEYBOARD)
)
