;; -*- Mode:LISP; Package:(BOXER GLOBAL 1000); Base:10.; fonts:cptfont, cptfontb -*-

#|

1Copyright 1982, 1983, 1984, 1985 Massachusetts Institute of Technology0

Permission to use, copy, modify, distribute, and sell this software
and its documentation for any purpose is hereby granted without fee,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of M.I.T. not be used in
advertising or publicity pertaining to distribution of the software
without specific, written prior permission.  M.I.T. makes no
representations about the suitability of this software for any
purpose.  It is provided "as is" without express or implied warranty.


 This file contains the system declaration, and various other random
 1BOXER0 1System0 hacking utilities.

|#

(EVAL-WHEN (LOAD)
  (LET ((ERROR-OUTPUT 'SI:NULL-STREAM))
    (GLOBALIZE "RECOMPILE-BOXER")
    (GLOBALIZE "LOAD-BOXER")
    (GLOBALIZE "MAKE-BOXER")
    (GLOBALIZE "START-BOXER")
    (GLOBALIZE "BOXER")
    (GLOBALIZE "INIT-FILE-BOXER")
    (GLOBALIZE "INIT-FILE-EVAL")
    (GLOBALIZE "INITIALIZE-BOXER-FROM-LISP"))
  )

(DEFSYSTEM BOXER
  (:NAME "Boxer")
  (:PATHNAME-DEFAULT "BOXER:BOXER;")
  (:PATCHABLE ":BOX-PATCH;")
  (:BUG-REPORTS "Boxer" "Report Problems about the Boxer system")
  (:MODULE DEFINITIONS ("BOXDEF"
			"ERROR"
			"DRAW"			
			"DISDEF"
			"EVDEFS"))  
  (:MODULE UTILITIES    "UTIL")
  (:MODULE RELATIONSHIPS "INFSUP")
  (:MODULE EVALDEFS    ("BIND"
			"FNCTNS"))
  (:MODULE STACK        "STACK")
; (:MODULE STEPPER      "STEP")
  (:MODULE EDITOR     (;"INFSUP"
			"STREAM"
			"EMANIP"
			"BOXWIN"
			"LODISP"
			"REDISP"
			"DISPLY"
			"MOUSE"
			"EDITOR"
			"REGION"
			"COMDEF"))
  (:MODULE PARSE1       "PARSE1")
  (:MODULE PARSE2       "PARSE2")
  (:MODULE KEYDEF      ("KEYDEF"))
  (:MODULE KEYS        ("KEYS1"
			"COMS1"))
  (:MODULE FILEDEFS    ("FILDFS"))
  (:MODULE FILESYS     ("BXFILE"
			"DUMPER"
			"LOADER"))
  (:MODULE GRAFDEFS    ("GRFDFS"
                        "GROBJS"))
  (:MODULE EVALUATOR   ("EVAL"
                        "EVPRIM"))
  (:MODULE GRAPHICS    ("TURTLE"
			"SPRITE"
			"GRDATA"))
  (:MODULE PBOX         "PBOX")
  (:MODULE BOXTEX       "BOXTEX")
  (:MODULE PRIMITIVES  ("PRIMS"
			"NUMBRS"
			"DATA"
			"GRPRIM"
			"NET"))
  (:MODULE REMOTE       "HCLOOP")
  (:MODULE COMETH       "COMETH")
  ;; The real transformations.
  (:COMPILE-LOAD DEFINITIONS)
  (:COMPILE-LOAD UTILITIES  (:FASLOAD DEFINITIONS)
                            (:FASLOAD DEFINITIONS))
  (:COMPILE-LOAD RELATIONSHIPS (:FASLOAD DEFINITIONS)
		               (:FASLOAD DEFINITIONS))
  (:COMPILE-LOAD EVALDEFS   (:FASLOAD DEFINITIONS)
                            (:FASLOAD DEFINITIONS))
  (:COMPILE-LOAD STACK      (:FASLOAD EVALDEFS)
		            (:FASLOAD EVALDEFS))
  (:COMPILE-LOAD EDITOR     (:FASLOAD EVALDEFS RELATIONSHIPS)
			    (:FASLOAD EVALDEFS RELATIONSHIPS))
  (:COMPILE-LOAD GRAFDEFS   (:FASLOAD EDITOR)
                            (:FASLOAD EDITOR))
  (:COMPILE-LOAD EVALUATOR  (:FASLOAD DEFINITIONS EDITOR GRAFDEFS EVALDEFS)
			    (:FASLOAD DEFINITIONS EDITOR GRAFDEFS EVALDEFS))
  (:COMPILE-LOAD PARSE1     (:FASLOAD EVALDEFS)
			    (:FASLOAD EVALDEFS))
  (:COMPILE-LOAD PARSE2     (:FASLOAD EVALDEFS PARSE1)
			    (:FASLOAD EVALDEFS PARSE1))
  (:COMPILE-LOAD PBOX       (:FASLOAD EDITOR EVALDEFS)
			    (:FASLOAD EDITOR EVALDEFS))
  (:COMPILE-LOAD BOXTEX     (:FASLOAD EDITOR EVALDEFS)
			    (:FASLOAD EDITOR EVALDEFS))
  (:COMPILE-LOAD KEYDEF     (:FASLOAD EDITOR EVALDEFS)
			    (:FASLOAD EDITOR EVALDEFS))
  (:COMPILE-LOAD KEYS       (:FASLOAD EDITOR EVALDEFS KEYDEF STACK)
			    (:FASLOAD EDITOR EVALDEFS KEYDEF STACK))
  (:COMPILE-LOAD FILEDEFS   (:FASLOAD EDITOR RELATIONSHIPS)
                            (:FASLOAD EDITOR RELATIONSHIPS))
  (:COMPILE-LOAD FILESYS    (:FASLOAD EDITOR FILEDEFS GRAFDEFS)
                            (:FASLOAD EDITOR FILEDEFS GRAFDEFS)) 
  (:COMPILE-LOAD GRAPHICS   (:FASLOAD EDITOR GRAFDEFS PARSE2)
                            (:FASLOAD EDITOR GRAFDEFS PARSE2))
  (:COMPILE-LOAD PRIMITIVES (:FASLOAD DEFINITIONS EVALDEFS EVALUATOR PARSE2 GRAPHICS PBOX)
			    (:FASLOAD DEFINITIONS EVALDEFS EVALUATOR PARSE2 GRAPHICS PBOX))
  (:COMPILE-LOAD REMOTE     (:FASLOAD EDITOR)
                            (:FASLOAD EDITOR))
  (:COMPILE-LOAD-INIT COMETH
		      (DEFINITIONS EDITOR EVALDEFS EVALUATOR PARSE1 PARSE2 KEYS PBOX
				   BOXTEX GRAPHICS PRIMITIVES)
		      (:FASLOAD DEFINITIONS EDITOR EVALDEFS EVALUATOR PARSE1 PARSE2 PBOX
		       BOXTEX KEYS GRAPHICS PRIMITIVES)
		      (:FASLOAD DEFINITIONS EDITOR EVALDEFS EVALUATOR PARSE1 PARSE2 PBOX
		       BOXTEX KEYS GRAPHICS PRIMITIVES)))


;;;; System maintenance utilities.
(DEFMACRO WITH-MORE-P-NIL (&BODY BODY)
  `(LET ((OLD-MORE-P (FUNCALL TERMINAL-IO ':MORE-P)))
     (UNWIND-PROTECT
       (PROGN (FORMAT TERMINAL-IO "~&Inhibiting more processing...")
	      (FUNCALL TERMINAL-IO ':SET-MORE-P NIL)
	      ,@BODY)
       (FUNCALL TERMINAL-IO ':SET-MORE-P OLD-MORE-P))))

(DEFMACRO WITH-INHIBIT-FDEFINE-WARNINGS-T (&BODY BODY)
  `(LET ((INHIBIT-FDEFINE-WARNINGS T))
     (FORMAT TERMINAL-IO "~%Inhibiting fdefine warnings...")
     ,@BODY))

;; This loads the boxer system based upon the currently loaded system declaration.
(DEFUN LOAD-BOXER ()
  (WITH-MORE-P-NIL
    (WITH-INHIBIT-FDEFINE-WARNINGS-T
      (MAKE-SYSTEM 'BOXER ':NOCONFIRM :nowarn #+SYMBOLICS '(:VERSION :LATEST)))))

;;Once boxer is loaded this makes a new boxer system.
(DEFUN MAKE-BOXER ()
  (TV:MAKE-WINDOW 'BOXER-FRAME))

;; This starts the existing boxer system.
(DECLARE (SPECIAL *BOXER-PANE*))
(DEFUN START-BOXER ()
  (AND (BOUNDP '*BOXER-PANE*) (NOT (NULL *BOXER-PANE*))
       (SEND *BOXER-PANE* ':SELECT)))

;; This is the function most people want to call.
(DEFUN BOXER ()					
  (LOAD-BOXER)
  (MAKE-BOXER)
  (START-BOXER))

;;; SHorthand for #+(or MIT LMI TI)
(EVAL-WHEN (EVAL COMPILE LOAD)
  #+(or MIT LMI TI)(SSTATUS FEATURE :LMITI)
  )
