
(in-package :TRAPS)             ; 
; 	File:		IntlResources.p
; 
; 	Copyright:	 1983-1993 by Apple Computer, Inc.
; 				All rights reserved.
; 
; 	Version:	System 7.1 for ETO #11
; 	Created:	Tuesday, March 30, 1993 18:00
; 
; 

; $IFC UNDEFINED UsingIncludes
; $SETC UsingIncludes := 0
; $ENDC

; $IFC NOT UsingIncludes

; $ENDC

; $IFC UNDEFINED UsingIntlResources
; $SETC UsingIntlResources := 1

; $I+
; $SETC IntlResourcesIncludes := UsingIncludes
; $SETC UsingIncludes := 1
; $IFC UNDEFINED UsingTypes

(require-interface 'TYPES)      ; $I $$Shell(PInterfaces)Types.p
; $ENDC
; $SETC UsingIncludes := IntlResourcesIncludes

;  Bits in the itlcFlags byte.
(defconstant $itlcShowIcon 7)   ; Show icon even if only one script
(defconstant $itlcDualCaret 6)  ; Use dual caret for mixed direction text

;  Bits in the itlcSysFlags word.
(defconstant $itlcSysDirection 15); System direction - left to right/right to left

;  the NumberParts indices 
(defconstant $tokLeftQuote 1)
(defconstant $tokRightQuote 2)
(defconstant $tokLeadPlacer 3)
(defconstant $tokLeader 4)
(defconstant $tokNonLeader 5)
(defconstant $tokZeroLead 6)
(defconstant $tokPercent 7)
(defconstant $tokPlusSign 8)
(defconstant $tokMinusSign 9)
(defconstant $tokThousands 10)
(defconstant $tokSeparator 12)  ; 11 is a reserved field
(defconstant $tokEscape 13)
(defconstant $tokDecPoint 14)
(defconstant $tokEPlus 15)
(defconstant $tokEMinus 16)
(defconstant $tokMaxSymbols 31)

(defconstant $curNumberPartsVersion 1); current version of NumberParts record

(defconstant $currSymLead 16)
(defconstant $currNegSym 32)
(defconstant $currTrailingZ 64)
(defconstant $currLeadingZ 128)

(defconstant $zeroCycle 1)      ; 0:00 AM/PM format
(defconstant $longDay 0)        ; day of the month
(defconstant $longWeek 1)       ; day of the week
(defconstant $longMonth 2)      ; month of the year
(defconstant $longYear 3)       ; year
(defconstant $supDay 1)         ; suppress day of month
(defconstant $supWeek 2)        ; suppress day of week
(defconstant $supMonth 4)       ; suppress month
(defconstant $supYear 8)        ; suppress year
(defconstant $dayLdingZ 32)
(defconstant $mntLdingZ 64)
(defconstant $century 128)
(defconstant $secLeadingZ 32)
(defconstant $minLeadingZ 64)
(defconstant $hrLeadingZ 128)

;  Date Orders 
(defconstant $mdy 0)
(defconstant $dmy 1)
(defconstant $ymd 2)
(defconstant $myd 3)
(defconstant $dym 4)
(defconstant $ydm 5)

(defrecord OffPair 
   (offFirst :SIGNED-INTEGER)
   (offSecond :SIGNED-INTEGER)
   )

(defrecord OffsetTable (array (ARRAY :OFFPAIR 3)))

(def-mactype :INTL0PTR (find-mactype :POINTER))
(def-mactype :INTL0HNDL (find-mactype :HANDLE))
(defrecord (Intl0Rec :handle) 
   (decimalPt :CHARACTER)       ; decimal point character
   (thousSep :CHARACTER)        ; thousands separator character
   (listSep :CHARACTER)         ; list separator character
   (currSym1 :CHARACTER)        ; currency symbol
   (currSym2 :CHARACTER)
   (currSym3 :CHARACTER)
   (currFmt :UNSIGNED-BYTE)     ; currency format flags
   (dateOrder :UNSIGNED-BYTE)   ; order of short date elements: mdy, dmy, etc.
   (shrtDateFmt :UNSIGNED-BYTE) ; format flags for each short date element
   (dateSep :CHARACTER)         ; date separator character
   (timeCycle :UNSIGNED-BYTE)   ; specifies time cycle: 0..23, 1..12, or 0..11
   (timeFmt :UNSIGNED-BYTE)     ; format flags for each time element
   (mornStr :OSTYPE)            ; trailing string for AM if 12-hour cycle
   (eveStr :OSTYPE)             ; trailing string for PM if 12-hour cycle
   (timeSep :CHARACTER)         ; time separator character
   (time1Suff :CHARACTER)       ; trailing string for AM if 24-hour cycle
   (time2Suff :CHARACTER)
   (time3Suff :CHARACTER)
   (time4Suff :CHARACTER)
   (time5Suff :CHARACTER)       ; trailing string for PM if 24-hour cycle
   (time6Suff :CHARACTER)
   (time7Suff :CHARACTER)
   (time8Suff :CHARACTER)
   (metricSys :UNSIGNED-BYTE)   ; 255 if metric, 0 if inches etc.
   (intl0Vers :SIGNED-INTEGER)  ; region code (hi byte) and version (lo byte)
   )

(def-mactype :INTL1PTR (find-mactype :POINTER))
(def-mactype :INTL1HNDL (find-mactype :HANDLE))
(defrecord (Intl1Rec :handle) 
   (days (:ARRAY (:STRING 15) 7)); day names
   (months (:ARRAY (:STRING 15) 12)); month names
   (suppressDay :UNSIGNED-BYTE) ; 255 for no day, or flags to suppress any element
   (lngDateFmt :UNSIGNED-BYTE)  ; order of long date elements
   (dayLeading0 :UNSIGNED-BYTE) ; 255 for leading 0 in day number
   (abbrLen :UNSIGNED-BYTE)     ; length for abbreviating names
   (st0 :OSTYPE)                ; separator strings for long date format
   (st1 :OSTYPE)
   (st2 :OSTYPE)
   (st3 :OSTYPE)
   (st4 :OSTYPE)
   (intl1Vers :SIGNED-INTEGER)  ; region code (hi byte) and version (lo byte)
   (localRtn (:ARRAY :SIGNED-INTEGER 1)); now a flag for opt extension
   )

(def-mactype :UNTOKENTABLEPTR (find-mactype :POINTER))
(def-mactype :UNTOKENTABLEHANDLE (find-mactype :HANDLE))
(defrecord (UntokenTable :handle) 
   (len :SIGNED-INTEGER)
   (lastToken :SIGNED-INTEGER)
   (index (:ARRAY :SIGNED-INTEGER 256)); index table; last = lastToken
   )

(defrecord WideChar 
   (:variant 

      ((a (:ARRAY :CHARACTER 2))); 0 is the high order character

      ((b :SIGNED-INTEGER))
      ))

(defrecord WideCharArr 
   (size :SIGNED-INTEGER)
   (data (:ARRAY :WIDECHAR 10))
   )

(def-mactype :NUMBERPARTSPTR (find-mactype :POINTER))
(defrecord NumberParts 
   (version :SIGNED-INTEGER)
   (data (:ARRAY :WIDECHAR 31)) ; index by [tokLeftQuote..tokMaxSymbols]
   (pePlus :WIDECHARARR)
   (peMinus :WIDECHARARR)
   (peMinusPlus :WIDECHARARR)
   (altNumTable :WIDECHARARR)
   (reserved (:ARRAY :CHARACTER 20))
   )

(def-mactype :ITL4PTR (find-mactype :POINTER))
(def-mactype :ITL4HANDLE (find-mactype :HANDLE))
(defrecord (Itl4Rec :handle) 
   (flags :SIGNED-INTEGER)      ; reserved
   (resourceType :SIGNED-LONG)  ; contains 'itl4'
   (resourceNum :SIGNED-INTEGER); resource ID
   (version :SIGNED-INTEGER)    ; version number
   (resHeader1 :SIGNED-LONG)    ; reserved
   (resHeader2 :SIGNED-LONG)    ; reserved
   (numTables :SIGNED-INTEGER)  ; number of tables, one-based
   (mapOffset :SIGNED-LONG)     ; offset to table that maps byte to token
   (strOffset :SIGNED-LONG)     ; offset to routine that copies canonical string
   (fetchOffset :SIGNED-LONG)   ; offset to routine that gets next byte of character
   (unTokenOffset :SIGNED-LONG) ; offset to table that maps token to canonical string
   (defPartsOffset :SIGNED-LONG); offset to default number parts table
   (resOffset6 :SIGNED-LONG)    ; reserved
   (resOffset7 :SIGNED-LONG)    ; reserved
   (resOffset8 :SIGNED-LONG)    ; reserved
   )

;  New NItl4Rec for System 7.0: 

(def-mactype :NITL4PTR (find-mactype :POINTER))
(def-mactype :NITL4HANDLE (find-mactype :HANDLE))
(defrecord (NItl4Rec :handle) 
   (flags :SIGNED-INTEGER)      ; reserved
   (resourceType :SIGNED-LONG)  ; contains 'itl4'
   (resourceNum :SIGNED-INTEGER); resource ID
   (version :SIGNED-INTEGER)    ; version number
   (format :SIGNED-INTEGER)     ; format code
   (resHeader :SIGNED-INTEGER)  ; reserved
   (resHeader2 :SIGNED-LONG)    ; reserved
   (numTables :SIGNED-INTEGER)  ; number of tables, one-based
   (mapOffset :SIGNED-LONG)     ; offset to table that maps byte to token
   (strOffset :SIGNED-LONG)     ; offset to routine that copies canonical string
   (fetchOffset :SIGNED-LONG)   ; offset to routine that gets next byte of character
   (unTokenOffset :SIGNED-LONG) ; offset to table that maps token to canonical string
   (defPartsOffset :SIGNED-LONG); offset to default number parts table
   (whtSpListOffset :SIGNED-LONG); offset to white space code list
   (resOffset7 :SIGNED-LONG)    ; reserved
   (resOffset8 :SIGNED-LONG)    ; reserved
   (resLength1 :SIGNED-INTEGER) ; reserved
   (resLength2 :SIGNED-INTEGER) ; reserved
   (resLength3 :SIGNED-INTEGER) ; reserved
   (unTokenLength :SIGNED-INTEGER); length of untoken table
   (defPartsLength :SIGNED-INTEGER); length of default number parts table
   (whtSpListLength :SIGNED-INTEGER); length of white space code list
   (resLength7 :SIGNED-INTEGER) ; reserved
   (resLength8 :SIGNED-INTEGER) ; reserved
   )

(defrecord TableDirectoryRecord 
   (tableSignature :OSTYPE)     ; 4 byte long table name 
   (reserved :SIGNED-LONG)      ; Reserved for internal use 
   (tableStartOffset :SIGNED-LONG); Table start offset in byte
   (tableSize :SIGNED-LONG)     ; Table size in byte
   )

(defrecord Itl5Record 
   (versionNumber :SIGNED-LONG) ; itl5 resource version number 
   (numberOfTables :SIGNED-INTEGER); Number of tables it contains 
   (reserved (:ARRAY :SIGNED-INTEGER 3)); Reserved for internal use 
   (tableDirectory (:ARRAY :TABLEDIRECTORYRECORD 1)); Table directory records 
   )

(defrecord RuleBasedTrslRecord 
   (sourceType :SIGNED-INTEGER) ; Transliterate target type for the LHS of the rule 
   (targetType :SIGNED-INTEGER) ; Transliterate target type for the RHS of the rule 
   (formatNumber :SIGNED-INTEGER); Transliterate resource format number 
   (propertyFlag :SIGNED-INTEGER); Transliterate property flags 
   (numberOfRules :SIGNED-INTEGER); Number of rules following this field 
   )

(defrecord ItlcRecord 
   (itlcSystem :SIGNED-INTEGER) ; default system script
   (itlcReserved :SIGNED-INTEGER); reserved
   (itlcFontForce :SIGNED-BYTE) ; default font force flag
   (itlcIntlForce :SIGNED-BYTE) ; default intl force flag
   (itlcOldKybd :SIGNED-BYTE)   ; MacPlus intl keybd flag
   (itlcFlags :SIGNED-BYTE)     ; general flags
   (itlcIconOffset :SIGNED-INTEGER); keyboard icon offset; not used in 7.0
   (itlcIconSide :SIGNED-BYTE)  ; keyboard icon side; not used in 7.0
   (itlcIconRsvd :SIGNED-BYTE)  ; rsvd for other icon info
   (itlcRegionCode :SIGNED-INTEGER); preferred verXxx code
   (itlcSysFlags :SIGNED-INTEGER); flags for setting system globals
   (itlcReserved4 (:ARRAY :SIGNED-BYTE 32)); for future use
   )

(defrecord ItlbRecord 
   (itlbNumber :SIGNED-INTEGER) ; itl0 id number
   (itlbDate :SIGNED-INTEGER)   ; itl1 id number
   (itlbSort :SIGNED-INTEGER)   ; itl2 id number
   (itlbFlags :SIGNED-INTEGER)  ; Script flags
   (itlbToken :SIGNED-INTEGER)  ; itl4 id number
   (itlbEncoding :SIGNED-INTEGER); itl5 ID # (optional; char encoding)
   (itlbLang :SIGNED-INTEGER)   ; current language for script 
   (itlbNumRep :SIGNED-BYTE)    ; number representation code
   (itlbDateRep :SIGNED-BYTE)   ; date representation code 
   (itlbKeys :SIGNED-INTEGER)   ; KCHR id number
   (itlbIcon :SIGNED-INTEGER)   ; ID # of SICN or kcs#/kcs4/kcs8 suite.
   )

;  New ItlbExtRecord structure for System 7.0 

(defrecord ItlbExtRecord 
   (base :ITLBRECORD)           ; un-extended ItlbRecord
   (itlbLocalSize :SIGNED-LONG) ; size of script's local record
   (itlbMonoFond :SIGNED-INTEGER); default monospace FOND ID
   (itlbMonoSize :SIGNED-INTEGER); default monospace font size
   (itlbPrefFond :SIGNED-INTEGER); preferred FOND ID
   (itlbPrefSize :SIGNED-INTEGER); preferred font size
   (itlbSmallFond :SIGNED-INTEGER); default small FOND ID
   (itlbSmallSize :SIGNED-INTEGER); default small font size
   (itlbSysFond :SIGNED-INTEGER); default system FOND ID
   (itlbSysSize :SIGNED-INTEGER); default system font size
   (itlbAppFond :SIGNED-INTEGER); default application FOND ID
   (itlbAppSize :SIGNED-INTEGER); default application font size
   (itlbHelpFond :SIGNED-INTEGER); default Help Mgr FOND ID
   (itlbHelpSize :SIGNED-INTEGER); default Help Mgr font size
   (itlbValidStyles :STYLE)     ; set of valid styles for script
   (itlbAliasStyle :STYLE)      ; style (set) to mark aliases
   )

; $ENDC                         ;  UsingIntlResources 

; $IFC NOT UsingIncludes

; $ENDC


(export '($YDM $DYM $MYD $YMD $DMY $MDY $HRLEADINGZ $MINLEADINGZ $SECLEADINGZ
          $CENTURY $MNTLDINGZ $DAYLDINGZ $SUPYEAR $SUPMONTH $SUPWEEK $SUPDAY
          $LONGYEAR $LONGMONTH $LONGWEEK $LONGDAY $ZEROCYCLE $CURRLEADINGZ
          $CURRTRAILINGZ $CURRNEGSYM $CURRSYMLEAD $CURNUMBERPARTSVERSION
          $TOKMAXSYMBOLS $TOKEMINUS $TOKEPLUS $TOKDECPOINT $TOKESCAPE
          $TOKSEPARATOR $TOKTHOUSANDS $TOKMINUSSIGN $TOKPLUSSIGN $TOKPERCENT
          $TOKZEROLEAD $TOKNONLEADER $TOKLEADER $TOKLEADPLACER $TOKRIGHTQUOTE
          $TOKLEFTQUOTE $ITLCSYSDIRECTION $ITLCDUALCARET $ITLCSHOWICON))
(provide-interface 'IntlResources)