; Example window.
;
; This is a simple example of how to create a typical window
; using MCL. 
;
;
; To use, load this file then eval this expression:
; (make-instance 'my-window)

;-------------------------------
(in-package ccl)                        ; specify package

(require :quickdraw)                    ; needed for paint-rect

;-------------------------------

(defclass my-window (window)
  ((color :initform 'red :accessor color :initarg :color))
  (:default-initargs
    :color-p t                          ; use color
    :window-title "I'm a MY-WINDOW"     ; title
    :window-show nil))                  ; hide window until initialize-instance runs


(defmethod initialize-instance :after ((self my-window) &rest ignore)
  (declare (ignore ignore))
  (let ((radio-button1 (make-instance 'radio-button-dialog-item
                         :dialog-item-text "Red"
                         :view-nick-name 'red
                         :view-position #@(10 10)
                         :radio-button-pushed-p t
                         :dialog-item-action #'push-color-button))
        (radio-button2 (make-instance 'radio-button-dialog-item
                         :dialog-item-text "Green"
                         :view-nick-name 'green
                         :view-position #@(10 30)
                         :dialog-item-action #'push-color-button))
        (radio-button3 (make-instance 'radio-button-dialog-item
                         :dialog-item-text "Blue"
                         :view-nick-name 'blue
                         :view-position #@(10 50)
                         :dialog-item-action #'push-color-button))
        (push-button (make-instance 'button-dialog-item
                       :view-nick-name 'boink-button
                       :dialog-item-text "Boink!"
                       :dialog-item-action
                       #'(lambda (button) 
                           (format t "~%You have pressed ~A and the color is ~A"
                                   button (color (view-container button)))))))
    (add-subviews self 
                  radio-button1 radio-button2 
                  radio-button3 push-button)
    (resize-subviews self)              ; move button
    (window-show self)))                ; then show finished window

;---------
; What happens when you push a button

(defun push-color-button (button)
  (let ((choice (view-nick-name button))
        (parent (view-container button)))
    (setf (color parent) choice)
    (invalidate-view parent)))

;---------
; Appearance

; Draw a big color rectangle
(defmethod view-draw-contents ((self my-window))
  (call-next-method)                    ; call other view-draw-contents methods too!
  (with-fore-color (ecase (color self)
                     (red *red-color*)
                     (green *green-color*)
                     (blue *blue-color*))
    (paint-rect self #@(100 10) #@(200 70))))

;---------
; Geometry
;

; Returns a position for the button in the corner.
(defmethod corner-position (button)
  (let ((margin #@(20 20)))
    (subtract-points (view-size (view-container button))
                     (add-points margin (view-size button)))))

; Automatically move the "boink" button when the window is resized.
(defmethod resize-subviews ((self my-window))
  (let ((button (view-named 'boink-button self)))
    (set-view-position button (corner-position button))))


; Update when window is resized.
(defmethod set-view-size :after ((self my-window) h &optional v)
  (declare (ignore h v))
  (resize-subviews self))

; Update when the window's zoombox is clicked.
(defmethod window-zoom-event-handler :after ((self my-window) message)
  (declare (ignore message))
  (resize-subviews self))

