;;
;; shift-left  (function key F8)
;; shifts each line in the selection left by 1 character
;; 
;; shift-right (function key F9)
;; shifts each line in the selection right by 1 character
;; 
;; quote-selection (function key F10)
;; shifts each line in the selection right by 1 character inserting a >
;; 
;; both key functions are undo-able
;;
;;    Copyright  1992 John R. Montbriand.  All Rights Reserved.



(defmethod shift-left ((w fred-mixin))
  "shifts each line in the selection to the left by one character"
  (multiple-value-bind (start end) (selection-range w)
    (prog ((line-starts nil) (append-p nil))
      (do ((i start (1+ i))) ((and line-starts (>= i end)))
        (multiple-value-bind (position-of-start shortfall)
                             (buffer-line-start (fred-buffer w) i 0)
          (declare (ignore shortfall))
          (if (null (member position-of-start line-starts))
            (push position-of-start line-starts))))
      (dolist (pos line-starts)
        (if (char= #\Space (buffer-char (fred-buffer w) pos))
          (progn
            (setq *last-command* nil)
            (ed-delete-with-undo w pos (1+ pos) nil nil append-p)
            (setq append-p t))))
      (if append-p (set-fred-undo-string w "shift left")))))

(defmethod shift-in ((w fred-mixin) shift-in-char)
  "shifts each line in the selection to the right by one character"
  (multiple-value-bind (start end) (selection-range w)
    (prog ((line-starts nil) (append-p nil))
      (do ((i start (1+ i))) ((and line-starts (>= i end)))
        (multiple-value-bind (position-of-start shortfall)
                             (buffer-line-start (fred-buffer w) i 0)
          (declare (ignore shortfall))
          (if (null (member position-of-start line-starts))
            (push position-of-start line-starts))))
      (dolist (pos line-starts)
        (ed-insert-with-undo w shift-in-char pos append-p)
        (setq append-p t))
      (if append-p (set-fred-undo-string w "shift right")))))

(defmethod shift-right ((w fred-mixin))
  "shifts each line in the selection to the right by one character"
  (shift-in w #\Space))

(defmethod quote-selection ((w fred-mixin))
  "quotes the selection by inserting > characters at the beginning of each line."
  (shift-in w #\>))


(comtab-set-key *comtab* '(:function #\8) 'shift-left)
(comtab-set-key *comtab* '(:function #\9) 'shift-right)
(comtab-set-key *comtab* '(:function #\a) 'quote-selection)
