/*
 *======================================================================
 *
 *Copyright 1992 Sun Microsystems, Inc.
 *
 *The Interface Definition Language Compiler Front End (CFE) is made
 *available for use provided that this legend is included on all media and
 *documentation and as a part of the software program in whole or part.
 *Users may copy and extend functionality (but may not remove
 *functionality) of the Interface Definition Language CFE without charge,
 *but are not authorized to license or distribute it to anyone else except
 *as part of a product or program developed by the user or with the express
 *written consent of Sun Microsystems, Inc.
 *
 *The names of Sun Microsystems, Inc. and any of its subsidiaries may not
 *be used in advertising or publicity pertaining to distribution of
 *Interface Definition Language CFE as permitted herein.
 *
 *The Interface Definition Language CFE may not be exported outside the
 *United States without first obtaining the appropriate government
 *approvals.
 *
 *INTERFACE DEFINITION LANGUAGE CFE IS PROVIDED AS IS WITH NO WARRANTIES
 *OF ANY KIND INCLUDING THE WARRANTIES OF DESIGN, MERCHANTIBILITY AND
 *FITNESS FOR A PARTICULAR PURPOSE, NONINFRINGEMENT, OR ARISING FROM A
 *COURSE OF DEALING, USAGE OR TRADE PRACTICE.
 *
 *Interface Definition Language CFE is provided with no support and
 *without any obligation on the part of Sun Microsystems, Inc. or any of
 *its subsidiaries or affiliates to assist in its use, correction,
 *modification or enhancement.
 *
 *SUN MICROSYSTEMS, INC. OR ANY OF ITS SUBSIDIARIES OR AFFILIATES SHALL
 *HAVE NO LIABILITY WITH RESPECT TO THE INFRINGEMENT OF COPYRIGHTS, TRADE
 *SECRETS OR ANY PATENTS BY INTERFACE DEFINITION LANGUAGE CFE OR ANY PART
 *THEREOF.
 *
 *IN NO EVENT WILL SUN MICROSYSTEMS, INC. OR ANY OF ITS SUBSIDIARIES OR
 *AFFILIATES BE LIABLE FOR ANY LOST REVENUE OR PROFITS OR OTHER SPECIAL,
 *INDIRECT AND CONSEQUENTIAL DAMAGES, EVEN IF SUN HAS BEEN ADVISED OF THE
 *POSSIBILITY OF SUCH DAMAGES.
 *
 *SunSoft, Inc.  
 *2550 Garcia Avenue 
 *Mountain View, California  94043
 *
 *
 *
 *
 *======================================================================
 */

#pragma ident "%@(#)utl_string.cc	1.20% %92/06/10% Sun Microsystems"

// utl_string.cc - Implementation of quick and dirty TEMPORARY String
//		   for IDL compiler

#include	<idl.hh>
#include	<idl_extern.hh>

/*
 * Constructors
 */

UTL_String::UTL_String() : p_str(NULL), len(0), alloced(0) {}

UTL_String::UTL_String(char *str)
{
  if (str == NULL) {
    len = alloced = 0;
    p_str = c_str = NULL;
  } else {
    len = strlen(str);
    alloced = len + 1;
    p_str = new char [alloced];
    c_str = new char [alloced];
    strcpy(p_str, str);
    canonicalize();
  }
}

UTL_String::UTL_String(unsigned long maxlen)
{
  len = maxlen;
  alloced = maxlen + 1;
  p_str = new char [alloced];
  c_str = new char [alloced];
  p_str[0] = '\0';
  c_str[0] = '\0';
}

UTL_String::UTL_String(UTL_String *s)
{
  char	*b;

  if (s == NULL) {
    p_str = c_str = NULL;
    alloced = len = 0;
  } else {
    b = s->get_string();
    if (b == NULL) {
      p_str = c_str = NULL;
      alloced = len = 0;
    } else {
      len = strlen(b);
      alloced = len + 1;
      p_str = new char [alloced];
      c_str = new char [alloced];
      strcpy(p_str, b);
      canonicalize();
    }
  }
}

/*
 * Private operations
 */

// Compute a canonical form for this string. This is (implemented as)
// a corresponding string with all upper case characters where the
// original has lower case characters, identical characters otherwise
void
UTL_String::canonicalize()
{
  long	i;

  for (i = 0; i < len; i++)
    c_str[i] = toupper(p_str[i]);
  c_str[i] = '\0';
}

/*
 * Public operations
 */

// Compare two String *
long
UTL_String::compare(UTL_String *s)
{
  char	*s_c_str;
  long	result;

  if (c_str == NULL || s == NULL || (s_c_str = s->get_canonical_rep()) == NULL)
    result = FALSE;
  else
    result = (strcmp(c_str, s_c_str) == 0) ? TRUE : FALSE;

  /*
   * Check that the names are typed consistently
   */
  if (result == TRUE && strcmp(p_str, s->get_string()) != 0)
    idl_global->err()->name_case_error(p_str, s->get_string());

  return result;
}

// Get the char * from a String
char *
UTL_String::get_string()
{
  return p_str;
}

// Get the canonical representation from a String
char *
UTL_String::get_canonical_rep()
{
  if (c_str == NULL) {
    c_str = new char [alloced];
    canonicalize();
  }
  return c_str;
}

/*
 * Redefined virtual operations
 */

// AST Dumping
void
UTL_String::dump(ostream &o)
{
  o << p_str;
}
