
%{
/*
 *======================================================================
 *
 *Copyright 1992 Sun Microsystems, Inc.
 *
 *The Interface Definition Language Compiler Front End (CFE) is made
 *available for use provided that this legend is included on all media and
 *documentation and as a part of the software program in whole or part.
 *Users may copy and extend functionality (but may not remove
 *functionality) of the Interface Definition Language CFE without charge,
 *but are not authorized to license or distribute it to anyone else except
 *as part of a product or program developed by the user or with the express
 *written consent of Sun Microsystems, Inc.
 *
 *The names of Sun Microsystems, Inc. and any of its subsidiaries may not
 *be used in advertising or publicity pertaining to distribution of
 *Interface Definition Language CFE as permitted herein.
 *
 *The Interface Definition Language CFE may not be exported outside the
 *United States without first obtaining the appropriate government
 *approvals.
 *
 *INTERFACE DEFINITION LANGUAGE CFE IS PROVIDED AS IS WITH NO WARRANTIES
 *OF ANY KIND INCLUDING THE WARRANTIES OF DESIGN, MERCHANTIBILITY AND
 *FITNESS FOR A PARTICULAR PURPOSE, NONINFRINGEMENT, OR ARISING FROM A
 *COURSE OF DEALING, USAGE OR TRADE PRACTICE.
 *
 *Interface Definition Language CFE is provided with no support and
 *without any obligation on the part of Sun Microsystems, Inc. or any of
 *its subsidiaries or affiliates to assist in its use, correction,
 *modification or enhancement.
 *
 *SUN MICROSYSTEMS, INC. OR ANY OF ITS SUBSIDIARIES OR AFFILIATES SHALL
 *HAVE NO LIABILITY WITH RESPECT TO THE INFRINGEMENT OF COPYRIGHTS, TRADE
 *SECRETS OR ANY PATENTS BY INTERFACE DEFINITION LANGUAGE CFE OR ANY PART
 *THEREOF.
 *
 *IN NO EVENT WILL SUN MICROSYSTEMS, INC. OR ANY OF ITS SUBSIDIARIES OR
 *AFFILIATES BE LIABLE FOR ANY LOST REVENUE OR PROFITS OR OTHER SPECIAL,
 *INDIRECT AND CONSEQUENTIAL DAMAGES, EVEN IF SUN HAS BEEN ADVISED OF THE
 *POSSIBILITY OF SUCH DAMAGES.
 *
 *SunSoft, Inc.  
 *2550 Garcia Avenue 
 *Mountain View, California  94043
 *
 *
 *
 *
 *======================================================================
 */

/*
 * idl.ll - Lexical scanner for IDL 1.1
 */

INCLUDE <idl.hh>
INCLUDE <idl_extern.hh>

INCLUDE <fe_private.hh>

INCLUDE <y.tab.hh>

static char	idl_escape_reader(char **);
static double	idl_atof(char *);
static unsigned long	idl_atoi(char *, long);
static void	idl_parse_line_and_file(char *);
static void	idl_store_pragma(char *);

// HPUX has yytext typed to unsigned char *. We make sure here that
// we'll always use char *
static char	*__yytext = (char *) yytext;

%}

%%

module		return MODULE;
raises		return RAISES;
readonly	return READONLY;
attribute	return ATTRIBUTE;
exception	return EXCEPTION;
context		return CONTEXT;
interface	return INTERFACE;
const		return CONST;
typedef		return TYPEDEF;
struct		return STRUCT;
enum		return ENUM;
string		return STRING;
sequence	return SEQUENCE;
union		return UNION;
switch		return SWITCH;
case		return CASE;
default		return DEFAULT;
float		return FLOAT;
double		return DOUBLE;
long		return LONG;
short		return SHORT;
unsigned	return UNSIGNED;
char		return CHAR;
boolean		return BOOLEAN;
octet		return OCTET;
void		return VOID;

TRUE		return TRUETOK;
FALSE		return FALSETOK;

inout		return INOUT;
in		return IN;
out		return OUT;
oneway		return ONEWAY;

\<\<		return LEFT_SHIFT;
\>\>		return RIGHT_SHIFT;
\:\:		{
		  yylval.sval = new String("::");
		  return SCOPE_DELIMITOR;
		}

[a-zA-Z][a-zA-Z0-9_]*	{
		  yylval.sval = new String(__yytext);
		  return IDENTIFIER;
		}


-?[0-9]+"."[0-9]*([eE][+-]?[0-9]+)?[lLfF]?      {
                  yylval.dval = idl_atof(__yytext);
                  return FLOATING_PT_LITERAL;
                }
-?[0-9]+[eE][+-]?[0-9]+[lLfF]?  {
                  yylval.dval = idl_atof(__yytext);
                  return FLOATING_PT_LITERAL;
                }

[1-9][0-9]*	{
		  yylval.ival = idl_atoi(__yytext, 10);
		  return INTEGER_LITERAL;
	        }
0[xX][a-fA-F0-9]+ {
		  yylval.ival = idl_atoi(__yytext, 16);
		  return INTEGER_LITERAL;
	        }
0[0-7]*	{
		  yylval.ival = idl_atoi(__yytext, 8);
		  return INTEGER_LITERAL;
	      	}

"\""[^\"\\]*"\""	{
		  __yytext[strlen(__yytext)-1] = '\0';
		  yylval.sval = new String(__yytext + 1);
		  return STRING_LITERAL;
	      	}
"\""([^\"\\]|(\\.))*"\""	{
		  char *src = __yytext + 1;
		  char *dst = __yytext;
		  int ch;

		  while ((ch = *src++) != '"') {
		    if (ch == '\\')
		      ch = idl_escape_reader(&src);
		    *dst++ = ch;
		  }
		  *dst = 0;
		  yylval.sval = new String(__yytext);
		  return STRING_LITERAL;
	      	}
"'"."'"		{
		  yylval.cval = __yytext[1];
		  return CHARACTER_LITERAL;
	      	}
"'"\\([0-7]{1,3})"'"	{
		  char *cursor = __yytext + 2;
		  yylval.cval = idl_escape_reader(&cursor);
		  return CHARACTER_LITERAL;
		}
"'"\\."'"	{
		  char *cursor = __yytext + 2;
		  yylval.cval = idl_escape_reader(&cursor);
		  return CHARACTER_LITERAL;
		}
^#[ \t]*pragma.*\n	{
  		  idl_global->set_lineno(idl_global->lineno() + 1);
		  idl_store_pragma(__yytext);
		}
^#" "[0-9]*" ""\""[^\"]*"\""" "[0-9]*\n		{
		  idl_parse_line_and_file(__yytext);
		}
^#" "[0-9]*" ""\""[^\"]*"\""\n			{
		  idl_parse_line_and_file(__yytext);
		}
^#" "[0-9]*\n	{
		  idl_parse_line_and_file(__yytext);
	        }
[ \t]*		;
\n		{
  		  idl_global->set_lineno(idl_global->lineno() + 1);
		}
.		return __yytext[0];

%%
	/* subroutines */

/*
 * Strip down a name to the last component, i.e. everything after the last
 * '/' character
 */
static char *
stripped_name(UTL_String *fn)
{
    char	*n = fn->get_string();
    long	l;

    if (n == NULL)
	return NULL;
    l = strlen(n);
    for (n += l; l > 0 && *n != '/'; l--, n--);
    if (*n == '/') n++;
    return n;
}
    
/*
 * Parse a #line statement generated by the C preprocessor
 */
static void
idl_parse_line_and_file(char *buf)
{
  char		*r = buf;
  char 		*h;
  UTL_String	*nm;

  /* Skip initial '#' */
  if (*r != '#') {
    return;
  }

  /* Find line number */
  for (r++; *r == ' ' || *r == '\t'; r++);
  h = r;
  for (; *r != '\0' && *r != ' ' && *r != '\t'; r++);
  *r++ = 0;
  idl_global->set_lineno(idl_atoi(h, 10));
  
  /* Find file name, if present */
  for (; *r != '"'; r++) {
    if (*r == '\n' || *r == '\0')
      return;
  }
  h = ++r;
  for (; *r != '"'; r++);
  *r = 0;
  if (*h == '\0')
    idl_global->set_filename(new String("standard input"));
  else
    idl_global->set_filename(new String(h));

  idl_global->set_in_main_file(
    (idl_global->filename()->compare(idl_global->main_filename())) ?
    TRUE :
    FALSE
  );
  /*
   * If it's an include file store the stripped name for the BE to use
   */
  if (!(idl_global->in_main_file())) {
    nm = new UTL_String(stripped_name(idl_global->filename()));
    idl_global->store_include_file_name(nm);
  }
}
    
/*
 * Store a #pragma line into the list of pragmas
 */
static void
idl_store_pragma(char *buf)
{
  if (idl_global->pragmas() == NULL)
    idl_global->set_pragmas(new UTL_StrList(new String(buf), NULL));
  else
    idl_global->pragmas()->nconc(new UTL_StrList(new String(buf), NULL));
}

/*
 * idl_atoi - Convert a string of digits into an integer according to base b
 */
static unsigned long
idl_atoi(char *s, long b)
{
	unsigned long	r = 0;

	if (b == 8 && *s == '0')
	  s++;
	else if (b == 16 && *s == '0' && (*(s + 1) == 'x' || *(s + 1) == 'X'))
	  s += 2;

	for (; *s; s++)
	  if (*s <= '9' && *s >= '0')
	    r = (r * b) + (*s - '0');
	  else if (b > 10 && *s <= 'f' && *s >= 'a')
	    r = (r * b) + (*s - 'a' + 10);
	  else if (b > 10 && *s <= 'F' && *s >= 'A')
	    r = (r * b) + (*s - 'A' + 10);
	  else
	    break;

	return r;
}

/*
 * Convert a string to a float; atof doesn't seem to work, always.
 */
static double
idl_atof(char *s)
{
	char    *h = s;
	double	d = 0.0;
	double	f = 0.0;
	double	e, k;
	long	neg = 0, negexp = 0;

	if (*s == '-') {
	  neg = 1;
	  s++;
	}
	while (*s >= '0' && *s <= '9') {
		d = (d * 10) + *s - '0';
		s++;
	}
	if (*s == '.') {
		s++;
		e = 10;
		while (*s >= '0' && *s <= '9') {
			d += (*s - '0') / (e * 1.0);
			e *= 10;
			s++;
		}
	}
	if (*s == 'e' || *s == 'E') {
		s++;
		if (*s == '-') {
			negexp = 1;
			s++;
		} else if (*s == '+')
			s++;
		e = 0;
		while (*s >= '0' && *s <= '9') {
			e = (e * 10) + *s - '0';
			s++;
		}
		if (e > 0) {
			for (k = 1; e > 0; k *= 10, e--);
			if (negexp)
				d /= k;
			else
				d *= k;
		}
	}

	if (neg) d *= -1.0;

	return d;
}	

/*
 * Convert (some) escaped characters into their ascii values
 */
static char
idl_escape_reader(
    char **p_cursor
)
{
    int ch = *(*p_cursor)++;

    switch (ch) {
      case 'n':
	return '\n';
      case 't':
	return '\t';
      case 'v':
	return '\v';
      case 'b':
	return '\b';
      case 'r':
	return '\r';
      case 'f':
	return '\f';
      case 'a':
	return '\a';
      case '\\':
	return '\\';
      case '\?':
	return '?';
      case '\'':
	return '\'';
      case '"':
	return '"';
      case 'x':
	{
	    // hex value
	    int out = 0;
	    for (int i = 0; i < 2 && isxdigit(ch = **p_cursor); i++) {
		out = out * 16 + ch -
			(isdigit(ch) ? '0' : ch >= 'a' ? 'a' - 10 : 'A' - 10);
		*p_cursor += 1;
	    }
	    return out;
	}
	break;
      default:
	// check for octal value
	if (ch >= '0' && ch <= '7') {
	    int out = ch - '0';
	    for (int i = 0; i < 2 && (ch = **p_cursor) >= '0' && ch <= '7'; i++)
		out = out * 8 + ch - '0', *p_cursor += 1;
	    return out;
	} else {
	  return ch - 'a';
	}
	break;
    }
}
