/*
 *======================================================================
 *
 *Copyright 1992 Sun Microsystems, Inc.
 *
 *The Interface Definition Language Compiler Front End (CFE) is made
 *available for use provided that this legend is included on all media and
 *documentation and as a part of the software program in whole or part.
 *Users may copy and extend functionality (but may not remove
 *functionality) of the Interface Definition Language CFE without charge,
 *but are not authorized to license or distribute it to anyone else except
 *as part of a product or program developed by the user or with the express
 *written consent of Sun Microsystems, Inc.
 *
 *The names of Sun Microsystems, Inc. and any of its subsidiaries may not
 *be used in advertising or publicity pertaining to distribution of
 *Interface Definition Language CFE as permitted herein.
 *
 *The Interface Definition Language CFE may not be exported outside the
 *United States without first obtaining the appropriate government
 *approvals.
 *
 *INTERFACE DEFINITION LANGUAGE CFE IS PROVIDED AS IS WITH NO WARRANTIES
 *OF ANY KIND INCLUDING THE WARRANTIES OF DESIGN, MERCHANTIBILITY AND
 *FITNESS FOR A PARTICULAR PURPOSE, NONINFRINGEMENT, OR ARISING FROM A
 *COURSE OF DEALING, USAGE OR TRADE PRACTICE.
 *
 *Interface Definition Language CFE is provided with no support and
 *without any obligation on the part of Sun Microsystems, Inc. or any of
 *its subsidiaries or affiliates to assist in its use, correction,
 *modification or enhancement.
 *
 *SUN MICROSYSTEMS, INC. OR ANY OF ITS SUBSIDIARIES OR AFFILIATES SHALL
 *HAVE NO LIABILITY WITH RESPECT TO THE INFRINGEMENT OF COPYRIGHTS, TRADE
 *SECRETS OR ANY PATENTS BY INTERFACE DEFINITION LANGUAGE CFE OR ANY PART
 *THEREOF.
 *
 *IN NO EVENT WILL SUN MICROSYSTEMS, INC. OR ANY OF ITS SUBSIDIARIES OR
 *AFFILIATES BE LIABLE FOR ANY LOST REVENUE OR PROFITS OR OTHER SPECIAL,
 *INDIRECT AND CONSEQUENTIAL DAMAGES, EVEN IF SUN HAS BEEN ADVISED OF THE
 *POSSIBILITY OF SUCH DAMAGES.
 *
 *SunSoft, Inc.  
 *2550 Garcia Avenue 
 *Mountain View, California  94043
 *
 *
 *
 *
 *======================================================================
 */

#pragma ident "%@(#)drv_main.cc	1.16% %92/06/10% Sun Microsystems"

/*
** drv_main.cc - Main program for IDL compiler driver
**
** LOGIC:
**
** 1. Initialize compiler driver
** 2. Parse command line args
** 3. If more than one file to parse, fork
** 4. Otherwise, for the single file, invoke DRV_drive
*/

#include	<idl.hh>
#include	<idl_extern.hh>

#include	<drv_private.hh>

static void
DRV_version()
{
  cerr << idl_global->prog_name() 
       << GTDEVEL(", version ")
       << IDL_CFE_VERSION 
       << "\n";
  BE_version();
}

/*
** Drive the compilation
**
** LOGIC:
**
** 1. Initialize the CFE, stage 1. This builds the scope stack
** 2. Initialize the BE. This builds an instance of the generator
** 3. Initialize the CFE, stage 2. This builds the global scope
**    and populates it with the predefined types
** 4. Invoke yyparse
** 5. Check for errors from yyparse. If any, exit now
** 6. Check for undefined forward declared interfaces. If any, exit now
** 7. Check if asked to dump AST. If so, do.
** 8. Invoke BE.
*/
void
DRV_drive(char *s)
{
  char	*fn;

  /*
   * Pass through CPP
   */
  if (idl_global->compile_flags() & IDL_CF_INFORMATIVE)
    cerr << idl_global->prog_name()
	 << GTDEVEL(": preprocessing ")
	 << s
	 << "\n";
  fn = DRV_pre_proc(s);
  idl_global->set_filename(new String(fn));
  idl_global->set_main_filename(new String(fn));
  /*
   * Initialize FE stage 1
   */
  FE_init_stage1();
  /*
   * Initialize BE
   */
  idl_global->set_gen(BE_init());
  /*
   * Initialize FE stage 2
   */
  FE_init_stage2();
  /*
   * Parse
   */
  if (idl_global->compile_flags() & IDL_CF_INFORMATIVE)
    cerr << idl_global->prog_name()
	 << GTDEVEL(": parsing ")
	 << s
	 << "\n";
  yyparse();
  /*
   * If there were any errors, stop
   */
  if (idl_global->err_count() > 0) {
    cerr << idl_global->prog_name()
	 << ": "
	 << s 
	 << GTDEVEL(": found ");
    cerr << idl_global->err_count()
	 << GTDEVEL(" error");
    cerr << (idl_global->err_count() > 1
	    ? GTDEVEL("s") : "")
    	 << "\n";
    /*
     * Call BE_abort to allow a BE to clean up after itself
     */
    BE_abort();
    exit((int) idl_global->err_count());
  }
  /*
   * Dump the code
   */
  if ((idl_global->compile_flags() & IDL_CF_INFORMATIVE)
      && (idl_global->compile_flags() & IDL_CF_DUMP_AST))
    cerr << idl_global->prog_name()
	 << GTDEVEL(": dump ")
	 << s
	 << "\n";
  if (idl_global->compile_flags() & IDL_CF_DUMP_AST) {
    cerr << GTDEVEL("Dump of AST:\n");
    idl_global->root()->dump(cerr);
  }
  /*
   * Call the main entry point for the BE
   */
  if (idl_global->compile_flags() & IDL_CF_INFORMATIVE)
    cerr << idl_global->prog_name()
	 << GTDEVEL(": BE processing on ")
	 << s
	 << "\n";
  BE_produce();
  /*
   * Exit cleanly
   */
  exit(0);
}

/*
 * IDL compiler main program. Logic as explained in comment at head
 * of file.
 */
int
main(int argc, char **argv)
{
  /*
   * Initialize driver and global variables
   */
  DRV_init();
  /*
   * Parse arguments
   */
  DRV_parse_args(argc, argv);

  /*
   * If a version message is requested, print it and exit
   */
  if (idl_global->compile_flags() & IDL_CF_VERSION) {
    DRV_version();
    exit(0);
  }
  /*
   * If a usage message is requested, give it and exit
   */
  if (idl_global->compile_flags() & IDL_CF_ONLY_USAGE) {
    DRV_usage();
    exit(99);
  }
  /*
   * Fork off a process for each file to process. Fork only if
   * there is more than one file to process
   */
  if (DRV_nfiles > 1) {
    /*
     * DRV_fork never returns
     */
    DRV_fork();
  } else {
    /*
     * Do the one file we have to parse
     *
     * Check if stdin and handle file name appropriately
     */
    if (DRV_nfiles == 0) {
      DRV_files[0] = "standard input";
    }
    DRV_file_index = 0;
    DRV_drive(DRV_files[DRV_file_index]);
  }
  return 0;
}
