/*
 *======================================================================
 *
 *Copyright 1992 Sun Microsystems, Inc.
 *
 *The Interface Definition Language Compiler Front End (CFE) is made
 *available for use provided that this legend is included on all media and
 *documentation and as a part of the software program in whole or part.
 *Users may copy and extend functionality (but may not remove
 *functionality) of the Interface Definition Language CFE without charge,
 *but are not authorized to license or distribute it to anyone else except
 *as part of a product or program developed by the user or with the express
 *written consent of Sun Microsystems, Inc.
 *
 *The names of Sun Microsystems, Inc. and any of its subsidiaries may not
 *be used in advertising or publicity pertaining to distribution of
 *Interface Definition Language CFE as permitted herein.
 *
 *The Interface Definition Language CFE may not be exported outside the
 *United States without first obtaining the appropriate government
 *approvals.
 *
 *INTERFACE DEFINITION LANGUAGE CFE IS PROVIDED AS IS WITH NO WARRANTIES
 *OF ANY KIND INCLUDING THE WARRANTIES OF DESIGN, MERCHANTIBILITY AND
 *FITNESS FOR A PARTICULAR PURPOSE, NONINFRINGEMENT, OR ARISING FROM A
 *COURSE OF DEALING, USAGE OR TRADE PRACTICE.
 *
 *Interface Definition Language CFE is provided with no support and
 *without any obligation on the part of Sun Microsystems, Inc. or any of
 *its subsidiaries or affiliates to assist in its use, correction,
 *modification or enhancement.
 *
 *SUN MICROSYSTEMS, INC. OR ANY OF ITS SUBSIDIARIES OR AFFILIATES SHALL
 *HAVE NO LIABILITY WITH RESPECT TO THE INFRINGEMENT OF COPYRIGHTS, TRADE
 *SECRETS OR ANY PATENTS BY INTERFACE DEFINITION LANGUAGE CFE OR ANY PART
 *THEREOF.
 *
 *IN NO EVENT WILL SUN MICROSYSTEMS, INC. OR ANY OF ITS SUBSIDIARIES OR
 *AFFILIATES BE LIABLE FOR ANY LOST REVENUE OR PROFITS OR OTHER SPECIAL,
 *INDIRECT AND CONSEQUENTIAL DAMAGES, EVEN IF SUN HAS BEEN ADVISED OF THE
 *POSSIBILITY OF SUCH DAMAGES.
 *
 *SunSoft, Inc.  
 *2550 Garcia Avenue 
 *Mountain View, California  94043
 *
 *
 *
 *
 *======================================================================
 */

#pragma ident "%@(#)ast_field.cc	1.46% %92/06/11% Sun Microsystems"

/*
 * ast_field.cc - Implementation of class AST_Field
 *
 * AST_Fields denote fields in IDL structure, union and exception
 * declarations. AST_Field is also used as a superclass of AST_Argument
 * and AST_UnionBranch.
 * AST_Fields have a field type (a subclass of AST_Type) and a name
 * (a UTL_ScopedName)
 *
 * AST_Field supplies two constructors, one to be used in constructing
 * AST_Field nodes, the other to be used in constructing AST_Argument
 * nodes and AST_UnionBranch nodes.
 */

#include	<idl.hh>
#include	<idl_extern.hh>

/*
 * Constructor(s) and destructor
 */

/*
 * Default constructor
 */
AST_Field::AST_Field()
	 : pd_field_type(NULL)
{
}

/*
 * To be used when constructing an AST_Field node
 */
AST_Field::AST_Field(AST_Type *ft, UTL_ScopedName *n, UTL_StrList *p)
	 : AST_Decl(AST_Decl::NT_field, n, p),
	   pd_field_type(ft)
{
}

/*
 * To be used when constructing a node of a subclass of AST_Field
 */
AST_Field::AST_Field(AST_Decl::NodeType nt, AST_Type *ft,
		   UTL_ScopedName *n, UTL_StrList *p)
	 : AST_Decl(nt, n, p),
	   pd_field_type(ft)
{
}

/*
 * Private operations
 */

/*
 * Public operations
 */


/*
 * Redefinition of inherited virtual operations
 */

/*
 * Dump this AST_Field node to the ostream o
 */
void
AST_Field::dump(ostream &o)
{
  pd_field_type->local_name()->dump(o);
  o << " ";
  local_name()->dump(o);
}

/*
 * Data accessors
 */

AST_Type *
AST_Field::field_type()
{
  return pd_field_type;
}

/*
 * Narrowing methods
 */
IMPL_NARROW_METHODS1(AST_Field, AST_Decl)
IMPL_NARROW_FROM_DECL(AST_Field)
