/*
Copyright (c) 1991, 1992, 1993 Xerox Corporation.  All Rights Reserved.  

Unlimited use, reproduction, and distribution of this software is
permitted.  Any copy of this software must include both the above
copyright notice of Xerox Corporation and this paragraph.  Any
distribution of this software must comply with all applicable United
States export control laws.  This software is made available AS IS,
and XEROX CORPORATION DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS FOR A PARTICULAR PURPOSE, AND NOTWITHSTANDING ANY OTHER
PROVISION CONTAINED HEREIN, ANY LIABILITY FOR DAMAGES RESULTING FROM
THE SOFTWARE OR ITS USE IS EXPRESSLY DISCLAIMED, WHETHER ARISING IN
CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, EVEN IF
XEROX CORPORATION IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.

$Id: server.c,v 1.14 1994/04/06 01:40:49 severson Exp $
*/
#include "cplusplus.h"

extern void UnmarkSupertypes (Type t);
extern Type ultimateType (Type);

static void DeclareCalleeReturnValue (Type type, Context context)
{
  if (type_basic_type(type) != void_Type)
    {
      fprintf (context->file, "\t%s _retvalue;\n", cplusplus_return_type(type));
    }
}

static void CalleeListArgument (Argument a, Context context)
{
  enum PrimitiveTypes t = type_basic_type (a->type);
  
  fprintf (context->file, ", %s%s",
	   (t == record_Type OR t == union_Type
	    OR t == longcardinal_Type OR t == longreal_Type) ? "&" : "",
	   cplusplus_argument_name(a));
}

void AllocateLocalArg (Argument arg, Context context)
{
  if (TypeIsNonObjectStruct(arg->type) || type_basic_type(arg->type) == array_Type)
    fprintf (context->file, "\t%s = (%s) malloc(sizeof(%s));\n", cplusplus_argument_name(arg), cplusplus_return_type(arg->type), cplusplus_type_name(arg->type));
}     

void FreeLocalArg (Argument arg, Context context)
{
  if (TypeIsNonObjectStruct(arg->type) || type_basic_type(arg->type) == array_Type)
    fprintf (context->file, "\tfree((char *) %s);\n", cplusplus_argument_name(arg));
}     

void ReadLocalArg (Argument arg, Context context)
{
  UnpackValue (context, arg->type, arg->def, cplusplus_argument_name(arg), FALSE, FALSE, FALSE);
}

static void DeclareLocalArgument (Argument arg, Context context)
{
  if (type_basic_type(arg->type) == object_Type)
    fprintf (context->file, "\t%s %s;\n", cplusplus_return_type(arg->type), cplusplus_argument_name(arg));
  else
    fprintf (context->file, "\t%s %s;\n", cplusplus_type_name(arg->type), cplusplus_argument_name(arg));
}

static void GenerateCalleeStub (Procedure m, Context context)
{
  char *retbuf;
  char *tn = cplusplus_type_name(m->object);

  fprintf (context->file, "void _%s_%s_stub (ilu_Call _call)\n{\n",
	   tn, cplusplus_simple_name(m->name));

  fprintf (context->file, "\t%sStatus _status;\n", cplusplus_interface_name(m->interface));

  list_enumerate (m->arguments, (iluparser_EnumProc) DeclareLocalArgument, context);

  DeclareCalleeReturnValue(m->returnType, context);
  fprintf (context->file, "\t%s *_realobj;\n\n", tn);
  fprintf (context->file, "\t_realobj = (%s *) iluObject::InputObject(_call, ilu_TRUE, %s::ILUClassRecord);\n", tn, tn);
/*
  list_enumerate (m->arguments, AllocateLocalArg, context);
*/
  list_enumerate (m->arguments, (iluparser_EnumProc) ReadLocalArg, context);
  fprintf (context->file, "\tif (ilu::FinishParameters(_call, (void *) _realobj) == 0)\n");
  fprintf (context->file, "\t\treturn;\n");

  fprintf (context->file, "\t_status.returnCode = NULL;\n");
  fprintf (context->file, "\t%s_realobj->%s (&_status",
	   (type_basic_type(m->returnType) == void_Type) ? "" : "_retvalue = ",
	   class_procedure_name(m));
  list_enumerate (m->arguments, (iluparser_EnumProc) CalleeListArgument, context);
  fprintf (context->file, ");\n\n");
  fprintf (context->file, "\tif (_status.returnCode == NULL) {\n");
  fprintf (context->file, "\t\tilu::BeginReply (_call, %s, (0",
	   (list_size(m->exceptions) > 0) ? "ilu_TRUE" : "ilu_FALSE");
  if (TypeIsArray(m->returnType))
    retbuf = "((_retvalue == NULL) ? NULL : *_retvalue)";
  else
    retbuf = "_retvalue";
  SizeType (m->returnType, retbuf, m->returnOptional, context);
  fprintf (context->file, "));\n");
  if (type_basic_type(m->returnType) != void_Type)
    {
      fprintf (context->file, "\t");
      EncodeValue (m->returnType, retbuf, m->returnOptional, context);
    }

  fprintf (context->file, "\t\tilu::FinishReply (_call);\n\t}\n");
  fprintf (context->file, "\telse {\n\t\t%s_G::SendException (_call, &_status);\n\t}\n\n",
	   cplusplus_interface_name(m->interface));
/*
  list_enumerate (m->arguments, FreeLocalArg, context);
*/
  fprintf (context->file, "}\n\n");
}

static void InitializeStubPointer (Procedure method, Context context)
{
  fprintf (context->file, "\tMethodRecord_%s_%s->me_stubproc = (ilu_stub_procedure) _%s_%s_stub;\n",
	   cplusplus_type_name(method->object), cplusplus_simple_name(method->name),
	   cplusplus_type_name(method->object), cplusplus_simple_name(method->name));
}

extern Class class_object();

static void SetupServerStubsInMethodTable (Type type, Context context)
{
  Class od;

  if (type == NULL || type_basic_type(type) != object_Type || (od = class_object(type)) == NULL)
    return;

  list_enumerate (od->methods, (iluparser_EnumProc) InitializeStubPointer, context);
}

static void ClassSetupStubs (Type class, Context context)
{
  Class od;

  if (class == NULL || type_basic_type(class) != object_Type || (od = class_object(class)) == NULL)
    return;

  list_enumerate (od->methods, (iluparser_EnumProc) GenerateCalleeStub, context);
}

extern cardinal MethodRecordID;
extern void DefineMethods(Type class, Context context);

extern void GenerateNecessaryIncludes(Context context);

static void generate_registration_code (Interface interface, Context context)
{
  char *interface_name = (char *) cplusplus_interface_name(interface);

  fprintf (context->file, "\n\n/* the following is all done to achieve load-time module initialization.\n");
  fprintf (context->file, "   We declare a private class which only has one instance, statically declared.\n");
  fprintf (context->file, "   We use the constructor of the class to do all the initializations we need\n");
  fprintf (context->file, "   for the module, trusting that the single static instance of the class will\n");
  fprintf (context->file, "   be initialized before the user code is given control. */\n\n");  
  
  fprintf (context->file, "class _%s_InitializeServerClass {\n\n public:\n\n", interface_name);
  fprintf (context->file, "  _%s_InitializeServerClass();\n};\n\n", interface_name);

  fprintf (context->file, "static class _%s_InitializeServerClass _%s_InitializationInstance;\n\n",
	   interface_name, interface_name);

  fprintf (context->file, "_%s_InitializeServerClass::_%s_InitializeServerClass()\n{\n",
	   interface_name, interface_name);

  list_enumerate (interface->classes, (iluparser_EnumProc) SetupServerStubsInMethodTable, context);

  fprintf (context->file, "};\n\n");
}

void generate_server_code (Interface parse, FILE *file)
{
  struct context_s context;

  context.file = file;
  context.interface = parse;

  fprintf (file, "#include <ilu.H>\n");
  fprintf (file, "#include <%s.H>\n\n",
	   cplusplus_interface_name(parse));

  fprintf (file, "extern ilu_Class %sClasses;\n\n", cplusplus_interface_name(parse));

  list_enumerate (parse->classes, (iluparser_EnumProc) ClassSetupStubs, &context);

  MethodRecordID = 0;
  list_enumerate (parse->classes, (iluparser_EnumProc) DefineMethods, &context);
  generate_registration_code (parse, &context);
}
