UNSAFE MODULE M3toC2;
IMPORT Cstdlib, Cstring, Ctypes, Text, TextF;

VAR zeroValue := 0;

TYPE
  M3TextBody = RECORD
                 string: ADDRESS;
                 size  : INTEGER
               END;

  M3Text = UNTRACED REF M3TextBody;

PROCEDURE SLtoT (s: Ctypes.CharStar; l: CARDINAL): TEXT =
  BEGIN
    RETURN CopySLtoT(s, l);
  END SLtoT;

PROCEDURE CopySLtoT (s: Ctypes.CharStar; l: CARDINAL): TEXT =
  BEGIN
    WITH t = NEW(TEXT, l + 1) DO
      EVAL Cstring.memcpy(ADR(t[0]), s, l);
      t[l] := VAL(0, CHAR);
      RETURN t;
    END;
  END CopySLtoT;

PROCEDURE TtoSL (t: TEXT): SL =
  BEGIN
    IF t = NIL OR t = "" THEN
      RETURN SL{ADR(zeroValue), 0}
    ELSE
      (* the magic to indirect on an open array *)
      RETURN SL{LOOPHOLE(t, M3Text).string, Text.Length(t)};
    END;
  END TtoSL;

PROCEDURE CopyTtoSL (t: TEXT): SL =
  BEGIN
    IF t = NIL OR t = "" THEN
      RETURN SL{ADR(zeroValue), 0}
    ELSE
      RETURN
        SL{
          Cstring.memcpy(
            Cstdlib.malloc(NUMBER(t^)), ADR(t[0]), NUMBER(t^)),
          Text.Length(t)};
    END;
  END CopyTtoSL;

PROCEDURE FreeS (<*UNUSED*> s: Ctypes.CharStar) =
  BEGIN
  END FreeS;

BEGIN
END M3toC2.
