(* IluF.i3 *)
(* Copyright (c) 1991, 1992, 1993 Xerox Corporation.  All Rights
   Reserved.

   Unlimited use, reproduction, and distribution of this software is
   permitted.  Any copy of this software must include both the above
   copyright notice of Xerox Corporation and this paragraph.  Any
   distribution of this software must comply with all applicable United
   States export control laws.  This software is made available AS IS,
   and XEROX CORPORATION DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
   INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF
   MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, AND
   NOTWITHSTANDING ANY OTHER PROVISION CONTAINED HEREIN, ANY LIABILITY
   FOR DAMAGES RESULTING FROM THE SOFTWARE OR ITS USE IS EXPRESSLY
   DISCLAIMED, WHETHER ARISING IN CONTRACT, TORT (INCLUDING NEGLIGENCE)
   OR STRICT LIABILITY, EVEN IF XEROX CORPORATION IS ADVISED OF THE
   POSSIBILITY OF SUCH DAMAGES. *)
(* Last tweaked by Mike Spreitzer March 17, 1994 9:32 pm PST *)

(* Private interface between modules in the ILU M3 runtime. *)

INTERFACE IluF;
IMPORT Ilu, IluKernel, Thread;
FROM IluBasics IMPORT Failed, Failure;
FROM IluKernel IMPORT C_String;

<*PRAGMA lL, Ll, Main*>

(* IluKernel.Server < ssMu < Ilu.Server *)
(* IluKernel.Server < srmu *)

REVEAL
  Ilu.ServerPrivate = MUTEX BRANDED OBJECT
                        <*lL, Ll, Main unconstrained*>
                        c_id: C_String := NIL;
                        <*lL >= {self}*>
                        ks: IluKernel.Server := NIL;
                      END;
  (* c_id is non-NIL for initted servers.  ks is NIL only if something
     went dreadfully wrong, and will never change after self is
     available. *)

<*Ll, Main unconstrained*>
<*lL.sup < ssMu*>
PROCEDURE SFromKs (ks: IluKernel.Server): Ilu.Server;

REVEAL
  Ilu.TrueServer =
    Ilu.Server OBJECT
    METHODS
      HandleListenerFailure (f: Failure): Ilu.FailureAction;
      HandleWorkerFailure   (f: Failure): Ilu.FailureAction;
    END
      BRANDED OBJECT
      objtab : Ilu.ObjectTable := NIL;
      exports: Exportation := NIL;
    OVERRIDES
      HandleListenerFailure := Ilu.DefaultHandleListenerFailure;
      HandleWorkerFailure   := Ilu.DefaultHandleWorkerFailure;
    END;

REVEAL Ilu.SurrogateServer = Ilu.Server BRANDED OBJECT END;

TYPE
  ConnectionWorker = Thread.Closure OBJECT
                       <*lL, Ll, Main unconstrained*>

                       ts   :  Ilu.TrueServer;
                       conn :  IluKernel.Connection;
                       work := TRUE;
                     OVERRIDES
                       apply := WorkForConnection
                     END;

<*lL, Ll = {}*>
PROCEDURE WorkForConnection (self: ConnectionWorker): REFANY RAISES {};

TYPE
  Exportation = REF RECORD
                      port       : IluKernel.Port := NIL;
                      contactArgs: Ilu.ContactInfo := NIL;
                      next       : Exportation;
                    END;

REVEAL
  Ilu.Object =
    Ilu.ObjectPublic BRANDED OBJECT
      (* The following fields are significant only in lead objects. *)
      ko: IluKernel.Object := NIL;
      sr: ADDRESS := NIL;
      sbh: TEXT := NIL; (* may be NIL for true objects of unexported
                           servers *)
      (* The following fields are significant only for lead
         surrogate objects. *)
      c_sbh  : C_String := NIL; (* M3toC.TtoS(sbh) *)
      mstid  : TEXT := NIL;
      c_mstid: C_String := NIL; (* M3toC.TtoS(mstid) *)
    OVERRIDES
      ILU_Close           := Ilu_Close;
      ILU_Close_Surrogate := Ilu_Close_Surrogate
    END;

<*Main Invariant holds; Ll otherwise unconstrained*>

PROCEDURE Ilu_Close (obj: Ilu.Object);
PROCEDURE Ilu_Close_Surrogate (obj: Ilu.Object);

<*lL = {} before;
  after:  Inside(o's server, o's type);
  excpn:  lL = {};
  forall conn: (Ll >= {conn.iomu}) => (Ll >= {conn.callmu});
  Main otherwise unconstrained*>
PROCEDURE KOfO (o: Ilu.Object): IluKernel.Object RAISES {Failed};

<*lL.sup < srmu; Ll, Main unconstrained*>

PROCEDURE NewStrongRef (r: REFANY): ADDRESS;
  (* Never returns NIL *)

PROCEDURE KillStrongRef (sr: ADDRESS);
  (* Won't accept NIL *)

PROCEDURE FromStrongRef (sr: ADDRESS): REFANY;
  (* Also maps NIL to NIL *)

<*lL = {}; Ll = {}*>

PROCEDURE StartGcClientSide();
PROCEDURE StartIlu ();

PROCEDURE DumpThreads();

END IluF.
